/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import java.util.concurrent.ExecutorService;

public abstract class CleanupManager {
    private long lastRunTimestamp = 0L;
    private final long intervalMillis;
    private final ExecutorService executorService;
    private boolean queued;

    public CleanupManager(ExecutorService executorService, long cleanupIntervalMillis) {
        this.executorService = executorService;
        this.intervalMillis = cleanupIntervalMillis;
        this.queued = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleCleanup() {
        boolean timeHasCome;
        if (this.queued) {
            return;
        }
        boolean bl = timeHasCome = System.currentTimeMillis() - this.lastRunTimestamp > this.intervalMillis;
        if (timeHasCome) {
            CleanupManager cleanupManager = this;
            synchronized (cleanupManager) {
                if (!this.queued) {
                    this.queued = true;
                    this.executorService.submit(() -> {
                        try {
                            this.execute();
                        }
                        finally {
                            this.queued = false;
                            this.lastRunTimestamp = System.currentTimeMillis();
                            this.finalized();
                        }
                    });
                }
            }
        }
    }

    protected abstract void execute();

    protected abstract void finalized();

    public boolean isQueued() {
        return this.queued;
    }
}

