/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.rostore.entity.RoStoreException;
import org.rostore.entity.media.ContainerListProperties;
import org.rostore.entity.media.ContainerMeta;
import org.rostore.v2.container.Container;
import org.rostore.v2.container.ContainerListHeader;
import org.rostore.v2.container.ContainerListOperations;
import org.rostore.v2.container.async.AsyncContainer;
import org.rostore.v2.container.async.CleanupManager;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.RootClosableImpl;

public class AsyncContainers
extends RootClosableImpl {
    private final Map<String, AsyncContainer> asyncContainers = new HashMap<String, AsyncContainer>();
    private final ExecutorService executorService;
    private final boolean privateExecutorService;
    private final ContainerListOperations containerListOperations;
    private final CleanupManager cleanupManager;
    private final Media media;

    public synchronized List<String> listAllContainers() {
        return this.containerListOperations.listAllContainers();
    }

    public CleanupManager getCleanupManager() {
        return this.cleanupManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public static AsyncContainers load(Media media, ExecutorService executorService, ContainerListHeader header) {
        return new AsyncContainers(media, executorService, header);
    }

    public static AsyncContainers create(Media media, ContainerListProperties containerListProperties, ExecutorService executorService) {
        return new AsyncContainers(media, containerListProperties, executorService);
    }

    public static AsyncContainers load(Media media, ContainerListHeader header) {
        return new AsyncContainers(media, header);
    }

    public static AsyncContainers create(Media media, ContainerListProperties containerListProperties) {
        return new AsyncContainers(media, containerListProperties);
    }

    private AsyncContainers(Media media, ExecutorService executorService, ContainerListHeader header) {
        this.media = media;
        this.executorService = executorService;
        this.privateExecutorService = false;
        this.containerListOperations = new ContainerListOperations(media, header);
        this.cleanupManager = this.createCleanupManager();
    }

    private AsyncContainers(Media media, ContainerListHeader header) {
        this.media = media;
        this.executorService = AsyncContainers.createPrivateExecutorService();
        this.privateExecutorService = true;
        this.containerListOperations = new ContainerListOperations(media, header);
        this.cleanupManager = this.createCleanupManager();
    }

    private static ExecutorService createPrivateExecutorService() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    }

    private AsyncContainers(Media media, ContainerListProperties containerListProperties, ExecutorService executorService) {
        this.media = media;
        this.executorService = executorService;
        this.privateExecutorService = false;
        this.containerListOperations = new ContainerListOperations(media, containerListProperties);
        this.cleanupManager = this.createCleanupManager();
    }

    private AsyncContainers(Media media, ContainerListProperties containerListProperties) {
        this.media = media;
        this.executorService = AsyncContainers.createPrivateExecutorService();
        this.privateExecutorService = true;
        this.containerListOperations = new ContainerListOperations(media, containerListProperties);
        this.cleanupManager = this.createCleanupManager();
    }

    private CleanupManager createCleanupManager() {
        return new CleanupManager(this.executorService, this.media.getMediaProperties().getCloseUnusedBlocksAfterMillis()){

            @Override
            protected void execute() {
                AsyncContainers.this.media.closeExpired();
            }

            @Override
            protected void finalized() {
            }
        };
    }

    public ContainerListHeader getContainerListHeader() {
        return this.containerListOperations.getContainerListHeader();
    }

    public AsyncContainer get(String name) {
        return this.getOrExecute(name, () -> {
            Container container = this.containerListOperations.get(name);
            if (container == null) {
                return null;
            }
            return new AsyncContainer(this, container);
        }, null);
    }

    public AsyncContainer create(String name, ContainerMeta containerMeta) {
        return this.getOrExecute(name, () -> {
            Container container = this.containerListOperations.create(name, containerMeta);
            if (container == null) {
                return null;
            }
            return new AsyncContainer(this, container);
        }, asyncContainer -> {
            throw new RoStoreException("The container is already created and opened");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(String name) {
        AsyncContainer asyncContainer;
        AsyncContainers asyncContainers = this;
        synchronized (asyncContainers) {
            asyncContainer = this.asyncContainers.remove(name);
            if (asyncContainer == null) {
                return false;
            }
        }
        asyncContainer.close();
        return true;
    }

    protected synchronized boolean evict(String name) {
        AsyncContainer asyncContainer = this.asyncContainers.remove(name);
        if (asyncContainer != null) {
            asyncContainer.getContainer().getContainerListOperations().evict(name);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        AsyncContainer asyncContainer = this.asyncContainers.get(name);
        if (asyncContainer != null) {
            asyncContainer.remove();
            return true;
        }
        return this.containerListOperations.remove(name);
    }

    public void close() {
        super.close();
        ArrayList<AsyncContainer> all = new ArrayList<AsyncContainer>(this.asyncContainers.values().size());
        all.addAll(this.asyncContainers.values());
        for (AsyncContainer asyncContainer : all) {
            asyncContainer.close();
        }
        if (this.privateExecutorService) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RoStoreException("Can't stop async containers..");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncContainer getOrExecute(String containerName, Supplier<AsyncContainer> factory, Consumer<AsyncContainer> validateExisting) {
        AsyncContainer container = this.asyncContainers.get(containerName);
        if (container == null) {
            AsyncContainers asyncContainers = this;
            synchronized (asyncContainers) {
                this.checkOpened();
                container = this.asyncContainers.get(containerName);
                if (container == null) {
                    container = factory.get();
                    if (container != null) {
                        this.asyncContainers.put(containerName, container);
                    }
                    return container;
                }
            }
        }
        if (container != null && validateExisting != null) {
            validateExisting.accept(container);
        }
        return container;
    }
}

