/*
 * Decompiled with CFR 0.152.
 */
package org.rostore.v2.container.async;

import java.io.File;
import java.util.concurrent.ExecutorService;
import org.rostore.v2.container.ContainerListHeader;
import org.rostore.v2.container.async.AsyncContainerMediaProperties;
import org.rostore.v2.container.async.AsyncContainers;
import org.rostore.v2.media.Closeable;
import org.rostore.v2.media.Media;
import org.rostore.v2.media.MediaProperties;
import org.rostore.v2.media.block.container.Status;

public class AsyncContainerMedia
implements Closeable {
    private AsyncContainers asyncContainers;
    private Media media;

    public AsyncContainers getAsyncContainers() {
        return this.asyncContainers;
    }

    public void setAsyncContainers(AsyncContainers asyncContainers) {
        this.asyncContainers = asyncContainers;
    }

    public Media getMedia() {
        return this.media;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public static AsyncContainerMedia create(File file, ExecutorService executorService, AsyncContainerMediaProperties asyncContainerMediaProperties) {
        AsyncContainers[] asyncContainers = new AsyncContainers[1];
        Media media = Media.create((File)file, (MediaProperties)asyncContainerMediaProperties.getMediaProperties(), (T m) -> {
            asyncContainers[0] = AsyncContainers.create(m, asyncContainerMediaProperties.getContainerListProperties(), executorService);
            return asyncContainers[0].getContainerListHeader();
        });
        return new AsyncContainerMedia(media, asyncContainers[0]);
    }

    public static AsyncContainerMedia load(File file, ExecutorService executorService) {
        AsyncContainers[] asyncContainers = new AsyncContainers[1];
        Media media = Media.open((File)file, ContainerListHeader.class, (m, containerListHeader) -> {
            asyncContainers[0] = AsyncContainers.load(m, executorService, containerListHeader);
        });
        return new AsyncContainerMedia(media, asyncContainers[0]);
    }

    public static AsyncContainerMedia create(File file, AsyncContainerMediaProperties asyncContainerMediaProperties) {
        AsyncContainers[] asyncContainers = new AsyncContainers[1];
        Media media = Media.create((File)file, (MediaProperties)asyncContainerMediaProperties.getMediaProperties(), (T m) -> {
            asyncContainers[0] = AsyncContainers.create(m, asyncContainerMediaProperties.getContainerListProperties());
            return asyncContainers[0].getContainerListHeader();
        });
        return new AsyncContainerMedia(media, asyncContainers[0]);
    }

    public static AsyncContainerMedia load(File file) {
        AsyncContainers[] asyncContainers = new AsyncContainers[1];
        Media media = Media.open((File)file, ContainerListHeader.class, (m, containerListHeader) -> {
            asyncContainers[0] = AsyncContainers.load(m, containerListHeader);
        });
        return new AsyncContainerMedia(media, asyncContainers[0]);
    }

    private AsyncContainerMedia(Media media, AsyncContainers asyncContainers) {
        this.media = media;
        this.asyncContainers = asyncContainers;
    }

    public void close() {
        this.asyncContainers.close();
        this.media.close();
    }

    public Status getStatus() {
        return this.media.getStatus();
    }
}

