/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.pojo.Y9Result;
import net.risesoft.security.ConcurrentSecurity;
import net.risesoft.security.SecurityManager;
import net.risesoft.service.DataBusinessService;
import net.risesoft.y9public.entity.DataBusinessEntity;
import net.risesoft.y9public.repository.DataBusinessRepository;
import net.risesoft.y9public.repository.DataTaskRepository;
import net.risesoft.y9public.repository.spec.DataBusinessSpecification;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataBusinessService")
public class DataBusinessServiceImpl
implements DataBusinessService {
    private final DataTaskRepository dataTaskRepository;
    private final DataBusinessRepository dataBusinessRepository;
    private final SecurityManager securityManager;

    @Override
    public Page<DataBusinessEntity> findByNamePage(String name, String parentId, int page, int rows) {
        if (page < 0) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createTime"}));
        if (StringUtils.isBlank((CharSequence)parentId)) {
            parentId = "0";
        }
        ConcurrentSecurity security = this.securityManager.getConcurrentSecurity();
        DataBusinessSpecification spec = new DataBusinessSpecification(parentId, name, security.getJobTypes());
        return this.dataBusinessRepository.findAll((Specification)spec, (Pageable)pageable);
    }

    @Override
    public DataBusinessEntity getById(String id) {
        return this.dataBusinessRepository.findById((Object)id).orElse(null);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9Result<String> deleteData(String id) {
        ConcurrentSecurity security = this.securityManager.getConcurrentSecurity();
        List ids = security.getJobTypes();
        if (ids.size() > 0 && !ids.contains(id)) {
            return Y9Result.failure((String)"\u6ca1\u6709\u8be5\u5206\u7c7b\u6743\u9650\uff0c\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u64cd\u4f5c");
        }
        if (this.dataTaskRepository.countByBusinessId(id) > 0L) {
            return Y9Result.failure((String)"\u5206\u7c7b\u4e0b\u5b58\u5728\u4efb\u52a1\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        List list = this.dataBusinessRepository.findByParentId(id);
        if (list != null && list.size() > 0) {
            if (this.dataTaskRepository.countByBusinessIdIn(list) > 0L) {
                return Y9Result.failure((String)"\u5b50\u5206\u7c7b\u4e0b\u5b58\u5728\u4efb\u52a1\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            this.dataBusinessRepository.deleteAllById((Iterable)list);
        }
        this.dataBusinessRepository.deleteById((Object)id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public List<DataBusinessEntity> findByParentId(String parentId) {
        return this.dataBusinessRepository.findByParentIdOrderByCreateTime(parentId);
    }

    @Override
    @Transactional(readOnly=false)
    public Y9Result<DataBusinessEntity> saveData(DataBusinessEntity entity) {
        if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getName())) {
            boolean top = StringUtils.isBlank((CharSequence)entity.getId()) && StringUtils.isBlank((CharSequence)entity.getParentId());
            ConcurrentSecurity security = this.securityManager.getConcurrentSecurity();
            if (security.getJobTypes().size() > 0 && top) {
                return Y9Result.failure((String)"\u6743\u9650\u4e0d\u591f\uff0c\u53ea\u80fd\u6dfb\u52a0\u5b50\u8282\u70b9");
            }
            DataBusinessEntity dataBusinessEntity = null;
            if (StringUtils.isBlank((CharSequence)entity.getId())) {
                dataBusinessEntity = new DataBusinessEntity();
                dataBusinessEntity.setId(Y9IdGenerator.genId());
                dataBusinessEntity.setParentId(entity.getParentId());
            } else {
                dataBusinessEntity = this.getById(entity.getId());
            }
            dataBusinessEntity.setName(entity.getName());
            if (StringUtils.isBlank((CharSequence)dataBusinessEntity.getParentId())) {
                dataBusinessEntity.setParentId("0");
            }
            return Y9Result.success((Object)((DataBusinessEntity)this.dataBusinessRepository.save((Object)dataBusinessEntity)), (String)"\u4fdd\u5b58\u6210\u529f");
        }
        return Y9Result.failure((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public List<Map<String, Object>> getTree() {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        List list = this.dataBusinessRepository.findByParentIdOrderByCreateTime("0");
        for (DataBusinessEntity business : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", business.getId());
            map.put("name", business.getName());
            ArrayList childMap = new ArrayList();
            List childList = this.dataBusinessRepository.findByParentIdOrderByCreateTime(business.getId());
            if (childList != null && childList.size() > 0) {
                for (DataBusinessEntity child : childList) {
                    HashMap<String, String> rmap = new HashMap<String, String>();
                    rmap.put("id", child.getId());
                    rmap.put("name", child.getName());
                    childMap.add(rmap);
                }
            }
            map.put("childs", childMap);
            listMap.add(map);
        }
        return listMap;
    }

    @Override
    public List<DataBusinessEntity> findAll() {
        ConcurrentSecurity security = this.securityManager.getConcurrentSecurity();
        List ids = security.getJobTypes();
        if (ids.size() > 0) {
            return this.dataBusinessRepository.findByIdIn(ids);
        }
        return this.dataBusinessRepository.findAll();
    }

    @Override
    public String getNameById(String id) {
        DataBusinessEntity dataBusinessEntity = this.getById(id);
        if (dataBusinessEntity != null) {
            return dataBusinessEntity.getName();
        }
        return "";
    }

    @Generated
    public DataBusinessServiceImpl(DataTaskRepository dataTaskRepository, DataBusinessRepository dataBusinessRepository, SecurityManager securityManager) {
        this.dataTaskRepository = dataTaskRepository;
        this.dataBusinessRepository = dataBusinessRepository;
        this.securityManager = securityManager;
    }
}

