/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.security.service.impl;

import java.util.List;
import java.util.UUID;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.exceptions.TokenException;
import net.risesoft.security.dao.TokenDao;
import net.risesoft.security.model.DataUser;
import net.risesoft.security.model.Token;
import net.risesoft.security.service.TokenService;
import net.risesoft.security.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
extends AutomaticCrudService<Token, String>
implements TokenService {
    @Autowired
    private TokenDao tokenDao;
    @Autowired
    private UserService userService;
    @Value(value="${beta.token.time:480}")
    public Long FAILURE_TIME;

    @Override
    public String createToken(DataUser userModel) {
        Token token = new Token();
        token.setTokenTime(System.currentTimeMillis());
        token.setToken(UUID.randomUUID().toString());
        token.setUserId(userModel.getId());
        this.insert(token);
        return token.getToken();
    }

    @Override
    public DataUser getUserByToken(String token) {
        String tokenUser = this.tokenDao.getTokenUser(token);
        if (StringUtils.isEmpty((CharSequence)tokenUser)) {
            throw new TokenException("token \u5931\u6548\u6216\u8005\u7528\u6237\u4e0d\u5b58\u5728");
        }
        DataUser betaUser = this.userService.findOne(tokenUser);
        if (betaUser == null) {
            throw new TokenException("token \u5931\u6548\u6216\u8005\u7528\u6237\u4e0d\u5b58\u5728");
        }
        betaUser.setPassword("");
        return betaUser;
    }

    @Override
    public boolean renew(String token, long time) {
        return this.tokenDao.renew(token, time) == 1;
    }

    @Override
    public boolean deleteToken(String token, long time) {
        return this.tokenDao.deleteToken(token, time) == 1;
    }

    @Override
    public long getFailureTime() {
        return System.currentTimeMillis() - this.FAILURE_TIME * 1000L * 60L;
    }

    @Override
    public boolean removeToken(String token) {
        return this.tokenDao.removeToken(token) == 1;
    }

    @Override
    public List<String> getFailureToken() {
        return this.tokenDao.getTokenForTime(this.getFailureTime());
    }

    @Override
    public DataUser login(String loginName) {
        DataUser dataUser = null;
        if (this.userService.hasName(loginName) == 0) {
            dataUser = new DataUser();
            dataUser.setAccount(loginName);
            dataUser.setUserName(loginName);
            dataUser.setPassword(loginName);
            dataUser.setId(this.userService.createUser(dataUser));
        } else {
            dataUser = this.userService.getByLoginName(loginName);
        }
        return dataUser;
    }
}

