/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.security;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.risedata.rpc.provide.context.RPCRequestContext;
import net.risesoft.exceptions.TokenException;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.security.ConcurrentSecurity;
import net.risesoft.security.RPCRequestFilter;
import net.risesoft.security.SecurityConfig;
import net.risesoft.security.SecurityManager;
import net.risesoft.security.model.Role;
import net.risesoft.security.pojo.DataUser;
import net.risesoft.security.service.RoleService;
import net.risesoft.security.service.TokenService;
import net.risesoft.util.IpUtils;
import net.risesoft.util.PattenUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9public.repository.DataBusinessRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class DefaultSecurityManager
implements SecurityManager,
Filter,
ApplicationContextAware {
    private ThreadLocal<Object> threadLocal = new ThreadLocal();
    private ConcurrentHashMap<String, ConcurrentSecurity> TOKEN_SECURITY_MAP = new ConcurrentHashMap();
    private Map<String, Long> TOKEN_TIME_MAP = new HashMap<String, Long>();
    private List<String> removedToken;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private RoleService roleService;
    public static Y9Result<Object> noToken = Y9Result.failure((int)401, (String)"no token or Token expired");
    public static Y9Result<Object> tokenError = Y9Result.failure((int)401, (String)"no token or Token expired");
    public static Y9Result<Object> noPermission = Y9Result.failure((int)403, (String)"no permission");
    @Autowired(required=false)
    private List<SecurityConfig> securityConfigs;
    public String[] excludeStartUrls = new String[]{"/RPC/", "/register/"};
    public String[] excludeEndUrls = new String[]{"getToken", "/register/", "getTestData", "saveTestData"};
    @Value(value="${server.servlet.context-path:}")
    private String baseContext;
    @Autowired
    private DataBusinessRepository dataBusinessRepository;

    public ConcurrentSecurity getConcurrentSecurity() {
        Object token = this.threadLocal.get();
        if (token == null) {
            return null;
        }
        if (token instanceof String) {
            this.threadLocal.set(this.TOKEN_SECURITY_MAP.get(token));
        }
        return (ConcurrentSecurity)this.threadLocal.get();
    }

    public boolean hasMatch(String source, String compare) {
        return PatternMatchUtils.simpleMatch((String)source, (String)compare);
    }

    public boolean hasMatch(String[] source, String compare) {
        for (String s : source) {
            if (!this.hasMatch(s, compare)) continue;
            return true;
        }
        return false;
    }

    public void tokenFailure(List<String> failureTokens, Long time) {
        boolean isNull;
        Long newTime = 0L;
        boolean bl = isNull = this.removedToken == null;
        if (isNull) {
            this.removedToken = new ArrayList<String>();
        }
        for (String failureToken : failureTokens) {
            newTime = this.TOKEN_TIME_MAP.get(failureToken);
            if (newTime == null) {
                if (this.removedToken.remove(failureToken)) {
                    this.tokenService.deleteToken(failureToken, time);
                    continue;
                }
                this.removedToken.add(failureToken);
                continue;
            }
            if (time < newTime) {
                if (this.tokenService.renew(failureToken, newTime)) continue;
                System.out.println("\u7eed\u8ba2\u5931\u8d25\u9700\u8981\u65b0\u589e");
                continue;
            }
            if (this.tokenService.deleteToken(failureToken, time)) {
                // empty if block
            }
            this.TOKEN_TIME_MAP.remove(failureToken);
            this.TOKEN_SECURITY_MAP.remove(failureToken);
        }
        if (!isNull) {
            this.removedToken = null;
        }
    }

    public boolean removeToken(String token) {
        boolean b = this.tokenService.removeToken(token);
        if (b) {
            this.TOKEN_TIME_MAP.remove(token);
            this.TOKEN_SECURITY_MAP.remove(token);
        }
        return b;
    }

    public String getConcurrentIp() {
        RPCRequestContext current = RPCRequestFilter.getCurrent();
        if (current != null) {
            return ((InetSocketAddress)current.getConcurrentConnection().getRemoteAddress()).getHostString();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return IpUtils.getIPAddress((HttpServletRequest)request);
    }

    @Scheduled(cron="0 0 0/1 * * ? ")
    public void checkFailureToken() {
        Set<String> tokenS = this.TOKEN_TIME_MAP.keySet();
        Long newTime = null;
        Long failureTime = this.tokenService.getFailureTime();
        for (Object key : tokenS.toArray()) {
            newTime = this.TOKEN_TIME_MAP.get(key);
            if (newTime == null || failureTime <= newTime) continue;
            this.TOKEN_TIME_MAP.remove(key);
            this.TOKEN_SECURITY_MAP.remove(key);
        }
        List<String> failureTokens = this.tokenService.getFailureToken();
        this.tokenFailure(failureTokens, failureTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest request1 = (HttpServletRequest)request;
            String token = request1.getHeader("x-token");
            String url = request1.getRequestURI();
            if (StringUtils.isEmpty((CharSequence)token)) {
                for (String excludeStartUrl : this.excludeEndUrls) {
                    if (!url.endsWith(excludeStartUrl)) continue;
                    chain.doFilter(request, response);
                    return;
                }
                for (String excludeStartUrl : this.excludeStartUrls) {
                    if (!url.startsWith(excludeStartUrl)) continue;
                    chain.doFilter(request, response);
                    return;
                }
                this.throwError(noToken, request, response);
                return;
            }
            this.saveSecurity(token);
            for (SecurityConfig securityConfig : this.securityConfigs) {
                if (!PattenUtil.hasMatch((List)securityConfig.getCheckUrl(), (String)url)) continue;
                if (PattenUtil.hasMatch((List)securityConfig.getWhiteList(), (String)url)) continue;
                if (securityConfig.getSecurityCheck().check(securityConfig, this.getConcurrentSecurity(), url, request1)) continue;
                this.throwError(noPermission, request, response);
                return;
            }
            chain.doFilter(request, response);
        }
        catch (TokenException e) {
            this.throwError(tokenError, request, response);
        }
        catch (Exception e) {
            this.throwError(Y9Result.failure((int)500, (String)e.getMessage()), request, response);
        }
        finally {
            this.threadLocal.remove();
        }
    }

    private void saveSecurity(String token) throws Exception {
        net.risesoft.security.model.DataUser userToken = this.tokenService.getUserByToken(token);
        List<Role> roles = this.roleService.getRolesByUser(userToken.getId());
        if (roles.size() == 0) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        DataUser user = new DataUser();
        user.setId(userToken.getId());
        user.setAccount(userToken.getAccount());
        user.setUserName(userToken.getUserName());
        ArrayList<String> environments = new ArrayList<String>();
        ArrayList<String> jobTypes = new ArrayList<String>();
        boolean systemManager = false;
        boolean userManager = false;
        for (Role role : roles) {
            if (StringUtils.isNotBlank((CharSequence)role.getEnvironments())) {
                environments.addAll(Arrays.asList(role.getEnvironments().split(",")));
            }
            if (StringUtils.isNotBlank((CharSequence)role.getJobTypes())) {
                String[] ids = role.getJobTypes().split(",");
                jobTypes.addAll(Arrays.asList(ids));
                for (String id : ids) {
                    jobTypes.addAll(this.dataBusinessRepository.findByParentId(id));
                }
            }
            if (role.getSystemManager() == 1) {
                systemManager = true;
            }
            if (role.getUserManager() != 1) continue;
            userManager = true;
        }
        ConcurrentSecurity concurrentSecurity = new ConcurrentSecurity(user, jobTypes, environments, userManager, systemManager);
        this.threadLocal.set(token);
        this.TOKEN_SECURITY_MAP.put(token, concurrentSecurity);
        this.TOKEN_TIME_MAP.put(token, System.currentTimeMillis());
        UserInfo userInfo = new UserInfo();
        userInfo.setPersonId(userToken.getId());
        userInfo.setName(userToken.getUserName());
        Y9LoginUserHolder.setUserInfo((UserInfo)userInfo);
        Y9LoginUserHolder.setPersonId((String)userToken.getId());
        Y9LoginUserHolder.setTenantId((String)"0");
    }

    private void throwError(Y9Result<?> result, ServletRequest request, ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        response.getWriter().write(JSON.toJSONString(result));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public String getToken() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return request.getHeader("x-token");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (!StringUtils.isEmpty((CharSequence)this.baseContext)) {
            for (int i = 0; i < this.excludeStartUrls.length; ++i) {
                this.excludeStartUrls[i] = this.baseContext + this.excludeStartUrls[i];
                System.out.println(this.excludeStartUrls[i]);
            }
        }
    }
}

