/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import javax.validation.Valid;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.search.LPageable;
import net.risesoft.pojo.Y9Result;
import net.risesoft.security.model.Role;
import net.risesoft.security.service.RoleService;
import net.risesoft.y9public.entity.DataBusinessEntity;
import net.risesoft.y9public.repository.DataBusinessRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rest/role"})
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private DataBusinessRepository dataBusinessRepository;

    @GetMapping(value={"search"})
    public Y9Result<Object> search(Role role, LPageable page) {
        LPage<Role> rolePage = this.roleService.searchForPage(role, page);
        for (Role row : rolePage.getContent()) {
            if (StringUtils.isNotBlank((CharSequence)row.getJobTypes())) {
                String[] ids = row.getJobTypes().split(",");
                Object names = "";
                for (String id : ids) {
                    String name = ((DataBusinessEntity)this.dataBusinessRepository.findById((Object)id).orElse(null)).getName();
                    names = (String)names + (String)(StringUtils.isBlank((CharSequence)names) ? name : "," + name);
                }
                row.setTypeNames((String)names);
                continue;
            }
            row.setTypeNames("");
        }
        return Y9Result.success(rolePage);
    }

    @PostMapping(value={"saveRole"})
    public Y9Result<String> saveRole(@RequestBody @Valid Role role) {
        try {
            this.roleService.saveRole(role);
        }
        catch (Exception e) {
            return Y9Result.failure((String)e.getMessage());
        }
        return Y9Result.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"deleteRole"})
    public Y9Result<Object> deleteUser(String id) {
        this.roleService.deleteByRoleId(id);
        return Y9Result.success((Object)"0");
    }

    @GetMapping(value={"getRole"})
    public Y9Result<Object> getRole(String id) {
        Role role = this.roleService.findById(id);
        if (StringUtils.isNotBlank((CharSequence)role.getJobTypes())) {
            String[] ids = role.getJobTypes().split(",");
            Object names = "";
            for (String id2 : ids) {
                String name = ((DataBusinessEntity)this.dataBusinessRepository.findById((Object)id2).orElse(null)).getName();
                names = (String)names + (String)(StringUtils.isBlank((CharSequence)names) ? name : "," + name);
            }
            role.setTypeNames((String)names);
        } else {
            role.setTypeNames("");
        }
        return Y9Result.success((Object)role);
    }
}

