/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DataBusinessService;
import net.risesoft.y9public.entity.DataBusinessEntity;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/rest/business"}, produces={"application/json"})
public class BusinessController {
    private final DataBusinessService dataBusinessService;

    @GetMapping(value={"/getAll"})
    public Y9Page<DataBusinessEntity> getAll(String name, String parentId, Integer page, Integer size) {
        Page<DataBusinessEntity> pageList = this.dataBusinessService.findByNamePage(name, parentId, page, size);
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
    }

    @GetMapping(value={"/findAll"})
    public Y9Result<List<DataBusinessEntity>> findAll() {
        return Y9Result.success(this.dataBusinessService.findAll(), (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/saveData"})
    public Y9Result<DataBusinessEntity> saveData(DataBusinessEntity entity) {
        return this.dataBusinessService.saveData(entity);
    }

    @GetMapping(value={"/getDataById"})
    public Y9Result<DataBusinessEntity> getDataById(@RequestParam String id) {
        return Y9Result.success((Object)this.dataBusinessService.getById(id), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/deleteData"})
    public Y9Result<String> deleteData(@RequestParam String id) {
        return this.dataBusinessService.deleteData(id);
    }

    @Generated
    public BusinessController(DataBusinessService dataBusinessService) {
        this.dataBusinessService = dataBusinessService;
    }
}

