/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository.custom.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import net.risesoft.model.log.LogInfoModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9public.entity.Y9logUserLoginInfo;
import net.risesoft.y9public.repository.Y9logUserLoginInfoRepository;
import net.risesoft.y9public.repository.custom.Y9logUserLoginInfoCustomRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class Y9logUserLoginInfoCustomRepositoryImpl
implements Y9logUserLoginInfoCustomRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9logUserLoginInfoCustomRepositoryImpl.class);
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private final Y9logUserLoginInfoRepository y9logUserLoginInfoRepository;

    @Override
    public long countByLoginTimeBetweenAndSuccess(final Date startTime, final Date endTime, final String success) {
        List ipList = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                String tenantId;
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                if (!(tenantId = Y9LoginUserHolder.getTenantId()).equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)startTime, (Comparable)endTime));
                return predicate;
            }
        });
        return ipList.size();
    }

    @Override
    public long countBySuccessAndUserHostIpAndUserId(final String success, final String userHostIp, final String userId) {
        List ipList = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                String tenantId = Y9LoginUserHolder.getTenantId();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)userHostIp)) {
                    list.add(criteriaBuilder.equal(root.get("userHostIp").as(String.class), (Object)userHostIp));
                }
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    list.add(criteriaBuilder.equal(root.get("userId").as(String.class), (Object)userId));
                }
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                return predicate;
            }
        });
        return ipList.size();
    }

    @Override
    public long countByUserHostIpAndSuccess(String userHostIp, String success) {
        return this.y9logUserLoginInfoRepository.countByUserHostIpAndSuccess(userHostIp, success);
    }

    @Override
    public long countByUserHostIpLikeAndLoginTimeBetweenAndSuccess(final String userHostIp, final Date startTime, final Date endTime, final String success) {
        List ipList = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                String tenantId = Y9LoginUserHolder.getTenantId();
                if (!tenantId.equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                if (StringUtils.isNotBlank((CharSequence)userHostIp)) {
                    list.add(criteriaBuilder.like(root.get("userHostIp").as(String.class), userHostIp + "%"));
                }
                list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)startTime, (Comparable)endTime));
                return predicate;
            }
        });
        return ipList.size();
    }

    @Override
    public List<Object[]> listDistinctUserHostIpByUserIdAndLoginTime(String userId, Date startTime, Date endTime) {
        ArrayList<Object[]> strList = new ArrayList<Object[]>();
        List<Map<String, Object>> userHostIpList = this.y9logUserLoginInfoRepository.findDistinctUserHostIpByUserIdAndLoginTime(userId, startTime, endTime);
        if (!userHostIpList.isEmpty()) {
            userHostIpList.forEach(userHostIp -> {
                String[] userLoginInfo = new String[]{"" + userHostIp.get("userHostIp"), String.valueOf(userHostIp.get("count"))};
                strList.add(userLoginInfo);
            });
        }
        return strList;
    }

    @Override
    public List<Map<String, Object>> listUserHostIpByCip(String cip) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<Map<String, Object>> userHostIpList = tenantId.equals("11111111-1111-1111-1111-111111111120") ? this.y9logUserLoginInfoRepository.findDistinctUserHostIpCountByUserHostIpLike(cip) : this.y9logUserLoginInfoRepository.findDistinctUserHostIpCountByUserHostIpLikeAndTenantId(cip, tenantId);
        if (!userHostIpList.isEmpty()) {
            userHostIpList.forEach(userHostIp -> {
                HashMap map = new HashMap();
                String text = userHostIp.get("userHostIp") + "<span style='color:red'>(" + userHostIp.get("count") + ")</span>";
                map.put("serverIp", userHostIp.get("userHostIp"));
                map.put("text", text);
                list.add(map);
            });
        }
        return list;
    }

    @Override
    public Y9Page<Y9logUserLoginInfo> page(final String tenantId, final String userHostIp, final String userId, final String success, final String startTime, final String endTime, Y9PageQuery pageQuery) {
        int page = pageQuery.getPage4Db();
        int size = pageQuery.getSize();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"loginTime"}));
        Page ipPage = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    list.add(criteriaBuilder.equal(root.get("userId").as(String.class), (Object)userId));
                }
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                if (StringUtils.isNotBlank((CharSequence)userHostIp)) {
                    list.add(criteriaBuilder.like(root.get("userHostIp").as(String.class), "%" + userHostIp + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
                    try {
                        list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)DATE_TIME_FORMAT.parse(startTime), (Comparable)DATE_TIME_FORMAT.parse(endTime)));
                    }
                    catch (ParseException e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)ipPage.getTotalPages(), (long)ipPage.getTotalElements(), (List)ipPage.getContent());
    }

    @Override
    public Y9Page<Y9logUserLoginInfo> pageByLoginTimeBetweenAndSuccess(final Date startTime, final Date endTime, final String success, int page, int rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"loginTime"}));
        Page pageInfo = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                String tenantId;
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                if (startTime != null && endTime != null) {
                    list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)startTime, (Comparable)endTime));
                }
                if (!(tenantId = Y9LoginUserHolder.getTenantId()).equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), (List)pageInfo.getContent());
    }

    @Override
    public Y9Page<Map<String, Object>> pageByUserHostIpAndSuccess(String userHostIp, String success, int page, int size) {
        ArrayList strList = new ArrayList();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)size);
        String tenantId = Y9LoginUserHolder.getTenantId();
        Page<Object[]> pageInfo = tenantId.equals("11111111-1111-1111-1111-111111111120") ? this.y9logUserLoginInfoRepository.findDistinctByUserHostIpAndSuccess(userHostIp, success, (Pageable)pageable) : this.y9logUserLoginInfoRepository.findDistinctByUserHostIpAndSuccessAndTenantId(userHostIp, success, tenantId, (Pageable)pageable);
        if (!pageInfo.getContent().isEmpty()) {
            pageInfo.getContent().forEach(logUserLoginInfo -> {
                String userId = (String)logUserLoginInfo[0];
                String userName = (String)logUserLoginInfo[1];
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userId", userId);
                map.put("userName", userName);
                map.put("userHostIp", logUserLoginInfo[2]);
                map.put("serverCount", String.valueOf(logUserLoginInfo[3]));
                strList.add(map);
            });
        }
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), strList);
    }

    @Override
    public Y9Page<Map<String, Object>> pageByUserHostIpAndSuccessAndUserNameLike(String userHostIp, String success, String userName, int page, int size) {
        ArrayList strList = new ArrayList();
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)size);
        String tenantId = Y9LoginUserHolder.getTenantId();
        Page<Object[]> pageInfo = tenantId.equals("11111111-1111-1111-1111-111111111120") ? this.y9logUserLoginInfoRepository.findByUserHostIpAndSuccessAndUserNameLike(userHostIp, success, userName, (Pageable)pageable) : this.y9logUserLoginInfoRepository.findByUserHostIpAndSuccessAndUserNameLikeAndTenantId(userHostIp, success, userName, tenantId, (Pageable)pageable);
        if (!pageInfo.getContent().isEmpty()) {
            pageInfo.getContent().forEach(logUserLoginInfo -> {
                String userId = (String)logUserLoginInfo[0];
                String name = (String)logUserLoginInfo[1];
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("userId", userId);
                map.put("userName", name);
                map.put("userHostIp", logUserLoginInfo[2]);
                map.put("serverCount", String.valueOf(logUserLoginInfo[3]));
                strList.add(map);
            });
        }
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), strList);
    }

    @Override
    public Y9Page<Y9logUserLoginInfo> pageByUserHostIpLikeAndLoginTimeBetweenAndSuccess(final String userHostIp, final Date startTime, final Date endTime, final String success, int page, int rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"loginTime"}));
        Page pageInfo = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                String tenantId;
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)success)) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)success));
                }
                if (StringUtils.isNotBlank((CharSequence)userHostIp)) {
                    list.add(criteriaBuilder.like(root.get("userHostIp").as(String.class), userHostIp + "%"));
                }
                if (startTime != null && endTime != null) {
                    list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)startTime, (Comparable)endTime));
                }
                if (!(tenantId = Y9LoginUserHolder.getTenantId()).equals("11111111-1111-1111-1111-111111111120")) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), (List)pageInfo.getContent());
    }

    public void save(Y9logUserLoginInfo y9logUserLoginInfo) {
        this.y9logUserLoginInfoRepository.save(y9logUserLoginInfo);
    }

    @Override
    public Y9Page<Y9logUserLoginInfo> searchQuery(final String tenantId, final String managerLevel, final LogInfoModel loginInfoModel, int page, int rows) {
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"loginTime"}));
        Page pageInfo = this.y9logUserLoginInfoRepository.findAll((Specification)new Specification<Y9logUserLoginInfo>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logUserLoginInfo> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    list.add(criteriaBuilder.equal(root.get("tenantId").as(String.class), (Object)tenantId));
                }
                if (StringUtils.isNotBlank((CharSequence)managerLevel)) {
                    list.add(criteriaBuilder.equal(root.get("managerLevel").as(String.class), (Object)managerLevel));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserName())) {
                    list.add(criteriaBuilder.like(root.get("userName").as(String.class), "%" + loginInfoModel.getUserName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getUserHostIp())) {
                    list.add(criteriaBuilder.like(root.get("userHostIp").as(String.class), "%" + loginInfoModel.getUserHostIp() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getOsName())) {
                    list.add(criteriaBuilder.like(root.get("osName").as(String.class), "%" + loginInfoModel.getOsName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getScreenResolution())) {
                    list.add(criteriaBuilder.like(root.get("screenResolution").as(String.class), "%" + loginInfoModel.getScreenResolution() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getSuccess())) {
                    list.add(criteriaBuilder.equal(root.get("success").as(String.class), (Object)loginInfoModel.getSuccess()));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getBrowserName())) {
                    list.add(criteriaBuilder.like(root.get("browserName").as(String.class), "%" + loginInfoModel.getBrowserName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getBrowserVersion())) {
                    list.add(criteriaBuilder.like(root.get("browserVersion").as(String.class), "%" + loginInfoModel.getBrowserVersion() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)loginInfoModel.getStartTime()) && StringUtils.isNotBlank((CharSequence)loginInfoModel.getEndTime())) {
                    String sTime = loginInfoModel.getStartTime() + " 00:00:00";
                    String eTime = loginInfoModel.getEndTime() + " 23:59:59";
                    SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    try {
                        Date startDate = DATE_TIME_FORMAT.parse(sTime);
                        Date endDate = DATE_TIME_FORMAT.parse(eTime);
                        Date start = sdfUtc.parse(sdfUtc.format(startDate));
                        Date end = sdfUtc.parse(sdfUtc.format(endDate));
                        list.add(criteriaBuilder.between(root.get("loginTime").as(Date.class), (Comparable)start, (Comparable)end));
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage(), (Throwable)e);
                    }
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return Y9Page.success((int)page, (int)pageInfo.getTotalPages(), (long)pageInfo.getTotalElements(), (List)pageInfo.getContent());
    }

    @Generated
    public Y9logUserLoginInfoCustomRepositoryImpl(Y9logUserLoginInfoRepository y9logUserLoginInfoRepository) {
        this.y9logUserLoginInfoRepository = y9logUserLoginInfoRepository;
    }
}

