/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository.custom.impl;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import net.risesoft.y9public.entity.Y9logMapping;
import net.risesoft.y9public.repository.Y9logMappingRepository;
import net.risesoft.y9public.repository.custom.Y9logMappingCustomRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class Y9logMappingCustomRepositoryImpl
implements Y9logMappingCustomRepository {
    private final Y9logMappingRepository y9logMappingRepository;

    @Override
    public String getCnModularName(String modularName) {
        List<Y9logMapping> list = this.y9logMappingRepository.findByModularName(modularName);
        if (list.isEmpty()) {
            return "";
        }
        return list.get(0).getModularCnName();
    }

    @Override
    public Page<Y9logMapping> pageSearchList(Integer page, Integer rows, final String modularName, final String modularCnName) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"modularCnName"});
        PageRequest pageable = PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)rows, (Sort)sort);
        return this.y9logMappingRepository.findAll((Specification)new Specification<Y9logMapping>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<Y9logMapping> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                if (StringUtils.isNotBlank((CharSequence)modularCnName)) {
                    list.add(criteriaBuilder.equal(root.get("modularCnName").as(String.class), (Object)modularCnName));
                }
                if (StringUtils.isNotBlank((CharSequence)modularName)) {
                    list.add(criteriaBuilder.equal(root.get("modularName").as(String.class), (Object)modularName));
                }
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Generated
    public Y9logMappingCustomRepositoryImpl(Y9logMappingRepository y9logMappingRepository) {
        this.y9logMappingRepository = y9logMappingRepository;
    }
}

