/*
 * Decompiled with CFR 0.152.
 */
package y9.oauth2.resource.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import net.risesoft.enums.platform.SexEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.model.log.AccessLog;
import net.risesoft.model.user.UserInfo;
import net.risesoft.model.user.UserProfile;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.configuration.feature.log.Y9LogProperties;
import net.risesoft.y9.configuration.feature.oauth2.resource.Y9Oauth2ResourceProperties;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.InetAddressUtil;
import net.risesoft.y9.util.RemoteCallUtil;
import net.risesoft.y9.util.Y9EnumUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import y9.oauth2.resource.filter.OAuth20IntrospectionAccessTokenSuccessResponse;

public class Y9Oauth2ResourceFilter
implements Filter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9Oauth2ResourceFilter.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private String serverIp = "";
    private final KafkaTemplate<String, Object> y9KafkaTemplate;
    private final Y9Properties y9Properties;
    private final Y9Oauth2ResourceProperties y9Oauth2ResourceProperties;
    private final Y9LogProperties y9LogProperties;

    public Y9Oauth2ResourceFilter(Y9Properties y9Properties, KafkaTemplate<String, Object> y9KafkaTemplate) {
        this.y9Properties = y9Properties;
        this.y9Oauth2ResourceProperties = y9Properties.getFeature().getOauth2().getResource();
        this.y9LogProperties = y9Properties.getFeature().getLog();
        this.y9KafkaTemplate = y9KafkaTemplate;
    }

    private String buildExceptionMessage(Exception ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        OAuth20IntrospectionAccessTokenSuccessResponse introspectionResponse;
        String accessToken;
        HttpSession session;
        long startTime;
        String success;
        String throwable;
        String errorMessage;
        UserInfo userInfo;
        HttpServletResponse response;
        HttpServletRequest request;
        block27: {
            ResponseEntity<OAuth20IntrospectionAccessTokenSuccessResponse> introspectEntity;
            block26: {
                block25: {
                    request = (HttpServletRequest)servletRequest;
                    response = (HttpServletResponse)servletResponse;
                    userInfo = null;
                    errorMessage = "";
                    throwable = "";
                    success = "\u6210\u529f";
                    startTime = System.nanoTime();
                    session = request.getSession(false);
                    accessToken = this.getAccessTokenFromRequest(request);
                    if (!StringUtils.isBlank((CharSequence)accessToken)) break block25;
                    this.setResponse(response, HttpStatus.UNAUTHORIZED, (ErrorCode)GlobalErrorCodeEnum.ACCESS_TOKEN_NOT_FOUND);
                    Y9LoginUserHolder.clear();
                    long endTime = System.nanoTime();
                    long elapsedTime = endTime - startTime;
                    String y9aoplog = response.getHeader("y9aoplog");
                    if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
                        this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
                    }
                    return;
                }
                introspectEntity = null;
                try {
                    introspectEntity = this.invokeIntrospectEndpoint(accessToken);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    this.setResponse(response, HttpStatus.INTERNAL_SERVER_ERROR, (ErrorCode)GlobalErrorCodeEnum.FAILURE);
                    Y9LoginUserHolder.clear();
                    long endTime = System.nanoTime();
                    long elapsedTime = endTime - startTime;
                    String y9aoplog = response.getHeader("y9aoplog");
                    if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
                        this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
                    }
                    return;
                }
                if (introspectEntity.getStatusCodeValue() == HttpStatus.OK.value()) break block26;
                this.setResponse(response, HttpStatus.UNAUTHORIZED, (ErrorCode)GlobalErrorCodeEnum.ACCESS_TOKEN_VERIFICATION_FAILED);
                Y9LoginUserHolder.clear();
                long endTime = System.nanoTime();
                long elapsedTime = endTime - startTime;
                String y9aoplog = response.getHeader("y9aoplog");
                if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
                    this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
                }
                return;
            }
            introspectionResponse = (OAuth20IntrospectionAccessTokenSuccessResponse)introspectEntity.getBody();
            if (introspectionResponse.isActive()) break block27;
            this.setResponse(response, HttpStatus.UNAUTHORIZED, (ErrorCode)GlobalErrorCodeEnum.ACCESS_TOKEN_EXPIRED);
            Y9LoginUserHolder.clear();
            long endTime = System.nanoTime();
            long elapsedTime = endTime - startTime;
            String y9aoplog = response.getHeader("y9aoplog");
            if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
                this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
            }
            return;
        }
        try {
            userInfo = (UserInfo)Y9JsonUtil.readValue((String)introspectionResponse.getAttr(), UserInfo.class);
            if (userInfo == null) {
                ResponseEntity<String> profileEntity = null;
                try {
                    profileEntity = this.invokeProfileEndpoint(accessToken);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    this.setResponse(response, HttpStatus.INTERNAL_SERVER_ERROR, (ErrorCode)GlobalErrorCodeEnum.FAILURE);
                }
                String profile = (String)profileEntity.getBody();
                userInfo = (UserInfo)Y9JsonUtil.readValue((String)profile, UserInfo.class);
            }
            if (userInfo != null) {
                if (session == null) {
                    session = request.getSession(true);
                }
                session.setAttribute("access_token", (Object)accessToken);
                session.setAttribute("userInfo", (Object)userInfo);
                session.setAttribute("loginName", (Object)userInfo.getLoginName());
                session.setAttribute("positionId", (Object)userInfo.getPositionId());
                session.setAttribute("deptId", (Object)userInfo.getParentId());
                if (StringUtils.isNotBlank((CharSequence)userInfo.getPositionId())) {
                    Y9LoginUserHolder.setPositionId((String)userInfo.getPositionId());
                } else if (StringUtils.isNotBlank((CharSequence)userInfo.getPositions())) {
                    String[] postionList = userInfo.getPositions().split(",");
                    Y9LoginUserHolder.setPositionId((String)postionList[0]);
                }
                Y9LoginUserHolder.setTenantId((String)userInfo.getTenantId());
                Y9LoginUserHolder.setTenantName((String)userInfo.getTenantName());
                Y9LoginUserHolder.setTenantShortName((String)userInfo.getTenantShortName());
                Y9LoginUserHolder.setUserInfo((UserInfo)userInfo);
                if (this.y9Oauth2ResourceProperties.isSaveOnlineMessage()) {
                    this.remoteSaveUserOnline(userInfo);
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            try {
                success = "\u51fa\u9519";
                errorMessage = ex.getMessage();
                throwable = this.buildExceptionMessage(ex);
                throw ex;
            }
            catch (Throwable throwable2) {
                Y9LoginUserHolder.clear();
                long endTime = System.nanoTime();
                long elapsedTime = endTime - startTime;
                String y9aoplog = response.getHeader("y9aoplog");
                if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
                    this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
                }
                throw throwable2;
            }
        }
        Y9LoginUserHolder.clear();
        long endTime = System.nanoTime();
        long elapsedTime = endTime - startTime;
        String y9aoplog = response.getHeader("y9aoplog");
        if (!"true".equals(y9aoplog) && this.y9Oauth2ResourceProperties.isSaveLogMessage()) {
            this.remoteSaveLog(request, userInfo, elapsedTime, success, errorMessage, throwable);
        }
    }

    private String getAccessTokenFromRequest(HttpServletRequest request) {
        String authHeader;
        String accessToken = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.startsWith("Bearer ")) {
            accessToken = authHeader.substring("Bearer ".length());
        }
        return accessToken;
    }

    private String getIpAddr(HttpServletRequest request) {
        String[] addrHeader;
        String addr = null;
        for (String header : addrHeader = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP"}) {
            if (!StringUtils.isEmpty(addr) && !"unknown".equalsIgnoreCase(addr)) break;
            addr = request.getHeader(header);
        }
        if (StringUtils.isEmpty(addr) || "unknown".equalsIgnoreCase(addr)) {
            addr = request.getRemoteAddr();
        } else {
            int i = addr.indexOf(",");
            if (i > 0) {
                addr = addr.substring(0, i);
            }
        }
        return addr;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.serverIp = InetAddressUtil.getLocalAddress().getHostAddress();
    }

    private ResponseEntity<OAuth20IntrospectionAccessTokenSuccessResponse> invokeIntrospectEndpoint(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBasicAuth(this.y9Oauth2ResourceProperties.getOpaque().getClientId(), this.y9Oauth2ResourceProperties.getOpaque().getClientSecret(), StandardCharsets.UTF_8);
        URI uri = URI.create(this.y9Oauth2ResourceProperties.getOpaque().getIntrospectionUri() + "?token=" + accessToken);
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)headers, HttpMethod.POST, uri);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, OAuth20IntrospectionAccessTokenSuccessResponse.class);
        return responseEntity;
    }

    private ResponseEntity<String> invokeProfileEndpoint(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("Authorization", "Bearer " + accessToken);
        URI uri = URI.create(this.y9Oauth2ResourceProperties.getOpaque().getProfileUri() + "?access_token=" + accessToken);
        RequestEntity requestEntity = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, uri);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, String.class);
        return responseEntity;
    }

    private void remoteSaveLog(HttpServletRequest request, UserInfo userInfo, long elapsedTime, String success, String errorMessage, String throwable) {
        String url = request.getRequestURL().toString();
        if (url.endsWith(".js") || url.endsWith(".css") || url.endsWith(".gif") || url.endsWith(".jpg") || url.endsWith(".png") || url.endsWith(".svg")) {
            return;
        }
        try {
            AccessLog log = new AccessLog();
            log.setLogLevel("RSLOG");
            log.setLogTime(new Date());
            log.setRequestUrl(url);
            log.setElapsedTime(String.valueOf(elapsedTime));
            log.setSuccess(success);
            log.setLogMessage(errorMessage);
            log.setThrowable(throwable);
            log.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            log.setServerIp(this.serverIp);
            log.setUserHostIp(this.getIpAddr(request));
            log.setOperateType("\u6d3b\u52a8");
            log.setUserAgent(request.getHeader("User-Agent"));
            log.setSystemName(this.y9Properties.getSystemName());
            if (userInfo != null) {
                log.setUserId(userInfo.getParentId());
                log.setUserName(userInfo.getLoginName());
                log.setTenantId(userInfo.getTenantId());
                log.setTenantName(userInfo.getTenantName());
                log.setGuidPath(userInfo.getGuidPath());
                log.setManagerLevel(String.valueOf(userInfo.getManagerLevel().getValue()));
            }
            if (Objects.equals(this.y9LogProperties.getLogSaveTarget(), Y9LogProperties.LogSaveTarget.KAFKA)) {
                if (this.y9KafkaTemplate != null) {
                    String jsonString = Y9JsonUtil.writeValueAsString((Object)log);
                    this.y9KafkaTemplate.send("y9_accessLog_message", (Object)jsonString);
                }
            } else if (Objects.equals(this.y9LogProperties.getLogSaveTarget(), Y9LogProperties.LogSaveTarget.API)) {
                String logBaseUrl = this.y9Properties.getCommon().getLogBaseUrl();
                String saveAccessLogUrl = logBaseUrl + "/services/rest/v1/accessLog/asyncSaveLog";
                List requestBody = RemoteCallUtil.objectToNameValuePairList((Object)log);
                RemoteCallUtil.post((String)saveAccessLogUrl, null, (List)requestBody, Object.class);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void remoteSaveUserOnline(UserInfo userInfo) {
        if (userInfo != null) {
            try {
                if (Objects.equals(this.y9LogProperties.getLogSaveTarget(), Y9LogProperties.LogSaveTarget.KAFKA)) {
                    String jsonString = Y9JsonUtil.writeValueAsString((Object)userInfo);
                    if (this.y9KafkaTemplate != null) {
                        this.y9KafkaTemplate.send("y9_userOnline_message", (Object)jsonString);
                    }
                } else if (Objects.equals(this.y9LogProperties.getLogSaveTarget(), Y9LogProperties.LogSaveTarget.API)) {
                    String userOnlineBaseUrl = this.y9Properties.getCommon().getUserOnlineBaseUrl();
                    String saveOnlineUrl = userOnlineBaseUrl + "/services/rest/userOnline/saveAsync";
                    List requestBody = RemoteCallUtil.objectToNameValuePairList((Object)userInfo);
                    RemoteCallUtil.post((String)saveOnlineUrl, null, (List)requestBody, Object.class);
                }
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setResponse(HttpServletResponse response, HttpStatus httpStatus, ErrorCode errorCode) {
        response.addHeader("WWW-Authenticate", "Bearer realm=\"risesoft\"");
        response.setStatus(httpStatus.value());
        response.setContentType("application/json");
        try {
            response.getWriter().write(Y9JsonUtil.writeValueAsString((Object)Y9Result.failure((ErrorCode)errorCode)));
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    private UserInfo toUserInfo(UserProfile userProfile) {
        UserInfo userInfo = new UserInfo();
        Map map = userProfile.getAttributes();
        userInfo.setCaid((String)map.get("caid"));
        userInfo.setEmail((String)map.get("email"));
        userInfo.setGuidPath((String)map.get("guidPath"));
        userInfo.setLoginName((String)map.get("loginName"));
        userInfo.setLoginType((String)map.get("loginType"));
        userInfo.setMobile((String)map.get("mobile"));
        userInfo.setOriginal(Boolean.parseBoolean(String.valueOf(map.get("original"))));
        userInfo.setOriginalId((String)map.get("originalId"));
        userInfo.setParentId((String)map.get("parentId"));
        userInfo.setPersonId((String)map.get("personId"));
        userInfo.setSex((SexEnum)Y9EnumUtil.valueOf(SexEnum.class, (Object)Integer.valueOf(String.valueOf(map.get("sex")))));
        userInfo.setTenantId((String)map.get("tenantId"));
        userInfo.setTenantShortName((String)map.get("tenantShortName"));
        userInfo.setTenantName((String)map.get("tenantName"));
        userInfo.setGlobalManager(Boolean.parseBoolean(String.valueOf(map.get("globalManager"))));
        userInfo.setAvator((String)map.get("avator"));
        userInfo.setRoles((String)map.get("roles"));
        userInfo.setPositions((String)map.get("positions"));
        userInfo.setPositionId((String)map.get("positionId"));
        return userInfo;
    }
}

