/*
 * Decompiled with CFR 0.152.
 */
package y9.autoconfiguration.oauth2.resource;

import java.util.Collection;
import javax.servlet.Filter;
import net.risesoft.y9.configuration.Y9Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;
import y9.oauth2.resource.filter.Y9Oauth2ResourceFilter;

@Configuration
@EnableConfigurationProperties(value={Y9Properties.class})
@ConditionalOnProperty(name={"y9.feature.oauth2.resource.enabled"}, havingValue="true", matchIfMissing=true)
public class Y9Oauth2ResourceConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"y9Oauth2ResourceFilter"})
    public FilterRegistrationBean<Y9Oauth2ResourceFilter> y9Oauth2ResourceFilter(Y9Properties y9Properties, @Autowired(required=false) KafkaTemplate<String, Object> y9KafkaTemplate) {
        FilterRegistrationBean filterBean = new FilterRegistrationBean();
        filterBean.setFilter((Filter)new Y9Oauth2ResourceFilter(y9Properties, y9KafkaTemplate));
        filterBean.setAsyncSupported(false);
        filterBean.setUrlPatterns((Collection)y9Properties.getFeature().getOauth2().getResource().getProtectedUrlPatterns());
        filterBean.setOrder(-2147483647);
        return filterBean;
    }
}

