/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.views;

import net.ripe.rpki.validator.lib.DateAndTime$;
import net.ripe.rpki.validator.lib.Validation;
import net.ripe.rpki.validator.lib.ValueAndTime;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.views.RtrSessionsView$;
import net.ripe.rpki.validator.views.Tab;
import net.ripe.rpki.validator.views.Tabs$;
import net.ripe.rpki.validator.views.View;
import net.ripe.rpki.validator.views.ViewHelpers;
import net.ripe.rpki.validator.views.ViewHelpers$class;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u00015\u0011qB\u0015;s'\u0016\u001c8/[8ogZKWm\u001e\u0006\u0003\u0007\u0011\tQA^5foNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0006\u000191\"$\b\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0005-&,w\u000f\u0005\u0002\u00187%\u0011AD\u0001\u0002\f-&,w\u000fS3ma\u0016\u00148\u000f\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0011M,7o]5p]N\u00042A\n\u00182\u001d\t9CF\u0004\u0002)W5\t\u0011F\u0003\u0002+\u0019\u00051AH]8pizJ\u0011\u0001I\u0005\u0003[}\tq\u0001]1dW\u0006<W-\u0003\u00020a\tA\u0011\n^3sC\ndWM\u0003\u0002.?A\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0004eR\u0014\u0018B\u0001\u001c4\u00059\u0011FO]*fgNLwN\u001c#bi\u0006D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0004]><\bC\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\u0011!\u0018.\\3\u000b\u0005yz\u0014\u0001\u00026pI\u0006T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\"<\u0005!!\u0015\r^3US6,\u0007\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"a\u0006\u0001\t\u000b\u0011\u001a\u0005\u0019A\u0013\t\u000fa\u001a\u0005\u0013!a\u0001s!)!\n\u0001C\u0001\u0017\u0006\u0019A/\u00192\u0016\u00031\u0003\"aF'\n\u00059\u0013!a\u0001+bE\")\u0001\u000b\u0001C\u0001#\u0006)A/\u001b;mKV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002V?\u0005\u0019\u00010\u001c7\n\u0005]#&\u0001\u0002+fqRDQ!\u0017\u0001\u0005\u0002i\u000bAAY8esV\t1\f\u0005\u0002T9&\u0011Q\f\u0016\u0002\b\u001d>$WmU3r\u0011\u0015y\u0006\u0001\"\u0001a\u0003U1wN]7bi\u000e{gN\\3di&|gn\u0015;bi\u0016$\"aW1\t\u000b\tt\u0006\u0019A\u0019\u0002\u0017M,7o]5p]\u0012\u000bG/\u0019\u0005\u0006I\u0002!\t!Z\u0001\u0012M>\u0014X.\u0019;QIV\u0014VmY3jm\u0016$GCA.g\u0011\u0015\u00117\r1\u00012\u0011\u0015A\u0007\u0001\"\u0001j\u000351wN]7biB#WoU3oiR\u00111L\u001b\u0005\u0006E\u001e\u0004\r!\r\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u00035!\u0018.\\3G_Jl\u0017\r\u001e;feV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rw\u00051am\u001c:nCRL!a\u001d9\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\u0003\u0004v\u0001\u0001\u0006IA\\\u0001\u000fi&lWMR8s[\u0006$H/\u001a:!\u000f\u001d9(!!A\t\u0006a\fqB\u0015;s'\u0016\u001c8/[8ogZKWm\u001e\t\u0003/e4q!\u0001\u0002\u0002\u0002#\u0015!pE\u0002z\u001duAQ\u0001R=\u0005\u0002q$\u0012\u0001\u001f\u0005\b}f\f\n\u0011\"\u0001\u0000\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uII*\"!!\u0001+\u0007e\n\u0019a\u000b\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011!C;oG\",7m[3e\u0015\r\tyaH\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\n\u0003\u0013\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RtrSessionsView
implements View,
ViewHelpers {
    private final Iterable<RtrSessionData> sessions;
    private final DateTime now;
    private final DateTimeFormatter timeFormatter;
    private final Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes;
    private final Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers;

    public static final DateTime init$default$2() {
        return RtrSessionsView$.MODULE$.init$default$2();
    }

    @Override
    public final Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$classes;
    }

    @Override
    public final Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$headers;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$classes_$eq(Map map) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$classes = map;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$headers_$eq(Map map) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$headers = map;
    }

    @Override
    public NodeSeq renderMessages(Seq<Validation.FeedbackMessage> messages2, Function1<String, String> fieldNameToText) {
        return ViewHelpers$class.renderMessages(this, messages2, fieldNameToText);
    }

    @Override
    public Tab tab() {
        return Tabs$.MODULE$.RtrSessionsTab();
    }

    public Text title() {
        return new Text("Router Sessions");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NodeSeq body() {
        Elem elem;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n    See below for a list routers that have connected to this validator.\n      See "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", Tabs$.MODULE$.RtrLogTab().url(), (MetaData)$md);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("here"));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)topScope$2, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text(" for debug logging of these connections. \n  "));
        $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("zebra-striped"), (MetaData)$md2);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Remote Address"));
        $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, (Seq)$buf7));
        $buf6.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("State"));
        $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, (Seq)$buf8));
        $buf6.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Last Request from Client"));
        $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$8, (Seq)$buf9));
        $buf6.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Last Serial Sent"));
        $buf6.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, (Seq)$buf10));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf4.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        if (this.sessions.isEmpty()) {
            TopScope$ topScope$11 = Predef$.MODULE$.$scope();
            NodeBuffer $buf12 = new NodeBuffer();
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("colspan", (Seq)new Text("4"), (MetaData)$md3);
            TopScope$ topScope$12 = Predef$.MODULE$.$scope();
            NodeBuffer $buf13 = new NodeBuffer();
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md4);
            TopScope$ topScope$13 = Predef$.MODULE$.$scope();
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("No connections"));
            $buf13.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)topScope$13, (Seq)$buf14));
            $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)topScope$12, (Seq)$buf13));
            Elem elem2 = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$11, (Seq)$buf12);
            elem = elem2;
        } else {
            elem = this.sessions.iterator().map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RtrSessionsView $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Elem apply(RtrSessionData sessionData) {
                    void var2_2;
                    void var3_3;
                    TopScope$ topScope$ = Predef$.MODULE$.$scope();
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)sessionData.remoteAddr().toString().replaceFirst("^/", ""));
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var3_3));
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)this.$outer.formatConnectionState(sessionData));
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$4 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf4 = new NodeBuffer();
                    $buf4.$amp$plus((Object)this.$outer.formatPduReceived(sessionData));
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$5 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf5 = new NodeBuffer();
                    $buf5.$amp$plus((Object)this.$outer.formatPduSent(sessionData));
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf5));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        $buf11.$amp$plus((Object)elem);
        $buf4.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$10, (Seq)$buf11));
        $buf4.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md2, (NamespaceBinding)topScope$3, (Seq)$buf4));
        TopScope$ topScope$14 = Predef$.MODULE$.$scope();
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Comment("\n$(document).ready(function() {\n  $('[rel=twipsy]').twipsy({\n    \"live\": true\n  });\n});\n// "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$14, (Seq)$buf15));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public NodeSeq formatConnectionState(RtrSessionData sessionData) {
        boolean connected = BoxesRunTime.unboxToBoolean((Object)sessionData.connected().value());
        String labelClass = connected ? "label success" : "label";
        String stateText = connected ? "Connected" : "Disconnected";
        String timeText = sessionData.connected().time().toString(this.timeFormatter());
        String periodText = new StringBuilder().append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)sessionData.connected().time(), (ReadableInstant)this.now), DateAndTime$.MODULE$.periodInWords$default$2())).append((Object)" ago").toString();
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
        $md = new UnprefixedAttribute("data-original-title", periodText, (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)timeText);
        $buf2.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf2));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", labelClass, (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)stateText);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)topScope$2, (Seq)$buf3));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    public NodeSeq formatPduReceived(RtrSessionData sessionData) {
        NodeSeq nodeSeq;
        if (sessionData.lastPduReceived().isDefined()) {
            String pduName = (String)((ValueAndTime)sessionData.lastPduReceived().get()).value();
            String timeText = ((ValueAndTime)sessionData.lastPduReceived().get()).time().toString(this.timeFormatter());
            String periodText = new StringBuilder().append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)sessionData.connected().time(), (ReadableInstant)this.now), DateAndTime$.MODULE$.periodInWords$default$2())).append((Object)" ago").toString();
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
            $md = new UnprefixedAttribute("data-original-title", periodText, (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)timeText);
            $buf2.$amp$plus((Object)new Text(" "));
            $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf2));
            TopScope$ topScope$2 = Predef$.MODULE$.$scope();
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)pduName);
            $buf.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf3));
            nodeSeq = NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
        } else {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        }
        return nodeSeq;
    }

    public NodeSeq formatPduSent(RtrSessionData sessionData) {
        NodeSeq nodeSeq;
        if (sessionData.lastPduSent().isDefined()) {
            String pduName = ((ValueAndTime)sessionData.lastPduSent().get()).value().getClass().getSimpleName();
            String pduDetails = ((Pdu)((ValueAndTime)sessionData.lastPduSent().get()).value()).toPrettyContentString();
            String timeText = ((ValueAndTime)sessionData.lastPduSent().get()).time().toString(this.timeFormatter());
            String periodText = new StringBuilder().append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)sessionData.connected().time(), (ReadableInstant)this.now), DateAndTime$.MODULE$.periodInWords$default$2())).append((Object)" ago").toString();
            NodeBuffer $buf = new NodeBuffer();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
            $md = new UnprefixedAttribute("data-original-title", periodText, (MetaData)$md);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)timeText);
            $buf2.$amp$plus((Object)new Text(" "));
            $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf2));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md2);
            $md2 = new UnprefixedAttribute("data-original-title", pduDetails, (MetaData)$md2);
            TopScope$ topScope$2 = Predef$.MODULE$.$scope();
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)pduName);
            $buf.$amp$plus((Object)new Elem(null, "strong", (MetaData)$md2, (NamespaceBinding)topScope$2, (Seq)$buf3));
            nodeSeq = NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
        } else {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        }
        return nodeSeq;
    }

    public DateTimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    public RtrSessionsView(Iterable<RtrSessionData> sessions, DateTime now) {
        this.sessions = sessions;
        this.now = now;
        ViewHelpers$class.$init$(this);
        this.timeFormatter = ISODateTimeFormat.time();
    }
}

