/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.statistics;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import net.ripe.rpki.validator.statistics.Metric;
import org.joda.time.DateTimeUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\tQb*\u001a;x_J\\7i\u001c8oK\u000e$\u0018N^5us6+GO]5dg*\u00111\u0001B\u0001\u000bgR\fG/[:uS\u000e\u001c(BA\u0003\u0007\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\b\u0011\u0005!!\u000f]6j\u0015\tI!\"\u0001\u0003sSB,'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\u0007\u0001qa\u0003\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!\u0011!Q\u0001\ny\tQB]3q_NLGo\u001c:z+JL\u0007CA\u0010\"\u001b\u0005\u0001#BA\u0006\u0013\u0013\t\u0011\u0003EA\u0002V%&CQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDC\u0001\u0014)!\t9\u0003!D\u0001\u0003\u0011\u0015i2\u00051\u0001\u001f\u0011\u0019Q\u0003\u0001)A\u0005W\u00051An\\4hKJ\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003A\n\u0001b\u001a:jujdW\rZ\u0005\u0003e5\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u001b\u0001A\u0003%Q'\u0001\nE\u000b\u001a\u000bU\u000b\u0014+`%NKfjQ0Q\u001fJ#\u0006CA\f7\u0013\t9\u0004DA\u0002J]RDq!\u000f\u0001C\u0002\u0013\u0005!(\u0001\u0005i_N$h.Y7f+\u0005Y\u0004CA\b=\u0013\ti\u0004C\u0001\u0004TiJLgn\u001a\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001e\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0003bB!\u0001\u0005\u0004%\tAQ\u0001\u0005a>\u0014H/F\u00016\u0011\u0019!\u0005\u0001)A\u0005k\u0005)\u0001o\u001c:uA!)a\t\u0001C\u0001\u000f\u00069Q.\u001a;sS\u000e\u001cX#\u0001%\u0011\u0007%\u000bFK\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q\nD\u0001\u0007yI|w\u000e\u001e \n\u0003eI!\u0001\u0015\r\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0004'\u0016\f(B\u0001)\u0019!\t9S+\u0003\u0002W\u0005\t1Q*\u001a;sS\u000eDa\u0001\u0017\u0001!\n\u0013I\u0016A\u00033og6+GO]5dgV\t!\fE\u0002\\=Rk\u0011\u0001\u0018\u0006\u0003;b\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011F\f\u0003\u0004a\u0001\u0001&I!Y\u0001\u0014G>tg.Z2uSZLG/_'fiJL7m]\u000b\u0002EB\u0019qc\u0019+\n\u0005\u0011D\"!B!se\u0006L\b\u0002\u00034\u0001\u0011\u000b\u0007K\u0011B4\u0002\u0013\u0005$GM]3tg\u0016\u001cX#\u00015\u0011\u0007]\u0019\u0017\u000e\u0005\u0002 U&\u00111\u000e\t\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0003\u0005n\u0001!\u0005\t\u0011)\u0003i\u0003)\tG\r\u001a:fgN,7\u000f\t\u0005\u0007_\u0002\u0001K\u0011\u00029\u0002\u0015Q\u0014\u0018pQ8o]\u0016\u001cG\u000f\u0006\u0002<c\")!O\u001ca\u0001S\u00069\u0011\r\u001a3sKN\u001c\b")
public class NetworkConnectivityMetrics
implements ScalaObject {
    public final URI net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri;
    private final Logger logger;
    private final int DEFAULT_RSYNC_PORT;
    private final String hostname;
    private final int port;
    private InetAddress[] addresses;
    private volatile int bitmap$priv$0;

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Metric> metrics() {
        void var1_1;
        Seq exceptionResult1 = null;
        try {
            exceptionResult1 = (Seq)this.dnsMetrics().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.connectivityMetrics()), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            this.logger.debug((Function0)new Serializable(this, exception){
                public static final long serialVersionUID;
                private final NetworkConnectivityMetrics $outer;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error checking connectivity to %s: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri, this.e$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.e$1 = exception;
                }
            }, (Function0)new Serializable(this, exception){
                public static final long serialVersionUID;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = exception;
                }
            });
            exceptionResult1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(Predef$.MODULE$.augmentString("network.connectivity[%s].exception").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), exception.toString(), DateTimeUtils.currentTimeMillis())}));
        }
        return var1_1;
    }

    private Seq<Metric> dnsMetrics() {
        long now = DateTimeUtils.currentTimeMillis();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(Predef$.MODULE$.augmentString("network.connectivity[%s].ipv4.count").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), ((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.addresses()).count((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(InetAddress inetAddress) {
                return inetAddress instanceof Inet4Address;
            }
        }))).toString(), now), new Metric(Predef$.MODULE$.augmentString("network.connectivity[%s].ipv6.count").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostname()})), ((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.addresses()).count((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(InetAddress inetAddress) {
                return inetAddress instanceof Inet6Address;
            }
        }))).toString(), now)}));
    }

    private Metric[] connectivityMetrics() {
        return (Metric[])Predef$.MODULE$.refArrayOps((Object[])this.addresses()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final NetworkConnectivityMetrics $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Metric> apply(InetAddress address) {
                long start = DateTimeUtils.currentTimeMillis();
                String status = this.$outer.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$tryConnect(address);
                long stop = DateTimeUtils.currentTimeMillis();
                long elapsed = stop - start;
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Metric[]{new Metric(Predef$.MODULE$.augmentString("network.connectivity[%s].status").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})), status, stop), new Metric(Predef$.MODULE$.augmentString("network.connectivity[%s].elapsed.ms").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})), ((Object)BoxesRunTime.boxToLong((long)elapsed)).toString(), stop)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Metric.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InetAddress[] addresses() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.addresses;
        NetworkConnectivityMetrics networkConnectivityMetrics = this;
        synchronized (networkConnectivityMetrics) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.addresses = this.liftedTree1$1();
                this.bitmap$priv$0 |= 1;
            }
            return this.addresses;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public final String net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$tryConnect(InetAddress address) {
        void var3_3;
        block10: {
            Socket s = new Socket();
            String exceptionResult2 = null;
            s.setSoTimeout(300000);
            s.connect(new InetSocketAddress(address, this.port()));
            exceptionResult2 = "OK";
            try {
                s.close();
                break block10;
            }
            catch (IOException iOException) {}
            catch (IOException iOException) {
                try {
                    exceptionResult2 = iOException.toString();
                }
                catch (Throwable throwable) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    s.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final InetAddress[] liftedTree1$1() {
        void var1_1;
        InetAddress[] exceptionResult3 = null;
        try {
            exceptionResult3 = InetAddress.getAllByName(this.hostname());
        }
        catch (UnknownHostException unknownHostException) {
            exceptionResult3 = (InetAddress[])Array$.MODULE$.empty(ClassManifest$.MODULE$.classType(InetAddress.class));
        }
        return var1_1;
    }

    public NetworkConnectivityMetrics(URI repositoryUri) {
        this.net$ripe$rpki$validator$statistics$NetworkConnectivityMetrics$$repositoryUri = repositoryUri;
        this.logger = Logger$.MODULE$.apply(Manifest$.MODULE$.classType(NetworkConnectivityMetrics.class));
        this.DEFAULT_RSYNC_PORT = 873;
        this.hostname = repositoryUri.getHost();
        this.port = repositoryUri.getPort() == -1 ? this.DEFAULT_RSYNC_PORT : repositoryUri.getPort();
    }
}

