/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import akka.dispatch.ExecutionContext;
import akka.dispatch.Future;
import akka.dispatch.Future$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump$;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader$;
import net.ripe.rpki.validator.bgp.preview.BgpRisEntry;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Right;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001f\t!\"i\u001a9SSN$U/\u001c9E_^tGn\\1eKJT!a\u0001\u0003\u0002\u000fA\u0014XM^5fo*\u0011QAB\u0001\u0004E\u001e\u0004(BA\u0004\t\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\n\u0015\u0005!!\u000f]6j\u0015\tYA\"\u0001\u0003sSB,'\"A\u0007\u0002\u00079,Go\u0001\u0001\u0014\t\u0001\u0001\u0002\u0004\t\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0006g24GG\u001b\u0006\u0002;\u0005AqM]5{u2,G-\u0003\u0002 5\t9Aj\\4hS:<\u0007CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u000bQR$\bo\u00117jK:$\bCA\u00153\u001b\u0005Q#BA\u0016-\u0003\u0019\u0019G.[3oi*\u0011QFL\u0001\u0005QR$\bO\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005)AE\u000f\u001e9DY&,g\u000e\u001e\u0005\u0006k\u0001!\tAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005]J\u0004C\u0001\u001d\u0001\u001b\u0005\u0011\u0001\"B\u00145\u0001\u0004A\u0003bB\u001e\u0001\u0005\u0004%\t\u0001P\u0001\r\t\u00163\u0015)\u0016'U?V\u0013FjU\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001\u0011\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+Z9\u0011\u0005E!\u0015BA#\u0013\u0005\u0019\u0019FO]5oO\"1q\t\u0001Q\u0001\nu\nQ\u0002R#G\u0003VcEkX+S\u0019N\u0003\u0003\"B%\u0001\t\u0003Q\u0015\u0001\u00033po:dw.\u00193\u0015\u0005-cFC\u0001'X!\ri%\u000bV\u0007\u0002\u001d*\u0011q\nU\u0001\tI&\u001c\b/\u0019;dQ*\t\u0011+\u0001\u0003bW.\f\u0017BA*O\u0005\u00191U\u000f^;sKB\u0011\u0001(V\u0005\u0003-\n\u0011!BQ4q%&\u001cH)^7q\u0011\u0015A\u0006\nq\u0001Z\u0003\t)7\r\u0005\u0002N5&\u00111L\u0014\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ!\u0018%A\u0002Q\u000bA\u0001Z;na\")q\f\u0001C\u0005A\u0006aA.Y:u\u001b>$\u0017NZ5fIR\u0011\u0011\r\u001c\t\u0004C\t$\u0017BA2#\u0005\u0019y\u0005\u000f^5p]B\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0005i&lWM\u0003\u0002ja\u0005!!n\u001c3b\u0013\tYgM\u0001\u0005ECR,G+[7f\u0011\u0015ig\f1\u0001o\u0003!\u0011Xm\u001d9p]N,\u0007CA8q\u001b\u0005a\u0013BA9-\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0011\u0019\u0019\b\u0001\"\u0005\u0003i\u0006\u0019R.Y6f%\u0016\u001c\bo\u001c8tK\"\u000bg\u000e\u001a7feR\u0011Qo\u001f\n\u0004mBAh\u0001B<\u0001\u0001U\u0014A\u0002\u0010:fM&tW-\\3oiz\u00022!K=U\u0013\tQ(FA\bSKN\u0004xN\\:f\u0011\u0006tG\r\\3s\u0011\u0015i&\u000f1\u0001U\u0001")
public class BgpRisDumpDownloader
implements Logging {
    public final HttpClient net$ripe$rpki$validator$bgp$preview$BgpRisDumpDownloader$$httpClient;
    private final Seq<String> DEFAULT_URLS;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Logger grizzled$slf4j$Logging$$_logger() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.grizzled$slf4j$Logging$$_logger;
        BgpRisDumpDownloader bgpRisDumpDownloader = this;
        synchronized (bgpRisDumpDownloader) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$priv$0 |= 1;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public Seq<String> DEFAULT_URLS() {
        return this.DEFAULT_URLS;
    }

    public Future<BgpRisDump> download(BgpRisDump dump$1, ExecutionContext ec) {
        return Future$.MODULE$.apply((Function0)new Serializable(this, dump$1){
            public static final long serialVersionUID;
            private final BgpRisDumpDownloader $outer;
            public final BgpRisDump dump$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final BgpRisDump apply() {
                void var1_1;
                BgpRisDump exceptionResult1 = null;
                try {
                    HttpGet get$1 = new HttpGet(this.dump$1.url());
                    this.dump$1.lastModified().foreach((Function1)new Serializable(this, get$1){
                        public static final long serialVersionUID;
                        private final HttpGet get$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(DateTime lastModified2) {
                            this.get$1.addHeader("If-Modified-Since", DateUtils.formatDate((Date)lastModified2.toDate()));
                        }
                        {
                            this.get$1 = httpGet;
                        }
                    });
                    ResponseHandler responseHandler = this.$outer.makeResponseHandler(this.dump$1);
                    exceptionResult1 = (BgpRisDump)this.$outer.net$ripe$rpki$validator$bgp$preview$BgpRisDumpDownloader$$httpClient.execute((HttpUriRequest)get$1, responseHandler);
                }
                catch (Exception exception) {
                    this.$outer.error((Function0)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$download$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"error retrieving BGP entries from ").append((Object)this.$outer.dump$1.url()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Function0)new Serializable(this, exception){
                        public static final long serialVersionUID;
                        private final Exception e$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = exception;
                        }
                    });
                    exceptionResult1 = this.dump$1;
                }
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dump$1 = bgpRisDump;
            }
        }, ec);
    }

    public final Option<DateTime> net$ripe$rpki$validator$bgp$preview$BgpRisDumpDownloader$$lastModified(HttpResponse response) {
        return Option$.MODULE$.apply((Object)response.getFirstHeader("Last-Modified")).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final DateTime apply(Header h) {
                return new DateTime((Object)DateUtils.parseDate((String)h.getValue()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public ResponseHandler makeResponseHandler(BgpRisDump dump$2) {
        void var2_2;
        ResponseHandler<BgpRisDump> responseHandler = new ResponseHandler<BgpRisDump>(this, dump$2){
            private final BgpRisDumpDownloader $outer;
            public final BgpRisDump dump$2;

            /*
             * WARNING - void declaration
             */
            public BgpRisDump handleResponse(HttpResponse response$1) {
                BgpRisDump bgpRisDump;
                int n = response$1.getStatusLine().getStatusCode();
                switch (n) {
                    case 304: {
                        if (this.gd1$1()) {
                            EntityUtils.consume((HttpEntity)response$1.getEntity());
                            this.$outer.info((Function0)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anon$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"BGP entries from ").append((Object)this.$outer.dump$2.url()).append((Object)" were not modified since ").append(this.$outer.dump$2.lastModified().get()).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            bgpRisDump = this.dump$2;
                            break;
                        }
                    }
                    default: {
                        EntityUtils.consume((HttpEntity)response$1.getEntity());
                        this.$outer.warn((Function0)new Serializable(this, response$1){
                            public static final long serialVersionUID;
                            private final $anon$1 $outer;
                            private final HttpResponse response$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"error retrieving BGP entries from ").append((Object)this.$outer.dump$2.url()).append((Object)". Code: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.getStatusLine().getStatusCode())).append((Object)" ").append((Object)this.response$1.getStatusLine().getReasonPhrase()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.response$1 = httpResponse;
                            }
                        });
                        bgpRisDump = this.dump$2;
                        break;
                    }
                    case 200: {
                        void var3_3;
                        BgpRisDump exceptionResult2 = null;
                        try {
                            BgpRisDump bgpRisDump2;
                            Either<Exception, IndexedSeq<BgpRisEntry>> either = BgpRisDump$.MODULE$.parse(new GZIPInputStream(response$1.getEntity().getContent()));
                            if (either instanceof Left) {
                                Exception exception;
                                Left left = (Left)either;
                                Exception exception$1 = exception = (Exception)left.a();
                                this.$outer.error((Function0)new Serializable(this, exception$1){
                                    public static final long serialVersionUID;
                                    private final $anon$1 $outer;
                                    private final Exception exception$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Error parsing BGP entries from ").append((Object)this.$outer.dump$2.url()).append((Object)". ").append((Object)this.exception$1.toString()).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.exception$1 = exception;
                                    }
                                }, (Function0)new Serializable(this, exception$1){
                                    public static final long serialVersionUID;
                                    private final Exception exception$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final Exception apply() {
                                        return this.exception$1;
                                    }
                                    {
                                        this.exception$1 = exception;
                                    }
                                });
                                bgpRisDump2 = this.dump$2;
                            } else if (either instanceof Right) {
                                IndexedSeq indexedSeq;
                                Right right = (Right)either;
                                IndexedSeq entries$1 = indexedSeq = (IndexedSeq)right.b();
                                Option<DateTime> modified$1 = this.$outer.net$ripe$rpki$validator$bgp$preview$BgpRisDumpDownloader$$lastModified(response$1);
                                this.$outer.info((Function0)new Serializable(this, entries$1, modified$1){
                                    public static final long serialVersionUID;
                                    private final $anon$1 $outer;
                                    private final IndexedSeq entries$1;
                                    private final Option modified$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Retrieved ").append((Object)BoxesRunTime.boxToInteger((int)this.entries$1.size())).append((Object)" entries from ").append((Object)this.$outer.dump$2.url()).append((Object)", last modified at ").append(this.modified$1.getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return "unknown";
                                            }
                                        })).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.entries$1 = indexedSeq;
                                        this.modified$1 = option;
                                    }
                                });
                                Option<DateTime> x$1 = modified$1;
                                IndexedSeq x$2 = entries$1;
                                String x$3 = this.dump$2.copy$default$1();
                                bgpRisDump2 = this.dump$2.copy(x$3, x$1, (Seq)x$2);
                            } else {
                                throw new MatchError(either);
                            }
                            exceptionResult2 = bgpRisDump2;
                        }
                        catch (Exception exception) {
                            this.$outer.error((Function0)new Serializable(this, exception){
                                public static final long serialVersionUID;
                                private final $anon$1 $outer;
                                private final Exception exception$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Error parsing BGP entries from ").append((Object)this.$outer.dump$2.url()).append((Object)". ").append((Object)this.exception$2.toString()).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.exception$2 = exception;
                                }
                            }, (Function0)new Serializable(this, exception){
                                public static final long serialVersionUID;
                                private final Exception exception$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Exception apply() {
                                    return this.exception$2;
                                }
                                {
                                    this.exception$2 = exception;
                                }
                            });
                            exceptionResult2 = this.dump$2;
                        }
                        bgpRisDump = var3_3;
                    }
                }
                return bgpRisDump;
            }

            private final boolean gd1$1() {
                return this.dump$2.lastModified().isDefined();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dump$2 = bgpRisDump;
            }
        };
        return var2_2;
    }

    public BgpRisDumpDownloader(HttpClient httpClient) {
        this.net$ripe$rpki$validator$bgp$preview$BgpRisDumpDownloader$$httpClient = httpClient;
        Logging.class.$init$((Logging)this);
        this.DEFAULT_URLS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://www.ris.ripe.net/dumps/riswhoisdump.IPv4.gz", "http://www.ris.ripe.net/dumps/riswhoisdump.IPv6.gz"}));
    }
}

