/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple3;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.InTxnImpl;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.concurrent.stm.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonTxn$
implements ScalaObject {
    public static final NonTxn$ MODULE$;

    static {
        new NonTxn$();
    }

    private void weakAwaitUnowned(Handle<?> handle, long m0) throws InterruptedException {
        CCSTM$.MODULE$.weakAwaitUnowned(handle, m0, null);
    }

    private void weakAwaitNewVersion(Handle<?> handle, long m0) throws InterruptedException {
        long m = 0L;
        int spins = 0;
        do {
            long m2;
            if (CCSTM$.MODULE$.version(m2 = handle.meta()) != CCSTM$.MODULE$.version(m0)) {
                return;
            }
            if (++spins <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
        } while (spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount());
        this.weakNoSpinAwaitNewVersion(handle, m);
    }

    private void weakNoSpinAwaitNewVersion(Handle<?> handle, long m0) throws InterruptedException {
        WakeupManager.Event event = CCSTM$.MODULE$.wakeupManager().subscribe();
        event.addSource(handle);
        do {
            long m;
            if (CCSTM$.MODULE$.version(m = handle.meta()) != CCSTM$.MODULE$.version(m0) || CCSTM$.MODULE$.changing(m)) {
                return;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            event.await();
            return;
        } while (!event.triggered());
    }

    private boolean weakAwaitNewVersion(Handle<?> handle, long m0, long nanoDeadline) throws InterruptedException {
        long m = 0L;
        int spins = 0;
        do {
            long m2;
            if (CCSTM$.MODULE$.version(m2 = handle.meta()) != CCSTM$.MODULE$.version(m0)) {
                return true;
            }
            if (++spins <= CCSTM$.MODULE$.SpinCount()) continue;
            if (System.nanoTime() >= nanoDeadline) {
                return false;
            }
            Thread.yield();
        } while (spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount());
        if (CCSTM$.MODULE$.changing(m)) {
            this.weakAwaitUnowned(handle, m);
            return true;
        }
        return this.weakNoSpinAwaitNewVersion(handle, m, nanoDeadline);
    }

    private boolean weakNoSpinAwaitNewVersion(Handle<?> handle, long m0, long nanoDeadline) throws InterruptedException {
        WakeupManager.Event event = CCSTM$.MODULE$.wakeupManager().subscribe();
        event.addSource(handle);
        do {
            long m;
            if (CCSTM$.MODULE$.version(m = handle.meta()) != CCSTM$.MODULE$.version(m0) || CCSTM$.MODULE$.changing(m)) {
                return true;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            return event.tryAwaitUntil(nanoDeadline);
        } while (!event.triggered());
        return true;
    }

    private long acquireLock(Handle<?> handle, boolean exclusive) throws InterruptedException {
        long mOwned;
        long m0 = 0L;
        long m1 = 0L;
        do {
            m0 = handle.meta();
            while (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
                this.weakAwaitUnowned(handle, m0);
                m0 = handle.meta();
            }
            mOwned = CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot());
        } while (!handle.metaCAS(m0, m1 = exclusive ? CCSTM$.MODULE$.withChanging(mOwned) : mOwned));
        return m1;
    }

    private long tryAcquireExclusiveLock(Handle<?> handle) {
        long m0 = handle.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return 0L;
        }
        long m1 = CCSTM$.MODULE$.withChanging(CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot()));
        if (handle.metaCAS(m0, m1)) {
            return m1;
        }
        return 0L;
    }

    private long upgradeLock(Handle<?> handle, long m0) {
        long before = m0;
        if (!handle.metaCAS(before, CCSTM$.MODULE$.withChanging(before))) {
            before = CCSTM$.MODULE$.withPendingWakeups(before);
            handle.meta_$eq(CCSTM$.MODULE$.withChanging(before));
        }
        return CCSTM$.MODULE$.withChanging(before);
    }

    private <T> void commitUpdate(Handle<T> handle, long m0, T newData) {
        long newVersion = CCSTM$.MODULE$.nonTxnWriteVersion(CCSTM$.MODULE$.version(m0));
        handle.data_$eq(newData);
        this.releaseLock(handle, m0, newVersion);
    }

    private void discardLock(Handle<?> handle, long m0) {
        this.releaseLock(handle, m0, CCSTM$.MODULE$.version(m0));
    }

    private void releaseLock(Handle<?> handle, long m0, long newVersion) {
        handle.meta_$eq(CCSTM$.MODULE$.withCommit(m0, newVersion));
        if (CCSTM$.MODULE$.pendingWakeups(m0)) {
            this.triggerWakeups(handle);
        }
    }

    private void triggerWakeups(Handle<?> handle) {
        CCSTM$.MODULE$.wakeupManager().trigger(CCSTM$.MODULE$.wakeupManager().prepareToTrigger(handle));
    }

    public <T> T get(Handle<T> handle) throws InterruptedException {
        long m0 = 0L;
        for (int tries = 0; tries < 100; ++tries) {
            m0 = handle.meta();
            if (CCSTM$.MODULE$.changing(m0)) {
                this.weakAwaitUnowned(handle, m0);
                continue;
            }
            T v = handle.data();
            long m1 = handle.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            return v;
        }
        return this.lockedGet(handle);
    }

    private <T> T lockedGet(Handle<T> handle) throws InterruptedException {
        long m0 = this.acquireLock(handle, false);
        T z = handle.data();
        this.discardLock(handle, m0);
        return z;
    }

    public <T> void await(Handle<T> handle, Function1<T, Object> pred) throws InterruptedException {
        while (true) {
            long m0;
            if (CCSTM$.MODULE$.changing(m0 = handle.meta())) {
                this.weakAwaitUnowned(handle, m0);
                continue;
            }
            T v = handle.data();
            long m1 = handle.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) {
                return;
            }
            this.weakAwaitNewVersion(handle, m1);
        }
    }

    public <T> boolean tryAwait(Handle<T> handle, Function1<T, Object> pred, long timeoutNanos) {
        long begin = 0L;
        while (true) {
            long m0;
            if (CCSTM$.MODULE$.changing(m0 = handle.meta())) {
                if (begin == 0L) {
                    begin = System.nanoTime();
                }
                this.weakAwaitUnowned(handle, m0);
                continue;
            }
            T v = handle.data();
            long m1 = handle.meta();
            if (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1)) continue;
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(v))) {
                return true;
            }
            if (timeoutNanos <= 0L) {
                return false;
            }
            if (begin == 0L) {
                begin = System.nanoTime();
            }
            if (!this.weakAwaitNewVersion(handle, m1, begin + timeoutNanos)) break;
        }
        return false;
    }

    public <T> void set(Handle<T> handle, T v) throws InterruptedException {
        long m0 = this.acquireLock(handle, true);
        this.commitUpdate(handle, m0, v);
    }

    public <T> T swap(Handle<T> handle, T v) throws InterruptedException {
        long m0 = this.acquireLock(handle, true);
        T z = handle.data();
        this.commitUpdate(handle, m0, v);
        return z;
    }

    public <T> boolean trySet(Handle<T> handle, T v) {
        boolean bl;
        long m0 = this.tryAcquireExclusiveLock(handle);
        if (m0 == 0L) {
            bl = false;
        } else {
            this.commitUpdate(handle, m0, v);
            bl = true;
        }
        return bl;
    }

    public <T> boolean compareAndSet(Handle<T> handle, T before, T after) throws InterruptedException {
        boolean success;
        long m0 = handle.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return this.invisibleCAS(handle, before, after);
        }
        long m1 = CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot());
        if (handle.metaCAS(m0, m1)) {
            success = false;
            boolean exceptionResult1 = false;
            if (BoxesRunTime.equals(before, handle.data())) {
                success = true;
                long m2 = this.upgradeLock(handle, m1);
                this.commitUpdate(handle, m2, after);
            }
            exceptionResult1 = success;
            return exceptionResult1;
        }
        return this.invisibleCAS(handle, before, after);
        finally {
            if (!success) {
                this.discardLock(handle, m1);
            }
        }
    }

    private <T> boolean invisibleCAS(Handle<T> handle, T before, T after) throws InterruptedException {
        boolean success;
        long m2;
        long m0 = 0L;
        long m1 = 0L;
        Object v = null;
        do {
            m0 = handle.meta();
            while (CCSTM$.MODULE$.changing(m0)) {
                this.weakAwaitUnowned(handle, m0);
                m0 = handle.meta();
            }
            v = handle.data();
            m1 = handle.meta();
        } while (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1));
        if (BoxesRunTime.equals(before, v)) {
            m2 = this.acquireLock(handle, false);
            success = false;
            boolean exceptionResult2 = false;
            if (CCSTM$.MODULE$.version(m2) == CCSTM$.MODULE$.version(m1) || BoxesRunTime.equals(before, handle.data())) {
                success = true;
                long m3 = this.upgradeLock(handle, m2);
                this.commitUpdate(handle, m3, after);
            }
            exceptionResult2 = success;
            return exceptionResult2;
        }
        return false;
        finally {
            if (!success) {
                this.discardLock(handle, m2);
            }
        }
    }

    public <T, R> boolean compareAndSetIdentity(Handle<T> handle, R before, T after) throws InterruptedException {
        long m0 = handle.meta();
        if (CCSTM$.MODULE$.owner(m0) != CCSTM$.MODULE$.unownedSlot()) {
            return this.invisibleCASI(handle, before, after);
        }
        long m1 = CCSTM$.MODULE$.withChanging(CCSTM$.MODULE$.withOwner(m0, CCSTM$.MODULE$.nonTxnSlot()));
        if (handle.metaCAS(m0, m1)) {
            boolean bl;
            if (before == handle.data()) {
                this.commitUpdate(handle, m1, after);
                bl = true;
            } else {
                this.discardLock(handle, m1);
                bl = false;
            }
            return bl;
        }
        return this.invisibleCASI(handle, before, after);
    }

    private <T, R extends T> boolean invisibleCASI(Handle<T> handle, R before, T after) throws InterruptedException {
        boolean bl;
        if (before == this.get(handle)) {
            long m0 = this.acquireLock(handle, true);
            if (before == handle.data()) {
                this.commitUpdate(handle, m0, after);
                bl = true;
            } else {
                this.discardLock(handle, m0);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public <T> T getAndTransform(Handle<T> handle, Function1<T, T> f) throws InterruptedException {
        return this.getAndTransformImpl(handle, f, this.acquireLock(handle, false));
    }

    private <T> T getAndTransformImpl(Handle<T> handle, Function1<T, T> f, long m0) {
        T v0 = handle.data();
        Object exceptionResult3 = null;
        try {
            Object repl = exceptionResult3 = f.apply(v0);
            long m1 = this.upgradeLock(handle, m0);
            this.commitUpdate(handle, m1, repl);
        }
        catch (Throwable throwable) {
            this.discardLock(handle, m0);
            throw throwable;
        }
        return v0;
    }

    public <T> T transformAndGet(Handle<T> handle, Function1<T, T> f) throws InterruptedException {
        return this.transformAndGetImpl(handle, f, this.acquireLock(handle, false));
    }

    private <T> T transformAndGetImpl(Handle<T> handle, Function1<T, T> f, long m0) {
        Object repl;
        Object exceptionResult4 = null;
        try {
            repl = exceptionResult4 = f.apply(handle.data());
            long m1 = this.upgradeLock(handle, m0);
            this.commitUpdate(handle, m1, repl);
        }
        catch (Throwable throwable) {
            this.discardLock(handle, m0);
            throw throwable;
        }
        return (T)repl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> boolean transformIfDefined(Handle<T> handle, PartialFunction<T, T> pf) throws InterruptedException {
        long m0;
        block4: {
            Object exceptionResult6;
            if (!pf.isDefinedAt(this.get(handle))) return false;
            m0 = this.acquireLock(handle, false);
            T v = handle.data();
            boolean exceptionResult5 = false;
            try {
                exceptionResult5 = pf.isDefinedAt(v);
                if (!exceptionResult5) break block4;
                exceptionResult6 = null;
            }
            catch (Throwable throwable) {
                this.discardLock(handle, m0);
                throw throwable;
            }
            try {
                Object repl = exceptionResult6 = pf.apply(v);
                long m1 = this.upgradeLock(handle, m0);
                this.commitUpdate(handle, m1, repl);
                return true;
            }
            catch (Throwable throwable) {
                this.discardLock(handle, m0);
                throw throwable;
            }
        }
        this.discardLock(handle, m0);
        return false;
    }

    public <A, B, Z> Z transform2(Handle<A> handleA, Handle<B> handleB, Function2<A, B, Tuple3<A, B, Z>> f) throws InterruptedException {
        Tuple3 tuple3;
        block4: {
            long mA0 = 0L;
            long mB0 = 0L;
            int tries = 0;
            do {
                mA0 = this.acquireLock(handleA, true);
                mB0 = this.tryAcquireExclusiveLock(handleB);
                if (mB0 != 0L) continue;
                this.discardLock(handleA, mA0);
                mA0 = 0L;
                Handle<A> handle = handleA;
                Handle<B> handle2 = handleB;
                if (!(handle != null ? !handle.equals(handle2) : handle2 != null)) {
                    return this.fallbackTransform2(handleA, handleB, f);
                }
                mB0 = this.acquireLock(handleB, true);
                mA0 = this.tryAcquireExclusiveLock(handleA);
                if (mA0 != 0L) continue;
                this.discardLock(handleB, mB0);
                mB0 = 0L;
                if (++tries <= 10) continue;
                return this.fallbackTransform2(handleA, handleB, f);
            } while (mB0 == 0L);
            Tuple3 exceptionResult7 = null;
            try {
                tuple3 = exceptionResult7 = (Tuple3)f.apply(handleA.data(), handleB.data());
                if (tuple3 == null) break block4;
            }
            catch (Throwable throwable) {
                this.discardLock(handleA, mA0);
                this.discardLock(handleB, mB0);
                throw throwable;
            }
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            Object a = tuple32._1();
            Object b = tuple32._2();
            Object z = tuple32._3();
            handleA.data_$eq(a);
            handleB.data_$eq(b);
            long wv = CCSTM$.MODULE$.nonTxnWriteVersion(scala.math.package$.MODULE$.max(CCSTM$.MODULE$.version(mA0), CCSTM$.MODULE$.version(mB0)));
            this.releaseLock(handleA, mA0, wv);
            this.releaseLock(handleB, mB0, wv);
            return (Z)z;
        }
        throw new MatchError((Object)tuple3);
    }

    private <A, B, Z> Z fallbackTransform2(Handle<A> handleA$3, Handle<B> handleB$3, Function2<A, B, Tuple3<A, B, Z>> f$1) throws InterruptedException {
        return package$.MODULE$.atomic().apply(new Serializable(handleA$3, handleB$3, f$1){
            public static final long serialVersionUID;
            private final Handle handleA$3;
            private final Handle handleB$3;
            private final Function2 f$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Z apply(InTxn t) {
                T b0;
                InTxnImpl txn = (InTxnImpl)t;
                T a0 = txn.get(this.handleA$3);
                Tuple3 tuple3 = (Tuple3)this.f$1.apply(a0, b0 = txn.get(this.handleB$3));
                if (tuple3 != null) {
                    Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                    Object a1 = tuple32._1();
                    Object b1 = tuple32._2();
                    Object z = tuple32._3();
                    txn.set(this.handleA$3, a1);
                    txn.set(this.handleB$3, b1);
                    return (Z)z;
                }
                throw new MatchError((Object)tuple3);
            }
            {
                this.handleA$3 = handle;
                this.handleB$3 = handle2;
                this.f$1 = function2;
            }
        }, MaybeTxn$.MODULE$.unknown());
    }

    public <A, B> boolean ccasi(Handle<A> handleA$2, A a0$2, Handle<B> handleB$2, B b0$2, B b1$1) throws InterruptedException {
        block0: for (int tries = 0; tries < 10; ++tries) {
            A a;
            long mB0 = this.acquireLock(handleB$2, true);
            if (b0$2 != handleB$2.data()) {
                this.discardLock(handleB$2, mB0);
                return false;
            }
            long mA0 = handleA$2.meta();
            while (true) {
                if (CCSTM$.MODULE$.changing(mA0)) {
                    this.discardLock(handleB$2, mB0);
                    this.weakAwaitUnowned(handleA$2, mA0);
                    continue block0;
                }
                a = handleA$2.data();
                long mA1 = handleA$2.meta();
                if (CCSTM$.MODULE$.changingAndVersion(mA0) == CCSTM$.MODULE$.changingAndVersion(mA1)) break;
                mA0 = mA1;
            }
            if (a == a0$2) {
                this.commitUpdate(handleB$2, mB0, b1$1);
                return true;
            }
            this.discardLock(handleB$2, mB0);
            return false;
        }
        return BoxesRunTime.unboxToBoolean(package$.MODULE$.atomic().apply(new Serializable(handleA$2, a0$2, handleB$2, b0$2, b1$1){
            public static final long serialVersionUID;
            private final Handle handleA$2;
            private final Object a0$2;
            private final Handle handleB$2;
            private final Object b0$2;
            private final Object b1$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(InTxn t) {
                InTxnImpl txn = (InTxnImpl)t;
                if (txn.get(this.handleA$2) != this.a0$2) return false;
                if (txn.get(this.handleB$2) != this.b0$2) return false;
                txn.set(this.handleB$2, this.b1$1);
                if (!true) return false;
                return true;
            }
            {
                this.handleA$2 = handle;
                this.a0$2 = object;
                this.handleB$2 = handle2;
                this.b0$2 = object2;
                this.b1$1 = object3;
            }
        }, MaybeTxn$.MODULE$.unknown()));
    }

    public <A, B> boolean cci(Handle<A> handleA$1, A a0$1, Handle<B> handleB$1, B b0$1) throws InterruptedException {
        for (int tries = 0; tries < 10; ++tries) {
            long mA0 = handleA$1.meta();
            long mB0 = handleB$1.meta();
            if (!CCSTM$.MODULE$.changing(mA0) && !CCSTM$.MODULE$.changing(mB0)) {
                B b = handleB$1.data();
                A a = handleA$1.data();
                long mA1 = handleA$1.meta();
                long mB1 = handleB$1.meta();
                if (CCSTM$.MODULE$.changingAndVersion(mA0) == CCSTM$.MODULE$.changingAndVersion(mA1) && CCSTM$.MODULE$.changingAndVersion(mB0) == CCSTM$.MODULE$.changingAndVersion(mB1)) {
                    return a0$1 == a && b0$1 == b;
                }
            }
            if (CCSTM$.MODULE$.changing(mA0)) {
                this.weakAwaitUnowned(handleA$1, mA0);
            }
            if (!CCSTM$.MODULE$.changing(mB0)) continue;
            this.weakAwaitUnowned(handleB$1, mB0);
        }
        return BoxesRunTime.unboxToBoolean(package$.MODULE$.atomic().apply(new Serializable(handleA$1, a0$1, handleB$1, b0$1){
            public static final long serialVersionUID;
            private final Handle handleA$1;
            private final Object a0$1;
            private final Handle handleB$1;
            private final Object b0$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(InTxn t) {
                InTxnImpl txn = (InTxnImpl)t;
                return txn.get(this.handleA$1) == this.a0$1 && txn.get(this.handleB$1) == this.b0$1;
            }
            {
                this.handleA$1 = handle;
                this.a0$1 = object;
                this.handleB$1 = handle2;
                this.b0$1 = object2;
            }
        }, MaybeTxn$.MODULE$.unknown()));
    }

    public int getAndAdd(Handle<Object> handle, int delta) throws InterruptedException {
        long m0 = this.acquireLock(handle, true);
        int v0 = BoxesRunTime.unboxToInt((Object)handle.data());
        this.commitUpdate(handle, m0, BoxesRunTime.boxToInteger((int)(v0 + delta)));
        return v0;
    }

    private NonTxn$() {
        MODULE$ = this;
    }
}

