/*
 * Decompiled with CFR 0.152.
 */
package rl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import rl.UrlCodingUtils;
import rl.UrlCodingUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public abstract class UrlCodingUtils$class {
    public static boolean isUrlEncoded(UrlCodingUtils $this, String string) {
        return $this.PctEncoded().findFirstIn((CharSequence)string).isDefined();
    }

    public static boolean containsInvalidUriChars(UrlCodingUtils $this, String string) {
        return $this.rl$UrlCodingUtils$$InvalidChars().findFirstIn((CharSequence)string).isDefined();
    }

    public static boolean needsUrlEncoding(UrlCodingUtils $this, String string) {
        return !$this.isUrlEncoded(string) && $this.containsInvalidUriChars(string);
    }

    public static String ensureUrlEncoding(UrlCodingUtils $this, String string) {
        return $this.needsUrlEncoding(string) ? $this.urlEncode(string, $this.urlEncode$default$2(), $this.urlEncode$default$3(), $this.urlEncode$default$4()) : string;
    }

    public static String ensureUppercasedEncodings(UrlCodingUtils $this, String string) {
        return $this.rl$UrlCodingUtils$$LowerPctEncoded().replaceAllIn((CharSequence)string, (Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Regex.Match match) {
                Regex.Match match2 = match;
                Option option = Regex.Groups$.MODULE$.unapplySeq(match2);
                if (option.isEmpty()) {
                    throw new MatchError((Object)match2);
                }
                Seq seq = (Seq)option.get();
                if (seq == null ? false : seq.lengthCompare(1) == 0) {
                    return new StringBuilder().append((Object)"%").append((Object)((String)seq.apply(0)).toUpperCase(Locale.ENGLISH)).toString();
                }
                throw new MatchError((Object)match2);
            }
        });
    }

    public static String urlEncode(UrlCodingUtils $this, String toEncode, Charset charset, boolean spaceIsPlus, BitSet toSkip) {
        ByteBuffer in = charset.encode($this.ensureUppercasedEncodings(toEncode));
        CharBuffer out = CharBuffer.allocate((int)Predef$.MODULE$.floatWrapper((float)(in.remaining() * 3)).ceil());
        while (in.hasRemaining()) {
            CharBuffer charBuffer;
            int b = in.get() & 0xFF;
            if (toSkip.contains(b)) {
                charBuffer = out.put((char)b);
                continue;
            }
            if (b == $this.rl$UrlCodingUtils$$space() && spaceIsPlus) {
                charBuffer = out.put('+');
                continue;
            }
            out.put('%');
            out.put(BoxesRunTime.unboxToChar((Object)$this.rl$UrlCodingUtils$$HexUpperCaseChars().apply(b >> 4 & 0xF)));
            charBuffer = out.put(BoxesRunTime.unboxToChar((Object)$this.rl$UrlCodingUtils$$HexUpperCaseChars().apply(b & 0xF)));
        }
        out.flip();
        return out.toString();
    }

    public static BitSet urlEncode$default$4(UrlCodingUtils $this) {
        return $this.rl$UrlCodingUtils$$toSkip();
    }

    public static boolean urlEncode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static Charset urlEncode$default$2(UrlCodingUtils $this) {
        return $this.Utf8();
    }

    public static String urlDecode(UrlCodingUtils $this, String toDecode, Charset charset, boolean plusIsSpace, String toSkip) {
        CharBuffer in = CharBuffer.wrap(toDecode);
        ByteBuffer out = ByteBuffer.allocate(in.remaining() * 3);
        BitSet skip = (BitSet)BitSet$.MODULE$.apply(((SetLike)Predef$.MODULE$.augmentString(toSkip).toSet().map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(char c) {
                return c;
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq());
        while (in.hasRemaining()) {
            Buffer buffer;
            int mark = in.position();
            char c = in.get();
            if (c == '%') {
                if (in.remaining() >= 2) {
                    char xc = in.get();
                    char yc = in.get();
                    int x = Character.digit(xc, 16);
                    int y = Character.digit(yc, 16);
                    if (x != -1 && y != -1) {
                        int oo = (x << 4) + y;
                        if (skip.contains(oo)) {
                            out.put((byte)37);
                            out.put((byte)xc);
                            buffer = out.put((byte)yc);
                            continue;
                        }
                        buffer = out.put((byte)oo);
                        continue;
                    }
                    buffer = in.position(mark);
                    continue;
                }
                buffer = in.position(in.position() - 1);
                continue;
            }
            buffer = c == '+' && plusIsSpace ? out.put((byte)32) : ($this.rl$UrlCodingUtils$$toSkip().contains((int)c) ? out.put((byte)c) : out.put(charset.encode(String.valueOf(c))));
        }
        out.flip();
        return charset.decode(out).toString();
    }

    public static String urlDecode$default$4(UrlCodingUtils $this) {
        return "";
    }

    public static boolean urlDecode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static Charset urlDecode$default$2(UrlCodingUtils $this) {
        return $this.Utf8();
    }

    public static void $init$(UrlCodingUtils $this) {
        $this.rl$UrlCodingUtils$_setter_$rl$UrlCodingUtils$$toSkip_$eq((BitSet)BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)((TraversableLike)Predef$.MODULE$.charWrapper('a').to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)Predef$.MODULE$.charWrapper('A').to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.charWrapper('0').to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.augmentString("!$&'()*+,;=:/?#[]@-._~").toSet(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new UrlCodingUtils$.anonfun.1($this), IndexedSeq$.MODULE$.canBuildFrom())));
        $this.rl$UrlCodingUtils$_setter_$rl$UrlCodingUtils$$space_$eq(32);
        $this.rl$UrlCodingUtils$_setter_$PctEncoded_$eq(Predef$.MODULE$.augmentString("%([0-9a-fA-F][0-9a-fA-F])").r());
        $this.rl$UrlCodingUtils$_setter_$rl$UrlCodingUtils$$LowerPctEncoded_$eq(Predef$.MODULE$.augmentString("%([0-9a-f][0-9a-f])").r());
        $this.rl$UrlCodingUtils$_setter_$rl$UrlCodingUtils$$InvalidChars_$eq(Predef$.MODULE$.augmentString("[^\\.a-zA-Z0-9!$&'()*+,;=:/?#\\[\\]@-_~]").r());
        $this.rl$UrlCodingUtils$_setter_$rl$UrlCodingUtils$$HexUpperCaseChars_$eq((IndexedSeq)Predef$.MODULE$.intWrapper(0).until(16).map((Function1)new UrlCodingUtils$.anonfun.2($this), IndexedSeq$.MODULE$.canBuildFrom()));
        $this.rl$UrlCodingUtils$_setter_$UTF_8_$eq("UTF-8");
        $this.rl$UrlCodingUtils$_setter_$Utf8_$eq(Charset.forName($this.UTF_8()));
    }
}

