/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigString;
import com.typesafe.config.impl.FromMapMode;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfigObject;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

final class PropertiesParser {
    PropertiesParser() {
    }

    static AbstractConfigObject parse(Reader reader, ConfigOrigin configOrigin) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return PropertiesParser.fromProperties(configOrigin, properties);
    }

    static String lastElement(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static String exceptLastElement(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    static Path pathFromPropertyKey(String string) {
        String string2 = PropertiesParser.lastElement(string);
        String string3 = PropertiesParser.exceptLastElement(string);
        Path path = new Path(string2, null);
        while (string3 != null) {
            string2 = PropertiesParser.lastElement(string3);
            string3 = PropertiesParser.exceptLastElement(string3);
            path = new Path(string2, path);
        }
        return path;
    }

    static AbstractConfigObject fromProperties(ConfigOrigin configOrigin, Properties properties) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof String)) continue;
            Path path = PropertiesParser.pathFromPropertyKey((String)object);
            hashMap.put(path, entry.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, true);
    }

    static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<?, ?> map) {
        HashMap<Path, Object> hashMap = new HashMap<Path, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            if (!(obj instanceof String)) {
                throw new ConfigException.BugOrBroken("Map has a non-string as a key, expecting a path expression as a String");
            }
            Path path = Path.newPath((String)obj);
            hashMap.put(path, entry.getValue());
        }
        return PropertiesParser.fromPathMap(configOrigin, hashMap, false);
    }

    private static AbstractConfigObject fromPathMap(ConfigOrigin configOrigin, Map<Path, Object> map, boolean bl) {
        AbstractConfigValue abstractConfigValue;
        Object object;
        Object object2;
        HashMap hashMap;
        Serializable serializable;
        Object object3;
        HashSet<Path> hashSet = new HashSet<Path>();
        HashSet<Path> hashSet2 = new HashSet<Path>();
        for (Path serializable22 : map.keySet()) {
            hashSet2.add(serializable22);
            for (object3 = serializable22.parent(); object3 != null; object3 = ((Path)object3).parent()) {
                hashSet.add((Path)object3);
            }
        }
        if (bl) {
            hashSet2.removeAll(hashSet);
        } else {
            for (Path path : hashSet2) {
                if (!hashSet.contains(path)) continue;
                throw new ConfigException.BugOrBroken("In the map, path '" + path.render() + "' occurs as both the parent object of a value and as a value. " + "Because Map has no defined ordering, this is a broken situation.");
            }
        }
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Path path : hashSet) {
            serializable = new HashMap();
            hashMap3.put(path, serializable);
        }
        for (Path path : hashSet2) {
            serializable = path.parent();
            hashMap = serializable != null ? (Map)hashMap3.get(serializable) : hashMap2;
            object2 = path.last();
            object = map.get(path);
            abstractConfigValue = bl ? new ConfigString(configOrigin, (String)object) : ConfigImpl.fromAnyRef(map.get(path), configOrigin, FromMapMode.KEYS_ARE_PATHS);
            hashMap.put(object2, abstractConfigValue);
        }
        object3 = new ArrayList();
        object3.addAll(hashSet);
        Collections.sort(object3, new Comparator<Path>(){

            @Override
            public int compare(Path path, Path path2) {
                return path2.length() - path.length();
            }
        });
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            serializable = (Path)iterator.next();
            hashMap = (Map)hashMap3.get(serializable);
            object2 = ((Path)serializable).parent();
            object = object2 != null ? (Map)hashMap3.get(object2) : hashMap2;
            abstractConfigValue = new SimpleConfigObject(configOrigin, hashMap, ResolveStatus.RESOLVED, false);
            object.put(((Path)serializable).last(), abstractConfigValue);
        }
        return new SimpleConfigObject(configOrigin, hashMap2, ResolveStatus.RESOLVED, false);
    }
}

