/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigSubstitution;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathBuilder;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import com.typesafe.config.impl.Tokens;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

final class Parser {
    static ConfigOrigin apiOrigin = SimpleConfigOrigin.newSimple("path parameter");

    Parser() {
    }

    static AbstractConfigValue parse(Iterator<Token> iterator, ConfigOrigin configOrigin, ConfigParseOptions configParseOptions, ConfigIncludeContext configIncludeContext) {
        ParseContext parseContext = new ParseContext(configParseOptions.getSyntax(), configOrigin, iterator, configParseOptions.getIncluder(), configIncludeContext);
        return parseContext.parse();
    }

    private static void addPathText(List<Element> list, boolean bl, String string) {
        int n = bl ? -1 : string.indexOf(46);
        Element element = list.get(list.size() - 1);
        if (n < 0) {
            element.sb.append(string);
            if (bl && element.sb.length() == 0) {
                element.canBeEmpty = true;
            }
        } else {
            element.sb.append(string.substring(0, n));
            list.add(new Element("", false));
            Parser.addPathText(list, false, string.substring(n + 1));
        }
    }

    private static Path parsePathExpression(Iterator<Token> iterator, ConfigOrigin configOrigin) {
        return Parser.parsePathExpression(iterator, configOrigin, null);
    }

    private static Path parsePathExpression(Iterator<Token> iterator, ConfigOrigin configOrigin, String string) {
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(new Element("", false));
        if (!iterator.hasNext()) {
            throw new ConfigException.BadPath(configOrigin, string, "Expecting a field name or path here, but got nothing");
        }
        while (iterator.hasNext()) {
            Object object3;
            object = iterator.next();
            if (Tokens.isValueWithType((Token)object, ConfigValueType.STRING)) {
                object3 = Tokens.getValue((Token)object);
                String string2 = ((AbstractConfigValue)object3).transformToString();
                Parser.addPathText(arrayList, true, string2);
                continue;
            }
            if (object == Tokens.END) continue;
            if (Tokens.isValue((Token)object)) {
                AbstractConfigValue abstractConfigValue = Tokens.getValue((Token)object);
                object3 = abstractConfigValue.transformToString();
            } else if (Tokens.isUnquotedText((Token)object)) {
                object3 = Tokens.getUnquotedText((Token)object);
            } else {
                throw new ConfigException.BadPath(configOrigin, string, "Token not allowed in path expression: " + object + " (you can double-quote this token if you really want it here)");
            }
            Parser.addPathText(arrayList, false, (String)object3);
        }
        object = new PathBuilder();
        for (Element element : arrayList) {
            if (element.sb.length() == 0 && !element.canBeEmpty) {
                throw new ConfigException.BadPath(configOrigin, string, "path has a leading, trailing, or two adjacent period '.' (use quoted \"\" empty string if you want an empty element)");
            }
            ((PathBuilder)object).appendKey(element.sb.toString());
        }
        return ((PathBuilder)object).result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path parsePath(String string) {
        Path path = Parser.speculativeFastParsePath(string);
        if (path != null) {
            return path;
        }
        StringReader stringReader = new StringReader(string);
        try {
            Iterator<Token> iterator = Tokenizer.tokenize(apiOrigin, stringReader, ConfigSyntax.CONF);
            iterator.next();
            Path path2 = Parser.parsePathExpression(iterator, apiOrigin, string);
            return path2;
        }
        finally {
            stringReader.close();
        }
    }

    private static boolean hasUnsafeChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || c == '.') continue;
            return true;
        }
        return false;
    }

    private static void appendPathString(PathBuilder pathBuilder, String string) {
        int n = string.indexOf(46);
        if (n < 0) {
            pathBuilder.appendKey(string);
        } else {
            pathBuilder.appendKey(string.substring(0, n));
            Parser.appendPathString(pathBuilder, string.substring(n + 1));
        }
    }

    private static Path speculativeFastParsePath(String string) {
        String string2 = ConfigImplUtil.unicodeTrim(string);
        if (string2.isEmpty()) {
            return null;
        }
        if (Parser.hasUnsafeChars(string2)) {
            return null;
        }
        if (string2.startsWith(".") || string2.endsWith(".") || string2.contains("..")) {
            return null;
        }
        PathBuilder pathBuilder = new PathBuilder();
        Parser.appendPathString(pathBuilder, string2);
        return pathBuilder.result();
    }

    static class Element {
        StringBuilder sb;
        boolean canBeEmpty;

        Element(String string, boolean bl) {
            this.canBeEmpty = bl;
            this.sb = new StringBuilder(string);
        }

        public String toString() {
            return "Element(" + this.sb.toString() + "," + this.canBeEmpty + ")";
        }
    }

    private static final class ParseContext {
        private int lineNumber = 1;
        private final Stack<TokenWithComments> buffer = new Stack();
        private final Iterator<Token> tokens;
        private final ConfigIncluder includer;
        private final ConfigIncludeContext includeContext;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private final LinkedList<Path> pathStack;
        int equalsCount;

        ParseContext(ConfigSyntax configSyntax, ConfigOrigin configOrigin, Iterator<Token> iterator, ConfigIncluder configIncluder, ConfigIncludeContext configIncludeContext) {
            this.tokens = iterator;
            this.flavor = configSyntax;
            this.baseOrigin = configOrigin;
            this.includer = configIncluder;
            this.includeContext = configIncludeContext;
            this.pathStack = new LinkedList();
            this.equalsCount = 0;
        }

        private void consolidateCommentBlock(Token token) {
            ArrayList<Token> arrayList = new ArrayList<Token>();
            ArrayList<Token> arrayList2 = new ArrayList<Token>();
            Token token2 = null;
            Token token3 = token;
            while (true) {
                if (Tokens.isNewline(token3)) {
                    if (token2 != null && Tokens.isNewline(token2)) {
                        arrayList2.clear();
                    }
                    arrayList.add(token3);
                } else {
                    if (!Tokens.isComment(token3)) break;
                    arrayList2.add(token3);
                }
                token2 = token3;
                token3 = this.tokens.next();
            }
            this.buffer.push(new TokenWithComments(token3, arrayList2));
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                this.buffer.push(new TokenWithComments((Token)listIterator.previous()));
            }
        }

        private TokenWithComments popToken() {
            if (this.buffer.isEmpty()) {
                Token token = this.tokens.next();
                if (Tokens.isComment(token)) {
                    this.consolidateCommentBlock(token);
                    return this.buffer.pop();
                }
                return new TokenWithComments(token);
            }
            return this.buffer.pop();
        }

        private TokenWithComments nextToken() {
            TokenWithComments tokenWithComments = null;
            tokenWithComments = this.popToken();
            Token token = tokenWithComments.token;
            if (Tokens.isProblem(token)) {
                ConfigOrigin configOrigin = token.origin();
                String string = Tokens.getProblemMessage(token);
                Throwable throwable = Tokens.getProblemCause(token);
                boolean bl = Tokens.getProblemSuggestQuotes(token);
                string = bl ? this.addQuoteSuggestion(token.toString(), string) : this.addKeyName(string);
                throw new ConfigException.Parse(configOrigin, string, throwable);
            }
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isUnquotedText(token)) {
                    throw this.parseError(this.addKeyName("Token not allowed in valid JSON: '" + Tokens.getUnquotedText(token) + "'"));
                }
                if (Tokens.isSubstitution(token)) {
                    throw this.parseError(this.addKeyName("Substitutions (${} syntax) not allowed in JSON"));
                }
            }
            return tokenWithComments;
        }

        private void putBack(TokenWithComments tokenWithComments) {
            this.buffer.push(tokenWithComments);
        }

        private TokenWithComments nextTokenIgnoringNewline() {
            TokenWithComments tokenWithComments = this.nextToken();
            while (Tokens.isNewline(tokenWithComments.token)) {
                this.lineNumber = tokenWithComments.token.lineNumber() + 1;
                tokenWithComments = this.nextToken();
            }
            return tokenWithComments;
        }

        private boolean checkElementSeparator() {
            if (this.flavor == ConfigSyntax.JSON) {
                TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
                if (tokenWithComments.token == Tokens.COMMA) {
                    return true;
                }
                this.putBack(tokenWithComments);
                return false;
            }
            boolean bl = false;
            TokenWithComments tokenWithComments = this.nextToken();
            while (true) {
                if (!Tokens.isNewline(tokenWithComments.token)) {
                    if (tokenWithComments.token == Tokens.COMMA) {
                        return true;
                    }
                    this.putBack(tokenWithComments);
                    return bl;
                }
                this.lineNumber = tokenWithComments.token.lineNumber() + 1;
                bl = true;
                tokenWithComments = this.nextToken();
            }
        }

        private void consolidateValueTokens() {
            if (this.flavor == ConfigSyntax.JSON) {
                return;
            }
            ArrayList<Token> arrayList = null;
            TokenWithComments tokenWithComments = null;
            TokenWithComments tokenWithComments2 = this.nextTokenIgnoringNewline();
            while (Tokens.isValue(tokenWithComments2.token) || Tokens.isUnquotedText(tokenWithComments2.token) || Tokens.isSubstitution(tokenWithComments2.token)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Token>();
                    tokenWithComments = tokenWithComments2;
                }
                arrayList.add(tokenWithComments2.token);
                tokenWithComments2 = this.nextToken();
            }
            this.putBack(tokenWithComments2);
            if (arrayList == null) {
                return;
            }
            if (arrayList.size() == 1 && Tokens.isValue(tokenWithComments.token)) {
                this.putBack(tokenWithComments);
                return;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            StringBuilder stringBuilder = new StringBuilder();
            ConfigOrigin configOrigin = null;
            for (Token token : arrayList) {
                List<Token> list;
                if (Tokens.isValue(token)) {
                    list = Tokens.getValue(token);
                    stringBuilder.append(((AbstractConfigValue)((Object)list)).transformToString());
                    if (configOrigin != null) continue;
                    configOrigin = ((AbstractConfigValue)((Object)list)).origin();
                    continue;
                }
                if (Tokens.isUnquotedText(token)) {
                    list = Tokens.getUnquotedText(token);
                    if (configOrigin == null) {
                        configOrigin = token.origin();
                    }
                    stringBuilder.append((String)((Object)list));
                    continue;
                }
                if (Tokens.isSubstitution(token)) {
                    if (configOrigin == null) {
                        configOrigin = token.origin();
                    }
                    if (stringBuilder.length() > 0) {
                        arrayList2.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    list = Tokens.getSubstitutionPathExpression(token);
                    Path path = Parser.parsePathExpression(list.iterator(), token.origin());
                    boolean bl = Tokens.getSubstitutionOptional(token);
                    arrayList2.add(new SubstitutionExpression(path, bl));
                    continue;
                }
                throw new ConfigException.BugOrBroken("should not be trying to consolidate token: " + token);
            }
            if (stringBuilder.length() > 0) {
                arrayList2.add(stringBuilder.toString());
            }
            if (arrayList2.isEmpty()) {
                throw new ConfigException.BugOrBroken("trying to consolidate values to nothing");
            }
            Object object = null;
            object = arrayList2.size() == 1 && arrayList2.get(0) instanceof String ? Tokens.newString(configOrigin, (String)arrayList2.get(0)) : Tokens.newValue(new ConfigSubstitution(configOrigin, arrayList2));
            this.putBack(new TokenWithComments((Token)object, tokenWithComments.comments));
        }

        private ConfigOrigin lineOrigin() {
            return ((SimpleConfigOrigin)this.baseOrigin).setLineNumber(this.lineNumber);
        }

        private ConfigException parseError(String string) {
            return this.parseError(string, null);
        }

        private ConfigException parseError(String string, Throwable throwable) {
            return new ConfigException.Parse(this.lineOrigin(), string, throwable);
        }

        private String previousFieldName(Path path) {
            if (path != null) {
                return path.render();
            }
            if (this.pathStack.isEmpty()) {
                return null;
            }
            return this.pathStack.peek().render();
        }

        private String previousFieldName() {
            return this.previousFieldName(null);
        }

        private String addKeyName(String string) {
            String string2 = this.previousFieldName();
            if (string2 != null) {
                return "in value for key '" + string2 + "': " + string;
            }
            return string;
        }

        private String addQuoteSuggestion(String string, String string2) {
            return this.addQuoteSuggestion(null, this.equalsCount > 0, string, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String addQuoteSuggestion(Path path, boolean bl, String string, String string2) {
            String string3;
            String string4 = this.previousFieldName(path);
            if (string.equals(Tokens.END.toString())) {
                if (string4 == null) return string2;
                string3 = string2 + " (if you intended '" + string4 + "' to be part of a value, instead of a key, " + "try adding double quotes around the whole value";
            } else {
                string3 = string4 != null ? string2 + " (if you intended " + string + " to be part of the value for '" + string4 + "', " + "try enclosing the value in double quotes" : string2 + " (if you intended " + string + " to be part of a key or string value, " + "try enclosing the key or value in double quotes";
            }
            if (!bl) return string3 + ")";
            return string3 + ", or you may be able to rename the file .properties rather than .conf)";
        }

        private AbstractConfigValue parseValue(TokenWithComments tokenWithComments) {
            AbstractConfigValue abstractConfigValue;
            if (Tokens.isValue(tokenWithComments.token)) {
                abstractConfigValue = Tokens.getValue(tokenWithComments.token);
            } else if (tokenWithComments.token == Tokens.OPEN_CURLY) {
                abstractConfigValue = this.parseObject(true);
            } else if (tokenWithComments.token == Tokens.OPEN_SQUARE) {
                abstractConfigValue = this.parseArray();
            } else {
                throw this.parseError(this.addQuoteSuggestion(tokenWithComments.token.toString(), "Expecting a value but got wrong token: " + tokenWithComments.token));
            }
            abstractConfigValue = abstractConfigValue.withOrigin(tokenWithComments.setComments(abstractConfigValue.origin()));
            return abstractConfigValue;
        }

        private static AbstractConfigObject createValueUnderPath(Path path, AbstractConfigValue abstractConfigValue) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = path.first();
            Path path2 = path.remainder();
            while (string != null) {
                arrayList.add(string);
                if (path2 == null) break;
                string = path2.first();
                path2 = path2.remainder();
            }
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            String string2 = (String)listIterator.previous();
            SimpleConfigObject simpleConfigObject = new SimpleConfigObject(abstractConfigValue.origin().setComments(null), Collections.singletonMap(string2, abstractConfigValue));
            while (listIterator.hasPrevious()) {
                Map<String, AbstractConfigValue> map = Collections.singletonMap(listIterator.previous(), simpleConfigObject);
                simpleConfigObject = new SimpleConfigObject(abstractConfigValue.origin().setComments(null), map);
            }
            return simpleConfigObject;
        }

        private Path parseKey(TokenWithComments tokenWithComments) {
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isValueWithType(tokenWithComments.token, ConfigValueType.STRING)) {
                    String string = (String)Tokens.getValue(tokenWithComments.token).unwrapped();
                    return Path.newKey(string);
                }
                throw this.parseError(this.addKeyName("Expecting close brace } or a field name here, got " + tokenWithComments));
            }
            ArrayList<Token> arrayList = new ArrayList<Token>();
            TokenWithComments tokenWithComments2 = tokenWithComments;
            while (Tokens.isValue(tokenWithComments2.token) || Tokens.isUnquotedText(tokenWithComments2.token)) {
                arrayList.add(tokenWithComments2.token);
                tokenWithComments2 = this.nextToken();
            }
            if (arrayList.isEmpty()) {
                throw this.parseError(this.addKeyName("expecting a close brace or a field name here, got " + tokenWithComments2));
            }
            this.putBack(tokenWithComments2);
            return Parser.parsePathExpression(arrayList.iterator(), this.lineOrigin());
        }

        private static boolean isIncludeKeyword(Token token) {
            return Tokens.isUnquotedText(token) && Tokens.getUnquotedText(token).equals("include");
        }

        private static boolean isUnquotedWhitespace(Token token) {
            if (!Tokens.isUnquotedText(token)) {
                return false;
            }
            String string = Tokens.getUnquotedText(token);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (ConfigImplUtil.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }

        private void parseInclude(Map<String, AbstractConfigValue> map) {
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            while (ParseContext.isUnquotedWhitespace(tokenWithComments.token)) {
                tokenWithComments = this.nextTokenIgnoringNewline();
            }
            if (Tokens.isValueWithType(tokenWithComments.token, ConfigValueType.STRING)) {
                String string = (String)Tokens.getValue(tokenWithComments.token).unwrapped();
                AbstractConfigObject abstractConfigObject = (AbstractConfigObject)this.includer.include(this.includeContext, string);
                if (!this.pathStack.isEmpty()) {
                    Path path = new Path(this.pathStack);
                    abstractConfigObject = abstractConfigObject.relativized(path);
                }
                for (String string2 : abstractConfigObject.keySet()) {
                    AbstractConfigValue abstractConfigValue = abstractConfigObject.get(string2);
                    AbstractConfigValue abstractConfigValue2 = map.get(string2);
                    if (abstractConfigValue2 != null) {
                        map.put(string2, abstractConfigValue.withFallback(abstractConfigValue2));
                        continue;
                    }
                    map.put(string2, abstractConfigValue);
                }
            } else {
                throw this.parseError("include keyword is not followed by a quoted string, but by: " + tokenWithComments);
            }
        }

        private boolean isKeyValueSeparatorToken(Token token) {
            if (this.flavor == ConfigSyntax.JSON) {
                return token == Tokens.COLON;
            }
            return token == Tokens.COLON || token == Tokens.EQUALS;
        }

        private AbstractConfigObject parseObject(boolean bl) {
            ConfigOrigin configOrigin;
            HashMap<String, AbstractConfigValue> hashMap;
            block24: {
                TokenWithComments tokenWithComments;
                hashMap = new HashMap<String, AbstractConfigValue>();
                configOrigin = this.lineOrigin();
                boolean bl2 = false;
                Path path = null;
                boolean bl3 = false;
                while (true) {
                    tokenWithComments = this.nextTokenIgnoringNewline();
                    if (tokenWithComments.token == Tokens.CLOSE_CURLY) {
                        if (this.flavor == ConfigSyntax.JSON && bl2) {
                            throw this.parseError(this.addQuoteSuggestion(tokenWithComments.toString(), "expecting a field name after a comma, got a close brace } instead"));
                        }
                        if (!bl) {
                            throw this.parseError(this.addQuoteSuggestion(tokenWithComments.toString(), "unbalanced close brace '}' with no open brace"));
                        }
                        break block24;
                    }
                    if (tokenWithComments.token == Tokens.END && !bl) {
                        this.putBack(tokenWithComments);
                        break block24;
                    }
                    if (this.flavor != ConfigSyntax.JSON && ParseContext.isIncludeKeyword(tokenWithComments.token)) {
                        this.parseInclude(hashMap);
                        bl2 = false;
                    } else {
                        AbstractConfigValue abstractConfigValue;
                        TokenWithComments tokenWithComments2;
                        TokenWithComments tokenWithComments3 = tokenWithComments;
                        Path path2 = this.parseKey(tokenWithComments3);
                        TokenWithComments tokenWithComments4 = this.nextTokenIgnoringNewline();
                        boolean bl4 = false;
                        this.pathStack.push(path2);
                        if (this.flavor == ConfigSyntax.CONF && tokenWithComments4.token == Tokens.OPEN_CURLY) {
                            tokenWithComments2 = tokenWithComments4;
                        } else {
                            if (!this.isKeyValueSeparatorToken(tokenWithComments4.token)) {
                                throw this.parseError(this.addQuoteSuggestion(tokenWithComments4.toString(), "Key '" + path2.render() + "' may not be followed by token: " + tokenWithComments4));
                            }
                            if (tokenWithComments4.token == Tokens.EQUALS) {
                                bl4 = true;
                                ++this.equalsCount;
                            }
                            this.consolidateValueTokens();
                            tokenWithComments2 = this.nextTokenIgnoringNewline();
                        }
                        AbstractConfigValue abstractConfigValue2 = this.parseValue(tokenWithComments2.prepend(tokenWithComments3.comments));
                        path = this.pathStack.pop();
                        if (bl4) {
                            --this.equalsCount;
                        }
                        bl3 = bl4;
                        String string = path2.first();
                        Path path3 = path2.remainder();
                        if (path3 == null) {
                            abstractConfigValue = (AbstractConfigValue)hashMap.get(string);
                            if (abstractConfigValue != null) {
                                if (this.flavor == ConfigSyntax.JSON) {
                                    throw this.parseError("JSON does not allow duplicate fields: '" + string + "' was already seen at " + abstractConfigValue.origin().description());
                                }
                                abstractConfigValue2 = abstractConfigValue2.withFallback(abstractConfigValue);
                            }
                            hashMap.put(string, abstractConfigValue2);
                        } else {
                            if (this.flavor == ConfigSyntax.JSON) {
                                throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                            }
                            abstractConfigValue = ParseContext.createValueUnderPath(path3, abstractConfigValue2);
                            AbstractConfigValue abstractConfigValue3 = (AbstractConfigValue)hashMap.get(string);
                            if (abstractConfigValue3 != null) {
                                abstractConfigValue = ((AbstractConfigObject)abstractConfigValue).withFallback(abstractConfigValue3);
                            }
                            hashMap.put(string, abstractConfigValue);
                        }
                        bl2 = false;
                    }
                    if (!this.checkElementSeparator()) break;
                    bl2 = true;
                }
                tokenWithComments = this.nextTokenIgnoringNewline();
                if (tokenWithComments.token == Tokens.CLOSE_CURLY) {
                    if (!bl) {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "unbalanced close brace '}' with no open brace"));
                    }
                } else {
                    if (bl) {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "Expecting close brace } or a comma, got " + tokenWithComments));
                    }
                    if (tokenWithComments.token == Tokens.END) {
                        this.putBack(tokenWithComments);
                    } else {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "Expecting end of input or a comma, got " + tokenWithComments));
                    }
                }
            }
            return new SimpleConfigObject(configOrigin, hashMap);
        }

        private SimpleConfigList parseArray() {
            ConfigOrigin configOrigin = this.lineOrigin();
            ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
            this.consolidateValueTokens();
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token == Tokens.CLOSE_SQUARE) {
                return new SimpleConfigList(configOrigin, Collections.<AbstractConfigValue>emptyList());
            }
            if (!Tokens.isValue(tokenWithComments.token) && tokenWithComments.token != Tokens.OPEN_CURLY && tokenWithComments.token != Tokens.OPEN_SQUARE) {
                throw this.parseError(this.addKeyName("List should have ] or a first element after the open [, instead had token: " + tokenWithComments + " (if you want " + tokenWithComments + " to be part of a string value, then double-quote it)"));
            }
            arrayList.add(this.parseValue(tokenWithComments));
            while (true) {
                if (!this.checkElementSeparator()) {
                    tokenWithComments = this.nextTokenIgnoringNewline();
                    if (tokenWithComments.token == Tokens.CLOSE_SQUARE) {
                        return new SimpleConfigList(configOrigin, arrayList);
                    }
                    throw this.parseError(this.addKeyName("List should have ended with ] or had a comma, instead had token: " + tokenWithComments + " (if you want " + tokenWithComments + " to be part of a string value, then double-quote it)"));
                }
                this.consolidateValueTokens();
                tokenWithComments = this.nextTokenIgnoringNewline();
                if (Tokens.isValue(tokenWithComments.token) || tokenWithComments.token == Tokens.OPEN_CURLY || tokenWithComments.token == Tokens.OPEN_SQUARE) {
                    arrayList.add(this.parseValue(tokenWithComments));
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON || tokenWithComments.token != Tokens.CLOSE_SQUARE) break;
                this.putBack(tokenWithComments);
            }
            throw this.parseError(this.addKeyName("List should have had new element after a comma, instead had token: " + tokenWithComments + " (if you want the comma or " + tokenWithComments + " to be part of a string value, then double-quote it)"));
        }

        AbstractConfigValue parse() {
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token != Tokens.START) {
                throw new ConfigException.BugOrBroken("token stream did not begin with START, had " + tokenWithComments);
            }
            tokenWithComments = this.nextTokenIgnoringNewline();
            AbstractConfigValue abstractConfigValue = null;
            if (tokenWithComments.token == Tokens.OPEN_CURLY || tokenWithComments.token == Tokens.OPEN_SQUARE) {
                abstractConfigValue = this.parseValue(tokenWithComments);
            } else {
                if (this.flavor == ConfigSyntax.JSON) {
                    if (tokenWithComments.token == Tokens.END) {
                        throw this.parseError("Empty document");
                    }
                    throw this.parseError("Document must have an object or array at root, unexpected token: " + tokenWithComments);
                }
                this.putBack(tokenWithComments);
                abstractConfigValue = this.parseObject(false);
            }
            tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token == Tokens.END) {
                return abstractConfigValue;
            }
            throw this.parseError("Document has trailing tokens after first object or array: " + tokenWithComments);
        }
    }

    private static final class TokenWithComments {
        final Token token;
        final List<Token> comments;

        TokenWithComments(Token token, List<Token> list) {
            this.token = token;
            this.comments = list;
        }

        TokenWithComments(Token token) {
            this(token, Collections.emptyList());
        }

        TokenWithComments prepend(List<Token> list) {
            if (this.comments.isEmpty()) {
                return new TokenWithComments(this.token, list);
            }
            ArrayList<Token> arrayList = new ArrayList<Token>();
            arrayList.addAll(list);
            arrayList.addAll(this.comments);
            return new TokenWithComments(this.token, arrayList);
        }

        SimpleConfigOrigin setComments(SimpleConfigOrigin simpleConfigOrigin) {
            if (this.comments.isEmpty()) {
                return simpleConfigOrigin;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Token token : this.comments) {
                arrayList.add(Tokens.getCommentText(token));
            }
            return simpleConfigOrigin.setComments(arrayList);
        }

        public String toString() {
            return this.token.toString();
        }
    }
}

