/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMergeObject;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

abstract class AbstractConfigObject
extends AbstractConfigValue
implements ConfigObject {
    private static final long serialVersionUID = 1L;
    private final SimpleConfig config = new SimpleConfig(this);

    protected AbstractConfigObject(ConfigOrigin configOrigin) {
        super(configOrigin);
    }

    @Override
    public SimpleConfig toConfig() {
        return this.config;
    }

    @Override
    public AbstractConfigObject toFallbackValue() {
        return this;
    }

    @Override
    public abstract AbstractConfigObject withOnlyKey(String var1);

    @Override
    public abstract AbstractConfigObject withoutKey(String var1);

    protected abstract AbstractConfigObject withOnlyPathOrNull(Path var1);

    abstract AbstractConfigObject withOnlyPath(Path var1);

    abstract AbstractConfigObject withoutPath(Path var1);

    protected final AbstractConfigValue peekAssumingResolved(String string, String string2) {
        try {
            return this.attemptPeekWithPartialResolve(string);
        }
        catch (AbstractConfigValue.NeedsFullResolve needsFullResolve) {
            throw new ConfigException.NotResolved(string2 + ": " + needsFullResolve.getMessage(), needsFullResolve);
        }
    }

    protected abstract AbstractConfigValue attemptPeekWithPartialResolve(String var1) throws AbstractConfigValue.NeedsFullResolve;

    protected AbstractConfigValue peekPath(Path path, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve {
        return AbstractConfigObject.peekPath(this, path, substitutionResolver, n, configResolveOptions);
    }

    AbstractConfigValue peekPathWithExternalExceptions(Path path) {
        try {
            return AbstractConfigObject.peekPath(this, path, null, 0, null);
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            throw notPossibleToResolve.exportException(this.origin(), path.render());
        }
        catch (AbstractConfigValue.NeedsFullResolve needsFullResolve) {
            throw new ConfigException.NotResolved("need to resolve() this Config before looking up value at " + path.render(), needsFullResolve);
        }
    }

    private static AbstractConfigValue peekPath(AbstractConfigObject abstractConfigObject, Path path, SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve {
        if (substitutionResolver != null) {
            AbstractConfigValue abstractConfigValue = substitutionResolver.resolve(abstractConfigObject, n, configResolveOptions, path);
            if (abstractConfigValue instanceof AbstractConfigObject) {
                return AbstractConfigObject.peekPath((AbstractConfigObject)abstractConfigValue, path, null, 0, null);
            }
            throw new ConfigException.BugOrBroken("resolved object to non-object " + abstractConfigObject + " to " + abstractConfigValue);
        }
        Path path2 = path.remainder();
        AbstractConfigValue abstractConfigValue = abstractConfigObject.attemptPeekWithPartialResolve(path.first());
        if (path2 == null) {
            return abstractConfigValue;
        }
        if (abstractConfigValue instanceof AbstractConfigObject) {
            return AbstractConfigObject.peekPath((AbstractConfigObject)abstractConfigValue, path2, null, 0, null);
        }
        return null;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.OBJECT;
    }

    protected abstract AbstractConfigObject newCopy(ResolveStatus var1, boolean var2, ConfigOrigin var3);

    @Override
    protected AbstractConfigObject newCopy(boolean bl, ConfigOrigin configOrigin) {
        return this.newCopy(this.resolveStatus(), bl, configOrigin);
    }

    @Override
    protected final AbstractConfigObject mergedWithTheUnmergeable(Unmergeable unmergeable) {
        if (this.ignoresFallbacks()) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        if (this instanceof Unmergeable) {
            arrayList.addAll(((Unmergeable)((Object)this)).unmergedValues());
        } else {
            arrayList.add(this);
        }
        arrayList.addAll(unmergeable.unmergedValues());
        return new ConfigDelayedMergeObject(AbstractConfigObject.mergeOrigins(arrayList), arrayList, ((AbstractConfigValue)((Object)unmergeable)).ignoresFallbacks());
    }

    @Override
    protected abstract AbstractConfigObject mergedWithObject(AbstractConfigObject var1);

    @Override
    public AbstractConfigObject withFallback(ConfigMergeable configMergeable) {
        return (AbstractConfigObject)super.withFallback(configMergeable);
    }

    static ConfigOrigin mergeOrigins(Collection<? extends AbstractConfigValue> collection) {
        if (collection.isEmpty()) {
            throw new ConfigException.BugOrBroken("can't merge origins on empty list");
        }
        ArrayList<SimpleConfigOrigin> arrayList = new ArrayList<SimpleConfigOrigin>();
        SimpleConfigOrigin simpleConfigOrigin = null;
        int n = 0;
        for (AbstractConfigValue abstractConfigValue : collection) {
            if (simpleConfigOrigin == null) {
                simpleConfigOrigin = abstractConfigValue.origin();
            }
            if (abstractConfigValue instanceof AbstractConfigObject && ((AbstractConfigObject)abstractConfigValue).resolveStatus() == ResolveStatus.RESOLVED && ((ConfigObject)((Object)abstractConfigValue)).isEmpty()) continue;
            arrayList.add(abstractConfigValue.origin());
            ++n;
        }
        if (n == 0) {
            arrayList.add(simpleConfigOrigin);
        }
        return SimpleConfigOrigin.mergeOrigins(arrayList);
    }

    static ConfigOrigin mergeOrigins(AbstractConfigObject ... abstractConfigObjectArray) {
        return AbstractConfigObject.mergeOrigins(Arrays.asList(abstractConfigObjectArray));
    }

    @Override
    abstract AbstractConfigObject resolveSubstitutions(SubstitutionResolver var1, int var2, ConfigResolveOptions var3, Path var4) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve;

    @Override
    abstract AbstractConfigObject relativized(Path var1);

    @Override
    public abstract AbstractConfigValue get(Object var1);

    @Override
    protected abstract void render(StringBuilder var1, int var2, boolean var3);

    private static UnsupportedOperationException weAreImmutable(String string) {
        return new UnsupportedOperationException("ConfigObject is immutable, you can't call Map." + string);
    }

    @Override
    public void clear() {
        throw AbstractConfigObject.weAreImmutable("clear");
    }

    @Override
    public ConfigValue put(String string, ConfigValue configValue) {
        throw AbstractConfigObject.weAreImmutable("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ConfigValue> map) {
        throw AbstractConfigObject.weAreImmutable("putAll");
    }

    @Override
    public ConfigValue remove(Object object) {
        throw AbstractConfigObject.weAreImmutable("remove");
    }
}

