/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import java.math.BigInteger;
import java.nio.ByteOrder;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.rpki.validator.rtr.BadData;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.PduTypes$;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.SerialNotifyPdu;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import scala.Array$;
import scala.Either;
import scala.Left;
import scala.MatchError;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.collection.GenTraversableOnce;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pdus$
implements ScalaObject {
    public static final Pdus$ MODULE$;
    private final byte SupportedProtocol;

    static {
        new Pdus$();
    }

    public byte SupportedProtocol() {
        return this.SupportedProtocol;
    }

    public byte[] encode(Pdu pdu) {
        Pdu pdu2;
        block9: {
            ChannelBuffer buffer;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        buffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)pdu.length());
                                        buffer.writeByte((int)pdu.protocolVersion());
                                        buffer.writeByte((int)pdu.pduType());
                                        buffer.writeShort((int)pdu.headerShort());
                                        buffer.writeInt(pdu.length());
                                        pdu2 = pdu;
                                        if (!(pdu2 instanceof SerialNotifyPdu)) break block2;
                                        buffer.writeInt((int)((SerialNotifyPdu)pdu2).serial());
                                        break block3;
                                    }
                                    if (!(pdu2 instanceof SerialQueryPdu)) break block4;
                                    buffer.writeInt((int)((SerialQueryPdu)pdu2).serial());
                                    break block3;
                                }
                                if (!(pdu2 instanceof ErrorPdu)) break block5;
                                ErrorPdu errorPdu = (ErrorPdu)pdu2;
                                this.writeErrorPduPayload(buffer, errorPdu, errorPdu.causingPdu());
                                break block3;
                            }
                            if (pdu2 instanceof ResetQueryPdu || pdu2 instanceof CacheResponsePdu) break block3;
                            if (!(pdu2 instanceof IPv4PrefixAnnouncePdu)) break block6;
                            IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu = (IPv4PrefixAnnouncePdu)pdu2;
                            this.writeIPv4PrefixAnnouncePduPayload(buffer, iPv4PrefixAnnouncePdu.ipv4PrefixStart(), iPv4PrefixAnnouncePdu.prefixLength(), iPv4PrefixAnnouncePdu.maxLength(), iPv4PrefixAnnouncePdu.asn());
                            break block3;
                        }
                        if (!(pdu2 instanceof IPv6PrefixAnnouncePdu)) break block7;
                        IPv6PrefixAnnouncePdu iPv6PrefixAnnouncePdu = (IPv6PrefixAnnouncePdu)pdu2;
                        this.writeIPv6PrefixAnnouncePduPayload(buffer, iPv6PrefixAnnouncePdu.ipv6PrefixStart(), iPv6PrefixAnnouncePdu.prefixLength(), iPv6PrefixAnnouncePdu.maxLength(), iPv6PrefixAnnouncePdu.asn());
                        break block3;
                    }
                    if (!(pdu2 instanceof EndOfDataPdu)) break block8;
                    buffer.writeInt((int)((EndOfDataPdu)pdu2).serial());
                    break block3;
                }
                if (!(pdu2 instanceof CacheResetPdu)) break block9;
            }
            return buffer.array();
        }
        throw new MatchError((Object)pdu2);
    }

    /*
     * WARNING - void declaration
     */
    public Either<BadData, Pdu> fromByteArray(ChannelBuffer buffer) {
        void var2_2;
        Left exceptionResult1 = null;
        try {
            Object object;
            byte protocol = buffer.readByte();
            byte pduType = buffer.readByte();
            short headerShort = buffer.readShort();
            int length = buffer.readInt();
            if (protocol != this.SupportedProtocol()) {
                object = new Right<Nothing$, SerialNotifyPdu>((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedProtocolVersion(), buffer.array()));
            } else {
                byte by = pduType;
                object = BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.SerialNotify()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseSerialNotifyPdu(buffer, headerShort) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.SerialQuery()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseSerialQueryPdu(buffer, headerShort) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.Error()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseErrorPdu(buffer, headerShort) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.ResetQuery()), (Object)BoxesRunTime.boxToByte((byte)by)) ? new Right<Nothing$, CacheResponsePdu>((Object)new ResetQueryPdu()) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.CacheResponse()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseCacheResponsePdu(headerShort) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.EndOfData()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseEndOfDataPdu(buffer, headerShort) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.IPv4Prefix()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseIPv4PrefixPdu(buffer) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.IPv6Prefix()), (Object)BoxesRunTime.boxToByte((byte)by)) ? this.parseIPv6PrefixPdu(buffer) : (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)PduTypes$.MODULE$.CacheReset()), (Object)BoxesRunTime.boxToByte((byte)by)) ? new Right((Object)new CacheResetPdu()) : new Left((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()))))))))));
            }
            exceptionResult1 = object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exceptionResult1 = new Left((Object)new BadData(ErrorPdu$.MODULE$.CorruptData(), buffer.array()));
        }
        return var2_2;
    }

    private byte[] convertToPrependedByteArray(BigInteger value, int bytesNeeded) {
        byte[] valueBytes = value.toByteArray();
        if (Predef$.MODULE$.byteArrayOps(valueBytes).size() > 1 && BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(valueBytes).head()) == 0) {
            valueBytes = (byte[])Predef$.MODULE$.byteArrayOps(valueBytes).drop(1);
        }
        int extraBytesNeeded = bytesNeeded - valueBytes.length;
        byte[] prependBytes = new byte[extraBytesNeeded];
        return (byte[])Predef$.MODULE$.byteArrayOps(prependBytes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(valueBytes), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Byte()));
    }

    private void writeErrorPduPayload(ChannelBuffer buffer, ErrorPdu errorPdu, byte[] causingPdu) {
        buffer.writeInt(causingPdu.length);
        buffer.writeBytes(causingPdu);
        buffer.writeInt(errorPdu.errorTextBytes().length);
        buffer.writeBytes(errorPdu.errorTextBytes());
    }

    private void writeIPv4PrefixAnnouncePduPayload(ChannelBuffer buffer, Ipv4Address prefix, byte length, byte maxLength, Asn asn) {
        buffer.writeByte(1);
        buffer.writeByte((int)length);
        buffer.writeByte((int)maxLength);
        buffer.writeByte(0);
        buffer.writeBytes(this.convertToPrependedByteArray(prefix.getValue(), 4));
        buffer.writeBytes(this.convertToPrependedByteArray(asn.getValue(), 4));
    }

    private void writeIPv6PrefixAnnouncePduPayload(ChannelBuffer buffer, Ipv6Address prefix, byte length, byte maxLength, Asn asn) {
        buffer.writeByte(1);
        buffer.writeByte((int)length);
        buffer.writeByte((int)maxLength);
        buffer.writeByte(0);
        buffer.writeBytes(this.convertToPrependedByteArray(prefix.getValue(), 16));
        buffer.writeBytes(this.convertToPrependedByteArray(asn.getValue(), 4));
    }

    private Right<Nothing$, SerialNotifyPdu> parseSerialNotifyPdu(ChannelBuffer buffer, short nonce) {
        long serial = buffer.readUnsignedInt();
        return new Right((Object)new SerialNotifyPdu(nonce, serial));
    }

    private Right<Nothing$, SerialQueryPdu> parseSerialQueryPdu(ChannelBuffer buffer, short nonce) {
        long serial = buffer.readUnsignedInt();
        return new Right((Object)new SerialQueryPdu(nonce, serial));
    }

    private Right<Nothing$, ErrorPdu> parseErrorPdu(ChannelBuffer buffer, short headerShort) {
        int causingPduLength = buffer.readInt();
        byte[] causingPdu = buffer.readBytes(causingPduLength).array();
        int errorTextLength = buffer.readInt();
        ChannelBuffer errorTextBytes = buffer.readBytes(errorTextLength);
        String errorText = new String(buffer.array(), "UTF-8");
        return new Right((Object)new ErrorPdu(headerShort, causingPdu, errorText));
    }

    private Right<Nothing$, CacheResponsePdu> parseCacheResponsePdu(short nonce) {
        return new Right((Object)new CacheResponsePdu(nonce));
    }

    private Right<Nothing$, EndOfDataPdu> parseEndOfDataPdu(ChannelBuffer buffer, short nonce) {
        long serial = buffer.readUnsignedInt();
        return new Right((Object)new EndOfDataPdu(nonce, serial));
    }

    private Either<BadData, Pdu> parseIPv4PrefixPdu(ChannelBuffer buffer) {
        Left left;
        byte by = buffer.readByte();
        if (by == 1) {
            byte length = buffer.readByte();
            byte maxLenght = buffer.readByte();
            buffer.skipBytes(1);
            Ipv4Address prefix = new Ipv4Address(buffer.readUnsignedInt());
            Asn asn = new Asn(buffer.readUnsignedInt());
            left = new Right((Object)new IPv4PrefixAnnouncePdu(prefix, length, maxLenght, asn));
        } else {
            left = new Left((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()));
        }
        return left;
    }

    private Either<BadData, Pdu> parseIPv6PrefixPdu(ChannelBuffer buffer) {
        Left left;
        byte by = buffer.readByte();
        if (by == 1) {
            byte length = buffer.readByte();
            byte maxLenght = buffer.readByte();
            buffer.skipBytes(1);
            byte[] ipv6Bytes = new byte[16];
            buffer.getBytes(12, ipv6Bytes);
            Ipv6Address prefix = new Ipv6Address(new BigInteger(1, ipv6Bytes));
            buffer.skipBytes(16);
            Asn asn = new Asn(buffer.readUnsignedInt());
            left = new Right((Object)new IPv6PrefixAnnouncePdu(prefix, length, maxLenght, asn));
        } else {
            left = new Left((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()));
        }
        return left;
    }

    private Pdus$() {
        MODULE$ = this;
        this.SupportedProtocol = 0;
    }
}

