/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.bgp.preview;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator.bgp.preview.BgpRisDump;
import net.ripe.rpki.validator.bgp.preview.BgpRisEntry;
import org.joda.time.DateTime;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Right;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BgpRisDump$
implements Logging,
Serializable {
    public static final BgpRisDump$ MODULE$;
    private final Regex BgpEntryRegex;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile int bitmap$priv$0;

    static {
        new BgpRisDump$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Logger grizzled$slf4j$Logging$$_logger() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.grizzled$slf4j$Logging$$_logger;
        BgpRisDump$ bgpRisDump$ = this;
        synchronized (bgpRisDump$) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$priv$0 |= 1;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public Either<Exception, IndexedSeq<BgpRisEntry>> parse(InputStream is) {
        BgpRisDump.ObjectIdentityMap identityMap$1 = new BgpRisDump.ObjectIdentityMap();
        BufferedReader reader$1 = new BufferedReader(new InputStreamReader(is));
        Left exceptionResult1 = null;
        try {
            exceptionResult1 = new Right((Object)package$.MODULE$.Iterator().continually((Function0)new Serializable(reader$1){
                public static final long serialVersionUID;
                private final BufferedReader reader$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return this.reader$1.readLine();
                }
                {
                    this.reader$1 = bufferedReader;
                }
            }).takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(String string) {
                    return string != null;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Iterable<BgpRisEntry> apply(String string) {
                    return Option$.MODULE$.option2Iterable(BgpRisDump$.MODULE$.parseLine(string));
                }
            }).map((Function1)new Serializable(identityMap$1){
                public static final long serialVersionUID;
                private final BgpRisDump.ObjectIdentityMap identityMap$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final BgpRisEntry apply(BgpRisEntry bgpRisEntry) {
                    return BgpRisDump$.MODULE$.net$ripe$rpki$validator$bgp$preview$BgpRisDump$$makeResourcesUnique(this.identityMap$1, bgpRisEntry);
                }
                {
                    this.identityMap$1 = objectIdentityMap;
                }
            }).toIndexedSeq());
        }
        catch (Exception exception) {
            exceptionResult1 = new Left((Object)exception);
        }
        return exceptionResult1;
    }

    public final BgpRisEntry net$ripe$rpki$validator$bgp$preview$BgpRisDump$$makeResourcesUnique(BgpRisDump.ObjectIdentityMap identityMap, BgpRisEntry entry) {
        Asn asn = identityMap.makeUnique(entry.origin());
        IpRange prefix = (IpRange)identityMap.makeUnique(entry.prefix().getStart()).upTo(identityMap.makeUnique(entry.prefix().getEnd()));
        return entry.copy(asn, prefix, entry.copy$default$3());
    }

    private Regex BgpEntryRegex() {
        return this.BgpEntryRegex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<BgpRisEntry> parseLine(String content$1) {
        None$ none$;
        None$ exceptionResult2;
        List list;
        String string = content$1;
        Option option = this.BgpEntryRegex().unapplySeq((Object)string);
        if (!option.isEmpty() && ((list = (List)option.get()) == null ? false : list.lengthCompare(3) == 0)) {
            exceptionResult2 = null;
            try {
                exceptionResult2 = new Some((Object)new BgpRisEntry(Asn.parse((String)((String)list.apply(0))), IpRange.parse((String)((String)list.apply(1))), Integer.parseInt((String)list.apply(2))));
            }
            catch (Throwable throwable) {
                this.error((Function0)new Serializable(content$1){
                    public static final long serialVersionUID;
                    private final String content$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Skipping unparseble line: ").append((Object)this.content$1).toString();
                    }
                    {
                        this.content$1 = string;
                    }
                });
                this.debug((Function0)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Detailed error: ";
                    }
                }, (Function0)new Serializable(throwable){
                    public static final long serialVersionUID;
                    private final Throwable e$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = throwable;
                    }
                });
                exceptionResult2 = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
            return none$;
        }
        none$ = exceptionResult2;
        return none$;
    }

    public Seq init$default$3() {
        return Nil$.MODULE$;
    }

    public Option init$default$2() {
        return None$.MODULE$;
    }

    public Option unapply(BgpRisDump x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.url(), x$0.lastModified(), x$0.entries()));
    }

    public BgpRisDump apply(String url, Option lastModified2, Seq entries) {
        return new BgpRisDump(url, (Option<DateTime>)lastModified2, (Seq<BgpRisEntry>)entries);
    }

    public Seq apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option apply$default$2() {
        return None$.MODULE$;
    }

    public Object readResolve() {
        return MODULE$;
    }

    private BgpRisDump$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.BgpEntryRegex = Predef$.MODULE$.augmentString("^\\s*([0-9]+)\\s+([0-9a-fA-F.:/]+)\\s+([0-9]+)\\s*$").r();
    }
}

