/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.cli.CommandLineOptions;
import net.ripe.rpki.validator.commands.TopDownCertificateRepositoryValidator;
import net.ripe.rpki.validator.commands.ValidationCommand;

public class TopDownValidationCommand
extends ValidationCommand {
    private File outputDir;
    private List<URI> prefetchUris;
    private boolean roaExportEnabled;
    private File roaExportFile;

    public TopDownValidationCommand(CommandLineOptions options) {
        super(options);
        this.outputDir = options.getOutputDir();
        this.prefetchUris = options.getPrefetchUris();
        this.roaExportEnabled = options.isRoaExportEnabled();
        this.roaExportFile = options.getRoaExportFile();
    }

    public void execute() {
        List<CertificateRepositoryObjectValidationContext> trustAnchors = this.getTrustAnchors();
        TopDownCertificateRepositoryValidator validator = this.roaExportEnabled ? new TopDownCertificateRepositoryValidator(trustAnchors, this.outputDir, this.roaExportFile) : new TopDownCertificateRepositoryValidator(trustAnchors, this.outputDir);
        validator.setPrefetchUris(this.prefetchUris);
        validator.prepare();
        validator.validate();
    }
}

