/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import java.util.zip.CRC32;

public class SqlMigration
extends Migration {
    private final PlaceholderReplacer placeholderReplacer;
    private final ClassPathResource sqlScriptResource;
    private final String encoding;

    public SqlMigration(ClassPathResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, String versionString, String scriptName) {
        this.sqlScriptResource = sqlScriptResource;
        this.encoding = encoding;
        this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(versionString);
        this.description = MigrationInfoHelper.extractDescription(versionString);
        String sqlScriptSource = sqlScriptResource.loadAsString(encoding);
        this.checksum = this.calculateChecksum(sqlScriptSource);
        this.script = scriptName;
        this.placeholderReplacer = placeholderReplacer;
    }

    public String getLocation() {
        return this.sqlScriptResource.getLocationOnDisk();
    }

    public void migrate(JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        String sqlScriptSource = this.sqlScriptResource.loadAsString(this.encoding);
        SqlScript sqlScript = dbSupport.createSqlScript(sqlScriptSource, this.placeholderReplacer);
        sqlScript.execute(jdbcTemplate);
    }

    private int calculateChecksum(String sql) {
        CRC32 crc32 = new CRC32();
        crc32.update(sql.getBytes());
        return (int)crc32.getValue();
    }

    public MigrationType getMigrationType() {
        return MigrationType.SQL;
    }
}

