/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.views;

import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.lib.DateAndTime$;
import net.ripe.rpki.validator.lib.DateAndTime$DateTimeOrdering$;
import net.ripe.rpki.validator.lib.Validation;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.Running;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.views.Tab;
import net.ripe.rpki.validator.views.Tabs$;
import net.ripe.rpki.validator.views.TrustAnchorsView$;
import net.ripe.rpki.validator.views.View;
import net.ripe.rpki.validator.views.ViewHelpers;
import net.ripe.rpki.validator.views.ViewHelpers$class;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u00015\u0011\u0001\u0003\u0016:vgR\fen\u00195peN4\u0016.Z<\u000b\u0005\r!\u0011!\u0002<jK^\u001c(BA\u0003\u0007\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\b\u0011\u0005!!\u000f]6j\u0015\tI!\"\u0001\u0003sSB,'\"A\u0006\u0002\u00079,Go\u0001\u0001\u0014\u000b\u0001qaCG\u000f\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\tYKWm\u001e\t\u0003/mI!\u0001\b\u0002\u0003\u0017YKWm\u001e%fYB,'o\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u00031!(/^:u\u0003:\u001c\u0007n\u001c:t!\t1\u0013&D\u0001(\u0015\tAC!\u0001\u0004n_\u0012,Gn]\u0005\u0003U\u001d\u0012A\u0002\u0016:vgR\fen\u00195peND\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0017m\u0006d\u0017\u000eZ1uS>t7\u000b^1ukN\u001cu.\u001e8ugB!a&\r\u001b;\u001d\tqr&\u0003\u00021?\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\u00075\u000b\u0007O\u0003\u00021?A\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007B\u0001\u0005kRLG.\u0003\u0002:m\t\u0011BK];ti\u0006s7\r[8s\u0019>\u001c\u0017\r^8s!\u0011q\u0013gO\"\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014A\u0003<bY&$\u0017\r^5p]*\u0011\u0001IB\u0001\bG>lWn\u001c8t\u0013\t\u0011UH\u0001\tWC2LG-\u0019;j_:\u001cF/\u0019;vgB\u0011a\u0004R\u0005\u0003\u000b~\u00111!\u00138u\u0011!9\u0005A!A!\u0002\u0013A\u0015a\u00018poB\u0011\u0011\nU\u0007\u0002\u0015*\u00111\nT\u0001\u0005i&lWM\u0003\u0002N\u001d\u0006!!n\u001c3b\u0015\u0005y\u0015aA8sO&\u0011\u0011K\u0013\u0002\t\t\u0006$X\rV5nK\"A1\u000b\u0001B\u0001B\u0003%A+\u0001\u0005nKN\u001c\u0018mZ3t!\r)V\f\u0019\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001/ \u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0007M+\u0017O\u0003\u0002]?A\u0011\u0011-\u001b\b\u0003E\u001at!a\u00193\u000e\u0003\u0011I!!\u001a\u0003\u0002\u00071L'-\u0003\u0002hQ\u0006Qa+\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u0015$\u0011B\u00016l\u0005=1U-\u001a3cC\u000e\\W*Z:tC\u001e,'BA4i\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u0019a\u0014N\\5u}Q)q\u000e]9sgB\u0011q\u0003\u0001\u0005\u0006I1\u0004\r!\n\u0005\u0006Y1\u0004\r!\f\u0005\b\u000f2\u0004\n\u00111\u0001I\u0011\u001d\u0019F\u000e%AA\u0002QCQ!\u001e\u0001\u0005\u0002Y\f1\u0001^1c+\u00059\bCA\fy\u0013\tI(AA\u0002UC\nDQa\u001f\u0001\u0005\u0002q\fQ\u0001^5uY\u0016,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005q$A\u0002y[2L1!!\u0002\u0000\u0005\u0011!V\r\u001f;\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u0005!!m\u001c3z+\t\ti\u0001E\u0002\u007f\u0003\u001fI1!!\u0005\u0000\u0005\u001dqu\u000eZ3TKFDq!!\u0006\u0001\t\u0013\t9\"\u0001\bsK:$WM]\"pk:$XM]:\u0015\r\u0005e\u0011qDA\u0015!\rq\u00181D\u0005\u0004\u0003;y(\u0001B#mK6D\u0001\"!\t\u0002\u0014\u0001\u0007\u00111E\u0001\u0003i\u0006\u00042AJA\u0013\u0013\r\t9c\n\u0002\f)J,8\u000f^!oG\"|'\u000fC\u0004\u0002,\u0005M\u0001\u0019\u0001\u001e\u0002\u0011\r|WO\u001c;feNDq!a\f\u0001\t\u0013\t\t$A\u0005fqBL'/Z:J]R!\u0011QBA\u001a\u0011\u001d\t)$!\fA\u0002!\u000bQB\\8u-\u0006d\u0017\u000eZ!gi\u0016\u0014\bbBA\u001d\u0001\u0011%\u00111H\u0001\u0013g>\u0014H/\u001a3UeV\u001cH/\u00118dQ>\u00148/\u0006\u0002\u0002>A1\u0011qHA#\u0003Gi!!!\u0011\u000b\u0007\u0005\rs$\u0001\u0006d_2dWm\u0019;j_:L1AXA!\u000f%\tIEAA\u0001\u0012\u000b\tY%\u0001\tUeV\u001cH/\u00118dQ>\u00148OV5foB\u0019q#!\u0014\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0003\u001f\u001aB!!\u0014\u000f;!9Q.!\u0014\u0005\u0002\u0005MCCAA&\u0011)\t9&!\u0014\u0012\u0002\u0013\u0005\u0011\u0011L\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYFK\u0002I\u0003;Z#!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Sz\u0012AC1o]>$\u0018\r^5p]&!\u0011QNA2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003c\ni%%A\u0005\u0002\u0005M\u0014AD5oSR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003kR3\u0001VA/\u0001")
public class TrustAnchorsView
implements View,
ViewHelpers {
    private final TrustAnchors trustAnchors;
    public final Map<TrustAnchorLocator, Map<ValidationStatus, Object>> net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts;
    public final DateTime net$ripe$rpki$validator$views$TrustAnchorsView$$now;
    private final Seq<Validation.FeedbackMessage> messages;
    private final Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes;
    private final Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers;

    public static final Seq init$default$4() {
        return TrustAnchorsView$.MODULE$.init$default$4();
    }

    public static final DateTime init$default$3() {
        return TrustAnchorsView$.MODULE$.init$default$3();
    }

    @Override
    public final Map<Validation.MessageKind, String> net$ripe$rpki$validator$views$ViewHelpers$$classes() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$classes;
    }

    @Override
    public final Map<Validation.MessageKind, NodeSeq> net$ripe$rpki$validator$views$ViewHelpers$$headers() {
        return this.net$ripe$rpki$validator$views$ViewHelpers$$headers;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$classes_$eq(Map map) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$classes = map;
    }

    @Override
    public void net$ripe$rpki$validator$views$ViewHelpers$_setter_$net$ripe$rpki$validator$views$ViewHelpers$$headers_$eq(Map map) {
        this.net$ripe$rpki$validator$views$ViewHelpers$$headers = map;
    }

    @Override
    public NodeSeq renderMessages(Seq<Validation.FeedbackMessage> messages2, Function1<String, String> fieldNameToText) {
        return ViewHelpers$class.renderMessages(this, messages2, fieldNameToText);
    }

    @Override
    public Tab tab() {
        return Tabs$.MODULE$.TrustAnchorsTab();
    }

    public Text title() {
        return new Text("Configured Trust Anchors");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NodeSeq body() {
        Elem elem;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)this.renderMessages(this.messages, (Function1<String, String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String string) {
                return (String)Predef$.MODULE$.identity((Object)string);
            }
        }));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", (Seq)new Text("trust-anchors"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("zebra-striped"), (MetaData)$md);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Enabled"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Trust anchor"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf6));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Processed Items"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, (Seq)$buf7));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$7 = Predef$.MODULE$.$scope();
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Expires in"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, (Seq)$buf8));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$8 = Predef$.MODULE$.$scope();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Last updated"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$8, (Seq)$buf9));
        $buf4.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Next update in"));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, (Seq)$buf10));
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md2);
        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.tab().url()).append((Object)"/update").toString(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md3);
        TopScope$ topScope$11 = Predef$.MODULE$.$scope();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        if (this.trustAnchors.all().forall((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(TrustAnchor trustAnchor) {
                return trustAnchor.status().isRunning();
            }
        }) || this.trustAnchors.all().forall((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(TrustAnchor trustAnchor) {
                return !trustAnchor.enabled();
            }
        })) {
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("disabled", (Seq)new Text("disabled"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("value", (Seq)new Text("Update all"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("class", (Seq)new Text("btn primary span2"), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md4);
            elem = new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        } else {
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("value", (Seq)new Text("Update all"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("class", (Seq)new Text("btn primary span2"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md5);
            elem = new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        }
        $buf12.$amp$plus((Object)elem);
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "form", (MetaData)$md3, (NamespaceBinding)topScope$11, (Seq)$buf12));
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "th", (MetaData)$md2, (NamespaceBinding)topScope$10, (Seq)$buf11));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus(this.sortedTrustAnchors().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final TrustAnchorsView $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Elem apply(TrustAnchor ta) {
                NodeBuffer nodeBuffer;
                Elem elem;
                Elem elem2;
                Elem elem3;
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md);
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.$outer.tab().url()).append((Object)"/toggle").toString(), (MetaData)$md2);
                $md2 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md2);
                $md2 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md2);
                TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n                  "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("value", ta.locator().getCaName(), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md3);
                $md3 = new UnprefixedAttribute("name", (Seq)new Text("name"), (MetaData)$md3);
                $buf3.$amp$plus((Object)new Elem(null, "input", (MetaData)$md3, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf3.$amp$plus((Object)new Text("\n                "));
                if (ta.enabled()) {
                    Null$ $md4 = Null$.MODULE$;
                    $md4 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("onclick", (Seq)new Text("this.form.submit();"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("name", (Seq)new Text("enable-ta"), (MetaData)$md4);
                    $md4 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md4);
                    elem3 = new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                } else {
                    Null$ $md5 = Null$.MODULE$;
                    $md5 = new UnprefixedAttribute("onclick", (Seq)new Text("this.form.submit();"), (MetaData)$md5);
                    $md5 = new UnprefixedAttribute("name", (Seq)new Text("enable-ta"), (MetaData)$md5);
                    $md5 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md5);
                    elem3 = new Elem(null, "input", (MetaData)$md5, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf3.$amp$plus((Object)elem3);
                $buf3.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus((Object)new Elem(null, "form", (MetaData)$md2, (NamespaceBinding)topScope$3, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)topScope$2, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n            "));
                TopScope$ topScope$4 = Predef$.MODULE$.$scope();
                NodeBuffer $buf4 = new NodeBuffer();
                Null$ $md6 = Null$.MODULE$;
                $md6 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md6);
                $md6 = new UnprefixedAttribute("data-original-title", (String)ta.certificate().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(X509ResourceCertificate x509ResourceCertificate) {
                        return x509ResourceCertificate.getSubject().toString();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "";
                    }
                }), (MetaData)$md6);
                TopScope$ topScope$5 = Predef$.MODULE$.$scope();
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)ta.name());
                $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)topScope$5, (Seq)$buf5));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md7 = Null$.MODULE$;
                $md7 = new UnprefixedAttribute("nowrap", (Seq)new Text("nowrap"), (MetaData)$md7);
                TopScope$ topScope$6 = Predef$.MODULE$.$scope();
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$renderCounters(ta, (Map<ValidationStatus, Object>)((Map)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts.getOrElse((Object)ta.locator(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Map<ValidationStatus, Nothing$> apply() {
                        return Predef$.MODULE$.Map().empty();
                    }
                }))));
                $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)topScope$6, (Seq)$buf6));
                Option<X509ResourceCertificate> option = ta.certificate();
                if (option instanceof Some) {
                    X509ResourceCertificate x509ResourceCertificate;
                    Some some = (Some)option;
                    X509ResourceCertificate certificate = x509ResourceCertificate = (X509ResourceCertificate)some.x();
                    DateTime notValidAfter = certificate.getValidityPeriod().getNotValidAfter();
                    TopScope$ topScope$7 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf7 = new NodeBuffer();
                    Null$ $md8 = Null$.MODULE$;
                    $md8 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md8);
                    $md8 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(notValidAfter), (MetaData)$md8);
                    TopScope$ topScope$8 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf8 = new NodeBuffer();
                    $buf8.$amp$plus((Object)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$expiresIn(notValidAfter));
                    $buf7.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)topScope$8, (Seq)$buf8));
                    Elem elem4 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$7, (Seq)$buf7);
                    elem2 = elem4;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<X509ResourceCertificate> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                    elem2 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf.$amp$plus((Object)elem2);
                if (ta.enabled()) {
                    Option<DateTime> option3 = ta.lastUpdated();
                    if (option3 instanceof Some) {
                        NodeSeq nodeSeq;
                        DateTime dateTime;
                        Some some = (Some)option3;
                        DateTime lastUpdated2 = dateTime = (DateTime)some.x();
                        Option manifestStale = ta.manifestNextUpdateTime().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$body$4 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<String> apply(DateTime dt) {
                                return dt.isBefore((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now) ? new Some((Object)new StringBuilder().append((Object)"Manifest has been stale for ").append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)dt, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now), DateAndTime$.MODULE$.periodInWords$default$2())).toString()) : None$.MODULE$;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Option crlStale = ta.crlNextUpdateTime().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anonfun$body$4 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<String> apply(DateTime dt) {
                                return dt.isBefore((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now) ? new Some((Object)new StringBuilder().append((Object)"CRL has been stale for ").append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)dt, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer().net$ripe$rpki$validator$views$TrustAnchorsView$$now), DateAndTime$.MODULE$.periodInWords$default$2())).toString()) : None$.MODULE$;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        Seq warnings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{manifestStale, crlStale})).flatten((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Iterable<String> apply(Option<String> option) {
                                return Option$.MODULE$.option2Iterable(option);
                            }
                        });
                        TopScope$ topScope$9 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf9 = new NodeBuffer();
                        Null$ $md9 = Null$.MODULE$;
                        $md9 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md9);
                        $md9 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(lastUpdated2), (MetaData)$md9);
                        TopScope$ topScope$10 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf10 = new NodeBuffer();
                        $buf10.$amp$plus((Object)new StringBuilder().append((Object)DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)lastUpdated2, (ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now).withMillis(0), 1)).append((Object)" ago").toString());
                        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)topScope$10, (Seq)$buf10));
                        if (warnings.isEmpty()) {
                            nodeSeq = NodeSeq$.MODULE$.Empty();
                        } else {
                            Null$ $md10 = Null$.MODULE$;
                            $md10 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md10);
                            $md10 = new UnprefixedAttribute("data-original-title", warnings.mkString(", "), (MetaData)$md10);
                            TopScope$ topScope$11 = Predef$.MODULE$.$scope();
                            NodeBuffer $buf11 = new NodeBuffer();
                            $buf11.$amp$plus((Object)new EntityRef("nbsp"));
                            Null$ $md11 = Null$.MODULE$;
                            $md11 = new UnprefixedAttribute("src", (Seq)new Text("/images/warningS.png"), (MetaData)$md11);
                            $md11 = new UnprefixedAttribute("align", (Seq)new Text("center"), (MetaData)$md11);
                            $buf11.$amp$plus((Object)new Elem(null, "img", (MetaData)$md11, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                            Elem elem5 = new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)topScope$11, (Seq)$buf11);
                            nodeSeq = elem5;
                        }
                        $buf9.$amp$plus((Object)nodeSeq);
                        $buf9.$amp$plus((Object)new Text(" "));
                        Elem elem6 = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$9, (Seq)$buf9);
                        elem = elem6;
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<DateTime> option4 = option3;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) throw new MatchError(option3);
                        elem = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                    }
                } else {
                    elem = new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
                }
                $buf.$amp$plus((Object)elem);
                if (ta.enabled()) {
                    ProcessingStatus processingStatus = ta.status();
                    if (processingStatus instanceof Running) {
                        NodeBuffer $buf12 = new NodeBuffer();
                        TopScope$ topScope$12 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf13 = new NodeBuffer();
                        $buf13.$amp$plus((Object)((Running)processingStatus).description());
                        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, (Seq)$buf13));
                        Null$ $md12 = Null$.MODULE$;
                        $md12 = new UnprefixedAttribute("style", (Seq)new Text("text-align: center;"), (MetaData)$md12);
                        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf14 = new NodeBuffer();
                        Null$ $md13 = Null$.MODULE$;
                        $md13 = new UnprefixedAttribute("src", (Seq)new Text("/images/spinner.gif"), (MetaData)$md13);
                        $buf14.$amp$plus((Object)new Elem(null, "img", (MetaData)$md13, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)topScope$13, (Seq)$buf14));
                        nodeBuffer = $buf12;
                    } else {
                        DateTime dateTime;
                        if (!(processingStatus instanceof Idle)) throw new MatchError((Object)processingStatus);
                        Idle idle = (Idle)processingStatus;
                        DateTime nextUpdate = dateTime = idle.nextUpdate();
                        NodeBuffer $buf15 = new NodeBuffer();
                        TopScope$ topScope$14 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf16 = new NodeBuffer();
                        Null$ $md14 = Null$.MODULE$;
                        $md14 = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md14);
                        $md14 = new UnprefixedAttribute("data-original-title", DateAndTime$.MODULE$.formatDateTime(nextUpdate), (MetaData)$md14);
                        TopScope$ topScope$15 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf17 = new NodeBuffer();
                        $buf17.$amp$plus((Object)(ta.enabled() ? (DateAndTime$.MODULE$.DateTimeOrderingOps(this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now, DateAndTime$DateTimeOrdering$.MODULE$).$less$eq((Object)nextUpdate) ? DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)this.$outer.net$ripe$rpki$validator$views$TrustAnchorsView$$now, (ReadableInstant)nextUpdate), 1) : "any moment") : ""));
                        $buf16.$amp$plus((Object)new Elem(null, "span", (MetaData)$md14, (NamespaceBinding)topScope$15, (Seq)$buf17));
                        $buf16.$amp$plus(idle.errorMessage().map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Elem apply(String text) {
                                void var3_3;
                                Null$ $md = Null$.MODULE$;
                                $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
                                $md = new UnprefixedAttribute("data-original-title", text, (MetaData)$md);
                                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                                NodeBuffer $buf = new NodeBuffer();
                                $buf.$amp$plus((Object)new EntityRef("nbsp"));
                                Null$ $md2 = Null$.MODULE$;
                                $md2 = new UnprefixedAttribute("src", (Seq)new Text("/images/warningS.png"), (MetaData)$md2);
                                $md2 = new UnprefixedAttribute("align", (Seq)new Text("center"), (MetaData)$md2);
                                $buf.$amp$plus((Object)new Elem(null, "img", (MetaData)$md2, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                                return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)var3_3);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final NodeSeq apply() {
                                return NodeSeq$.MODULE$.Empty();
                            }
                        }));
                        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$14, (Seq)$buf16));
                        Null$ $md15 = Null$.MODULE$;
                        $md15 = new UnprefixedAttribute("class", (Seq)new Text("center"), (MetaData)$md15);
                        TopScope$ topScope$16 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf18 = new NodeBuffer();
                        $buf18.$amp$plus((Object)new Text("\n                        "));
                        Null$ $md16 = Null$.MODULE$;
                        $md16 = new UnprefixedAttribute("action", new StringBuilder().append((Object)this.$outer.tab().url()).append((Object)"/update").toString(), (MetaData)$md16);
                        $md16 = new UnprefixedAttribute("style", (Seq)new Text("padding:0;margin:0;"), (MetaData)$md16);
                        $md16 = new UnprefixedAttribute("method", (Seq)new Text("POST"), (MetaData)$md16);
                        TopScope$ topScope$17 = Predef$.MODULE$.$scope();
                        NodeBuffer $buf19 = new NodeBuffer();
                        $buf19.$amp$plus((Object)new Text("\n                            "));
                        Null$ $md17 = Null$.MODULE$;
                        $md17 = new UnprefixedAttribute("value", ta.locator().getCaName(), (MetaData)$md17);
                        $md17 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md17);
                        $md17 = new UnprefixedAttribute("name", (Seq)new Text("name"), (MetaData)$md17);
                        $buf19.$amp$plus((Object)new Elem(null, "input", (MetaData)$md17, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf19.$amp$plus((Object)new Text("\n                            "));
                        Null$ $md18 = Null$.MODULE$;
                        $md18 = new UnprefixedAttribute("value", (Seq)new Text("Update"), (MetaData)$md18);
                        $md18 = new UnprefixedAttribute("class", (Seq)new Text("btn span2"), (MetaData)$md18);
                        $md18 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md18);
                        $buf19.$amp$plus((Object)new Elem(null, "input", (MetaData)$md18, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                        $buf19.$amp$plus((Object)new Text("\n                        "));
                        $buf18.$amp$plus((Object)new Elem(null, "form", (MetaData)$md16, (NamespaceBinding)topScope$17, (Seq)$buf19));
                        $buf18.$amp$plus((Object)new Text("\n                      "));
                        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)topScope$16, (Seq)$buf18));
                        nodeBuffer = $buf15;
                    }
                } else {
                    NodeBuffer $buf20 = new NodeBuffer();
                    $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                    $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)Predef$.MODULE$.$scope(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                    nodeBuffer = $buf20;
                }
                $buf.$amp$plus((Object)nodeBuffer);
                $buf.$amp$plus((Object)new Text("\n          "));
                return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
            }

            public TrustAnchorsView net$ripe$rpki$validator$views$TrustAnchorsView$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        $buf3.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$12, (Seq)$buf13));
        $buf3.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)$md, (NamespaceBinding)topScope$2, (Seq)$buf3));
        TopScope$ topScope$13 = Predef$.MODULE$.$scope();
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Comment("\n$(function () {\n  $('[rel=twipsy]').twipsy({\n    \"live\": true\n  });\n  var refresh = function() {\n    $.ajax({\n      url: \"/trust-anchors\",\n      dataType: \"html\",\n      success: function (data) {\n        var updatedTable = $(data).filter(\"#trust-anchors\");\n        $(\"#trust-anchors\").replaceWith(updatedTable);\n        $(\"div.twipsy\").fadeOut();\n      }\n    });\n  };\n  setInterval(refresh, 10000);\n});\n//"));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$13, (Seq)$buf14));
        return NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf);
    }

    /*
     * WARNING - void declaration
     */
    public final Elem net$ripe$rpki$validator$views$TrustAnchorsView$$renderCounters(TrustAnchor ta$1, Map<ValidationStatus, Object> counters) {
        void var3_3;
        Elem elem;
        Elem elem2;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.badge$1("success", BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.PASSED, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }))));
        $buf.$amp$plus((Object)new Text("\n      "));
        int n = BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.WARNING, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        if (n == 0) {
            elem2 = this.badge$1("warning", 0);
        } else {
            int nr = n;
            elem2 = this.link$1((NodeSeq)this.badge$1("warning", nr), new StringBuilder().append(nr).append((Object)" warnings exist, click to view").toString(), ta$1);
        }
        $buf.$amp$plus((Object)elem2);
        $buf.$amp$plus((Object)new Text("\n      "));
        int n2 = BoxesRunTime.unboxToInt((Object)counters.getOrElse((Object)ValidationStatus.ERROR, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        if (n2 == 0) {
            elem = this.badge$1("important", 0);
        } else {
            int nr = n2;
            elem = this.link$1((NodeSeq)this.badge$1("important", nr), new StringBuilder().append(nr).append((Object)" errors exist, click to view").toString(), ta$1);
        }
        $buf.$amp$plus((Object)elem);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final NodeSeq net$ripe$rpki$validator$views$TrustAnchorsView$$expiresIn(DateTime notValidAfter) {
        Text text;
        if (this.net$ripe$rpki$validator$views$TrustAnchorsView$$now.isBefore((ReadableInstant)notValidAfter)) {
            text = new Text(DateAndTime$.MODULE$.periodInWords(new Period((ReadableInstant)this.net$ripe$rpki$validator$views$TrustAnchorsView$$now, (ReadableInstant)notValidAfter), DateAndTime$.MODULE$.periodInWords$default$2()));
        } else {
            void var2_2;
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("EXPIRED"));
            text = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
        }
        return text;
    }

    private Seq<TrustAnchor> sortedTrustAnchors() {
        return (Seq)this.trustAnchors.all().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(TrustAnchor trustAnchor) {
                return trustAnchor.name();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    private final Elem badge$1(String level, int count) {
        String clazz = new StringBuilder().append((Object)"object-counter label ").append((Object)level).toString();
        String style = count > 0 ? "" : "opacity: 0.25;";
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", style, (MetaData)$md);
        $md = new UnprefixedAttribute("class", clazz, (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)count));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf);
    }

    private final NodeSeq link$1(NodeSeq s, String helpText, TrustAnchor trustAnchor) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("rel", (Seq)new Text("twipsy"), (MetaData)$md);
        $md = new UnprefixedAttribute("data-original-title", helpText, (MetaData)$md);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("href", new StringBuilder().append((Object)Tabs$.MODULE$.ValidationResultsTab().url()).append((Object)"?q=").append((Object)trustAnchor.name()).toString(), (MetaData)$md2);
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)s);
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)topScope$2, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        return new Elem(null, "span", (MetaData)$md, (NamespaceBinding)topScope$, (Seq)$buf);
    }

    public TrustAnchorsView(TrustAnchors trustAnchors, Map<TrustAnchorLocator, Map<ValidationStatus, Object>> validationStatusCounts2, DateTime now, Seq<Validation.FeedbackMessage> messages2) {
        this.trustAnchors = trustAnchors;
        this.net$ripe$rpki$validator$views$TrustAnchorsView$$validationStatusCounts = validationStatusCounts2;
        this.net$ripe$rpki$validator$views$TrustAnchorsView$$now = now;
        this.messages = messages2;
        ViewHelpers$class.$init$(this);
    }
}

