/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import grizzled.slf4j.Logger;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.util.Specifications;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ConsistentObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RemoteObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcherAdapter;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scalaz.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u00015\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0005\u000191\"\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\tWC2LG-\u0019;j_:\u0004&o\\2fgN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u00111bU2bY\u0006|%M[3di\"A\u0011\u0005\u0001BC\u0002\u0013\u0005#%\u0001\nueV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014X#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011\u0001B;uS2L!\u0001K\u0013\u0003%Q\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005G\u0005\u0019BO];ti\u0006s7\r[8s\u0019>\u001c\u0017\r^8sA!AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0007nCb\u001cF/\u00197f\t\u0006L8\u000f\u0005\u0002\u001c]%\u0011q\u0006\b\u0002\u0004\u0013:$\b\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0017!$H\u000f]*vaB|'\u000f\u001e\t\u00037MJ!\u0001\u000e\u000f\u0003\u000f\t{w\u000e\\3b]\")a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"B\u0001O\u001d;wA\u0011q\u0003\u0001\u0005\u0006CU\u0002\ra\t\u0005\u0006YU\u0002\r!\f\u0005\u0006cU\u0002\rA\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0003\u001dy\u0007\u000f^5p]N,\u0012a\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b!B^1mS\u0012\fG/[8o\u0015\t!e!A\u0004d_6lwN\\:\n\u0005\u0019\u000b%!\u0005,bY&$\u0017\r^5p]>\u0003H/[8og\"1\u0001\n\u0001Q\u0001\n}\n\u0001b\u001c9uS>t7\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0003Y\u00116/\u001f8d\t&\u001c8nQ1dQ\u0016\u0014\u0015m]3QCRDW#\u0001'\u0011\u0005=i\u0015B\u0001(\u0011\u0005\u0019\u0019FO]5oO\"1\u0001\u000b\u0001Q\u0001\n1\u000bqCU:z]\u000e$\u0015n]6DC\u000eDWMQ1tKB\u000bG\u000f\u001b\u0011\t\u000bI\u0003A\u0011I*\u00023\u0015DHO]1diR\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u000b\u0002)B\u0011q#V\u0005\u0003-\n\u0011qBV1mS\u0012\fG/\u001a3PE*,7\r\u001e\u0005\u00061\u0002!\t%W\u0001\u0010m\u0006d\u0017\u000eZ1uK>\u0013'.Z2ugR\u0011!l\u001a\t\u00057\u0002\u0014G+D\u0001]\u0015\tif,A\u0005j[6,H/\u00192mK*\u0011q\fH\u0001\u000bG>dG.Z2uS>t\u0017BA1]\u0005\ri\u0015\r\u001d\t\u0003G\u0016l\u0011\u0001\u001a\u0006\u0003\u0017II!A\u001a3\u0003\u0007U\u0013\u0016\nC\u0003i/\u0002\u0007\u0011.A\u0006dKJ$\u0018NZ5dCR,\u0007C\u00016n\u001b\u0005Y'B\u00017B\u0003Ay'M[3diZ\fG.\u001b3bi>\u00148/\u0003\u0002oW\na3)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGR4\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006a\u0002!\t!]\u0001\u0013o&\u0004XMU:z]\u000e$\u0015n]6DC\u000eDW\rF\u0001s!\tY2/\u0003\u0002u9\t!QK\\5u\u0011\u00151\b\u0001\"\u0003x\u00035\u0019'/Z1uK\u001a+Go\u00195feR\u0011\u0001P \t\u0003srl\u0011A\u001f\u0006\u0003w\u0012\t\u0001BZ3uG\",'o]\u0005\u0003{j\u0014!eQ3si&4\u0017nY1uKJ+\u0007o\\:ji>\u0014\u0018p\u00142kK\u000e$h)\u001a;dQ\u0016\u0014\bBB@v\u0001\u0004\t\t!A\u0005mSN$XM\\3sgB)1$a\u0001\u0002\b%\u0019\u0011Q\u0001\u000f\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002\n\u0005=abA=\u0002\f%\u0019\u0011Q\u0002>\u0002W9{G/\u001b4zS:<7)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGR4U\r^2iKJLA!!\u0005\u0002\u0014\tAA*[:uK:,'OC\u0002\u0002\u000eiD!\"a\u0006\u0001\u0011\u000b\u0007K\u0011BA\r\u0003]\u0019wN\\:jgR,g\u000e^(cU\u0016\u001cGOR3uG\",'/\u0006\u0002\u0002\u001cA\u0019\u00110!\b\n\u0007\u0005}!PA\fD_:\u001c\u0018n\u001d;f]R|%M[3di\u001a+Go\u00195fe\"Q\u00111\u0005\u0001\t\u0002\u0003\u0005K!a\u0007\u00021\r|gn]5ti\u0016tGo\u00142kK\u000e$h)\u001a;dQ\u0016\u0014\bE\u0002\u0004\u0002(\u0001!\u0011\u0011\u0006\u0002\r%>\f7i\u001c7mK\u000e$xN]\n\u0006\u0003K\tYC\u0007\t\u0005\u0003\u0013\ti#\u0003\u0003\u00020\u0005M!a\u0004'jgR,g.\u001a:BI\u0006\u0004H/\u001a:\t\u0015\u0005M\u0012Q\u0005B\u0001B\u0003%1%A\u0006ueV\u001cH/\u00118dQ>\u0014\bbCA\u001c\u0003K\u0011\t\u0011)A\u0005\u0003s\tqa\u001c2kK\u000e$8\u000f\r\u0003\u0002<\u0005E\u0003\u0003CA\u001f\u0003\u0007\n9%!\u0014\u000e\u0005\u0005}\"bAA!=\u00069Q.\u001e;bE2,\u0017\u0002BA#\u0003\u007f\u0011qAQ;jY\u0012,'\u000fE\u0003\u001c\u0003\u0013\u0012G+C\u0002\u0002Lq\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA(\u0003#b\u0001\u0001B\u0006\u0002T\u0001\t\t\u0011!A\u0003\u0002\u0005U#aA0%cE!\u0011qKA/!\rY\u0012\u0011L\u0005\u0004\u00037b\"a\u0002(pi\"Lgn\u001a\t\u00047\u0005}\u0013bAA19\t\u0019\u0011I\\=\t\u000fY\n)\u0003\"\u0001\u0002fQ1\u0011qMA6\u0003[\u0002B!!\u001b\u0002&5\t\u0001\u0001C\u0004\u00024\u0005\r\u0004\u0019A\u0012\t\u0011\u0005]\u00121\ra\u0001\u0003_\u0002D!!\u001d\u0002vAA\u0011QHA\"\u0003\u000f\n\u0019\b\u0005\u0003\u0002P\u0005UD\u0001DA*\u0003G\n\t\u0011!A\u0003\u0002\u0005U\u0003\u0002CA=\u0003K!\t%a\u001f\u0002#\u00054G/\u001a:GKR\u001c\u0007NR1jYV\u0014X\rF\u0003s\u0003{\n\t\tC\u0004\u0002\u0000\u0005]\u0004\u0019\u00012\u0002\u0007U\u0014\u0018\u000e\u0003\u0005\u0002\u0004\u0006]\u0004\u0019AAC\u0003\u0019\u0011Xm];miB\u0019\u0001)a\"\n\u0007\u0005%\u0015I\u0001\tWC2LG-\u0019;j_:\u0014Vm];mi\"A\u0011QRA\u0013\t\u0003\ny)A\tbMR,'OR3uG\"\u001cVoY2fgN$rA]AI\u0003'\u000b\u0019\u000bC\u0004\u0002\u0000\u0005-\u0005\u0019\u00012\t\u0011\u0005U\u00151\u0012a\u0001\u0003/\u000b1a\u001c2k!\u0011\tI*a(\u000e\u0005\u0005m%bAAO\u0007\u000611M]=qi>LA!!)\u0002\u001c\nY2)\u001a:uS\u001aL7-\u0019;f%\u0016\u0004xn]5u_JLxJ\u00196fGRD\u0001\"a!\u0002\f\u0002\u0007\u0011Q\u0011")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    private final int maxStaleDays;
    private final ValidationOptions options;
    private final String RsyncDiskCacheBasePath;
    private ConsistentObjectFetcher consistentObjectFetcher;
    private final Logger logger;
    private volatile int bitmap$priv$0;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$ValidationProcess$_setter_$logger_$eq(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Validation<String, Map<URI, ValidatedObject>> runProcess() {
        return ValidationProcess$class.runProcess(this);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions options() {
        return this.options;
    }

    private String RsyncDiskCacheBasePath() {
        return this.RsyncDiskCacheBasePath;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator() {
        Product product;
        URI uri = this.trustAnchorLocator().getCertificateLocation();
        ValidationResult validationResult = ValidationResult.withLocation((URI)uri);
        CertificateRepositoryObject cro = this.consistentObjectFetcher().fetch(uri, (Specification<byte[]>)Specifications.alwaysTrue(), validationResult);
        CertificateRepositoryObject certificateRepositoryObject = cro;
        if (certificateRepositoryObject instanceof X509ResourceCertificate) {
            X509ResourceCertificate x509ResourceCertificate;
            X509ResourceCertificate certificate = x509ResourceCertificate = (X509ResourceCertificate)certificateRepositoryObject;
            String string = this.trustAnchorLocator().getPublicKeyInfo();
            String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
            validationResult.rejectIfFalse(!(string != null ? !string.equals(string2) : string2 != null), "trust.anchor.public.key.match", new String[0]);
            product = validationResult.hasFailureForCurrentLocation() ? new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet()) : new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), (CertificateRepositoryObject)certificate);
        } else {
            product = new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet());
        }
        return product;
    }

    @Override
    public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        RoaCollector roaCollector = new RoaCollector(this, this.trustAnchorLocator(), builder);
        CertificateRepositoryObjectFetcher fetcher$1 = this.createFetcher((Seq<NotifyingCertificateRepositoryObjectFetcher.Listener>)((Seq)this.objectFetcherListeners().$plus$colon((Object)roaCollector, Seq$.MODULE$.canBuildFrom())));
        RepositoryObjectStore cache = new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource());
        cache.purgeExpired(this.maxStaleDays);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this, fetcher$1){
            public static final long serialVersionUID;
            private final TrustAnchorValidationProcess $outer;
            private final CertificateRepositoryObjectFetcher fetcher$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(URI prefetchUri$1) {
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri$1){
                    public static final long serialVersionUID;
                    private final URI prefetchUri$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Prefetching '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = uRI;
                    }
                });
                ValidationResult validationResult = ValidationResult.withLocation((URI)prefetchUri$1);
                this.fetcher$1.prefetch(prefetchUri$1, validationResult);
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri$1){
                    public static final long serialVersionUID;
                    private final URI prefetchUri$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Done prefetching for '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = uRI;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetcher$1 = certificateRepositoryObjectFetcher;
            }
        });
        TopDownWalker walker = new TopDownWalker(fetcher$1);
        walker.addTrustAnchor(certificate);
        walker.execute();
        return (Map)builder.result();
    }

    public void wipeRsyncDiskCache() {
        File diskCache = new File(this.RsyncDiskCacheBasePath());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    private CertificateRepositoryObjectFetcher createFetcher(Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> listeners) {
        ValidatingCertificateRepositoryObjectFetcher validatingFetcher = new ValidatingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)new RpkiRepositoryObjectFetcherAdapter((RpkiRepositoryObjectFetcher)this.consistentObjectFetcher()), this.options());
        NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1 = new NotifyingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)validatingFetcher);
        CachingCertificateRepositoryObjectFetcher cachingFetcher = new CachingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)notifyingFetcher$1);
        validatingFetcher.setOuterMostDecorator((CertificateRepositoryObjectFetcher)cachingFetcher);
        listeners.foreach((Function1)new Serializable(this, notifyingFetcher$1){
            public static final long serialVersionUID;
            private final NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(NotifyingCertificateRepositoryObjectFetcher.Listener listener) {
                this.notifyingFetcher$1.addCallback(listener);
            }
            {
                this.notifyingFetcher$1 = notifyingCertificateRepositoryObjectFetcher;
            }
        });
        return cachingFetcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConsistentObjectFetcher consistentObjectFetcher() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.consistentObjectFetcher;
        TrustAnchorValidationProcess trustAnchorValidationProcess = this;
        synchronized (trustAnchorValidationProcess) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                Rsync rsync = new Rsync();
                rsync.setTimeoutInSeconds(300);
                RsyncRpkiRepositoryObjectFetcher rsyncFetcher = new RsyncRpkiRepositoryObjectFetcher(rsync, new UriToFileMapper(new File(new StringBuilder().append((Object)this.RsyncDiskCacheBasePath()).append((Object)this.trustAnchorLocator().getFile().getName()).toString())));
                RemoteObjectFetcher remoteFetcher = new RemoteObjectFetcher(rsyncFetcher);
                this.consistentObjectFetcher = new ConsistentObjectFetcher(remoteFetcher, new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource()));
                this.bitmap$priv$0 |= 1;
            }
            return this.consistentObjectFetcher;
        }
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, int maxStaleDays, boolean httpSupport2) {
        this.trustAnchorLocator = trustAnchorLocator;
        this.maxStaleDays = maxStaleDays;
        ValidationProcess$class.$init$(this);
        this.options = new ValidationOptions();
        this.RsyncDiskCacheBasePath = "tmp/cache/";
        this.options().setMaxStaleDays(maxStaleDays);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RoaCollector
    extends NotifyingCertificateRepositoryObjectFetcher.ListenerAdapter
    implements ScalaObject {
        private final Builder<Tuple2<URI, ValidatedObject>, ?> objects;
        public final TrustAnchorValidationProcess $outer;

        public void afterFetchFailure(URI uri, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet())));
        }

        public void afterFetchSuccess(URI uri, CertificateRepositoryObject obj, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), obj)));
        }

        public TrustAnchorValidationProcess net$ripe$rpki$validator$models$TrustAnchorValidationProcess$RoaCollector$$$outer() {
            return this.$outer;
        }

        public RoaCollector(TrustAnchorValidationProcess $outer, TrustAnchorLocator trustAnchor, Builder<Tuple2<URI, ValidatedObject>, ?> objects) {
            this.objects = objects;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

