/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.statistics;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsBuilder;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlBuilder;
import net.ripe.rpki.commons.crypto.util.KeyPairFactoryTest;
import net.ripe.rpki.commons.crypto.x509cert.RpkiSignedObjectEeCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.statistics.InconsistentRepositoryCheckingTest$;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InconsistentRepositoryCheckingTest$
implements ScalaObject,
Serializable {
    public static final InconsistentRepositoryCheckingTest$ MODULE$;
    private final URI TA_CER_URI;
    private final URI TA_CER_REPO_URI;
    private final URI TA_MFT_URI;
    private final URI TA_CRL_URI;
    private final URI TA_MISSING_CER_URI;
    private final URI TA_UNKNOWN_CER_URI;
    private final X500Principal TA_CER_SUBJECT;
    private final ValidityPeriod TA_CER_VALIDITY;
    private final KeyPair TA_CER_KEY_PAIR;
    private final IpResourceSet TA_CER_RESOURCES;
    private final X509ResourceCertificate TA_CER_OBJECT;
    private final ValidObject TA_CER_VALIDATED_OBJECT;
    private final ValidityPeriod TA_CRL_VALIDITY;
    private final X509Crl TA_CRL_OBJECT;
    private final ValidObject TA_CRL_VALIDATED_OBJECT;
    private final InvalidObject MISSING_CER_VALIDATED_OBJECT;
    private final X500Principal TA_MFT_SUBJECT;
    private final ValidityPeriod TA_MFT_VALIDITY;
    private final KeyPair TA_MFT_KEY_PAIR;
    private final X509ResourceCertificate TA_MFT_EE_CER;
    private final ManifestCms TA_MFT_OBJECT;
    private final ValidObject TA_MFT_VALIDATED_OBJECT;
    private final ManifestCms INCONSISTENT_TA_MFT_OBJECT;
    private final ValidObject INCONSISTENT_TA_MFT_VALIDATED_OBJECT;
    private final Map<URI, ValidObject> CONSISTENT_OBJECT_SET;
    private final Map<URI, Product> INCONSISTENT_OBJECT_SET;

    static {
        new InconsistentRepositoryCheckingTest$();
    }

    public URI TA_CER_URI() {
        return this.TA_CER_URI;
    }

    public URI TA_CER_REPO_URI() {
        return this.TA_CER_REPO_URI;
    }

    public URI TA_MFT_URI() {
        return this.TA_MFT_URI;
    }

    public URI TA_CRL_URI() {
        return this.TA_CRL_URI;
    }

    public URI TA_MISSING_CER_URI() {
        return this.TA_MISSING_CER_URI;
    }

    public URI TA_UNKNOWN_CER_URI() {
        return this.TA_UNKNOWN_CER_URI;
    }

    public X500Principal TA_CER_SUBJECT() {
        return this.TA_CER_SUBJECT;
    }

    public ValidityPeriod TA_CER_VALIDITY() {
        return this.TA_CER_VALIDITY;
    }

    public KeyPair TA_CER_KEY_PAIR() {
        return this.TA_CER_KEY_PAIR;
    }

    public IpResourceSet TA_CER_RESOURCES() {
        return this.TA_CER_RESOURCES;
    }

    public X509ResourceCertificate TA_CER_OBJECT() {
        return this.TA_CER_OBJECT;
    }

    public ValidObject TA_CER_VALIDATED_OBJECT() {
        return this.TA_CER_VALIDATED_OBJECT;
    }

    public ValidityPeriod TA_CRL_VALIDITY() {
        return this.TA_CRL_VALIDITY;
    }

    public X509Crl TA_CRL_OBJECT() {
        return this.TA_CRL_OBJECT;
    }

    public ValidObject TA_CRL_VALIDATED_OBJECT() {
        return this.TA_CRL_VALIDATED_OBJECT;
    }

    public InvalidObject MISSING_CER_VALIDATED_OBJECT() {
        return this.MISSING_CER_VALIDATED_OBJECT;
    }

    public X500Principal TA_MFT_SUBJECT() {
        return this.TA_MFT_SUBJECT;
    }

    public ValidityPeriod TA_MFT_VALIDITY() {
        return this.TA_MFT_VALIDITY;
    }

    public KeyPair TA_MFT_KEY_PAIR() {
        return this.TA_MFT_KEY_PAIR;
    }

    public X509ResourceCertificate TA_MFT_EE_CER() {
        return this.TA_MFT_EE_CER;
    }

    public ManifestCms TA_MFT_OBJECT() {
        return this.TA_MFT_OBJECT;
    }

    public ValidObject TA_MFT_VALIDATED_OBJECT() {
        return this.TA_MFT_VALIDATED_OBJECT;
    }

    public ManifestCms INCONSISTENT_TA_MFT_OBJECT() {
        return this.INCONSISTENT_TA_MFT_OBJECT;
    }

    public ValidObject INCONSISTENT_TA_MFT_VALIDATED_OBJECT() {
        return this.INCONSISTENT_TA_MFT_VALIDATED_OBJECT;
    }

    public Map<URI, ValidObject> CONSISTENT_OBJECT_SET() {
        return this.CONSISTENT_OBJECT_SET;
    }

    public Map<URI, Product> INCONSISTENT_OBJECT_SET() {
        return this.INCONSISTENT_OBJECT_SET;
    }

    public Object readResolve() {
        return MODULE$;
    }

    private InconsistentRepositoryCheckingTest$() {
        MODULE$ = this;
        this.TA_CER_URI = URI.create("rsync://host/ta.cer");
        this.TA_CER_REPO_URI = URI.create("rsync://host/");
        this.TA_MFT_URI = URI.create("rsync://host/ta.mft");
        this.TA_CRL_URI = URI.create("rsync://host/ta.crl");
        this.TA_MISSING_CER_URI = URI.create("rsync://host/missing.cer");
        this.TA_UNKNOWN_CER_URI = URI.create("rsync://host/unknown.cer");
        this.TA_CER_SUBJECT = new X500Principal("CN=root-cert");
        this.TA_CER_VALIDITY = new ValidityPeriod((ReadableInstant)new DateTime().minusMinutes(1), (ReadableInstant)new DateTime().plusHours(1));
        this.TA_CER_KEY_PAIR = KeyPairFactoryTest.TEST_KEY_PAIR;
        this.TA_CER_RESOURCES = IpResourceSet.parse((String)"10/8");
        X509ResourceCertificateBuilder builder = new X509ResourceCertificateBuilder();
        builder.withCa(true);
        builder.withKeyUsage(6);
        builder.withSubjectDN(this.TA_CER_SUBJECT());
        builder.withIssuerDN(this.TA_CER_SUBJECT());
        builder.withSerial(BigInteger.ONE);
        builder.withValidityPeriod(this.TA_CER_VALIDITY());
        builder.withPublicKey(this.TA_CER_KEY_PAIR().getPublic());
        builder.withSigningKeyPair(this.TA_CER_KEY_PAIR());
        builder.withResources(this.TA_CER_RESOURCES());
        builder.withSubjectInformationAccess(new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.TA_CER_REPO_URI()), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, this.TA_MFT_URI())});
        this.TA_CER_OBJECT = builder.build();
        this.TA_CER_VALIDATED_OBJECT = new ValidObject(this.TA_CER_URI(), Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)this.TA_CER_OBJECT());
        this.TA_CRL_VALIDITY = this.TA_CER_VALIDITY();
        X509CrlBuilder builder2 = new X509CrlBuilder();
        builder2.withIssuerDN(new X500Principal("CN=issuer"));
        builder2.withThisUpdateTime(this.TA_CRL_VALIDITY().getNotValidBefore());
        builder2.withNextUpdateTime(this.TA_CRL_VALIDITY().getNotValidAfter());
        builder2.withNumber(BigInteger.TEN);
        builder2.withAuthorityKeyIdentifier(this.TA_CER_KEY_PAIR().getPublic());
        builder2.addEntry(BigInteger.TEN, new DateTime().minusDays(1));
        builder2.addEntry(BigInteger.valueOf(42L), new DateTime().minusDays(3));
        this.TA_CRL_OBJECT = builder2.build(this.TA_CER_KEY_PAIR().getPrivate());
        this.TA_CRL_VALIDATED_OBJECT = new ValidObject(this.TA_CRL_URI(), Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)this.TA_CRL_OBJECT());
        this.MISSING_CER_VALIDATED_OBJECT = new InvalidObject(this.TA_MISSING_CER_URI(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidationCheck[]{new ValidationCheck(ValidationStatus.ERROR, "validator.read.file", new String[]{this.TA_MISSING_CER_URI().toString()})})));
        this.TA_MFT_SUBJECT = new X500Principal("CN=root-mft");
        this.TA_MFT_VALIDITY = this.TA_CRL_VALIDITY();
        this.TA_MFT_KEY_PAIR = KeyPairFactoryTest.SECOND_TEST_KEY_PAIR;
        RpkiSignedObjectEeCertificateBuilder builder3 = new RpkiSignedObjectEeCertificateBuilder();
        builder3.withCorrespondingCmsPublicationPoint(this.TA_MFT_URI());
        builder3.withSubjectDN(this.TA_MFT_SUBJECT());
        builder3.withIssuerDN(this.TA_CER_SUBJECT());
        builder3.withSerial(BigInteger.ONE);
        builder3.withValidityPeriod(this.TA_MFT_VALIDITY());
        builder3.withPublicKey(this.TA_MFT_KEY_PAIR().getPublic());
        builder3.withSigningKeyPair(this.TA_CER_KEY_PAIR());
        builder3.withInheritedResourceTypes(EnumSet.allOf(IpResourceType.class));
        builder3.withCrlUri(this.TA_CRL_URI());
        builder3.withParentResourceCertificatePublicationUri(this.TA_CER_URI());
        this.TA_MFT_EE_CER = builder3.build();
        ManifestCmsBuilder builder4 = new ManifestCmsBuilder();
        builder4.withManifestNumber(BigInteger.ONE);
        builder4.withThisUpdateTime(this.TA_MFT_EE_CER().getValidityPeriod().getNotValidBefore());
        builder4.withNextUpdateTime(this.TA_MFT_EE_CER().getValidityPeriod().getNotValidAfter());
        builder4.withCertificate(this.TA_MFT_EE_CER());
        builder4.addFile("ta.cer", this.TA_CER_OBJECT().getEncoded());
        builder4.addFile("ta.crl", this.TA_CRL_OBJECT().getEncoded());
        this.TA_MFT_OBJECT = builder4.build(this.TA_MFT_KEY_PAIR().getPrivate());
        this.TA_MFT_VALIDATED_OBJECT = new ValidObject(this.TA_MFT_URI(), Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)this.TA_MFT_OBJECT());
        ManifestCmsBuilder builder5 = new ManifestCmsBuilder();
        builder5.withManifestNumber(BigInteger.ONE);
        builder5.withThisUpdateTime(this.TA_MFT_EE_CER().getValidityPeriod().getNotValidBefore());
        builder5.withNextUpdateTime(this.TA_MFT_EE_CER().getValidityPeriod().getNotValidAfter());
        builder5.withCertificate(this.TA_MFT_EE_CER());
        builder5.addFile("ta.cer", this.TA_CER_OBJECT().getEncoded());
        builder5.addFile("missing.cer", this.TA_CER_OBJECT().getEncoded());
        builder5.addFile("ta.crl", this.TA_CRL_OBJECT().getEncoded());
        this.INCONSISTENT_TA_MFT_OBJECT = builder5.build(this.TA_MFT_KEY_PAIR().getPrivate());
        this.INCONSISTENT_TA_MFT_VALIDATED_OBJECT = new ValidObject(this.TA_MFT_URI(), Predef$.MODULE$.Set().empty(), (CertificateRepositoryObject)this.INCONSISTENT_TA_MFT_OBJECT());
        this.CONSISTENT_OBJECT_SET = ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ValidObject[]{this.TA_CER_VALIDATED_OBJECT(), this.TA_CRL_VALIDATED_OBJECT(), this.TA_MFT_VALIDATED_OBJECT()})).map((Function1)new anonfun.7(), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.INCONSISTENT_OBJECT_SET = ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{this.TA_CER_VALIDATED_OBJECT(), this.TA_CRL_VALIDATED_OBJECT(), this.INCONSISTENT_TA_MFT_VALIDATED_OBJECT(), this.MISSING_CER_VALIDATED_OBJECT()})).map((Function1)new anonfun.8(), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }
}

