@REM ----------------------------------------------------------------------------
@REM Copyright 2001-2004 The Apache Software Foundation.
@REM
@REM Licensed under the Apache License, Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM
@REM      http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.
@REM ----------------------------------------------------------------------------
@REM

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\conf;"%REPO%"\joda-time\joda-time\1.6.2\joda-time-1.6.2.jar;"%REPO%"\org\bouncycastle\bcprov-jdk15on\1.48\bcprov-jdk15on-1.48.jar;"%REPO%"\org\bouncycastle\bcmail-jdk15on\1.48\bcmail-jdk15on-1.48.jar;"%REPO%"\org\bouncycastle\bcpkix-jdk15on\1.48\bcpkix-jdk15on-1.48.jar;"%REPO%"\net\ripe\ipresource\ipresource\1.45\ipresource-1.45.jar;"%REPO%"\commons-io\commons-io\2.4\commons-io-2.4.jar;"%REPO%"\commons-codec\commons-codec\1.7\commons-codec-1.7.jar;"%REPO%"\com\thoughtworks\xstream\xstream\1.4.3\xstream-1.4.3.jar;"%REPO%"\xmlpull\xmlpull\1.1.3.1\xmlpull-1.1.3.1.jar;"%REPO%"\xpp3\xpp3_min\1.1.4c\xpp3_min-1.1.4c.jar;"%REPO%"\net\ripe\rpki\rpki-validator-cli\2.8\rpki-validator-cli-2.8.jar;"%REPO%"\org\scala-lang\scala-library\2.9.3\scala-library-2.9.3.jar;"%REPO%"\org\scalatra\scalatra\2.1.1\scalatra-2.1.1.jar;"%REPO%"\io\backchat\rl\rl_2.9.2\0.3.2\rl_2.9.2-0.3.2.jar;"%REPO%"\com\typesafe\akka\akka-actor\2.0.4\akka-actor-2.0.4.jar;"%REPO%"\com\typesafe\config\0.3.1\config-0.3.1.jar;"%REPO%"\com\typesafe\akka\akka-agent\2.0.4\akka-agent-2.0.4.jar;"%REPO%"\org\scala-tools\scala-stm_2.9.1\0.5\scala-stm_2.9.1-0.5.jar;"%REPO%"\org\jboss\netty\netty\3.2.5.Final\netty-3.2.5.Final.jar;"%REPO%"\org\scalaz\scalaz-core_2.9.2\6.0.4\scalaz-core_2.9.2-6.0.4.jar;"%REPO%"\commons-cli\commons-cli\1.2\commons-cli-1.2.jar;"%REPO%"\com\yammer\metrics\metrics-core\2.1.2\metrics-core-2.1.2.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.2.2\httpclient-4.2.2.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.2.2\httpcore-4.2.2.jar;"%REPO%"\commons-logging\commons-logging\1.1.1\commons-logging-1.1.1.jar;"%REPO%"\net\liftweb\lift-json_2.9.1\2.4\lift-json_2.9.1-2.4.jar;"%REPO%"\com\thoughtworks\paranamer\paranamer\2.3\paranamer-2.3.jar;"%REPO%"\org\scala-lang\scalap\2.9.3\scalap-2.9.3.jar;"%REPO%"\org\scala-lang\scala-compiler\2.9.3\scala-compiler-2.9.3.jar;"%REPO%"\org\clapper\argot_2.9.1\0.3.5\argot_2.9.1-0.3.5.jar;"%REPO%"\org\clapper\grizzled-scala_2.9.1\1.0.8\grizzled-scala_2.9.1-1.0.8.jar;"%REPO%"\jline\jline\0.9.94\jline-0.9.94.jar;"%REPO%"\org\clapper\grizzled-slf4j_2.9.2\0.6.10\grizzled-slf4j_2.9.2-0.6.10.jar;"%REPO%"\org\slf4j\slf4j-api\1.6.2\slf4j-api-1.6.2.jar;"%REPO%"\org\slf4j\slf4j-log4j12\1.6.2\slf4j-log4j12-1.6.2.jar;"%REPO%"\org\eclipse\jetty\jetty-servlet\8.1.3.v20120416\jetty-servlet-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-security\8.1.3.v20120416\jetty-security-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-server\8.1.3.v20120416\jetty-server-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\orbit\javax.servlet\3.0.0.v201112011016\javax.servlet-3.0.0.v201112011016.jar;"%REPO%"\org\eclipse\jetty\jetty-continuation\8.1.3.v20120416\jetty-continuation-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-http\8.1.3.v20120416\jetty-http-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-io\8.1.3.v20120416\jetty-io-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-xml\8.1.3.v20120416\jetty-xml-8.1.3.v20120416.jar;"%REPO%"\org\eclipse\jetty\jetty-util\8.1.3.v20120416\jetty-util-8.1.3.v20120416.jar;"%REPO%"\com\h2database\h2\1.3.167\h2-1.3.167.jar;"%REPO%"\commons-dbcp\commons-dbcp\1.4\commons-dbcp-1.4.jar;"%REPO%"\commons-pool\commons-pool\1.5.4\commons-pool-1.5.4.jar;"%REPO%"\com\googlecode\flyway\flyway-core\1.6.1\flyway-core-1.6.1.jar;"%REPO%"\org\springframework\spring-jdbc\3.1.1.RELEASE\spring-jdbc-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-beans\3.1.1.RELEASE\spring-beans-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-core\3.1.1.RELEASE\spring-core-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-asm\3.1.1.RELEASE\spring-asm-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-tx\3.1.1.RELEASE\spring-tx-3.1.1.RELEASE.jar;"%REPO%"\aopalliance\aopalliance\1.0\aopalliance-1.0.jar;"%REPO%"\org\springframework\spring-aop\3.1.1.RELEASE\spring-aop-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-context\3.1.1.RELEASE\spring-context-3.1.1.RELEASE.jar;"%REPO%"\org\springframework\spring-expression\3.1.1.RELEASE\spring-expression-3.1.1.RELEASE.jar;"%REPO%"\net\ripe\rpki\rpki-commons\1.0.26\rpki-commons-1.0.26.jar;"%REPO%"\commons-lang\commons-lang\2.6\commons-lang-2.6.jar;"%REPO%"\log4j\log4j\1.2.14\log4j-1.2.14.jar;"%REPO%"\net\ripe\rpki\rpki-validator-app\2.8\rpki-validator-app-2.8.jar
set EXTRA_JVM_ARGUMENTS=-Xms512m -Xmx512m
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% %EXTRA_JVM_ARGUMENTS% -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="rpki-validator" -Dapp.repo="%REPO%" -Dbasedir="%BASEDIR%" net.ripe.rpki.validator.config.Main %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=1

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@endlocal

:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
