/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.math.BigInteger;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.ipresource.UniqueIpResource;

public abstract class IpAddress
extends UniqueIpResource {
    private static final long serialVersionUID = 2L;

    public static IpAddress parse(String s) {
        return IpAddress.parse(s, false);
    }

    public static IpAddress parse(String s, boolean defaultMissingOctets) {
        try {
            return Ipv4Address.parse(s, defaultMissingOctets);
        }
        catch (IllegalArgumentException e) {
            try {
                return Ipv6Address.parse(s);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(String.format("Invalid IP address: " + s, new Object[0]));
            }
        }
    }

    protected static BigInteger bitMask(int prefixLength, IpResourceType type) {
        BigInteger MINUS_ONE = new BigInteger("-1");
        return BigInteger.ONE.shiftLeft(type.getBitSize() - prefixLength).add(MINUS_ONE);
    }

    public IpAddress getCommonPrefix(IpAddress other) {
        return this.lowerBoundForPrefix(this.getCommonPrefixLength(other));
    }

    protected IpAddress createOfSameType(BigInteger value) {
        return (IpAddress)this.getType().fromBigInteger(value);
    }

    public int getLeastSignificantOne() {
        return this.getLeastSignificant(true);
    }

    public int getLeastSignificantZero() {
        return this.getLeastSignificant(false);
    }

    private int getLeastSignificant(boolean bit) {
        for (int i = 0; i < this.getType().getBitSize(); ++i) {
            if (this.getValue().testBit(i) != bit) continue;
            return i;
        }
        return this.getType().getBitSize();
    }

    public IpAddress stripLeastSignificantOnes() {
        int leastSignificantZero = this.getLeastSignificantZero();
        return this.createOfSameType(this.getValue().shiftRight(leastSignificantZero).shiftLeft(leastSignificantZero));
    }

    public String toString() {
        return this.toString(false);
    }

    public abstract String toString(boolean var1);
}

