/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang.Validate;

public class Asn
extends UniqueIpResource {
    private static final long serialVersionUID = 2L;
    private static final Pattern ASN_TEXT_PATTERN = Pattern.compile("(?:AS)?(\\d+)(\\.(\\d+))?", 2);
    public static final long ASN_MIN_VALUE = 0L;
    public static final long ASN16_MAX_VALUE = 65535L;
    public static final long ASN32_MAX_VALUE = 0xFFFFFFFFL;
    private int intValue;

    public Asn(BigInteger value) {
        this(value.longValue());
    }

    public Asn(long value) {
        Asn.checkRange(value, 0xFFFFFFFFL);
        this.intValue = (int)value;
    }

    @Override
    public IpResourceType getType() {
        return IpResourceType.ASN;
    }

    public static Asn parse(String text) {
        long low;
        if (text == null) {
            return null;
        }
        Matcher matcher = ASN_TEXT_PATTERN.matcher(text = text.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not a legal ASN: " + text);
        }
        long high = 0L;
        if (matcher.group(3) != null) {
            low = Long.valueOf(matcher.group(3));
            high = Long.valueOf(matcher.group(1));
            Asn.checkRange(high, 65535L);
            Asn.checkRange(low, 65535L);
        } else {
            low = Long.valueOf(matcher.group(1));
            Asn.checkRange(low, 0xFFFFFFFFL);
        }
        return new Asn(high << 16 | low);
    }

    private static void checkRange(long value, long max) {
        Validate.isTrue((value >= 0L ? 1 : 0) != 0);
        Validate.isTrue((value <= max ? 1 : 0) != 0);
    }

    public final long longValue() {
        return (long)this.intValue & 0xFFFFFFFFL;
    }

    @Override
    protected int doHashCode() {
        return this.intValue;
    }

    @Override
    protected int doCompareTo(IpResource obj) {
        if (obj instanceof Asn) {
            long otherValue = ((Asn)obj).longValue();
            if (this.longValue() < otherValue) {
                return -1;
            }
            if (this.longValue() > otherValue) {
                return 1;
            }
            return 0;
        }
        return super.doCompareTo(obj);
    }

    public String toString() {
        return "AS" + this.longValue();
    }

    @Override
    public int getCommonPrefixLength(UniqueIpResource other) {
        throw new UnsupportedOperationException("prefix notation not supported for ASN resources");
    }

    @Override
    public IpAddress lowerBoundForPrefix(int prefixLength) {
        throw new UnsupportedOperationException("prefix notation not supported for ASN resources");
    }

    @Override
    public IpAddress upperBoundForPrefix(int prefixLength) {
        throw new UnsupportedOperationException("prefix notation not supported for ASN resources");
    }

    @Override
    public final BigInteger getValue() {
        return BigInteger.valueOf(this.longValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        this.intValue = !gf.defaulted("intValue") ? gf.get("intValue", 0) : (int)gf.get("value", 0L);
    }
}

