/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.akka.util;

import akka.event.LoggingAdapter;
import akka.util.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.akka.util.MapBackedSet;
import org.jboss.netty.akka.util.Timeout;
import org.jboss.netty.akka.util.Timer;
import org.jboss.netty.akka.util.TimerTask;
import org.jboss.netty.akka.util.internal.ConcurrentIdentityHashMap;
import org.jboss.netty.akka.util.internal.ReusableIterator;

public class HashedWheelTimer
implements Timer {
    private final Worker worker = new Worker();
    final Thread workerThread;
    boolean shutdown = false;
    private final long roundDuration;
    final long tickDuration;
    final Set<HashedWheelTimeout>[] wheel;
    final ReusableIterator<HashedWheelTimeout>[] iterators;
    final int mask;
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final boolean isWindows;
    volatile int wheelCursor;
    private LoggingAdapter logger;

    public HashedWheelTimer(LoggingAdapter loggingAdapter, ThreadFactory threadFactory, Duration duration, int n) {
        boolean bl = this.isWindows = System.getProperty("os.name", "").toLowerCase().indexOf("win") >= 0;
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        if (duration.toNanos() <= 0L) {
            throw new IllegalArgumentException("duration must be greater than 0 ns: " + duration.toNanos());
        }
        if (n <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n);
        }
        this.logger = loggingAdapter;
        this.wheel = HashedWheelTimer.createWheel(n);
        this.iterators = HashedWheelTimer.createIterators(this.wheel);
        this.mask = this.wheel.length - 1;
        this.tickDuration = duration.toNanos();
        if (this.tickDuration == Long.MAX_VALUE || this.tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException("tickDuration is too long: " + this.tickDuration + ' ' + (Object)((Object)duration.unit()));
        }
        this.roundDuration = this.tickDuration * (long)this.wheel.length;
        this.workerThread = threadFactory.newThread(this.worker);
    }

    private static Set<HashedWheelTimeout>[] createWheel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n);
        }
        if (n > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + n);
        }
        n = HashedWheelTimer.normalizeTicksPerWheel(n);
        Set[] setArray = new Set[n];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = new MapBackedSet(new ConcurrentIdentityHashMap(16, 0.95f, 4));
        }
        return setArray;
    }

    private static ReusableIterator<HashedWheelTimeout>[] createIterators(Set<HashedWheelTimeout>[] setArray) {
        ReusableIterator[] reusableIteratorArray = new ReusableIterator[setArray.length];
        for (int i = 0; i < setArray.length; ++i) {
            reusableIteratorArray[i] = (ReusableIterator)setArray[i].iterator();
        }
        return reusableIteratorArray;
    }

    private static int normalizeTicksPerWheel(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.lock.readLock().lock();
        try {
            if (this.shutdown) {
                throw new IllegalStateException("cannot be started once stopped");
            }
            if (!this.workerThread.isAlive()) {
                this.workerThread.start();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Timeout> stop() {
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            if (this.shutdown) {
                Set<Timeout> set = Collections.emptySet();
                return set;
            }
            this.shutdown = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        boolean bl = false;
        while (this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        HashSet<HashedWheelTimeout> hashSet = new HashSet<HashedWheelTimeout>();
        for (Set<HashedWheelTimeout> set : this.wheel) {
            hashSet.addAll(set);
            set.clear();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public HashedWheelTimeout createTimeout(TimerTask timerTask, long l) {
        return new HashedWheelTimeout(timerTask, l);
    }

    @Override
    public Timeout newTimeout(TimerTask timerTask, Duration duration) {
        long l = System.nanoTime();
        if (timerTask == null) {
            throw new NullPointerException("task");
        }
        if (duration == null) {
            throw new NullPointerException("delay");
        }
        if (!this.workerThread.isAlive()) {
            this.start();
        }
        HashedWheelTimeout hashedWheelTimeout = this.createTimeout(timerTask, l + duration.toNanos());
        this.scheduleTimeout(hashedWheelTimeout, duration.toNanos());
        return hashedWheelTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTimeout(HashedWheelTimeout hashedWheelTimeout, long l) {
        long l2 = (l + this.tickDuration - 1L) / this.tickDuration;
        if (l2 < 0L) {
            l2 = l / this.tickDuration;
        }
        if (l2 == 0L) {
            l2 = 1L;
        }
        long l3 = l2 / (long)this.wheel.length;
        this.lock.readLock().lock();
        try {
            int n;
            if (this.shutdown) {
                throw new IllegalStateException("cannot enqueue after shutdown");
            }
            hashedWheelTimeout.stopIndex = n = (int)((long)this.wheelCursor + l2 & (long)this.mask);
            hashedWheelTimeout.remainingRounds = l3;
            this.wheel[n].add(hashedWheelTimeout);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private final class HashedWheelTimeout
    implements Timeout {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private final TimerTask task;
        final long deadline;
        volatile int stopIndex;
        volatile long remainingRounds;
        private final AtomicInteger state = new AtomicInteger(0);

        HashedWheelTimeout(TimerTask timerTask, long l) {
            this.task = timerTask;
            this.deadline = l;
        }

        @Override
        public Timer getTimer() {
            return HashedWheelTimer.this;
        }

        @Override
        public TimerTask getTask() {
            return this.task;
        }

        @Override
        public void cancel() {
            if (!this.state.compareAndSet(0, 1)) {
                return;
            }
            HashedWheelTimer.this.wheel[this.stopIndex].remove(this);
        }

        @Override
        public boolean isCancelled() {
            return this.state.get() == 1;
        }

        @Override
        public boolean isExpired() {
            return this.state.get() != 0;
        }

        public void expire() {
            if (!this.state.compareAndSet(0, 2)) {
                return;
            }
            try {
                this.task.run(this);
            }
            catch (Throwable throwable) {
                HashedWheelTimer.this.logger.warning("An exception was thrown by " + TimerTask.class.getSimpleName() + ".", throwable);
            }
        }

        public String toString() {
            long l = System.nanoTime();
            long l2 = this.deadline - l;
            StringBuilder stringBuilder = new StringBuilder(192);
            stringBuilder.append(this.getClass().getSimpleName());
            stringBuilder.append('(');
            stringBuilder.append("deadline: ");
            if (l2 > 0L) {
                stringBuilder.append(l2);
                stringBuilder.append(" ns later, ");
            } else if (l2 < 0L) {
                stringBuilder.append(-l2);
                stringBuilder.append(" ns ago, ");
            } else {
                stringBuilder.append("now, ");
            }
            if (this.isCancelled()) {
                stringBuilder.append(", cancelled");
            }
            return stringBuilder.append(')').toString();
        }
    }

    private final class Worker
    implements Runnable {
        private long startTime;
        private long tick;

        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shutdown() {
            HashedWheelTimer.this.lock.readLock().lock();
            try {
                boolean bl = HashedWheelTimer.this.shutdown;
                return bl;
            }
            finally {
                HashedWheelTimer.this.lock.readLock().unlock();
            }
        }

        @Override
        public void run() {
            ArrayList<HashedWheelTimeout> arrayList = new ArrayList<HashedWheelTimeout>();
            this.startTime = System.nanoTime();
            this.tick = 1L;
            while (!this.shutdown()) {
                long l = this.waitForNextTick();
                if (l <= Long.MIN_VALUE) continue;
                this.fetchExpiredTimeouts(arrayList, l);
                this.notifyExpiredTimeouts(arrayList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchExpiredTimeouts(List<HashedWheelTimeout> list, long l) {
            HashedWheelTimer.this.lock.writeLock().lock();
            try {
                int n = HashedWheelTimer.this.wheelCursor = HashedWheelTimer.this.wheelCursor + 1 & HashedWheelTimer.this.mask;
                ReusableIterator<HashedWheelTimeout> reusableIterator = HashedWheelTimer.this.iterators[n];
                this.fetchExpiredTimeouts(list, reusableIterator, l);
            }
            finally {
                HashedWheelTimer.this.lock.writeLock().unlock();
            }
        }

        private void fetchExpiredTimeouts(List<HashedWheelTimeout> list, ReusableIterator<HashedWheelTimeout> reusableIterator, long l) {
            ArrayList<Object> arrayList = null;
            reusableIterator.rewind();
            while (reusableIterator.hasNext()) {
                HashedWheelTimeout hashedWheelTimeout = (HashedWheelTimeout)reusableIterator.next();
                if (hashedWheelTimeout.remainingRounds <= 0L) {
                    reusableIterator.remove();
                    if (hashedWheelTimeout.deadline - l <= 0L) {
                        list.add(hashedWheelTimeout);
                        continue;
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(hashedWheelTimeout);
                    continue;
                }
                --hashedWheelTimeout.remainingRounds;
            }
            if (arrayList != null) {
                for (HashedWheelTimeout hashedWheelTimeout : arrayList) {
                    HashedWheelTimer.this.scheduleTimeout(hashedWheelTimeout, hashedWheelTimeout.deadline - l);
                }
            }
        }

        private void notifyExpiredTimeouts(List<HashedWheelTimeout> list) {
            for (int i = list.size() - 1; i >= 0; --i) {
                list.get(i).expire();
            }
            list.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private long waitForNextTick() {
            long l = this.startTime + HashedWheelTimer.this.tickDuration * this.tick;
            while (true) {
                long l2;
                long l3;
                if ((l3 = (l - (l2 = System.nanoTime()) + 999999L) / 1000000L) <= 0L) {
                    ++this.tick;
                    if (l2 != Long.MIN_VALUE) return l2;
                    return -9223372036854775807L;
                }
                if (HashedWheelTimer.this.isWindows) {
                    l3 = l3 / 10L * 10L;
                }
                try {
                    Thread.sleep(l3);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.shutdown()) return Long.MIN_VALUE;
                    continue;
                }
                break;
            }
        }
    }
}

