/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import java.util.HashMap;
import java.util.Map;

final class SubstitutionResolver {
    private final AbstractConfigObject root;
    private final Map<MemoKey, AbstractConfigValue> memos;

    SubstitutionResolver(AbstractConfigObject abstractConfigObject) {
        this.root = abstractConfigObject;
        this.memos = new HashMap<MemoKey, AbstractConfigValue>();
    }

    AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, int n, ConfigResolveOptions configResolveOptions, Path path) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve {
        MemoKey memoKey = new MemoKey(abstractConfigValue, null);
        MemoKey memoKey2 = null;
        AbstractConfigValue abstractConfigValue2 = this.memos.get(memoKey);
        if (abstractConfigValue2 == null && path != null) {
            memoKey2 = new MemoKey(abstractConfigValue, path);
            abstractConfigValue2 = this.memos.get(memoKey2);
        }
        if (abstractConfigValue2 != null) {
            return abstractConfigValue2;
        }
        AbstractConfigValue abstractConfigValue3 = abstractConfigValue.resolveSubstitutions(this, n, configResolveOptions, path);
        if (abstractConfigValue3 == null || abstractConfigValue3.resolveStatus() == ResolveStatus.RESOLVED) {
            this.memos.put(memoKey, abstractConfigValue3);
        } else {
            if (path == null) {
                throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
            }
            if (memoKey2 == null) {
                throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
            }
            this.memos.put(memoKey2, abstractConfigValue3);
        }
        return abstractConfigValue3;
    }

    AbstractConfigObject root() {
        return this.root;
    }

    static AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions, Path path) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve {
        SubstitutionResolver substitutionResolver = new SubstitutionResolver(abstractConfigObject);
        return substitutionResolver.resolve(abstractConfigValue, 0, configResolveOptions, path);
    }

    static AbstractConfigValue resolveWithExternalExceptions(AbstractConfigValue abstractConfigValue, AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions) {
        SubstitutionResolver substitutionResolver = new SubstitutionResolver(abstractConfigObject);
        try {
            return substitutionResolver.resolve(abstractConfigValue, 0, configResolveOptions, null);
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            throw notPossibleToResolve.exportException(abstractConfigValue.origin(), null);
        }
        catch (AbstractConfigValue.NeedsFullResolve needsFullResolve) {
            throw new ConfigException.NotResolved(abstractConfigValue.origin().description() + ": Must resolve() config object before use", needsFullResolve);
        }
    }

    private final class MemoKey {
        private final AbstractConfigValue value;
        private final Path restrictToChildOrNull;

        MemoKey(AbstractConfigValue abstractConfigValue, Path path) {
            this.value = abstractConfigValue;
            this.restrictToChildOrNull = path;
        }

        public final int hashCode() {
            int n = System.identityHashCode(this.value);
            if (this.restrictToChildOrNull != null) {
                return n + 41 * (41 + this.restrictToChildOrNull.hashCode());
            }
            return n;
        }

        public final boolean equals(Object object) {
            if (object instanceof MemoKey) {
                MemoKey memoKey = (MemoKey)object;
                if (memoKey.value != this.value) {
                    return false;
                }
                if (memoKey.restrictToChildOrNull == this.restrictToChildOrNull) {
                    return true;
                }
                if (memoKey.restrictToChildOrNull == null || this.restrictToChildOrNull == null) {
                    return false;
                }
                return memoKey.restrictToChildOrNull.equals(this.restrictToChildOrNull);
            }
            return false;
        }
    }
}

