/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import akka.util.ByteString$;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.Timestamp;
import javax.sql.DataSource;
import net.ripe.rpki.validator.models.StoredRepositoryObject;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011QCU3q_NLGo\u001c:z\u001f\nTWm\u0019;Ti>\u0014XM\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003)!\u0017\r^1t_V\u00148-\u001a\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n1a]9m\u0015\u0005\u0019\u0013!\u00026bm\u0006D\u0018BA\u0013!\u0005)!\u0015\r^1T_V\u00148-\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0001\"B\u000f'\u0001\u0004q\u0002bB\u0017\u0001\u0005\u0004%\tAL\u0001\ti\u0016l\u0007\u000f\\1uKV\tq\u0006\u0005\u00021s5\t\u0011G\u0003\u00023g\u0005!1m\u001c:f\u0015\t!T'\u0001\u0003kI\n\u001c'B\u0001\u001c8\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;c\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"1A\b\u0001Q\u0001\n=\n\u0011\u0002^3na2\fG/\u001a\u0011\t\u000by\u0002A\u0011A \u0002\u0007A,H\u000f\u0006\u0002A\u0007B\u0011q#Q\u0005\u0003\u0005b\u0011A!\u00168ji\")A)\u0010a\u0001\u000b\u0006y!/\u001a;sS\u00164X\rZ(cU\u0016\u001cG\u000f\u0005\u0002G\u00136\tqI\u0003\u0002I\t\u00051Qn\u001c3fYNL!AS$\u0003-M#xN]3e%\u0016\u0004xn]5u_JLxJ\u00196fGRDQA\u0010\u0001\u0005\u00021#\"\u0001Q'\t\u000b9[\u0005\u0019A(\u0002!I,GO]5fm\u0016$wJ\u00196fGR\u001c\bc\u0001)Y\u000b:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)2\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005]C\u0012a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9\u0006\u0004C\u0003]\u0001\u0011\u0005Q,\u0001\u0007qkJ<W-\u0012=qSJ,G\r\u0006\u0002A=\"9ql\u0017I\u0001\u0002\u0004\u0001\u0017\u0001D7bqN#\u0018\r\\3ECf\u001c\bCA\fb\u0013\t\u0011\u0007DA\u0002J]RDQ\u0001\u001a\u0001\u0005\u0002\u0015\fQa\u00197fCJ$\u0012\u0001\u0011\u0005\u0006O\u0002!\t\u0001[\u0001\u000fO\u0016$H*\u0019;fgR\u0014\u00150\u0016:m)\tIG\u000eE\u0002\u0018U\u0016K!a\u001b\r\u0003\r=\u0003H/[8o\u0011\u0015ig\r1\u0001o\u0003\r)(\u000f\u001c\t\u0003_Fl\u0011\u0001\u001d\u0006\u0003\u0017II!A\u001d9\u0003\u0007U\u0013\u0016\nC\u0003u\u0001\u0011\u0005Q/A\u0005hKR\u0014\u0015\u0010S1tQR\u0011\u0011N\u001e\u0005\u0006oN\u0004\r\u0001_\u0001\u0005Q\u0006\u001c\b\u000eE\u0002\u0018snL!A\u001f\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]a\u0018BA?\u0019\u0005\u0011\u0011\u0015\u0010^3\t\r}\u0004A\u0011BA\u0001\u0003E9W\r^(qi&|g.\u00197SKN,H\u000e\u001e\u000b\u0006S\u0006\r\u0011Q\u0003\u0005\b\u0003\u000bq\b\u0019AA\u0004\u00031\u0019X\r\\3diN#(/\u001b8h!\u0011\tI!a\u0004\u000f\u0007]\tY!C\u0002\u0002\u000ea\ta\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u00071!9\u0011q\u0003@A\u0002\u0005e\u0011AC:fY\u0016\u001cG/\u0011:hgB\u0019q#\u001f\b\u0007\r\u0005u\u0001\u0001BA\u0010\u0005I\u0019Fo\u001c:fI>\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0014\r\u0005ma\"!\t\u0017!\u0011\u0001\u00141E#\n\u0007\u0005\u0015\u0012GA\u0005S_^l\u0015\r\u001d9fe\"9q%a\u0007\u0005\u0002\u0005%BCAA\u0016!\u0011\ti#a\u0007\u000e\u0003\u0001A\u0001\"!\r\u0002\u001c\u0011\u0005\u00131G\u0001\u0007[\u0006\u0004(k\\<\u0015\u000b\u0015\u000b)$a\u0011\t\u0011\u0005]\u0012q\u0006a\u0001\u0003s\t!A]:\u0011\t\u0005m\u0012qH\u0007\u0003\u0003{Q!!\t\n\n\t\u0005\u0005\u0013Q\b\u0002\n%\u0016\u001cX\u000f\u001c;TKRDq!!\u0012\u00020\u0001\u0007\u0001-\u0001\u0004s_^tU/\u001c\u0005\n\u0003\u0013\u0002\u0011\u0013!C\u0001\u0003\u0017\na\u0003];sO\u0016,\u0005\u0010]5sK\u0012$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bR3\u0001YA(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class RepositoryObjectStore
implements ScalaObject {
    private final JdbcTemplate template;

    public JdbcTemplate template() {
        return this.template;
    }

    public void put(StoredRepositoryObject retrievedObject) {
        Long updateOrder = Predef$.MODULE$.long2Long(this.template().queryForLong("SELECT NEXTVAL('update_order_seq')"));
        try {
            this.template().update("insert into retrieved_objects (hash, uri, encoded_object, expires, update_order) values (?, ?, ?, ?, ?)", new Object[]{Base64.encodeBase64String((byte[])((byte[])retrievedObject.hash().toArray((ClassManifest)Manifest$.MODULE$.Byte()))), retrievedObject.uri().toString(), Base64.encodeBase64String((byte[])((byte[])retrievedObject.binaryObject().toArray((ClassManifest)Manifest$.MODULE$.Byte()))), new Timestamp(retrievedObject.expires().getMillis()), updateOrder});
        }
        catch (DuplicateKeyException duplicateKeyException) {
            this.template().update("update retrieved_objects set update_order = ? where hash = ?", new Object[]{updateOrder, Base64.encodeBase64String((byte[])((byte[])retrievedObject.hash().toArray((ClassManifest)Manifest$.MODULE$.Byte())))});
        }
    }

    public void put(Seq<StoredRepositoryObject> retrievedObjects) {
        retrievedObjects.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final RepositoryObjectStore $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(StoredRepositoryObject storedRepositoryObject) {
                this.$outer.put(storedRepositoryObject);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void purgeExpired(int maxStaleDays) {
        DateTime mustBeValidAfter = new DateTime().minusDays(maxStaleDays);
        this.template().update("delete from retrieved_objects where expires < ?", new Object[]{new Timestamp(mustBeValidAfter.getMillis())});
    }

    public int purgeExpired$default$1() {
        return 0;
    }

    public void clear() {
        this.template().update("truncate table retrieved_objects");
    }

    public Option<StoredRepositoryObject> getLatestByUrl(URI url) {
        String selectString = "select * from retrieved_objects where uri = ? order by update_order desc limit 1";
        Object[] selectArgs = new Object[]{url.toString()};
        return this.getOptionalResult(selectString, selectArgs);
    }

    public Option<StoredRepositoryObject> getByHash(byte[] hash) {
        String encodedHash = Base64.encodeBase64String((byte[])hash);
        String selectString = "select * from retrieved_objects where hash = ?";
        Object[] selectArgs = new Object[]{encodedHash};
        return this.getOptionalResult(selectString, selectArgs);
    }

    /*
     * WARNING - void declaration
     */
    private Option<StoredRepositoryObject> getOptionalResult(String selectString, Object[] selectArgs) {
        void var3_3;
        None$ exceptionResult1 = null;
        try {
            exceptionResult1 = new Some(this.template().queryForObject(selectString, selectArgs, (RowMapper)new StoredObjectMapper(this)));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var3_3;
    }

    public RepositoryObjectStore(DataSource datasource) {
        this.template = new JdbcTemplate(datasource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StoredObjectMapper
    implements RowMapper<StoredRepositoryObject>,
    ScalaObject {
        public final RepositoryObjectStore $outer;

        public StoredRepositoryObject mapRow(ResultSet rs, int rowNum) {
            return new StoredRepositoryObject(ByteString$.MODULE$.apply(Base64.decodeBase64((String)rs.getString("hash"))), URI.create(rs.getString("uri")), ByteString$.MODULE$.apply(Base64.decodeBase64((String)rs.getString("encoded_object"))), new DateTime((Object)rs.getTimestamp("expires")).withZone(DateTimeZone.UTC));
        }

        public RepositoryObjectStore net$ripe$rpki$validator$store$RepositoryObjectStore$StoredObjectMapper$$$outer() {
            return this.$outer;
        }

        public StoredObjectMapper(RepositoryObjectStore $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

