/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.summary;

import java.math.BigInteger;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaPrefix;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;

public class ValidationSummaryCollector
implements NotifyingCertificateRepositoryObjectFetcher.Listener {
    private static final BigInteger ROA_IPV6_PREFIX_COUNT_UNIT = BigInteger.valueOf(2L).pow(80);
    private static final BigInteger ROA_IPV4_PREFIX_COUNT_UNIT = BigInteger.valueOf(2L).pow(8);
    private int numberOfRoas = 0;
    private int numberOfCertificates = 0;
    private Set<Asn> distinctAsns = new HashSet<Asn>();
    private Set<RoaPrefix> distinctRoaIPv4Prefixes = new HashSet<RoaPrefix>();
    private Set<RoaPrefix> distinctRoaIPv6Prefixes = new HashSet<RoaPrefix>();
    private int numberOfRejectedRoas = 0;
    private int numberOfRejectedCerts = 0;

    @Override
    public void afterPrefetchFailure(URI uri, ValidationResult result) {
    }

    @Override
    public void afterPrefetchSuccess(URI uri, ValidationResult result) {
    }

    @Override
    public void afterFetchFailure(URI uri, ValidationResult result) {
        if (uri.toString().endsWith("cer")) {
            ++this.numberOfRejectedCerts;
        } else if (uri.toString().endsWith("roa")) {
            ++this.numberOfRejectedRoas;
        }
    }

    @Override
    public void afterFetchSuccess(URI uri, CertificateRepositoryObject object, ValidationResult result) {
        if (object instanceof RoaCms) {
            this.processValidRoa((RoaCms)object);
        } else if (object instanceof X509ResourceCertificate) {
            ++this.numberOfCertificates;
        }
    }

    private void processValidRoa(RoaCms roa) {
        ++this.numberOfRoas;
        this.countDistinctRoaPrefixes(roa);
        this.distinctAsns.add(roa.getAsn());
    }

    private void countDistinctRoaPrefixes(RoaCms roa) {
        for (RoaPrefix prefix : roa.getPrefixes()) {
            IpResourceType type = prefix.getPrefix().getType();
            if (type == IpResourceType.IPv4) {
                this.distinctRoaIPv4Prefixes.add(prefix);
                continue;
            }
            this.distinctRoaIPv6Prefixes.add(prefix);
        }
    }

    int getNumberOfRoas() {
        return this.numberOfRoas;
    }

    int getNumberOfCertificates() {
        return this.numberOfCertificates;
    }

    int getNumberOfDistinctRoaIPv4Prefixes() {
        return this.distinctRoaIPv4Prefixes.size();
    }

    int getNumberOfDistinctRoaIPv6Prefixes() {
        return this.distinctRoaIPv6Prefixes.size();
    }

    int getNumberOfDistinctAsns() {
        return this.distinctAsns.size();
    }

    BigInteger getRoaIPv4Coverage() {
        IpResourceSet ipResourceSet = this.convertRoaPrefixSetToResourceSet(this.distinctRoaIPv4Prefixes);
        BigInteger coverage = this.calculateNumberOfAddressesContainedInIpResourceSet(ipResourceSet);
        return coverage.divide(ROA_IPV4_PREFIX_COUNT_UNIT);
    }

    BigInteger getRoaIPv6Coverage() {
        IpResourceSet ipResourceSet = this.convertRoaPrefixSetToResourceSet(this.distinctRoaIPv6Prefixes);
        BigInteger coverage = this.calculateNumberOfAddressesContainedInIpResourceSet(ipResourceSet);
        return coverage.divide(ROA_IPV6_PREFIX_COUNT_UNIT);
    }

    private IpResourceSet convertRoaPrefixSetToResourceSet(Set<RoaPrefix> roaPrefixes) {
        IpResourceSet ipResourceSet = new IpResourceSet();
        for (RoaPrefix roaPrefix : roaPrefixes) {
            ipResourceSet.add((IpResource)roaPrefix.getPrefix());
        }
        return ipResourceSet;
    }

    private BigInteger calculateNumberOfAddressesContainedInIpResourceSet(IpResourceSet ipResourceSet) {
        BigInteger coverage = BigInteger.ZERO;
        for (IpResource ipResource : ipResourceSet) {
            UniqueIpResource start = ipResource.getStart();
            UniqueIpResource end = ipResource.getEnd();
            coverage = coverage.add(end.getValue().subtract(start.getValue())).add(BigInteger.ONE);
        }
        return coverage;
    }

    public int getNumberOfRejectedCerts() {
        return this.numberOfRejectedCerts;
    }

    public int getNumberOfRejectedRoas() {
        return this.numberOfRejectedRoas;
    }
}

