/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.fetchers;

import java.net.URI;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.util.Specifications;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcher;

public class RpkiRepositoryObjectFetcherAdapter
implements CertificateRepositoryObjectFetcher {
    private final RpkiRepositoryObjectFetcher fetcher;

    public RpkiRepositoryObjectFetcherAdapter(RpkiRepositoryObjectFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public void prefetch(URI uri, ValidationResult result) {
        this.fetcher.prefetch(uri, result);
    }

    public X509Crl getCrl(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        CertificateRepositoryObject object = this.getObject(uri, context, (Specification<byte[]>)Specifications.alwaysTrue(), result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        result.rejectIfFalse(object instanceof X509Crl, "validator.fetched.object.is.crl", new String[0]);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return (X509Crl)object;
    }

    @Override
    public ManifestCms getManifest(URI uri, CertificateRepositoryObjectValidationContext context, ValidationResult result) {
        CertificateRepositoryObject object = this.getObject(uri, context, (Specification<byte[]>)Specifications.alwaysTrue(), result);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        result.rejectIfFalse(object instanceof ManifestCms, "validator.fetched.object.is.manifest", new String[0]);
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return (ManifestCms)object;
    }

    @Override
    public CertificateRepositoryObject getObject(URI uri, CertificateRepositoryObjectValidationContext context, Specification<byte[]> fileContentSpecification, ValidationResult result) {
        return this.fetcher.fetch(uri, fileContentSpecification, result);
    }
}

