/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.commands;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcherAdapter;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.output.ObjectFetcherResultLogger;
import net.ripe.rpki.validator.output.ValidatedObjectWriter;
import net.ripe.rpki.validator.output.ValidatedRoaWriter;
import net.ripe.rpki.validator.runtimeproblems.ValidatorIOException;
import net.ripe.rpki.validator.summary.ValidationSummaryCollector;
import net.ripe.rpki.validator.summary.ValidationSummaryPrinter;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class TopDownCertificateRepositoryValidator {
    private static final Logger LOG = Logger.getLogger(TopDownCertificateRepositoryValidator.class);
    static final String BASE_DIRECTORY_NAME = "rta";
    static final String VALIDATED_DIRECTORY_NAME = "validated";
    static final String OLD_VALIDATED_DIRECTORY_NAME = "validated.old";
    static final String UNVALIDATED_DIRECTORY_NAME = "unvalidated";
    private List<CertificateRepositoryObjectValidationContext> trustAnchors;
    private List<URI> prefetchUris = new ArrayList<URI>();
    private File outputDirectory;
    private TopDownWalker topDownWalker;
    private boolean roaExportEnabled;
    private File roaExportFile;
    private ValidatedRoaWriter roaExporterCallBack;
    private CertificateRepositoryObjectFetcher fetcher;
    private ValidationSummaryCollector validationSummaryCollector;

    public TopDownCertificateRepositoryValidator(List<CertificateRepositoryObjectValidationContext> trustAnchors, File outputDirectory) {
        Validate.notNull(trustAnchors);
        Validate.notNull((Object)outputDirectory);
        this.init(trustAnchors, outputDirectory, false, null);
    }

    public TopDownCertificateRepositoryValidator(List<CertificateRepositoryObjectValidationContext> trustAnchors, File outputDirectory, File roaExportFile) {
        Validate.notNull(trustAnchors);
        Validate.notNull((Object)outputDirectory);
        Validate.notNull((Object)roaExportFile);
        this.init(trustAnchors, outputDirectory, true, roaExportFile);
    }

    private void init(List<CertificateRepositoryObjectValidationContext> trustAnchors, File outputDirectory, boolean roaExportEnabled, File roaExportFile) {
        this.trustAnchors = trustAnchors;
        this.outputDirectory = outputDirectory;
        this.roaExportFile = roaExportFile;
        this.roaExportEnabled = roaExportEnabled;
        if (roaExportEnabled) {
            this.roaExporterCallBack = new ValidatedRoaWriter();
        }
        this.fetcher = this.createCertificateRepositoryObjectFetcher();
        this.topDownWalker = new TopDownWalker(this.fetcher);
    }

    private CachingCertificateRepositoryObjectFetcher createCertificateRepositoryObjectFetcher() {
        RpkiRepositoryObjectFetcherAdapter rsyncFetcher = new RpkiRepositoryObjectFetcherAdapter(new RsyncRpkiRepositoryObjectFetcher(new Rsync(), new UriToFileMapper(this.getUnvalidatedOutputDirectory())));
        ValidatingCertificateRepositoryObjectFetcher validatingFetcher = new ValidatingCertificateRepositoryObjectFetcher(rsyncFetcher);
        NotifyingCertificateRepositoryObjectFetcher notifyingFetcher = new NotifyingCertificateRepositoryObjectFetcher(validatingFetcher);
        notifyingFetcher.addCallback(new ObjectFetcherResultLogger());
        notifyingFetcher.addCallback(new ValidatedObjectWriter(new UriToFileMapper(this.getValidatedOutputDirectory())));
        this.validationSummaryCollector = new ValidationSummaryCollector();
        notifyingFetcher.addCallback(this.validationSummaryCollector);
        if (this.roaExportEnabled) {
            notifyingFetcher.addCallback(this.roaExporterCallBack);
        }
        CachingCertificateRepositoryObjectFetcher cachingFetcher = new CachingCertificateRepositoryObjectFetcher(notifyingFetcher);
        validatingFetcher.setOuterMostDecorator(cachingFetcher);
        return cachingFetcher;
    }

    public void setPrefetchUris(List<URI> prefetchUris) {
        Validate.notNull(prefetchUris, (String)"prefetch URIs is null");
        this.prefetchUris = prefetchUris;
    }

    public void prepare() {
        File oldValidatedDirectory = new File(new File(this.outputDirectory, BASE_DIRECTORY_NAME), OLD_VALIDATED_DIRECTORY_NAME);
        try {
            if (oldValidatedDirectory.exists()) {
                FileUtils.deleteDirectory((File)oldValidatedDirectory);
            }
        }
        catch (IOException e) {
            throw new ValidatorIOException("Could not delete existing output directory (" + oldValidatedDirectory.getAbsolutePath() + ")", e);
        }
        File validatedDirectory = this.getValidatedOutputDirectory();
        if (validatedDirectory.exists()) {
            validatedDirectory.renameTo(oldValidatedDirectory);
        }
        validatedDirectory.mkdirs();
        File unvalidatedDirectory = this.getUnvalidatedOutputDirectory();
        unvalidatedDirectory.mkdirs();
        if (!unvalidatedDirectory.isDirectory()) {
            throw new ValidatorIOException("directory " + unvalidatedDirectory + " could not be created. Is there a file in the way?");
        }
    }

    public void validate() {
        this.doPrefetching();
        this.processTrustAnchors();
        if (this.roaExportEnabled) {
            this.roaExporterCallBack.writeCsvFile(this.roaExportFile);
        }
        this.printSummary();
    }

    private void doPrefetching() {
        for (URI prefetchUri : this.prefetchUris) {
            LOG.info((Object)("prefetching " + prefetchUri));
            this.fetcher.prefetch(prefetchUri, ValidationResult.withLocation((URI)prefetchUri));
        }
    }

    private void processTrustAnchors() {
        for (CertificateRepositoryObjectValidationContext trustAnchor : this.trustAnchors) {
            this.topDownWalker.addTrustAnchor(trustAnchor);
            this.topDownWalker.execute();
        }
    }

    private void printSummary() {
        System.out.print(ValidationSummaryPrinter.getMessage(this.validationSummaryCollector));
    }

    private File getUnvalidatedOutputDirectory() {
        return new File(new File(this.outputDirectory, BASE_DIRECTORY_NAME), UNVALIDATED_DIRECTORY_NAME);
    }

    private File getValidatedOutputDirectory() {
        return new File(new File(this.outputDirectory, BASE_DIRECTORY_NAME), VALIDATED_DIRECTORY_NAME);
    }

    void setFetcher(CertificateRepositoryObjectFetcher fetcher) {
        this.fetcher = fetcher;
    }

    CertificateRepositoryObjectFetcher getFetcher() {
        return this.fetcher;
    }

    void setTopDownWalker(TopDownWalker topDownWalker) {
        this.topDownWalker = topDownWalker;
    }
}

