/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.cli;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class CommandLineOptions {
    private static final Logger LOG = Logger.getLogger(CommandLineOptions.class);
    private static final String HELP = "help";
    private static final String VERSION = "version";
    private static final String PRINT = "print";
    private static final String TAL = "tal";
    private static final String OUTPUT_DIR = "output-dir";
    private static final String FILE = "file";
    private static final String ROA_EXPORT = "roa-export";
    private static final String PREFETCH = "prefetch";
    private static final String VERBOSE = "verbose";
    private Options options = new Options();
    private File inputFile;
    private File outputDir;
    private List<TrustAnchorLocator> trustAnchorLocators = new ArrayList<TrustAnchorLocator>();
    private List<URI> prefetchUris = new ArrayList<URI>();
    private File roaExportFile;
    private boolean printHelpMode;
    private boolean printVersionMode;
    private boolean printObjectMode;
    private boolean validationMode;
    private boolean roaExportEnabled;
    private boolean verboseEnabled;
    private boolean topDownValidationEnabled;

    public CommandLineOptions() {
        this.addCommandGroup();
        this.addOptions();
    }

    private void addCommandGroup() {
        OptionGroup group = new OptionGroup();
        Option helpOption = new Option("h", HELP, false, "Show usage information");
        group.addOption(helpOption);
        Option versionOption = new Option(null, VERSION, false, "Show version information");
        group.addOption(versionOption);
        Option printOption = new Option("p", PRINT, false, "Show the certificate repository object in a readable format");
        group.addOption(printOption);
        Option talOption = new Option("t", TAL, true, "Trust Anchor Locator (TAL). Can be specified more than once.");
        talOption.setArgs(-2);
        group.addOption(talOption);
        group.setRequired(true);
        this.options.addOptionGroup(group);
    }

    private void addOptions() {
        this.options.addOption("f", FILE, true, "Certificate repository object file");
        this.options.addOption(null, PREFETCH, true, "Prefetch specified rsync URI before top-down validation. Can be specified more than once.");
        this.options.getOption(PREFETCH).setArgs(-2);
        this.options.addOption("o", OUTPUT_DIR, true, "Output directory for the results of top-down validation and the trust anchor file");
        this.options.addOption("r", ROA_EXPORT, true, "Export routing authorisation found in validated ROAs");
        this.options.addOption("v", VERBOSE, false, "Show all validation steps");
    }

    public void parse(String ... args) throws ParseException {
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(this.options, args);
        if (commandLine.hasOption(HELP) || commandLine.getOptions().length == 0) {
            this.printHelpMode = true;
        } else if (commandLine.hasOption(VERSION)) {
            this.printVersionMode = true;
        } else if (commandLine.hasOption(PRINT)) {
            this.printObjectMode = true;
            this.requireInputFileOption(commandLine);
            this.parseInputFile(commandLine);
        } else if (commandLine.hasOption(TAL)) {
            this.validationMode = true;
            this.parseTrustAnchorFile(commandLine);
            this.requireOutputDir(commandLine);
            this.parseOutputDir(commandLine);
            if (commandLine.hasOption(FILE)) {
                this.topDownValidationEnabled = false;
                this.parseInputFile(commandLine);
            } else {
                this.topDownValidationEnabled = true;
                this.parseRoaExportFile(commandLine);
                this.parsePrefetchURIs(commandLine);
            }
            if (commandLine.hasOption(VERBOSE)) {
                this.verboseEnabled = true;
            }
        }
    }

    private void requireInputFileOption(CommandLine commandLine) throws ParseException {
        if (!commandLine.hasOption(FILE)) {
            throw new ParseException("Required option 'file' missing");
        }
    }

    private void parseInputFile(CommandLine commandLine) {
        this.inputFile = new File(commandLine.getOptionValue(FILE));
    }

    private void requireOutputDir(CommandLine commandLine) throws ParseException {
        if (!commandLine.hasOption(OUTPUT_DIR)) {
            throw new ParseException("Required option 'output-dir' missing");
        }
    }

    private void parseOutputDir(CommandLine commandLine) {
        this.outputDir = new File(commandLine.getOptionValue(OUTPUT_DIR));
    }

    private void parseTrustAnchorFile(CommandLine commandLine) {
        this.trustAnchorLocators = new ArrayList<TrustAnchorLocator>();
        for (String optionValue : commandLine.getOptionValues(TAL)) {
            TrustAnchorLocator tal = TrustAnchorLocator.fromFile(new File(optionValue));
            this.trustAnchorLocators.add(tal);
            this.prefetchUris.addAll(tal.getPrefetchUris());
        }
    }

    private void parseRoaExportFile(CommandLine commandLine) {
        if (commandLine.hasOption(ROA_EXPORT)) {
            this.roaExportEnabled = true;
            this.roaExportFile = new File(commandLine.getOptionValue(ROA_EXPORT));
        }
    }

    private void parsePrefetchURIs(CommandLine commandLine) {
        if (commandLine.hasOption(PREFETCH)) {
            for (String prefetchUri : commandLine.getOptionValues(PREFETCH)) {
                try {
                    if (!prefetchUri.endsWith("/")) {
                        prefetchUri = prefetchUri + "/";
                    }
                    URI uri = new URI(prefetchUri);
                    this.prefetchUris.add(uri);
                }
                catch (URISyntaxException e) {
                    LOG.warn((Object)("unrecognized prefetch URI '" + prefetchUri + "' ignored"));
                }
            }
        }
    }

    public boolean isPrintHelpMode() {
        return this.printHelpMode;
    }

    public boolean isPrintVersionMode() {
        return this.printVersionMode;
    }

    public boolean isPrintObjectMode() {
        return this.printObjectMode;
    }

    public boolean isValidationMode() {
        return this.validationMode;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public List<TrustAnchorLocator> getTrustAnchorFiles() {
        return this.trustAnchorLocators;
    }

    public boolean isVerboseEnabled() {
        return this.verboseEnabled;
    }

    public boolean isTopDownValidationEnabled() {
        return this.topDownValidationEnabled;
    }

    public List<URI> getPrefetchUris() {
        return this.prefetchUris;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean isRoaExportEnabled() {
        return this.roaExportEnabled;
    }

    public File getRoaExportFile() {
        return this.roaExportFile;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("For detailed usage scenarios see README file. Options:", this.options);
    }
}

