/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models;

import grizzled.slf4j.Logger;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.util.Specification;
import net.ripe.rpki.commons.util.Specifications;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.commands.TopDownWalker;
import net.ripe.rpki.validator.fetchers.CachingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.CertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ConsistentObjectFetcher;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RemoteObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.RpkiRepositoryObjectFetcherAdapter;
import net.ripe.rpki.validator.fetchers.RsyncRpkiRepositoryObjectFetcher;
import net.ripe.rpki.validator.fetchers.ValidatingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidationProcess;
import net.ripe.rpki.validator.models.ValidationProcess$class;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.store.RepositoryObjectStore;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import net.ripe.rpki.validator.util.UriToFileMapper;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scalaz.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u00015\u0011A\u0004\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\n\u0005\u000191\"\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\tWC2LG-\u0019;j_:\u0004&o\\2fgN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u00111bU2bY\u0006|%M[3di\"A\u0011\u0005\u0001BC\u0002\u0013\u0005#%\u0001\nueV\u001cH/\u00118dQ>\u0014Hj\\2bi>\u0014X#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011\u0001B;uS2L!\u0001K\u0013\u0003%Q\u0013Xo\u001d;B]\u000eDwN\u001d'pG\u0006$xN\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005G\u0005\u0019BO];ti\u0006s7\r[8s\u0019>\u001c\u0017\r^8sA!AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0007nCb\u001cF/\u00197f\t\u0006L8\u000f\u0005\u0002\u001c]%\u0011q\u0006\b\u0002\u0004\u0013:$\b\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00024iU\u0002\"a\u0006\u0001\t\u000b\u0005\u0002\u0004\u0019A\u0012\t\u000b1\u0002\u0004\u0019A\u0017\t\u000f]\u0002!\u0019!C\u0005q\u00059q\u000e\u001d;j_:\u001cX#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014A\u0003<bY&$\u0017\r^5p]*\u0011aHB\u0001\bG>lWn\u001c8t\u0013\t\u00015HA\tWC2LG-\u0019;j_:|\u0005\u000f^5p]NDaA\u0011\u0001!\u0002\u0013I\u0014\u0001C8qi&|gn\u001d\u0011\t\u000f\u0011\u0003!\u0019!C\u0005\u000b\u00061\"k]=oG\u0012K7o[\"bG\",')Y:f!\u0006$\b.F\u0001G!\tyq)\u0003\u0002I!\t11\u000b\u001e:j]\u001eDaA\u0013\u0001!\u0002\u00131\u0015a\u0006*ts:\u001cG)[:l\u0007\u0006\u001c\u0007.\u001a\"bg\u0016\u0004\u0016\r\u001e5!\u0011\u0015a\u0005\u0001\"\u0011N\u0003e)\u0007\u0010\u001e:bGR$&/^:u\u0003:\u001c\u0007n\u001c:M_\u000e\fGo\u001c:\u0015\u00039\u0003\"aF(\n\u0005A\u0013!a\u0004,bY&$\u0017\r^3e\u001f\nTWm\u0019;\t\u000bI\u0003A\u0011I*\u0002\u001fY\fG.\u001b3bi\u0016|%M[3diN$\"\u0001V1\u0011\tUSFLT\u0007\u0002-*\u0011q\u000bW\u0001\nS6lW\u000f^1cY\u0016T!!\u0017\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\-\n\u0019Q*\u00199\u0011\u0005u{V\"\u00010\u000b\u0005-\u0011\u0012B\u00011_\u0005\r)&+\u0013\u0005\u0006EF\u0003\raY\u0001\fG\u0016\u0014H/\u001b4jG\u0006$X\r\u0005\u0002eO6\tQM\u0003\u0002gw\u0005\u0001rN\u00196fGR4\u0018\r\\5eCR|'o]\u0005\u0003Q\u0016\u0014AfQ3si&4\u0017nY1uKJ+\u0007o\\:ji>\u0014\u0018p\u00142kK\u000e$h+\u00197jI\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\u000b)\u0004A\u0011A6\u0002%]L\u0007/\u001a*ts:\u001cG)[:l\u0007\u0006\u001c\u0007.\u001a\u000b\u0002YB\u00111$\\\u0005\u0003]r\u0011A!\u00168ji\")\u0001\u000f\u0001C\u0005c\u0006i1M]3bi\u00164U\r^2iKJ$\"A\u001d=\u0011\u0005M4X\"\u0001;\u000b\u0005U$\u0011\u0001\u00034fi\u000eDWM]:\n\u0005]$(AI\"feRLg-[2bi\u0016\u0014V\r]8tSR|'/_(cU\u0016\u001cGOR3uG\",'\u000fC\u0003z_\u0002\u0007!0A\u0005mSN$XM\\3sgB\u00191d_?\n\u0005qd\"A\u0003\u001fsKB,\u0017\r^3e}A\u0019a0a\u0001\u000f\u0005M|\u0018bAA\u0001i\u0006Ycj\u001c;jMfLgnZ\"feRLg-[2bi\u0016\u0014V\r]8tSR|'/_(cU\u0016\u001cGOR3uG\",'/\u0003\u0003\u0002\u0006\u0005\u001d!\u0001\u0003'jgR,g.\u001a:\u000b\u0007\u0005\u0005A\u000f\u0003\u0006\u0002\f\u0001A)\u0019)C\u0005\u0003\u001b\tqcY8og&\u001cH/\u001a8u\u001f\nTWm\u0019;GKR\u001c\u0007.\u001a:\u0016\u0005\u0005=\u0001cA:\u0002\u0012%\u0019\u00111\u0003;\u0003/\r{gn]5ti\u0016tGo\u00142kK\u000e$h)\u001a;dQ\u0016\u0014\bBCA\f\u0001!\u0005\t\u0011)\u0003\u0002\u0010\u0005A2m\u001c8tSN$XM\u001c;PE*,7\r\u001e$fi\u000eDWM\u001d\u0011\u0007\r\u0005m\u0001\u0001BA\u000f\u00051\u0011v.Y\"pY2,7\r^8s'\u0015\tI\"a\b\u001b!\rq\u0018\u0011E\u0005\u0005\u0003G\t9AA\bMSN$XM\\3s\u0003\u0012\f\u0007\u000f^3s\u0011)\t9#!\u0007\u0003\u0002\u0003\u0006IaI\u0001\fiJ,8\u000f^!oG\"|'\u000fC\u0006\u0002,\u0005e!\u0011!Q\u0001\n\u00055\u0012aB8cU\u0016\u001cGo\u001d\u0019\u0005\u0003_\t)\u0005\u0005\u0005\u00022\u0005]\u00121HA!\u001b\t\t\u0019DC\u0002\u00026a\u000bq!\\;uC\ndW-\u0003\u0003\u0002:\u0005M\"a\u0002\"vS2$WM\u001d\t\u00067\u0005uBLT\u0005\u0004\u0003\u007fa\"A\u0002+va2,'\u0007\u0005\u0003\u0002D\u0005\u0015C\u0002\u0001\u0003\f\u0003\u000f\u0002\u0011\u0011!A\u0001\u0006\u0003\tIEA\u0002`IE\nB!a\u0013\u0002RA\u00191$!\u0014\n\u0007\u0005=CDA\u0004O_RD\u0017N\\4\u0011\u0007m\t\u0019&C\u0002\u0002Vq\u00111!\u00118z\u0011\u001d\t\u0014\u0011\u0004C\u0001\u00033\"b!a\u0017\u0002`\u0005\u0005\u0004\u0003BA/\u00033i\u0011\u0001\u0001\u0005\b\u0003O\t9\u00061\u0001$\u0011!\tY#a\u0016A\u0002\u0005\r\u0004\u0007BA3\u0003S\u0002\u0002\"!\r\u00028\u0005m\u0012q\r\t\u0005\u0003\u0007\nI\u0007\u0002\u0007\u0002H\u0005]\u0013\u0011!A\u0001\u0006\u0003\tI\u0005\u0003\u0005\u0002n\u0005eA\u0011IA8\u0003E\tg\r^3s\r\u0016$8\r\u001b$bS2,(/\u001a\u000b\u0006Y\u0006E\u0014Q\u000f\u0005\b\u0003g\nY\u00071\u0001]\u0003\r)(/\u001b\u0005\t\u0003o\nY\u00071\u0001\u0002z\u00051!/Z:vYR\u00042AOA>\u0013\r\tih\u000f\u0002\u0011-\u0006d\u0017\u000eZ1uS>t'+Z:vYRD\u0001\"!!\u0002\u001a\u0011\u0005\u00131Q\u0001\u0012C\u001a$XM\u001d$fi\u000eD7+^2dKN\u001cHc\u00027\u0002\u0006\u0006\u001d\u0015q\u0013\u0005\b\u0003g\ny\b1\u0001]\u0011!\tI)a A\u0002\u0005-\u0015aA8cUB!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012v\naa\u0019:zaR|\u0017\u0002BAK\u0003\u001f\u00131dQ3si&4\u0017nY1uKJ+\u0007o\\:ji>\u0014\u0018p\u00142kK\u000e$\b\u0002CA<\u0003\u007f\u0002\r!!\u001f")
public class TrustAnchorValidationProcess
implements ValidationProcess {
    private final TrustAnchorLocator trustAnchorLocator;
    private final int maxStaleDays;
    private final ValidationOptions options;
    private final String RsyncDiskCacheBasePath;
    private ConsistentObjectFetcher consistentObjectFetcher;
    private final Logger logger;
    private volatile int bitmap$priv$0;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void net$ripe$rpki$validator$models$ValidationProcess$_setter_$logger_$eq(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Validation<String, Map<URI, ValidatedObject>> runProcess() {
        return ValidationProcess$class.runProcess(this);
    }

    @Override
    public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
        return ValidationProcess$class.exceptionHandler(this);
    }

    @Override
    public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
        return ValidationProcess$class.objectFetcherListeners(this);
    }

    @Override
    public void finishProcessing() {
        ValidationProcess$class.finishProcessing(this);
    }

    @Override
    public void shutdown() {
        ValidationProcess$class.shutdown(this);
    }

    @Override
    public TrustAnchorLocator trustAnchorLocator() {
        return this.trustAnchorLocator;
    }

    private ValidationOptions options() {
        return this.options;
    }

    private String RsyncDiskCacheBasePath() {
        return this.RsyncDiskCacheBasePath;
    }

    @Override
    public ValidatedObject extractTrustAnchorLocator() {
        Product product;
        URI uri = this.trustAnchorLocator().getCertificateLocation();
        ValidationResult validationResult = ValidationResult.withLocation((URI)uri);
        CertificateRepositoryObject cro = this.consistentObjectFetcher().fetch(uri, (Specification<byte[]>)Specifications.alwaysTrue(), validationResult);
        CertificateRepositoryObject certificateRepositoryObject = cro;
        if (certificateRepositoryObject instanceof X509ResourceCertificate) {
            X509ResourceCertificate x509ResourceCertificate;
            X509ResourceCertificate certificate = x509ResourceCertificate = (X509ResourceCertificate)certificateRepositoryObject;
            String string = this.trustAnchorLocator().getPublicKeyInfo();
            String string2 = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
            validationResult.rejectIfFalse(!(string != null ? !string.equals(string2) : string2 != null), "trust.anchor.public.key.match", new String[0]);
            product = validationResult.hasFailureForCurrentLocation() ? new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet()) : new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), (CertificateRepositoryObject)certificate);
        } else {
            product = new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(validationResult.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet());
        }
        return product;
    }

    @Override
    public Map<URI, ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate) {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        RoaCollector roaCollector = new RoaCollector(this, this.trustAnchorLocator(), builder);
        CertificateRepositoryObjectFetcher fetcher$1 = this.createFetcher((Seq<NotifyingCertificateRepositoryObjectFetcher.Listener>)((Seq)this.objectFetcherListeners().$plus$colon((Object)roaCollector, Seq$.MODULE$.canBuildFrom())));
        RepositoryObjectStore cache = new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource());
        cache.purgeExpired(this.maxStaleDays);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.trustAnchorLocator().getPrefetchUris()).asScala()).foreach((Function1)new Serializable(this, fetcher$1){
            public static final long serialVersionUID;
            private final TrustAnchorValidationProcess $outer;
            private final CertificateRepositoryObjectFetcher fetcher$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(URI prefetchUri$1) {
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri$1){
                    public static final long serialVersionUID;
                    private final URI prefetchUri$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Prefetching '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = uRI;
                    }
                });
                ValidationResult validationResult = ValidationResult.withLocation((URI)prefetchUri$1);
                this.fetcher$1.prefetch(prefetchUri$1, validationResult);
                this.$outer.logger().info((Function0)new Serializable(this, prefetchUri$1){
                    public static final long serialVersionUID;
                    private final URI prefetchUri$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Done prefetching for '").append((Object)this.prefetchUri$1).append((Object)"'").toString();
                    }
                    {
                        this.prefetchUri$1 = uRI;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetcher$1 = certificateRepositoryObjectFetcher;
            }
        });
        TopDownWalker walker = new TopDownWalker(fetcher$1);
        walker.addTrustAnchor(certificate);
        walker.execute();
        return (Map)builder.result();
    }

    public void wipeRsyncDiskCache() {
        File diskCache = new File(this.RsyncDiskCacheBasePath());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    private CertificateRepositoryObjectFetcher createFetcher(Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> listeners) {
        ValidatingCertificateRepositoryObjectFetcher validatingFetcher = new ValidatingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)new RpkiRepositoryObjectFetcherAdapter((RpkiRepositoryObjectFetcher)this.consistentObjectFetcher()), this.options());
        NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1 = new NotifyingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)validatingFetcher);
        CachingCertificateRepositoryObjectFetcher cachingFetcher = new CachingCertificateRepositoryObjectFetcher((CertificateRepositoryObjectFetcher)notifyingFetcher$1);
        validatingFetcher.setOuterMostDecorator((CertificateRepositoryObjectFetcher)cachingFetcher);
        listeners.foreach((Function1)new Serializable(this, notifyingFetcher$1){
            public static final long serialVersionUID;
            private final NotifyingCertificateRepositoryObjectFetcher notifyingFetcher$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(NotifyingCertificateRepositoryObjectFetcher.Listener listener) {
                this.notifyingFetcher$1.addCallback(listener);
            }
            {
                this.notifyingFetcher$1 = notifyingCertificateRepositoryObjectFetcher;
            }
        });
        return cachingFetcher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConsistentObjectFetcher consistentObjectFetcher() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.consistentObjectFetcher;
        TrustAnchorValidationProcess trustAnchorValidationProcess = this;
        synchronized (trustAnchorValidationProcess) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                Rsync rsync = new Rsync();
                rsync.setTimeoutInSeconds(300);
                RsyncRpkiRepositoryObjectFetcher rsyncFetcher = new RsyncRpkiRepositoryObjectFetcher(rsync, new UriToFileMapper(new File(new StringBuilder().append((Object)this.RsyncDiskCacheBasePath()).append((Object)this.trustAnchorLocator().getFile().getName()).toString())));
                RemoteObjectFetcher remoteFetcher = new RemoteObjectFetcher(rsyncFetcher);
                this.consistentObjectFetcher = new ConsistentObjectFetcher(remoteFetcher, new RepositoryObjectStore((DataSource)DataSources$.MODULE$.DurableDataSource()));
                this.bitmap$priv$0 |= 1;
            }
            return this.consistentObjectFetcher;
        }
    }

    public TrustAnchorValidationProcess(TrustAnchorLocator trustAnchorLocator, int maxStaleDays) {
        this.trustAnchorLocator = trustAnchorLocator;
        this.maxStaleDays = maxStaleDays;
        ValidationProcess$class.$init$(this);
        this.options = new ValidationOptions();
        this.RsyncDiskCacheBasePath = "tmp/cache/";
        this.options().setMaxStaleDays(maxStaleDays);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RoaCollector
    extends NotifyingCertificateRepositoryObjectFetcher.ListenerAdapter
    implements ScalaObject {
        private final Builder<Tuple2<URI, ValidatedObject>, ?> objects;
        public final TrustAnchorValidationProcess $outer;

        public void afterFetchFailure(URI uri, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)new InvalidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet())));
        }

        public void afterFetchSuccess(URI uri, CertificateRepositoryObject obj, ValidationResult result) {
            this.objects.$plus$eq((Object)Predef$.MODULE$.any2ArrowAssoc((Object)uri).$minus$greater((Object)new ValidObject(uri, (Set<ValidationCheck>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAllValidationChecksForLocation(new ValidationLocation(uri))).asScala()).toSet(), obj)));
        }

        public TrustAnchorValidationProcess net$ripe$rpki$validator$models$TrustAnchorValidationProcess$RoaCollector$$$outer() {
            return this.$outer;
        }

        public RoaCollector(TrustAnchorValidationProcess $outer, TrustAnchorLocator trustAnchor, Builder<Tuple2<URI, ValidatedObject>, ?> objects) {
            this.objects = objects;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

