/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import java.net.InetSocketAddress;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.rtr.BadData;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import scala.Array$;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Right;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u0011\u0011C\u0015;s'\u0016\u001c8/[8o\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002siJT!!\u0002\u0004\u0002\u0013Y\fG.\u001b3bi>\u0014(BA\u0004\t\u0003\u0011\u0011\bo[5\u000b\u0005%Q\u0011\u0001\u0002:ja\u0016T\u0011aC\u0001\u0004]\u0016$8\u0001A\u000b\u0003\u001d\u0005\u001a2\u0001A\b\u0018!\t\u0001R#D\u0001\u0012\u0015\t\u00112#\u0001\u0003mC:<'\"\u0001\u000b\u0002\t)\fg/Y\u0005\u0003-E\u0011aa\u00142kK\u000e$\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"aC*dC2\fwJ\u00196fGRD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0011\u0005\u0001\nC\u0002\u0001\u0003\u0006E\u0001\u0011\ra\t\u0002\u0002)F\u0011Ae\n\t\u00031\u0015J!AJ\r\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0004K\u0005\u0003Se\u00111!\u00118z\u0011!Y\u0003A!A!\u0002\u0013a\u0013!F4fi\u000e+(O]3oi\u000e\u000b7\r[3TKJL\u0017\r\u001c\t\u000415z\u0013B\u0001\u0018\u001a\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002\u0019a%\u0011\u0011'\u0007\u0002\u0004\u0013:$\b\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002+\u001d,GoQ;se\u0016tGO\u0015;s!J,g-\u001b=fgB\u0019\u0001$L\u001b\u0011\u0007YJDH\u0004\u0002\u0019o%\u0011\u0001(G\u0001\u0007!J,G-\u001a4\n\u0005iZ$aA*fi*\u0011\u0001(\u0007\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\ta!\\8eK2\u001c\u0018BA!?\u0005%\u0011FO\u001d)sK\u001aL\u0007\u0010\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0003=9W\r^\"veJ,g\u000e\u001e(p]\u000e,\u0007c\u0001\r.\u000bB\u0011aI\u0013\b\u0003\u000f\"k\u0011AA\u0005\u0003\u0013\n\t1\u0001\u00153v\u0013\tYEJA\u0003O_:\u001cWM\u0003\u0002J\u0005!)a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"R\u0001U)S'R\u00032a\u0012\u0001 \u0011\u0015qR\n1\u0001 \u0011\u0015YS\n1\u0001-\u0011\u0015\u0019T\n1\u00015\u0011\u0015\u0019U\n1\u0001E\u0011\u001d1\u0006A1A\u0005\u0002]\u000b1b]3tg&|g\u000eR1uCV\t\u0001\f\u0005\u0002H3&\u0011!L\u0001\u0002\u000f%R\u00148+Z:tS>tG)\u0019;b\u0011\u0019a\u0006\u0001)A\u00051\u0006a1/Z:tS>tG)\u0019;bA!)a\f\u0001C\u0001?\u000691m\u001c8oK\u000e$H#\u00011\u0011\u0005a\t\u0017B\u00012\u001a\u0005\u0011)f.\u001b;\t\u000b\u0011\u0004A\u0011A0\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000fC\u0003g\u0001\u0011\u0005q-\u0001\u0007tKJL\u0017\r\u001c(pi&4\u0017\u0010\u0006\u0002aQ\")\u0011.\u001aa\u0001U\u0006\u0019\u0001\u000fZ;\u0011\u0005\u001d[\u0017B\u00017\u0003\u0005\r\u0001F-\u001e\u0005\u0006]\u0002!\ta\\\u0001\u000faJ|7-Z:t%\u0016\fX/Z:u)\t\u0001H\u0010E\u0002rs*t!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005Ud\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tA\u0018$A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(aA*fc*\u0011\u00010\u0007\u0005\u0006{6\u0004\rA`\u0001\be\u0016\fX/Z:u!\u0015Ar0a\u0001k\u0013\r\t\t!\u0007\u0002\u0007\u000b&$\b.\u001a:\u0011\u0007\u001d\u000b)!C\u0002\u0002\b\t\u0011qAQ1e\t\u0006$\u0018\rC\u0004\u0002\f\u0001!\t!!\u0004\u0002#\u0011,G/\u001a:nS:,WI\u001d:peB#W\u000f\u0006\u0003\u0002\u0010\u0005U\u0001cA$\u0002\u0012%\u0019\u00111\u0003\u0002\u0003\u0011\u0015\u0013(o\u001c:QIVD\u0001\"a\u0006\u0002\n\u0001\u0007\u0011\u0011D\u0001\u0006G\u0006,8/\u001a\t\u0004c\u0006m\u0011bAA\u000fw\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0003C\u0001A\u0011BA\u0012\u00035A\u0017M\u001c3mK\n\u000bG\rR1uCR1\u0011QEA\u0016\u0003_\u0001B!]A\u0014U&\u0019\u0011\u0011F>\u0003\t1K7\u000f\u001e\u0005\b\u0003[\ty\u00021\u00010\u0003%)'O]8s\u0007>$W\r\u0003\u0005\u00022\u0005}\u0001\u0019AA\u001a\u0003\u001d\u0019wN\u001c;f]R\u0004R\u0001GA\u001b\u0003sI1!a\u000e\u001a\u0005\u0015\t%O]1z!\rA\u00121H\u0005\u0004\u0003{I\"\u0001\u0002\"zi\u0016Dq!!\u0011\u0001\t\u0013\t\u0019%A\tqe>\u001cWm]:SKF,Xm\u001d;QIV$2\u0001]A#\u0011\u0019I\u0017q\ba\u0001U\"9\u0011\u0011\n\u0001\u0005\n\u0005-\u0013!\u00059s_\u000e,7o\u001d*fg\u0016$\u0018+^3ssV\t\u0001\u000fC\u0004\u0002P\u0001!I!!\u0015\u0002%A\u0014xnY3tgN+'/[1m#V,'/\u001f\u000b\u0007\u0003'\n\u0019(! \u0011\r\u0005U\u0013qLA1\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C5n[V$\u0018M\u00197f\u0015\r\ti&G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0015\u0003/\u0012r!a\u0019\u0002h\u00055$N\u0002\u0004\u0002f\u0001\u0001\u0011\u0011\r\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u00041\u0005%\u0014bAA63\t9\u0001K]8ek\u000e$\bc\u0001\r\u0002p%\u0019\u0011\u0011O\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005U\u0014Q\na\u0001\u0003o\nQA\\8oG\u0016\u00042\u0001GA=\u0013\r\tY(\u0007\u0002\u0006'\"|'\u000f\u001e\u0005\t\u0003\u007f\ni\u00051\u0001\u0002\u0002\u000611/\u001a:jC2\u00042\u0001GAB\u0013\r\t))\u0007\u0002\u0005\u0019>tw\r")
public class RtrSessionHandler<T>
implements ScalaObject {
    private final Function0<Object> getCurrentCacheSerial;
    private final Function0<Set<RtrPrefix>> getCurrentRtrPrefixes;
    private final Function0<Object> getCurrentNonce;
    private final RtrSessionData sessionData;

    public RtrSessionData sessionData() {
        return this.sessionData;
    }

    public void connect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)true));
    }

    public void disconnect() {
        this.sessionData().connected().apply(BoxesRunTime.boxToBoolean((boolean)false));
    }

    public void serialNotify(Pdu pdu) {
        this.sessionData().lastPduSent_$eq(pdu);
    }

    public Seq<Pdu> processRequest(Either<BadData, Pdu> request) {
        Either<BadData, Pdu> either;
        block5: {
            List<Pdu> list;
            block4: {
                Pdu pdu;
                block2: {
                    block3: {
                        either = request;
                        if (!(either instanceof Left)) break block2;
                        Left left = (Left)either;
                        BadData badData = (BadData)left.a();
                        if (badData == null) break block3;
                        list = this.handleBadData(badData.errorCode(), badData.content());
                        break block4;
                    }
                    throw new MatchError(either);
                }
                if (!(either instanceof Right)) break block5;
                Right right = (Right)either;
                Pdu pdu2 = pdu = (Pdu)right.b();
                Seq<Pdu> result = this.processRequestPdu(pdu2);
                this.sessionData().lastPduSent_$eq((Pdu)result.last());
                list = result;
            }
            return list;
        }
        throw new MatchError(either);
    }

    /*
     * WARNING - void declaration
     */
    public ErrorPdu determineErrorPdu(Throwable cause) {
        void var2_3;
        this.sessionData().lastPduReceived_$eq(cause.getMessage());
        Throwable throwable = cause;
        ErrorPdu result = throwable instanceof CorruptedFrameException ? new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), ((CorruptedFrameException)throwable).toString()) : (throwable instanceof TooLongFrameException ? new ErrorPdu(ErrorPdu$.MODULE$.CorruptData(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), ((TooLongFrameException)throwable).toString()) : (throwable instanceof ReadTimeoutException ? new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), "Connection timed out") : new ErrorPdu(ErrorPdu$.MODULE$.InternalError(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), throwable.toString())));
        this.sessionData().lastPduSent_$eq(result);
        return var2_3;
    }

    private List<Pdu> handleBadData(int errorCode, byte[] content) {
        this.sessionData().lastPduReceived_$eq(Predef$.MODULE$.augmentString("Bad data (error code: %d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errorCode)})));
        ErrorPdu pdu = new ErrorPdu(errorCode, content, "");
        this.sessionData().lastPduSent_$eq(pdu);
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{pdu}));
    }

    private Seq<Pdu> processRequestPdu(Pdu pdu) {
        List list;
        Pdu pdu2 = pdu;
        if (pdu2 instanceof ResetQueryPdu) {
            this.sessionData().lastPduReceived_$eq("ResetQuery");
            list = this.processResetQuery();
        } else if (pdu2 instanceof SerialQueryPdu) {
            SerialQueryPdu serialQueryPdu = (SerialQueryPdu)pdu2;
            this.sessionData().lastPduReceived_$eq("SerialQuery");
            list = this.processSerialQuery(serialQueryPdu.nonce(), serialQueryPdu.serial());
        } else {
            this.sessionData().lastPduReceived_$eq("Invalid Request");
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.InvalidRequest(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), "")}));
        }
        return list;
    }

    private Seq<Pdu> processResetQuery() {
        List list;
        int n = this.getCurrentCacheSerial.apply$mcI$sp();
        if (n == 0) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErrorPdu[]{new ErrorPdu(ErrorPdu$.MODULE$.NoDataAvailable(), (byte[])Array$.MODULE$.empty((ClassManifest)Manifest$.MODULE$.Byte()), "")}));
        } else {
            ObjectRef responsePdus$1 = new ObjectRef((Object)package$.MODULE$.Vector().empty());
            responsePdus$1.elem = (Vector)((Vector)responsePdus$1.elem).$colon$plus((Object)new CacheResponsePdu(this.getCurrentNonce.apply$mcS$sp()), Vector$.MODULE$.canBuildFrom());
            ((IterableLike)this.getCurrentRtrPrefixes.apply()).foreach((Function1)new Serializable(this, responsePdus$1){
                public static final long serialVersionUID;
                private final ObjectRef responsePdus$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(RtrPrefix rtrPrefix) {
                    IpRange prefix = rtrPrefix.prefix();
                    int prefixLength$1 = prefix.getPrefixLength();
                    int maxLength = BoxesRunTime.unboxToInt((Object)rtrPrefix.maxPrefixLength().getOrElse((Function0)new Serializable(this, prefixLength$1){
                        public static final long serialVersionUID;
                        private final int prefixLength$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.prefixLength$1;
                        }
                        {
                            this.prefixLength$1 = n;
                        }
                    }));
                    Asn asn = rtrPrefix.asn();
                    UniqueIpResource uniqueIpResource = prefix.getStart();
                    if (uniqueIpResource instanceof Ipv4Address) {
                        this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv4PrefixAnnouncePdu((Ipv4Address)uniqueIpResource, (byte)prefixLength$1, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                    } else if (uniqueIpResource instanceof Ipv6Address) {
                        this.responsePdus$1.elem = (Vector)((Vector)this.responsePdus$1.elem).$colon$plus((Object)new IPv6PrefixAnnouncePdu((Ipv6Address)uniqueIpResource, (byte)prefixLength$1, (byte)maxLength, asn), Vector$.MODULE$.canBuildFrom());
                    } else {
                        Predef$.MODULE$.assert(false);
                    }
                }
                {
                    this.responsePdus$1 = rtrSessionHandler;
                }
            });
            list = (Seq)((Vector)responsePdus$1.elem).$colon$plus((Object)new EndOfDataPdu(this.getCurrentNonce.apply$mcS$sp(), this.getCurrentCacheSerial.apply$mcI$sp()), Vector$.MODULE$.canBuildFrom());
        }
        return list;
    }

    private List<Product> processSerialQuery(short nonce, long serial) {
        return nonce == this.getCurrentNonce.apply$mcS$sp() && serial == (long)this.getCurrentCacheSerial.apply$mcI$sp() ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new CacheResponsePdu(nonce), new EndOfDataPdu(nonce, serial)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CacheResetPdu[]{new CacheResetPdu()}));
    }

    public RtrSessionHandler(T remoteAddress, Function0<Object> getCurrentCacheSerial, Function0<Set<RtrPrefix>> getCurrentRtrPrefixes, Function0<Object> getCurrentNonce) {
        this.getCurrentCacheSerial = getCurrentCacheSerial;
        this.getCurrentRtrPrefixes = getCurrentRtrPrefixes;
        this.getCurrentNonce = getCurrentNonce;
        this.sessionData = new RtrSessionData((InetSocketAddress)remoteAddress);
    }
}

