/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.AbstractX509CertificateWrapperException;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public abstract class AbstractX509CertificateWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ASN1ObjectIdentifier POLICY_OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.14.2");
    public static final PolicyInformation POLICY_INFORMATION = new PolicyInformation(POLICY_OID);
    private final X509Certificate certificate;

    protected AbstractX509CertificateWrapper(X509Certificate certificate) {
        Validate.notNull((Object)certificate);
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public ASN1ObjectIdentifier getCertificatePolicy() {
        return POLICY_OID;
    }

    public int hashCode() {
        return this.certificate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractX509CertificateWrapper)) {
            return false;
        }
        AbstractX509CertificateWrapper other = (AbstractX509CertificateWrapper)obj;
        return this.certificate.equals(other.certificate);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("serial", (Object)this.getSerialNumber()).append("subject", (Object)this.getSubject()).toString();
    }

    public boolean isEe() {
        return !this.isCa();
    }

    public boolean isCa() {
        try {
            byte[] basicConstraintsExtension = this.certificate.getExtensionValue(X509Extension.basicConstraints.getId());
            if (basicConstraintsExtension == null) {
                return false;
            }
            BasicConstraints constraints = BasicConstraints.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])basicConstraintsExtension));
            return constraints.isCA();
        }
        catch (IOException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }

    public boolean isRoot() {
        return this.certificate.getSubjectX500Principal().equals(this.certificate.getIssuerX500Principal());
    }

    public URI getManifestUri() {
        return this.findFirstSubjectInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST);
    }

    public URI getRepositoryUri() {
        return this.findFirstSubjectInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY);
    }

    public boolean isObjectIssuer() {
        return this.getManifestUri() != null;
    }

    public byte[] getSubjectKeyIdentifier() {
        return X509CertificateUtil.getSubjectKeyIdentifier(this.certificate);
    }

    public byte[] getAuthorityKeyIdentifier() {
        return X509CertificateUtil.getAuthorityKeyIdentifier(this.certificate);
    }

    public X500Principal getSubject() {
        return this.certificate.getSubjectX500Principal();
    }

    public X500Principal getIssuer() {
        return this.certificate.getIssuerX500Principal();
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public ValidityPeriod getValidityPeriod() {
        return new ValidityPeriod(this.certificate.getNotBefore(), this.certificate.getNotAfter());
    }

    public BigInteger getSerialNumber() {
        return this.getCertificate().getSerialNumber();
    }

    public X509CertificateInformationAccessDescriptor[] getAuthorityInformationAccess() {
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(X509Extension.authorityInfoAccess.getId());
            if (extensionValue == null) {
                return null;
            }
            AccessDescription[] accessDescriptions = AuthorityInformationAccess.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue)).getAccessDescriptions();
            return X509CertificateInformationAccessDescriptor.convertAccessDescriptors(accessDescriptions);
        }
        catch (IOException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }

    public URI findFirstAuthorityInformationAccessByMethod(ASN1ObjectIdentifier method) {
        Validate.notNull((Object)method, (String)"method is null");
        return this.findFirstByMethod(method, "rsync", this.getAuthorityInformationAccess());
    }

    private URI findFirstByMethod(ASN1ObjectIdentifier method, String scheme, X509CertificateInformationAccessDescriptor[] accessDescriptor) {
        if (accessDescriptor == null) {
            return null;
        }
        for (X509CertificateInformationAccessDescriptor ad : accessDescriptor) {
            if (!method.equals((Object)ad.getMethod()) || !ad.getLocation().getScheme().equals(scheme)) continue;
            return ad.getLocation();
        }
        return null;
    }

    public X509CertificateInformationAccessDescriptor[] getSubjectInformationAccess() {
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(X509Extension.subjectInfoAccess.getId());
            if (extensionValue == null) {
                return null;
            }
            AccessDescription[] accessDescriptions = AuthorityInformationAccess.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue)).getAccessDescriptions();
            return X509CertificateInformationAccessDescriptor.convertAccessDescriptors(accessDescriptions);
        }
        catch (IOException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }

    public URI findFirstSubjectInformationAccessByMethod(ASN1ObjectIdentifier method) {
        Validate.notNull((Object)method, (String)"method is null");
        return this.findFirstByMethod(method, "rsync", this.getSubjectInformationAccess());
    }

    public URI[] getCrlDistributionPoints() {
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(X509Extension.cRLDistributionPoints.getId());
            if (extensionValue == null) {
                return null;
            }
            CRLDistPoint crldp = CRLDistPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue));
            return this.convertCrlDistributionPointToUris(crldp);
        }
        catch (IOException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }

    public URI findFirstRsyncCrlDistributionPoint() {
        URI[] crlDistributionPoints = this.getCrlDistributionPoints();
        if (crlDistributionPoints == null) {
            return null;
        }
        for (URI uri : crlDistributionPoints) {
            if (!uri.getScheme().equals("rsync")) continue;
            return uri;
        }
        return null;
    }

    private URI[] convertCrlDistributionPointToUris(CRLDistPoint crldp) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (DistributionPoint dp : crldp.getDistributionPoints()) {
            Validate.isTrue((dp.getCRLIssuer() == null ? 1 : 0) != 0, (String)"crlIssuer MUST be omitted");
            Validate.isTrue((dp.getReasons() == null ? 1 : 0) != 0, (String)"reasons MUST be omitted");
            Validate.notNull((Object)dp.getDistributionPoint(), (String)"distributionPoint MUST be present");
            Validate.isTrue((dp.getDistributionPoint().getType() == 0 ? 1 : 0) != 0, (String)"distributionPoint type MUST be FULL_NAME");
            GeneralNames names = (GeneralNames)dp.getDistributionPoint().getName();
            for (GeneralName name : names.getNames()) {
                Validate.isTrue((name.getTagNo() == 6 ? 1 : 0) != 0, (String)"name MUST be a uniformResourceIdentifier");
                DERIA5String uri = (DERIA5String)name.getName();
                try {
                    result.add(new URI(uri.getString()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return result.toArray(new URI[result.size()]);
    }

    public void verify(PublicKey publicKey) throws InvalidKeyException, SignatureException {
        try {
            this.getCertificate().verify(publicKey, "SunRsaSign");
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] getEncoded() {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new AbstractX509CertificateWrapperException(e);
        }
    }
}

