/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.util;

import java.io.File;
import java.net.URI;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang.Validate;

public class UriToFileMapper {
    private static final String RSYNC_SCHEME = "rsync";
    private File targetDirectory;

    public UriToFileMapper(File targetDirectory) {
        Validate.notNull((Object)targetDirectory);
        this.targetDirectory = targetDirectory;
    }

    public File map(URI uri, ValidationResult result) {
        Validate.notNull((Object)result);
        Validate.notNull((Object)uri);
        result.rejectIfFalse(RSYNC_SCHEME.equalsIgnoreCase(uri.getScheme()), "validator.uri.rsync.scheme", new String[]{uri.toString()});
        result.rejectIfNull((Object)uri.getHost(), "validator.uri.host", new String[]{uri.toString()});
        result.rejectIfNull((Object)uri.getRawPath(), "validator.uri.path", new String[]{uri.toString()});
        String s = uri.toString();
        result.rejectIfTrue(s.contains("/../") || s.endsWith("/.."), "validator.uri.safety", new String[]{uri.toString()});
        if (result.hasFailureForCurrentLocation()) {
            return null;
        }
        return new File(new File(this.targetDirectory, this.getHostPortAsString(uri)), uri.getRawPath());
    }

    private String getHostPortAsString(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        return port == -1 ? host : host + ":" + port;
    }
}

