/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionResolver;
import com.typesafe.config.impl.Unmergeable;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ConfigDelayedMergeObject
extends AbstractConfigObject
implements Unmergeable {
    private static final long serialVersionUID = 1L;
    private final List<AbstractConfigValue> stack;
    private final boolean ignoresFallbacks;

    ConfigDelayedMergeObject(ConfigOrigin configOrigin, List<AbstractConfigValue> list) {
        this(configOrigin, list, false);
    }

    ConfigDelayedMergeObject(ConfigOrigin configOrigin, List<AbstractConfigValue> list, boolean bl) {
        super(configOrigin);
        this.stack = list;
        this.ignoresFallbacks = bl;
        if (list.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge object");
        }
        if (!(list.get(0) instanceof AbstractConfigObject)) {
            throw new ConfigException.BugOrBroken("created a delayed merge object not guaranteed to be an object");
        }
        for (AbstractConfigValue abstractConfigValue : list) {
            if (!(abstractConfigValue instanceof ConfigDelayedMerge) && !(abstractConfigValue instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMergeObject, should have consolidated stack");
        }
    }

    @Override
    protected ConfigDelayedMergeObject newCopy(ResolveStatus resolveStatus, boolean bl, ConfigOrigin configOrigin) {
        if (resolveStatus != this.resolveStatus()) {
            throw new ConfigException.BugOrBroken("attempt to create resolved ConfigDelayedMergeObject");
        }
        return new ConfigDelayedMergeObject(configOrigin, this.stack, bl);
    }

    @Override
    AbstractConfigObject resolveSubstitutions(SubstitutionResolver substitutionResolver, int n, ConfigResolveOptions configResolveOptions, Path path) throws AbstractConfigValue.NotPossibleToResolve, AbstractConfigValue.NeedsFullResolve {
        AbstractConfigValue abstractConfigValue = ConfigDelayedMerge.resolveSubstitutions(this.stack, substitutionResolver, n, configResolveOptions, path);
        if (abstractConfigValue instanceof AbstractConfigObject) {
            return (AbstractConfigObject)abstractConfigValue;
        }
        throw new ConfigException.BugOrBroken("somehow brokenly merged an object and didn't get an object");
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigDelayedMergeObject relativized(Path path) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            arrayList.add(abstractConfigValue.relativized(path));
        }
        return new ConfigDelayedMergeObject(this.origin(), arrayList, this.ignoresFallbacks);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    protected ConfigDelayedMergeObject mergedWithObject(AbstractConfigObject abstractConfigObject) {
        if (this.ignoresFallbacks) {
            throw new ConfigException.BugOrBroken("should not be reached");
        }
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        arrayList.addAll(this.stack);
        arrayList.add(abstractConfigObject);
        return new ConfigDelayedMergeObject(AbstractConfigObject.mergeOrigins(arrayList), arrayList, abstractConfigObject.ignoresFallbacks());
    }

    @Override
    public ConfigDelayedMergeObject withFallback(ConfigMergeable configMergeable) {
        return (ConfigDelayedMergeObject)super.withFallback(configMergeable);
    }

    @Override
    public ConfigDelayedMergeObject withOnlyKey(String string) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public ConfigDelayedMergeObject withoutKey(String string) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    protected AbstractConfigObject withOnlyPathOrNull(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    AbstractConfigObject withOnlyPath(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    AbstractConfigObject withoutPath(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    public Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigDelayedMergeObject;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigDelayedMergeObject) {
            return this.canEqual(object) && ((Object)this.stack).equals(((ConfigDelayedMergeObject)object).stack);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, String string, boolean bl) {
        ConfigDelayedMerge.render(this.stack, stringBuilder, n, string, bl);
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, boolean bl) {
        this.render(stringBuilder, n, null, bl);
    }

    private static ConfigException notResolved() {
        return new ConfigException.NotResolved("bug: this object has not had substitutions resolved, so can't be used");
    }

    @Override
    public Map<String, Object> unwrapped() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public AbstractConfigValue get(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean containsKey(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean containsValue(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean isEmpty() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Set<String> keySet() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public int size() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Collection<ConfigValue> values() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    protected AbstractConfigValue attemptPeekWithPartialResolve(String string) throws AbstractConfigValue.NeedsFullResolve {
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            if (abstractConfigValue instanceof AbstractConfigObject) {
                AbstractConfigObject abstractConfigObject = (AbstractConfigObject)abstractConfigValue;
                AbstractConfigValue abstractConfigValue2 = abstractConfigObject.attemptPeekWithPartialResolve(string);
                if (abstractConfigValue2 != null) {
                    if (!abstractConfigValue2.ignoresFallbacks()) continue;
                    return abstractConfigValue2;
                }
                if (!(abstractConfigValue instanceof Unmergeable)) continue;
                throw new ConfigException.BugOrBroken("should not be reached: unmergeable object returned null value");
            }
            if (!(abstractConfigValue instanceof Unmergeable)) continue;
            throw new AbstractConfigValue.NeedsFullResolve("Key '" + string + "' is not available at '" + this.origin().description() + "' because value at '" + abstractConfigValue.origin().description() + "' has not been resolved and may turn out to contain '" + string + "'." + " Be sure to Config.resolve() before using a config object.");
        }
        throw new ConfigException.BugOrBroken("Delayed merge stack does not contain any unmergeable values");
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ConfigDelayedMergeObject(this.origin(), new LinkedList<AbstractConfigValue>(this.stack), this.ignoresFallbacks);
    }
}

