/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.actor.ActorSystem;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcherConfigurator;
import akka.event.Logging;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Either;
import scala.Left;
import scala.MatchError;
import scala.Predef$;
import scala.Right;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}q!B\u0001\u0003\u0011\u000b9\u0011a\u0003#jgB\fGo\u00195feNT!a\u0001\u0003\u0002\u0011\u0011L7\u000f]1uG\"T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001RA\u0006\u0003\u0017\u0011K7\u000f]1uG\",'o]\n\u0004\u00131!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u00067%!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAqAH\u0005C\u0002\u0013\u0015q$A\nEK\u001a\fW\u000f\u001c;ESN\u0004\u0018\r^2iKJLE-F\u0001!\u001f\u0005\t\u0013%\u0001\u0012\u0002;\u0005\\7.\u0019\u0018bGR|'O\f3fM\u0006,H\u000e^\u0017eSN\u0004\u0018\r^2iKJDa\u0001J\u0005!\u0002\u001b\u0001\u0013\u0001\u0006#fM\u0006,H\u000e\u001e#jgB\fGo\u00195fe&#\u0007E\u0002\u0003\u000b\u0005\u000113cA\u0013\r)!A\u0001&\nBC\u0002\u0013\u0005\u0011&\u0001\u0005tKR$\u0018N\\4t+\u0005Q\u0003CA\u00162\u001d\tas&D\u0001.\u0015\tqC!A\u0003bGR|'/\u0003\u00021[\u0005Y\u0011i\u0019;peNK8\u000f^3n\u0013\t\u00114G\u0001\u0005TKR$\u0018N\\4t\u0015\t\u0001T\u0006\u0003\u00056K\t\u0005\t\u0015!\u0003+\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005\u0003\u00058K\t\u0015\r\u0011\"\u00019\u00035\u0001(/\u001a:fcVL7/\u001b;fgV\t\u0011\b\u0005\u0002\tu%\u00111H\u0001\u0002\u0018\t&\u001c\b/\u0019;dQ\u0016\u0014\bK]3sKF,\u0018n]5uKND\u0001\"P\u0013\u0003\u0002\u0003\u0006I!O\u0001\u000faJ,'/Z9vSNLG/Z:!\u0011\u0015YR\u0005\"\u0001@)\r\u0001\u0015I\u0011\t\u0003\u0011\u0015BQ\u0001\u000b A\u0002)BQa\u000e A\u0002eBq\u0001R\u0013C\u0002\u0013\u0005Q)A\feK\u001a\fW\u000f\u001c;ESN\u0004\u0018\r^2iKJ\u001cuN\u001c4jOV\ta\t\u0005\u0002H\u001d6\t\u0001J\u0003\u0002J\u0015\u000611m\u001c8gS\u001eT!a\u0013'\u0002\u0011QL\b/Z:bM\u0016T\u0011!T\u0001\u0004G>l\u0017BA(I\u0005\u0019\u0019uN\u001c4jO\"1\u0011+\nQ\u0001\n\u0019\u000b\u0001\u0004Z3gCVdG\u000fR5ta\u0006$8\r[3s\u0007>tg-[4!\u0011\u0015\u0019V\u0005\"\u0001U\u0003]!WMZ1vYR<En\u001c2bY\u0012K7\u000f]1uG\",'/F\u0001V!\tAa+\u0003\u0002X\u0005\t\tR*Z:tC\u001e,G)[:qCR\u001c\u0007.\u001a:\t\u000fe+#\u0019!C\u00055\u00069B-[:qCR\u001c\u0007.\u001a:D_:4\u0017nZ;sCR|'o]\u000b\u00027B!A,Y2k\u001b\u0005i&B\u00010`\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003AB\tA!\u001e;jY&\u0011!-\u0018\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u00013h\u001d\t)R-\u0003\u0002g-\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1g\u0003\u0005\u0002\tW&\u0011AN\u0001\u0002\u001e\u001b\u0016\u001c8/Y4f\t&\u001c\b/\u0019;dQ\u0016\u00148i\u001c8gS\u001e,(/\u0019;pe\"1a.\nQ\u0001\nm\u000b\u0001\u0004Z5ta\u0006$8\r[3s\u0007>tg-[4ve\u0006$xN]:!\u0011\u0015\u0001X\u0005\"\u0001r\u0003\u0019awn\\6vaR\u0011QK\u001d\u0005\u0006g>\u0004\raY\u0001\u0003S\u0012DQ!^\u0013\u0005\nY\f!\u0003\\8pWV\u00048i\u001c8gS\u001e,(/\u0019;peR\u0011!n\u001e\u0005\u0006gR\u0004\ra\u0019\u0005\u0006\u0013\u0016\"I!\u001f\u000b\u0003\rjDQa\u001d=A\u0002\rDQ\u0001`\u0013\u0005\nu\f\u0001\"\u001b3D_:4\u0017n\u001a\u000b\u0003\rzDQa]>A\u0002\rD\u0001\"!\u0001&\t\u0003!\u00111A\u0001\u0005MJ|W\u000eF\u0002V\u0003\u000bAa!a\u0002\u0000\u0001\u00041\u0015aA2gO\"A\u00111B\u0013\u0005\u0002\u0011\ti!A\u000bjg\n\u000bG.\u00198dS:<G)[:qCR\u001c\u0007.\u001a:\u0015\t\u0005=\u0011Q\u0003\t\u0004+\u0005E\u0011bAA\n-\t9!i\\8mK\u0006t\u0007BB:\u0002\n\u0001\u00071\rC\u0004\u0002\u001a\u0015\"I!a\u0007\u0002!\r|gNZ5hkJ\fGo\u001c:Ge>lGc\u00016\u0002\u001e!9\u0011qAA\f\u0001\u00041\u0005")
public class Dispatchers
implements ScalaObject {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;

    public static final String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("akka.actor.default-dispatcher");
    }

    private ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators() {
        return this.dispatcherConfigurators;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id).dispatcher();
    }

    private MessageDispatcherConfigurator lookupConfigurator(String id) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators().get(id);
        if (messageDispatcherConfigurator2 == null) {
            MessageDispatcherConfigurator messageDispatcherConfigurator3;
            if (this.settings().config().hasPath(id)) {
                messageDispatcherConfigurator3 = this.configuratorFrom(this.config(id));
            } else {
                this.prerequisites().eventStream().publish(new Logging.Warning("Dispatchers", this.getClass(), Predef$.MODULE$.augmentString("Dispatcher [%s] not configured, using default-dispatcher").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id}))));
                messageDispatcherConfigurator3 = this.lookupConfigurator("akka.actor.default-dispatcher");
            }
            MessageDispatcherConfigurator newConfigurator = messageDispatcherConfigurator3;
            MessageDispatcherConfigurator messageDispatcherConfigurator4 = this.dispatcherConfigurators().putIfAbsent(id, newConfigurator);
            messageDispatcherConfigurator = messageDispatcherConfigurator4 == null ? newConfigurator : messageDispatcherConfigurator4;
        } else {
            messageDispatcherConfigurator = messageDispatcherConfigurator2;
        }
        return messageDispatcherConfigurator;
    }

    private Config config(String id$1) {
        return this.idConfig(id$1).withFallback((ConfigMergeable)this.settings().config().getConfig(id$1)).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"name").$minus$greater((Object)this.simpleName$1(id$1))}))).asJava()))).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        return ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"id").$minus$greater((Object)id)}))).asJava()));
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBalancingDispatcher(String id) {
        if (!this.settings().config().hasPath(id)) return false;
        String string = this.config(id).getString("type");
        String string2 = "BalancingDispatcher";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        block4: {
            Either either;
            String fqn;
            block9: {
                MessageDispatcherConfigurator messageDispatcherConfigurator;
                block6: {
                    String string;
                    block8: {
                        block7: {
                            block5: {
                                if (!cfg.hasPath("id")) break block4;
                                String string2 = string = cfg.getString("type");
                                String string3 = "Dispatcher";
                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block5;
                                messageDispatcherConfigurator = new DispatcherConfigurator(cfg, this.prerequisites());
                                break block6;
                            }
                            String string4 = string;
                            String string5 = "BalancingDispatcher";
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
                            messageDispatcherConfigurator = new BalancingDispatcherConfigurator(cfg, this.prerequisites());
                            break block6;
                        }
                        String string6 = string;
                        String string7 = "PinnedDispatcher";
                        if (string6 != null ? !string6.equals(string7) : string7 != null) break block8;
                        messageDispatcherConfigurator = new PinnedDispatcherConfigurator(cfg, this.prerequisites());
                        break block6;
                    }
                    fqn = string;
                    Seq args = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(Config.class).$minus$greater((Object)cfg), Predef$.MODULE$.any2ArrowAssoc(DispatcherPrerequisites.class).$minus$greater((Object)this.prerequisites())}));
                    either = this.prerequisites().dynamicAccess().createInstanceFor(fqn, args, ClassManifest$.MODULE$.classType(MessageDispatcherConfigurator.class));
                    if (!(either instanceof Right)) break block9;
                    messageDispatcherConfigurator = (MessageDispatcherConfigurator)((Right)either).b();
                }
                return messageDispatcherConfigurator;
            }
            if (either instanceof Left) {
                throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [akka.dispatch.DispatcherPrerequisites] parameters").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fqn, cfg.getString("id")})), (Throwable)((Left)either).a());
            }
            throw new MatchError(either);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Missing dispatcher 'id' property in config: ").append((Object)cfg.root().render()).toString());
    }

    private final String simpleName$1(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.defaultDispatcherConfig = this.idConfig("akka.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("akka.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
    }
}

