/*
 * Decompiled with CFR 0.152.
 */
package grizzled.math;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class stats$
implements ScalaObject {
    public static final stats$ MODULE$;

    static {
        new stats$();
    }

    public <T> double geometricMean(Seq<T> items, Numeric<T> n$1) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        Predef$.MODULE$.require(!itemList.exists((Function1)new Serializable(n$1){
            public static final long serialVersionUID;
            private final Numeric n$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(T t) {
                return this.n$1.toDouble(t) <= 0.0;
            }
            {
                this.n$1 = numeric;
            }
        }));
        int n = len;
        if (n == 1) {
            d = n$1.toDouble(itemList.apply(0));
        } else {
            double recip$1 = 1.0 / (double)len;
            double d2 = 1.0;
            d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n$1, recip$1){
                public static final long serialVersionUID;
                private final Numeric n$1;
                private final double recip$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final double apply(double a, T b) {
                    return a * package$.MODULE$.pow(this.n$1.toDouble(b), this.recip$1);
                }
                {
                    this.n$1 = numeric;
                    this.recip$1 = d;
                }
            }));
        }
        return d;
    }

    public <T> double harmonicMean(Seq<T> items, Numeric<T> n$2) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n = len;
        if (n == 1) {
            d = n$2.toDouble(itemList.apply(0));
        } else {
            double d2 = 0.0;
            d = (double)len / BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n$2){
                public static final long serialVersionUID;
                private final Numeric n$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final double apply(double a, T b) {
                    return a + 1.0 / this.n$2.toDouble(b);
                }
                {
                    this.n$2 = numeric;
                }
            }));
        }
        return d;
    }

    public <T> double arithmeticMean(Seq<T> items, Numeric<T> n$3) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        int n = len;
        if (n == 1) {
            d = n$3.toDouble(itemList.apply(0));
        } else {
            double d2 = 0.0;
            d = BoxesRunTime.unboxToDouble((Object)itemList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d2), (Function2)new Serializable(n$3){
                public static final long serialVersionUID;
                private final Numeric n$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final double apply(double a, T b) {
                    return a + this.n$3.toDouble(b);
                }
                {
                    this.n$3 = numeric;
                }
            })) / (double)len;
        }
        return d;
    }

    public <T> double mean(Seq<T> items, Numeric<T> n) {
        return this.arithmeticMean((Seq<T>)items.toList(), n);
    }

    public <T> double median(Seq<T> items, Numeric<T> n$4) {
        double d;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            d = n$4.toDouble(itemList.apply(0));
        } else {
            List sorted = (List)itemList.sortWith((Function2)new Serializable(n$4){
                public static final long serialVersionUID;
                private final Numeric n$4;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(T t, T t2) {
                    return this.n$4.compare(t, t2) < 0;
                }
                {
                    this.n$4 = numeric;
                }
            });
            int midpoint = sorted.length() / 2;
            int n = len % 2;
            switch (n) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                case 0: {
                    d = this.mean((Seq<T>)Predef$.MODULE$.wrapDoubleArray(new double[]{n$4.toDouble(sorted.apply(midpoint)), n$4.toDouble(sorted.apply(midpoint - 1))}), (Numeric<T>)Numeric$DoubleIsFractional$.MODULE$);
                    break;
                }
                case 1: {
                    d = n$4.toDouble(sorted.apply(midpoint));
                }
            }
        }
        return d;
    }

    public <T> List<T> mode(Seq<T> items, Numeric<T> n) {
        List list;
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 0);
        if (len == 1) {
            list = itemList.take(1);
        } else {
            Map m$1 = Map$.MODULE$.empty();
            itemList.foreach((Function1)new Serializable(m$1){
                public static final long serialVersionUID;
                private final Map m$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Map<T, Object> apply(T t) {
                    return (Map)this.m$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc(t).$minus$greater((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.m$1.getOrElse(t, (Function0)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })) + 1))));
                }
                {
                    this.m$1 = map;
                }
            });
            int n2 = 0;
            int max$1 = BoxesRunTime.unboxToInt((Object)m$1.values().$div$colon((Object)BoxesRunTime.boxToInteger((int)n2), (Function2)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(int n, int n2) {
                    return this.apply$mcIII$sp(n, n2);
                }

                public int apply$mcIII$sp(int v1, int v2) {
                    return package$.MODULE$.max(v1, v2);
                }
            }));
            list = ((TraversableOnce)((TraversableLike)m$1.filter((Function1)new Serializable(max$1){
                public static final long serialVersionUID;
                private final int max$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<T, Object> tup) {
                    return tup._2$mcI$sp() == this.max$1;
                }
                {
                    this.max$1 = n;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final T apply(Tuple2<T, Object> tup) {
                    return (T)tup._1();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toList();
        }
        return list;
    }

    public <T> double populationVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length(), items.toList(), n);
    }

    public <T> double sampleVariance(Seq<T> items, Numeric<T> n) {
        return this.calculateVariance(items.length() - 1, items.toList(), n);
    }

    public <T> double populationStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double popStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.populationVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStandardDeviation(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> double sampleStdDev(Seq<T> items, Numeric<T> n) {
        return Math.sqrt(this.sampleVariance((Seq<T>)items.toList(), n));
    }

    public <T> T range(Seq<T> items, Numeric<T> n$6) {
        Tuple2 tuple2 = new Tuple2(n$6.fromInt(Integer.MAX_VALUE), n$6.fromInt(0));
        Tuple2 tuple22 = (Tuple2)items.$div$colon((Object)tuple2, (Function2)new Serializable(n$6){
            public static final long serialVersionUID;
            private final Numeric n$6;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<T, T> apply(Tuple2<T, T> tuple, T i) {
                return new Tuple2(this.n$6.min(tuple._1(), i), this.n$6.max(tuple._1(), i));
            }
            {
                this.n$6 = numeric;
            }
        });
        if (tuple22 != null) {
            Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
            Object min2 = tuple23._1();
            Object max2 = tuple23._2();
            return (T)n$6.minus(max2, min2);
        }
        throw new MatchError((Object)tuple22);
    }

    private <T> double calculateVariance(int denominator, List<T> items, Numeric<T> n$5) {
        List itemList = items.toList();
        int len = itemList.length();
        Predef$.MODULE$.require(len > 1);
        double mn$1 = this.mean((Seq<T>)itemList, n$5);
        List deviations = (List)itemList.map((Function1)new Serializable(n$5, mn$1){
            public static final long serialVersionUID;
            private final Numeric n$5;
            private final double mn$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(T t) {
                return this.n$5.toDouble(t) - this.mn$1;
            }
            {
                this.n$5 = numeric;
                this.mn$1 = d;
            }
        }, List$.MODULE$.canBuildFrom());
        return this.sumOfSquares$1(deviations) / (double)denominator;
    }

    private final double sumOfSquares$1(List dList) {
        double d = 0.0;
        return BoxesRunTime.unboxToDouble((Object)dList.$div$colon((Object)BoxesRunTime.boxToDouble((double)d), (Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final double apply(double sum, double d) {
                return this.apply$mcDDD$sp(sum, d);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return v1 + v2 * v2;
            }
        }));
    }

    private stats$() {
        MODULE$ = this;
    }
}

