/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.rtr;

import java.math.BigInteger;
import java.nio.ByteOrder;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.rpki.validator.rtr.BadData;
import net.ripe.rpki.validator.rtr.CacheResetPdu;
import net.ripe.rpki.validator.rtr.CacheResponsePdu;
import net.ripe.rpki.validator.rtr.EndOfDataPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu;
import net.ripe.rpki.validator.rtr.ErrorPdu$;
import net.ripe.rpki.validator.rtr.IPv4PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.IPv6PrefixAnnouncePdu;
import net.ripe.rpki.validator.rtr.Pdu;
import net.ripe.rpki.validator.rtr.PduTypes$;
import net.ripe.rpki.validator.rtr.ResetQueryPdu;
import net.ripe.rpki.validator.rtr.SerialNotifyPdu;
import net.ripe.rpki.validator.rtr.SerialQueryPdu;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Pdus$ {
    public static final Pdus$ MODULE$;
    private final byte SupportedProtocol;

    static {
        new Pdus$();
    }

    public byte SupportedProtocol() {
        return this.SupportedProtocol;
    }

    public byte[] encode(Pdu pdu) {
        Pdu pdu2;
        block11: {
            ChannelBuffer buffer;
            block3: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                buffer = ChannelBuffers.buffer((ByteOrder)ByteOrder.BIG_ENDIAN, (int)pdu.length());
                                                buffer.writeByte((int)pdu.protocolVersion());
                                                buffer.writeByte((int)pdu.pduType());
                                                buffer.writeShort((int)pdu.headerShort());
                                                buffer.writeInt(pdu.length());
                                                pdu2 = pdu;
                                                if (!(pdu2 instanceof SerialNotifyPdu)) break block2;
                                                SerialNotifyPdu serialNotifyPdu = (SerialNotifyPdu)pdu2;
                                                long serial = serialNotifyPdu.serial();
                                                buffer.writeInt((int)serial);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (!(pdu2 instanceof SerialQueryPdu)) break block4;
                                            SerialQueryPdu serialQueryPdu = (SerialQueryPdu)pdu2;
                                            long serial = serialQueryPdu.serial();
                                            buffer.writeInt((int)serial);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(pdu2 instanceof ErrorPdu)) break block5;
                                        ErrorPdu errorPdu = (ErrorPdu)pdu2;
                                        byte[] causingPdu = errorPdu.causingPdu();
                                        this.writeErrorPduPayload(buffer, errorPdu, causingPdu);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(pdu2 instanceof ResetQueryPdu)) break block6;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(pdu2 instanceof CacheResponsePdu)) break block7;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(pdu2 instanceof IPv4PrefixAnnouncePdu)) break block8;
                            IPv4PrefixAnnouncePdu iPv4PrefixAnnouncePdu = (IPv4PrefixAnnouncePdu)pdu2;
                            Ipv4Address prefix = iPv4PrefixAnnouncePdu.ipv4PrefixStart();
                            byte length = iPv4PrefixAnnouncePdu.prefixLength();
                            byte maxLength = iPv4PrefixAnnouncePdu.maxLength();
                            Asn asn = iPv4PrefixAnnouncePdu.asn();
                            this.writeIPv4PrefixAnnouncePduPayload(buffer, prefix, length, maxLength, asn);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(pdu2 instanceof IPv6PrefixAnnouncePdu)) break block9;
                        IPv6PrefixAnnouncePdu iPv6PrefixAnnouncePdu = (IPv6PrefixAnnouncePdu)pdu2;
                        Ipv6Address prefix = iPv6PrefixAnnouncePdu.ipv6PrefixStart();
                        byte length = iPv6PrefixAnnouncePdu.prefixLength();
                        byte maxLength = iPv6PrefixAnnouncePdu.maxLength();
                        Asn asn = iPv6PrefixAnnouncePdu.asn();
                        this.writeIPv6PrefixAnnouncePduPayload(buffer, prefix, length, maxLength, asn);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(pdu2 instanceof EndOfDataPdu)) break block10;
                    EndOfDataPdu endOfDataPdu = (EndOfDataPdu)pdu2;
                    long serial = endOfDataPdu.serial();
                    buffer.writeInt((int)serial);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(pdu2 instanceof CacheResetPdu)) break block11;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return buffer.array();
        }
        throw new MatchError((Object)pdu2);
    }

    public Either<BadData, Pdu> fromByteArray(ChannelBuffer buffer) {
        Right<Nothing$, SerialNotifyPdu> right;
        try {
            byte protocol = buffer.readByte();
            byte pduType = buffer.readByte();
            short headerShort = buffer.readShort();
            int length = buffer.readInt();
            if (protocol != this.SupportedProtocol()) {
                right = package$.MODULE$.Left().apply((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedProtocolVersion(), buffer.array()));
            } else {
                byte by = pduType;
                Object object = PduTypes$.MODULE$.SerialNotify() == by ? this.parseSerialNotifyPdu(buffer, headerShort) : (PduTypes$.MODULE$.SerialQuery() == by ? this.parseSerialQueryPdu(buffer, headerShort) : (PduTypes$.MODULE$.Error() == by ? this.parseErrorPdu(buffer, headerShort) : (PduTypes$.MODULE$.ResetQuery() == by ? package$.MODULE$.Right().apply((Object)new ResetQueryPdu()) : (PduTypes$.MODULE$.CacheResponse() == by ? this.parseCacheResponsePdu(headerShort) : (PduTypes$.MODULE$.EndOfData() == by ? this.parseEndOfDataPdu(buffer, headerShort) : (PduTypes$.MODULE$.IPv4Prefix() == by ? this.parseIPv4PrefixPdu(buffer) : (PduTypes$.MODULE$.IPv6Prefix() == by ? this.parseIPv6PrefixPdu(buffer) : (PduTypes$.MODULE$.CacheReset() == by ? package$.MODULE$.Right().apply((Object)new CacheResetPdu()) : package$.MODULE$.Left().apply((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()))))))))));
                right = object;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            right = package$.MODULE$.Left().apply((Object)new BadData(ErrorPdu$.MODULE$.CorruptData(), buffer.array()));
        }
        return right;
    }

    private byte[] convertToPrependedByteArray(BigInteger value, int bytesNeeded) {
        byte[] valueBytes = value.toByteArray();
        if (Predef$.MODULE$.byteArrayOps(valueBytes).size() > 1 && BoxesRunTime.unboxToByte((Object)Predef$.MODULE$.byteArrayOps(valueBytes).head()) == 0) {
            valueBytes = (byte[])Predef$.MODULE$.byteArrayOps(valueBytes).drop(1);
        }
        int extraBytesNeeded = bytesNeeded - valueBytes.length;
        byte[] prependBytes = new byte[extraBytesNeeded];
        return (byte[])Predef$.MODULE$.byteArrayOps(prependBytes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(valueBytes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
    }

    private void writeErrorPduPayload(ChannelBuffer buffer, ErrorPdu errorPdu, byte[] causingPdu) {
        buffer.writeInt(causingPdu.length);
        buffer.writeBytes(causingPdu);
        buffer.writeInt(errorPdu.errorTextBytes().length);
        buffer.writeBytes(errorPdu.errorTextBytes());
    }

    private void writeIPv4PrefixAnnouncePduPayload(ChannelBuffer buffer, Ipv4Address prefix, byte length, byte maxLength, Asn asn) {
        buffer.writeByte(1);
        buffer.writeByte((int)length);
        buffer.writeByte((int)maxLength);
        buffer.writeByte(0);
        buffer.writeBytes(this.convertToPrependedByteArray(prefix.getValue(), 4));
        buffer.writeBytes(this.convertToPrependedByteArray(asn.getValue(), 4));
    }

    private void writeIPv6PrefixAnnouncePduPayload(ChannelBuffer buffer, Ipv6Address prefix, byte length, byte maxLength, Asn asn) {
        buffer.writeByte(1);
        buffer.writeByte((int)length);
        buffer.writeByte((int)maxLength);
        buffer.writeByte(0);
        buffer.writeBytes(this.convertToPrependedByteArray(prefix.getValue(), 16));
        buffer.writeBytes(this.convertToPrependedByteArray(asn.getValue(), 4));
    }

    private Right<Nothing$, SerialNotifyPdu> parseSerialNotifyPdu(ChannelBuffer buffer, short sessionId) {
        long serial = buffer.readUnsignedInt();
        return package$.MODULE$.Right().apply((Object)new SerialNotifyPdu(sessionId, serial));
    }

    private Right<Nothing$, SerialQueryPdu> parseSerialQueryPdu(ChannelBuffer buffer, short sessionId) {
        long serial = buffer.readUnsignedInt();
        return package$.MODULE$.Right().apply((Object)new SerialQueryPdu(sessionId, serial));
    }

    private Right<Nothing$, ErrorPdu> parseErrorPdu(ChannelBuffer buffer, short headerShort) {
        int causingPduLength = buffer.readInt();
        byte[] causingPdu = buffer.readBytes(causingPduLength).array();
        int errorTextLength = buffer.readInt();
        ChannelBuffer errorTextBytes = buffer.readBytes(errorTextLength);
        String errorText = new String(buffer.array(), "UTF-8");
        return package$.MODULE$.Right().apply((Object)new ErrorPdu(headerShort, causingPdu, errorText));
    }

    private Right<Nothing$, CacheResponsePdu> parseCacheResponsePdu(short sessionId) {
        return package$.MODULE$.Right().apply((Object)new CacheResponsePdu(sessionId));
    }

    private Right<Nothing$, EndOfDataPdu> parseEndOfDataPdu(ChannelBuffer buffer, short sessionId) {
        long serial = buffer.readUnsignedInt();
        return package$.MODULE$.Right().apply((Object)new EndOfDataPdu(sessionId, serial));
    }

    private Either<BadData, Pdu> parseIPv4PrefixPdu(ChannelBuffer buffer) {
        Left left;
        byte by = buffer.readByte();
        switch (by) {
            default: {
                left = package$.MODULE$.Left().apply((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()));
                break;
            }
            case 1: {
                byte length = buffer.readByte();
                byte maxLenght = buffer.readByte();
                buffer.skipBytes(1);
                Ipv4Address prefix = new Ipv4Address(buffer.readUnsignedInt());
                Asn asn = new Asn(buffer.readUnsignedInt());
                left = package$.MODULE$.Right().apply((Object)new IPv4PrefixAnnouncePdu(prefix, length, maxLenght, asn));
            }
        }
        return left;
    }

    private Either<BadData, Pdu> parseIPv6PrefixPdu(ChannelBuffer buffer) {
        Left left;
        byte by = buffer.readByte();
        switch (by) {
            default: {
                left = package$.MODULE$.Left().apply((Object)new BadData(ErrorPdu$.MODULE$.UnsupportedPduType(), buffer.array()));
                break;
            }
            case 1: {
                byte length = buffer.readByte();
                byte maxLenght = buffer.readByte();
                buffer.skipBytes(1);
                byte[] ipv6Bytes = new byte[16];
                buffer.getBytes(12, ipv6Bytes);
                Ipv6Address prefix = new Ipv6Address(new BigInteger(1, ipv6Bytes));
                buffer.skipBytes(16);
                Asn asn = new Asn(buffer.readUnsignedInt());
                left = package$.MODULE$.Right().apply((Object)new IPv6PrefixAnnouncePdu(prefix, length, maxLenght, asn));
            }
        }
        return left;
    }

    private Pdus$() {
        MODULE$ = this;
        this.SupportedProtocol = 0;
    }
}

