/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import java.net.URI;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.fetchers.RrdpFetcher;
import net.ripe.rpki.validator.fetchers.RsyncFetcher;
import net.ripe.rpki.validator.fetchers.SingleObjectHttpFetcher;
import net.ripe.rpki.validator.fetchers.SingleObjectRsyncFetcher;
import net.ripe.rpki.validator.store.HttpFetcherStore;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u001f\tAa)\u001a;dQ\u0016\u00148O\u0003\u0002\u0004\t\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AB7pI\u0016d7O\u0003\u0002\b\u0011\u0005Ia/\u00197jI\u0006$xN\u001d\u0006\u0003\u0013)\tAA\u001d9lS*\u00111\u0002D\u0001\u0005e&\u0004XMC\u0001\u000e\u0003\rqW\r^\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005I\u0001\u000e\u001e;q'R|'/\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0019\tQa\u001d;pe\u0016L!!\b\u000e\u0003!!#H\u000f\u001d$fi\u000eDWM]*u_J,\u0007\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\r\r|gNZ5h!\t\tC%D\u0001#\u0015\t\u0019c!\u0001\u0005gKR\u001c\u0007.\u001a:t\u0013\t)#EA\u0007GKR\u001c\u0007.\u001a:D_:4\u0017n\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u0018M\u0001\u0007\u0001\u0004C\u0003 M\u0001\u0007\u0001\u0005C\u0003/\u0001\u0011\u0005q&A\ntS:<G.Z(cU\u0016\u001cGOR3uG\",'\u000f\u0006\u00021gA\u0011\u0011%M\u0005\u0003e\t\u0012qAR3uG\",'\u000fC\u00035[\u0001\u0007Q'A\u0005pE*,7\r^+sSB\u0011aGO\u0007\u0002o)\u0011Q\u0002\u000f\u0006\u0002s\u0005!!.\u0019<b\u0013\tYtGA\u0002V%&CQ!\u0010\u0001\u0005\u0002y\n\u0011\"[:M_\u000e\fGNR*\u0015\u0005}\u0012\u0005CA\tA\u0013\t\t%CA\u0004C_>dW-\u00198\t\u000b\rc\u0004\u0019A\u001b\u0002\u0003UDQ!\u0012\u0001\u0005\u0002\u0019\u000bqAZ3uG\",'\u000f\u0006\u00021\u000f\")\u0001\n\u0012a\u0001k\u00059!/\u001a9p+JL\u0007")
public class Fetchers {
    private final HttpFetcherStore httpStore;
    private final FetcherConfig config;

    public Fetcher singleObjectFetcher(URI objectUri) {
        block9: {
            SingleObjectRsyncFetcher singleObjectRsyncFetcher;
            block6: {
                Fetcher fetcher;
                block8: {
                    boolean bl;
                    String string;
                    block7: {
                        block5: {
                            if (!this.isLocalFS(objectUri)) break block5;
                            singleObjectRsyncFetcher = new SingleObjectRsyncFetcher(this.config);
                            break block6;
                        }
                        String string2 = string = objectUri.getScheme();
                        if ("rsync" != null ? !"rsync".equals(string2) : string2 != null) break block7;
                        fetcher = new SingleObjectRsyncFetcher(this.config);
                        break block8;
                    }
                    String string3 = string;
                    if (!("http" != null ? !"http".equals(string3) : string3 != null)) {
                        bl = true;
                    } else {
                        String string4 = string;
                        bl = !("https" != null ? !"https".equals(string4) : string4 != null);
                    }
                    if (!bl) break block9;
                    fetcher = new SingleObjectHttpFetcher(this.httpStore);
                }
                singleObjectRsyncFetcher = fetcher;
            }
            return singleObjectRsyncFetcher;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No fetcher for the object ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{objectUri})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLocalFS(URI u) {
        if (u.getHost() != null) return false;
        if (u.getScheme() != null) return false;
        String string = u.toString();
        String string2 = u.getPath();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public Fetcher fetcher(URI repoUri) {
        block9: {
            RsyncFetcher rsyncFetcher;
            block6: {
                Fetcher fetcher;
                block8: {
                    boolean bl;
                    String string;
                    block7: {
                        block5: {
                            if (!this.isLocalFS(repoUri)) break block5;
                            rsyncFetcher = new RsyncFetcher(this.config);
                            break block6;
                        }
                        String string2 = string = repoUri.getScheme();
                        if ("rsync" != null ? !"rsync".equals(string2) : string2 != null) break block7;
                        fetcher = new RsyncFetcher(this.config);
                        break block8;
                    }
                    String string3 = string;
                    if (!("http" != null ? !"http".equals(string3) : string3 != null)) {
                        bl = true;
                    } else {
                        String string4 = string;
                        bl = !("https" != null ? !"https".equals(string4) : string4 != null);
                    }
                    if (!bl) break block9;
                    fetcher = new RrdpFetcher(this.httpStore);
                }
                rsyncFetcher = fetcher;
            }
            return rsyncFetcher;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No fetcher for the uri ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repoUri})));
    }

    public Fetchers(HttpFetcherStore httpStore, FetcherConfig config) {
        this.httpStore = httpStore;
        this.config = config;
    }
}

