/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config.health;

import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.config.health.Health$;
import net.ripe.rpki.validator.config.health.Status;
import net.ripe.rpki.validator.config.health.Status$;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class Health$ {
    public static final Health$ MODULE$;
    private final DateTimeFormatter timeFormatter;

    static {
        new Health$();
    }

    private DateTimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    public Status getValidationTimeStatus(Seq<Option<DateTime>> lastUpdated) {
        Tuple2 tuple2;
        block4: {
            Status status;
            block3: {
                Tuple2 tuple22;
                VolatileByteRef bitmap$0;
                block2: {
                    bitmap$0 = new VolatileByteRef(0);
                    if (!lastUpdated.isEmpty()) break block2;
                    status = Status$.MODULE$.ok();
                    break block3;
                }
                ObjectRef notAllValidated$lzy = new ObjectRef(null);
                tuple2 = lastUpdated.partition((Function1)new anonfun.1());
                if (tuple2 == null) break block4;
                Seq validated = (Seq)tuple2._1();
                Seq notValidated = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)validated, (Object)notValidated);
                Seq validated2 = (Seq)tuple23._1();
                Seq notValidated2 = (Seq)tuple23._2();
                Instant tooLongAgo = Instant.now().minus(ApplicationOptions$.MODULE$.validationInterval().length() * 2L);
                status = validated2.exists((Function1)new Serializable(tooLongAgo){
                    public static final long serialVersionUID = 0L;
                    private final Instant tooLongAgo$1;

                    public final boolean apply(Option<DateTime> x$3) {
                        return ((AbstractInstant)x$3.get()).isAfter((ReadableInstant)this.tooLongAgo$1);
                    }
                    {
                        this.tooLongAgo$1 = tooLongAgo$1;
                    }
                }) ? Status$.MODULE$.ok() : (validated2.isEmpty() ? this.notAllValidated$1(notAllValidated$lzy, bitmap$0) : (notValidated2.nonEmpty() ? this.notAllValidated$1(notAllValidated$lzy, bitmap$0) : Status$.MODULE$.recoverableError(new StringBuilder().append((Object)"No trust anchors have been validated since ").append((Object)tooLongAgo.toString(this.timeFormatter())).toString())));
            }
            return status;
        }
        throw new MatchError((Object)tuple2);
    }

    public Status rsyncStatus() {
        Status status;
        try {
            Rsync rsync = new Rsync();
            rsync.addOptions(new String[]{"--version"});
            int rc = rsync.execute();
            status = rc == 0 ? Status$.MODULE$.ok("Can find and execute rsync") : Status$.MODULE$.validationError("Problems executing rsync, make sure you have rsync installed on the path");
        }
        catch (Exception exception) {
            status = Status$.MODULE$.validationError(exception.getMessage());
        }
        return status;
    }

    public Map<String, Status> getTasStatus(ValidatedObjects objects) {
        return (Map)objects.validationStatusCountByTal().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Status> apply(Tuple2<TrustAnchorLocator, Map<ValidationStatus, Object>> x0$1) {
                Tuple2<TrustAnchorLocator, Map<ValidationStatus, Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TrustAnchorLocator tal = (TrustAnchorLocator)tuple2._1();
                    Map counters = (Map)tuple2._2();
                    Status status = (Status)counters.get((Object)ValidationStatus.ERROR).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Status apply(int e) {
                            return Status$.MODULE$.validationError(new StringBuilder().append((Object)"There ").append((Object)(e == 1 ? "is 1 error" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"are ", " errors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)e)})))).toString());
                        }
                    }).orElse((Function0)new Serializable(this, counters){
                        public static final long serialVersionUID = 0L;
                        private final Map counters$1;

                        public final Option<Status> apply() {
                            return this.counters$1.get((Object)ValidationStatus.WARNING).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Status apply(int w) {
                                    return Status$.MODULE$.warning(new StringBuilder().append((Object)"There ").append((Object)(w == 1 ? "is 1 error" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"are ", " errors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)w)})))).toString());
                                }
                            });
                        }
                        {
                            this.counters$1 = counters$1;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Status apply() {
                            return Status$.MODULE$.ok();
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)tal.getCaName()), (Object)status);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Status jvmMemoryCheck() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"totalMemory: ", ", freeMemory: ", ", maxMemory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalMemory), BoxesRunTime.boxToLong((long)freeMemory), BoxesRunTime.boxToLong((long)maxMemory)}));
        return (double)freeMemory < (double)maxMemory * 0.05 ? Status$.MODULE$.recoverableError(message) : Status$.MODULE$.ok(message);
    }

    private final Status notAllValidated$lzycompute$1(ObjectRef notAllValidated$lzy$1, VolatileByteRef bitmap$0$1) {
        Health$ health$ = this;
        synchronized (health$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                notAllValidated$lzy$1.elem = Status$.MODULE$.warning("Not all TA's are validated.");
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Status)notAllValidated$lzy$1.elem;
        }
    }

    private final Status notAllValidated$1(ObjectRef notAllValidated$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.notAllValidated$lzycompute$1(notAllValidated$lzy$1, bitmap$0$1) : (Status)notAllValidated$lzy$1.elem;
    }

    private Health$() {
        MODULE$ = this;
        this.timeFormatter = ISODateTimeFormat.dateTimeNoMillis();
    }
}

