/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.config;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumSet;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator.api.RestApi;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncement;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementSet;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementSet$;
import net.ripe.rpki.validator.bgp.preview.BgpAnnouncementValidator;
import net.ripe.rpki.validator.bgp.preview.BgpRisDumpDownloader;
import net.ripe.rpki.validator.bgp.preview.BgpValidatedAnnouncement;
import net.ripe.rpki.validator.config.ApplicationOptions$;
import net.ripe.rpki.validator.config.Http;
import net.ripe.rpki.validator.config.Http$class;
import net.ripe.rpki.validator.config.Main$;
import net.ripe.rpki.validator.config.Main$$anon$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$;
import net.ripe.rpki.validator.config.Main$$anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$;
import net.ripe.rpki.validator.config.MemoryImage;
import net.ripe.rpki.validator.config.MemoryImage$;
import net.ripe.rpki.validator.config.PersistentData;
import net.ripe.rpki.validator.config.PersistentData$;
import net.ripe.rpki.validator.config.PersistentDataSerialiser$;
import net.ripe.rpki.validator.config.ReleaseInfo$;
import net.ripe.rpki.validator.config.WebFilter;
import net.ripe.rpki.validator.config.health.HealthServlet;
import net.ripe.rpki.validator.fetchers.FetcherConfig;
import net.ripe.rpki.validator.fetchers.FetcherConfig$;
import net.ripe.rpki.validator.fetchers.NotifyingCertificateRepositoryObjectFetcher;
import net.ripe.rpki.validator.lib.DateAndTime$DateTimeOrdering$;
import net.ripe.rpki.validator.lib.OnlineNewVersionDetailFetcher;
import net.ripe.rpki.validator.lib.UserPreferences;
import net.ripe.rpki.validator.models.Filters;
import net.ripe.rpki.validator.models.Idle;
import net.ripe.rpki.validator.models.IgnoreFilter;
import net.ripe.rpki.validator.models.ProcessingStatus;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.RtrPrefix;
import net.ripe.rpki.validator.models.TrustAnchor;
import net.ripe.rpki.validator.models.TrustAnchorData;
import net.ripe.rpki.validator.models.TrustAnchors;
import net.ripe.rpki.validator.models.TrustAnchors$;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.ValidatedObjects;
import net.ripe.rpki.validator.models.ValidatedObjects$;
import net.ripe.rpki.validator.models.Whitelist;
import net.ripe.rpki.validator.models.validation.RepoFetcher$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.TrackValidationProcess;
import net.ripe.rpki.validator.models.validation.TrackValidationProcess$class;
import net.ripe.rpki.validator.models.validation.TrustAnchorValidationProcess;
import net.ripe.rpki.validator.models.validation.ValidationProcess$class;
import net.ripe.rpki.validator.models.validation.ValidationProcessLogger$ObjectFetcherLogger$;
import net.ripe.rpki.validator.models.validation.ValidationProcessLogger$class;
import net.ripe.rpki.validator.rtr.RTRServer;
import net.ripe.rpki.validator.rtr.RtrSessionData;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.DurableCaches$;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.InTxnEnd;
import scala.concurrent.stm.MaybeTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$;
import scala.concurrent.stm.package$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;
import scalaz.Failure;
import scalaz.Success;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\t\u0005t!B\u0001\u0003\u0011\u0003i\u0011\u0001B'bS:T!a\u0001\u0003\u0002\r\r|gNZ5h\u0015\t)a!A\u0005wC2LG-\u0019;pe*\u0011q\u0001C\u0001\u0005eB\\\u0017N\u0003\u0002\n\u0015\u0005!!/\u001b9f\u0015\u0005Y\u0011a\u00018fi\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"\u0001B'bS:\u001c\"a\u0004\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011\u0015Ir\u0002\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\tQ\u0002C\u0004\u001d\u001f\t\u0007I\u0011B\u000f\u0002\u0013M,7o]5p]&#W#\u0001\u0010\u0011\u0005})cB\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\r\u0011HO]\u0005\u0003I\u0005\n1\u0001\u00153v\u0013\t1sEA\u0005TKN\u001c\u0018n\u001c8JI*\u0011A%\t\u0005\u0007S=\u0001\u000b\u0011\u0002\u0010\u0002\u0015M,7o]5p]&#\u0007\u0005C\u0003,\u001f\u0011\u0005A&\u0001\u0003nC&tGCA\u00171!\t\u0019b&\u0003\u00020)\t!QK\\5u\u0011\u0015\t$\u00061\u00013\u0003\u0011\t'oZ:\u0011\u0007M\u0019T'\u0003\u00025)\t)\u0011I\u001d:bsB\u0011aG\u0010\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!A\u000f\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0012BA\u001f\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\"\u0002\"\u0002\"\u0010\t\u0013\u0019\u0015\u0001D:fiV\u0004Hj\\4hS:<G#A\u0017\u0007\tA\u0011\u0001!R\n\u0005\tJ1\u0015\n\u0005\u0002\u000f\u000f&\u0011\u0001J\u0001\u0002\u0005\u0011R$\b\u000f\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006)1\u000f\u001c45U*\ta*\u0001\u0005he&T(\u0010\\3e\u0013\t\u00016JA\u0004M_\u001e<\u0017N\\4\t\u000be!E\u0011\u0001*\u0015\u0003M\u0003\"A\u0004#\t\u000fU#%\u0019!C\u0002-\u0006Y\u0011m\u0019;peNK8\u000f^3n+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0015\t7\r^8s\u0015\u0005a\u0016\u0001B1lW\u0006L!AX-\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\u0007A\u0012\u0003\u000b\u0011B,\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\t\u000f\t$%\u0019!C\u0001G\u0006I1\u000f^1si\u0016$\u0017\t^\u000b\u0002IB\u00111#Z\u0005\u0003MR\u0011A\u0001T8oO\"1\u0001\u000e\u0012Q\u0001\n\u0011\f!b\u001d;beR,G-\u0011;!\u0011\u001dQGI1A\u0005\u0002-\f1CY4q\u0003:tw.\u001e8dK6,g\u000e^*fiN,\u0012\u0001\u001c\t\u0004[J$X\"\u00018\u000b\u0005=\u0004\u0018aA:u[*\u0011\u0011\u000fF\u0001\u000bG>t7-\u001e:sK:$\u0018BA:o\u0005\r\u0011VM\u001a\t\u0004kbTX\"\u0001<\u000b\u0005]$\u0012AC2pY2,7\r^5p]&\u0011\u0011P\u001e\u0002\u0004'\u0016\f\bcA>\u0002\u00025\tAP\u0003\u0002~}\u00069\u0001O]3wS\u0016<(BA@\u0005\u0003\r\u0011w\r]\u0005\u0004\u0003\u0007a(A\u0005\"ha\u0006sgn\\;oG\u0016lWM\u001c;TKRDq!a\u0002EA\u0003%A.\u0001\u000bcOB\feN\\8v]\u000e,W.\u001a8u'\u0016$8\u000f\t\u0005\n\u0003\u0017!%\u0019!C\u0001\u0003\u001b\t\u0001DY4q\u0003:tw.\u001e8dK6,g\u000e\u001e,bY&$\u0017\r^8s+\t\ty\u0001E\u0002|\u0003#I1!a\u0005}\u0005a\u0011u\r]!o]>,hnY3nK:$h+\u00197jI\u0006$xN\u001d\u0005\t\u0003/!\u0005\u0015!\u0003\u0002\u0010\u0005I\"m\u001a9B]:|WO\\2f[\u0016tGOV1mS\u0012\fGo\u001c:!\u0011%\tY\u0002\u0012b\u0001\n\u0003\ti\"\u0001\u0005eCR\fg)\u001b7f+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0005%|'BAA\u0015\u0003\u0011Q\u0017M^1\n\t\u00055\u00121\u0005\u0002\u0005\r&dW\r\u0003\u0005\u00022\u0011\u0003\u000b\u0011BA\u0010\u0003%!\u0017\r^1GS2,\u0007\u0005C\u0005\u00026\u0011\u0013\r\u0011\"\u0001\u00028\u0005!A-\u0019;b+\t\tI\u0004E\u0002\u000f\u0003wI1!!\u0010\u0003\u00059\u0001VM]:jgR,g\u000e\u001e#bi\u0006D\u0001\"!\u0011EA\u0003%\u0011\u0011H\u0001\u0006I\u0006$\u0018\r\t\u0005\n\u0003\u000b\"%\u0019!C\u0001\u0003\u000f\nA\u0002\u001e:vgR\fen\u00195peN,\"!!\u0013\u0011\r\u0005-\u0013\u0011KA+\u001b\t\tiEC\u0002\u0002PY\f\u0011\"[7nkR\f'\r\\3\n\t\u0005M\u0013Q\n\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006B\u0001\u0007[>$W\r\\:\n\t\u0005}\u0013\u0011\f\u0002\f)J,8\u000f^!oG\"|'\u000f\u0003\u0005\u0002d\u0011\u0003\u000b\u0011BA%\u00035!(/^:u\u0003:\u001c\u0007n\u001c:tA!I\u0011q\r#C\u0002\u0013\u0005\u0011\u0011N\u0001\u0005e>\f7/\u0006\u0002\u0002lA!\u0011qKA7\u0013\u0011\ty'!\u0017\u0003!Y\u000bG.\u001b3bi\u0016$wJ\u00196fGR\u001c\b\u0002CA:\t\u0002\u0006I!a\u001b\u0002\u000bI|\u0017m\u001d\u0011\t\u000f\u0005]D\t\"\u0011\u0002\u001e\u0005!BO];ti\u0016$7)\u001a:ug2{7-\u0019;j_:D\u0011\"a\u001fE\u0005\u0004%\t!! \u0002\u001fU\u001cXM\u001d)sK\u001a,'/\u001a8dKN,\"!a \u0011\t5\u0014\u0018\u0011\u0011\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0003\u0002\u00071L'-\u0003\u0003\u0002\f\u0006\u0015%aD+tKJ\u0004&/\u001a4fe\u0016t7-Z:\t\u0011\u0005=E\t)A\u0005\u0003\u007f\n\u0001#^:feB\u0013XMZ3sK:\u001cWm\u001d\u0011\t\u0013\u0005MEI1A\u0005\u0002\u0005U\u0015\u0001\u00062haJK7\u000fR;na\u0012{wO\u001c7pC\u0012,'/\u0006\u0002\u0002\u0018B\u001910!'\n\u0007\u0005mEP\u0001\u000bCOB\u0014\u0016n\u001d#v[B$un\u001e8m_\u0006$WM\u001d\u0005\t\u0003?#\u0005\u0015!\u0003\u0002\u0018\u0006)\"m\u001a9SSN$U/\u001c9E_^tGn\\1eKJ\u0004\u0003\"CAR\t\n\u0007I\u0011AAS\u0003-iW-\\8ss&k\u0017mZ3\u0016\u0005\u0005\u001d\u0006\u0003B7s\u0003S\u00032ADAV\u0013\r\tiK\u0001\u0002\f\u001b\u0016lwN]=J[\u0006<W\r\u0003\u0005\u00022\u0012\u0003\u000b\u0011BAT\u00031iW-\\8ss&k\u0017mZ3!\u0011-\t)\f\u0012a\u0001\u0002\u0004%\t!a.\u0002\u000bM$xN]3\u0016\u0005\u0005e\u0006\u0003BA^\u0003\u007fk!!!0\u000b\u0007\u0005UF!\u0003\u0003\u0002B\u0006u&AC\"bG\",7\u000b^8sK\"Y\u0011Q\u0019#A\u0002\u0003\u0007I\u0011AAd\u0003%\u0019Ho\u001c:f?\u0012*\u0017\u000fF\u0002.\u0003\u0013D!\"a3\u0002D\u0006\u0005\t\u0019AA]\u0003\rAH%\r\u0005\t\u0003\u001f$\u0005\u0015)\u0003\u0002:\u000611\u000f^8sK\u0002Bq!a5E\t\u0003\t).A\tva\u0012\fG/Z'f[>\u0014\u00180S7bO\u0016$B!a6\u0002dR\u0019Q&!7\t\u0011\u0005m\u0017\u0011\u001ba\u0002\u0003;\f1\u0002\u001e:b]N\f7\r^5p]B\u0019Q.a8\n\u0007\u0005\u0005hN\u0001\u0005NCf\u0014W\r\u0016=o\u0011!\t)/!5A\u0002\u0005\u001d\u0018!\u00014\u0011\u000fM\tI/!+\u0002*&\u0019\u00111\u001e\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"CAx\t\n\u0007I\u0011AAy\u0003%\u0011HO]*feZ,'/\u0006\u0002\u0002tB\u0019\u0001%!>\n\u0007\u0005]\u0018EA\u0005S)J\u001bVM\u001d<fe\"A\u00111 #!\u0002\u0013\t\u00190\u0001\u0006siJ\u001cVM\u001d<fe\u0002Bq!a@E\t\u0013\u0011\t!\u0001\tm_\u0006$GK];ti\u0006s7\r[8sgR\u0011!1\u0001\t\u0005\u0003/\u0012)!\u0003\u0003\u0003\b\u0005e#\u0001\u0004+skN$\u0018I\\2i_J\u001c\bB\u0002B\u0006\t\u0012%1)A\bsK\u001a\u0014Xm\u001d5SSN$U/\u001c9t\u0011\u001d\u0011y\u0001\u0012C\u0005\u0005#\tAB];o-\u0006d\u0017\u000eZ1u_J$2!\fB\n\u0011!\u0011)B!\u0004A\u0002\t]\u0011!\u00044pe\u000e,g*Z<GKR\u001c\u0007\u000eE\u0002\u0014\u00053I1Aa\u0007\u0015\u0005\u001d\u0011un\u001c7fC:DqAa\u0004E\t\u0013\u0011y\u0002F\u0003.\u0005C\u0011\t\u0004\u0003\u0005\u0003$\tu\u0001\u0019\u0001B\u0013\u0003A!(/^:u\u0003:\u001c\u0007n\u001c:OC6,7\u000fE\u0003\u0003(\t5RGD\u00028\u0005SI1Aa\u000b\u0015\u0003\u001d\u0001\u0018mY6bO\u0016L1!\u001fB\u0018\u0015\r\u0011Y\u0003\u0006\u0005\t\u0005+\u0011i\u00021\u0001\u0003\u0018!1!Q\u0007#\u0005\n\r\u000bAB];o/\u0016\u00147+\u001a:wKJDqA!\u000fE\t\u0013\u0011Y$\u0001\u0007sk:\u0014FO]*feZ,'\u000f\u0006\u0002\u0002t\"9!q\b#\u0005\n\t\u0005\u0013!B:fiV\u0004H\u0003\u0002B\"\u00057\u0002BA!\u0012\u0003X5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%\u0001\u0004tKJ4XM\u001d\u0006\u0005\u0005\u001b\u0012y%A\u0003kKR$\u0018P\u0003\u0003\u0003R\tM\u0013aB3dY&\u00048/\u001a\u0006\u0003\u0005+\n1a\u001c:h\u0013\u0011\u0011IFa\u0012\u0003\rM+'O^3s\u0011!\u0011IE!\u0010A\u0002\t\r\u0003B\u0002B0\t\u0012%1)\u0001\nxSB,'k]=oG\u0012K7o[\"bG\",\u0007")
public class Main
implements Http,
Logging {
    private final ActorSystem actorSystem;
    private final long startedAt;
    private final Ref<Seq<BgpAnnouncementSet>> bgpAnnouncementSets;
    private final BgpAnnouncementValidator bgpAnnouncementValidator;
    private final File dataFile;
    private final PersistentData data;
    private final List<TrustAnchor> trustAnchors;
    private final ValidatedObjects roas;
    private final Ref<UserPreferences> userPreferences;
    private final BgpRisDumpDownloader bgpRisDumpDownloader;
    private final Ref<MemoryImage> memoryImage;
    private CacheStore store;
    private final RTRServer rtrServer;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private final KeyStore net$ripe$rpki$validator$config$Http$$customKeyStore;
    private final X509Certificate[] net$ripe$rpki$validator$config$Http$$systemTrustedCertificates;
    private final RequestConfig net$ripe$rpki$validator$config$Http$$httpRequestConfig;
    private final SSLContext net$ripe$rpki$validator$config$Http$$customSslContext;
    private final CloseableHttpClient net$ripe$rpki$validator$config$Http$$httpClient;
    private final CloseableHttpClient net$ripe$rpki$validator$config$Http$$wrongSslHttp;
    private Set<String> net$ripe$rpki$validator$config$Http$$invalidSslHosts;
    private volatile byte bitmap$0;

    public static void main(String[] stringArray) {
        Main$.MODULE$.main(stringArray);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Main main = this;
        synchronized (main) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    @Override
    public KeyStore net$ripe$rpki$validator$config$Http$$customKeyStore() {
        return this.net$ripe$rpki$validator$config$Http$$customKeyStore;
    }

    @Override
    public X509Certificate[] net$ripe$rpki$validator$config$Http$$systemTrustedCertificates() {
        return this.net$ripe$rpki$validator$config$Http$$systemTrustedCertificates;
    }

    @Override
    public RequestConfig net$ripe$rpki$validator$config$Http$$httpRequestConfig() {
        return this.net$ripe$rpki$validator$config$Http$$httpRequestConfig;
    }

    @Override
    public SSLContext net$ripe$rpki$validator$config$Http$$customSslContext() {
        return this.net$ripe$rpki$validator$config$Http$$customSslContext;
    }

    @Override
    public CloseableHttpClient net$ripe$rpki$validator$config$Http$$httpClient() {
        return this.net$ripe$rpki$validator$config$Http$$httpClient;
    }

    private CloseableHttpClient net$ripe$rpki$validator$config$Http$$wrongSslHttp$lzycompute() {
        Main main = this;
        synchronized (main) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.net$ripe$rpki$validator$config$Http$$wrongSslHttp = Http$class.net$ripe$rpki$validator$config$Http$$wrongSslHttp(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.net$ripe$rpki$validator$config$Http$$wrongSslHttp;
        }
    }

    @Override
    public CloseableHttpClient net$ripe$rpki$validator$config$Http$$wrongSslHttp() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.net$ripe$rpki$validator$config$Http$$wrongSslHttp$lzycompute() : this.net$ripe$rpki$validator$config$Http$$wrongSslHttp;
    }

    @Override
    public Set<String> net$ripe$rpki$validator$config$Http$$invalidSslHosts() {
        return this.net$ripe$rpki$validator$config$Http$$invalidSslHosts;
    }

    @Override
    @TraitSetter
    public void net$ripe$rpki$validator$config$Http$$invalidSslHosts_$eq(Set<String> x$1) {
        this.net$ripe$rpki$validator$config$Http$$invalidSslHosts = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customKeyStore_$eq(KeyStore x$1) {
        this.net$ripe$rpki$validator$config$Http$$customKeyStore = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$systemTrustedCertificates_$eq(X509Certificate[] x$1) {
        this.net$ripe$rpki$validator$config$Http$$systemTrustedCertificates = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpRequestConfig_$eq(RequestConfig x$1) {
        this.net$ripe$rpki$validator$config$Http$$httpRequestConfig = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$customSslContext_$eq(SSLContext x$1) {
        this.net$ripe$rpki$validator$config$Http$$customSslContext = x$1;
    }

    @Override
    public void net$ripe$rpki$validator$config$Http$_setter_$net$ripe$rpki$validator$config$Http$$httpClient_$eq(CloseableHttpClient x$1) {
        this.net$ripe$rpki$validator$config$Http$$httpClient = x$1;
    }

    @Override
    public CloseableHttpClient http() {
        return Http$class.http(this);
    }

    @Override
    public CloseableHttpResponse httpGet(String url) {
        return Http$class.httpGet(this, url);
    }

    @Override
    public CloseableHttpResponse httpGetIfNotModified(String url, Option<DateTime> ifModifiedSince) {
        return Http$class.httpGetIfNotModified(this, url, ifModifiedSince);
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public long startedAt() {
        return this.startedAt;
    }

    public Ref<Seq<BgpAnnouncementSet>> bgpAnnouncementSets() {
        return this.bgpAnnouncementSets;
    }

    public BgpAnnouncementValidator bgpAnnouncementValidator() {
        return this.bgpAnnouncementValidator;
    }

    public File dataFile() {
        return this.dataFile;
    }

    public PersistentData data() {
        return this.data;
    }

    public List<TrustAnchor> trustAnchors() {
        return this.trustAnchors;
    }

    public ValidatedObjects roas() {
        return this.roas;
    }

    @Override
    public File trustedCertsLocation() {
        return ApplicationOptions$.MODULE$.trustedSslCertsLocation();
    }

    public Ref<UserPreferences> userPreferences() {
        return this.userPreferences;
    }

    public BgpRisDumpDownloader bgpRisDumpDownloader() {
        return this.bgpRisDumpDownloader;
    }

    public Ref<MemoryImage> memoryImage() {
        return this.memoryImage;
    }

    public CacheStore store() {
        return this.store;
    }

    public void store_$eq(CacheStore x$1) {
        this.store = x$1;
    }

    public void updateMemoryImage(Function1<MemoryImage, MemoryImage> f, MaybeTxn transaction) {
        package$.MODULE$.atomic().apply((Function1)new Serializable(this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Function1 f$1;

            public final void apply(InTxn transaction) {
                int oldVersion = ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version();
                this.$outer.memoryImage().transform(this.f$1, (Object)transaction);
                int newVersion = ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).version();
                Seq bgpAnnouncements = (Seq)((TraversableLike)this.$outer.bgpAnnouncementSets().apply((Object)transaction)).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<BgpAnnouncement> apply(BgpAnnouncementSet x$3) {
                        return x$3.entries();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq<RtrPrefix> distinctRtrPrefixes = ((MemoryImage)this.$outer.memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes();
                Txn$.MODULE$.afterCommit((Function1)new Serializable(this, oldVersion, newVersion, bgpAnnouncements, distinctRtrPrefixes){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$updateMemoryImage$1 $outer;
                    private final int oldVersion$1;
                    private final int newVersion$1;
                    private final Seq bgpAnnouncements$1;
                    private final Seq distinctRtrPrefixes$1;

                    public final void apply(Txn.Status x$4) {
                        if (this.oldVersion$1 != this.newVersion$1) {
                            this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)this.bgpAnnouncements$1, (Seq<RtrPrefix>)this.distinctRtrPrefixes$1.toSeq());
                            this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().rtrServer().notify(this.newVersion$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.oldVersion$1 = oldVersion$1;
                        this.newVersion$1 = newVersion$1;
                        this.bgpAnnouncements$1 = bgpAnnouncements$1;
                        this.distinctRtrPrefixes$1 = distinctRtrPrefixes$1;
                    }
                }, (InTxnEnd)transaction);
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        }, transaction);
    }

    public RTRServer rtrServer() {
        return this.rtrServer;
    }

    private TrustAnchors loadTrustAnchors() {
        Collection tals = FileUtils.listFiles((File)ApplicationOptions$.MODULE$.talDirLocation(), (String[])((String[])((Object[])new String[]{"tal"})), (boolean)false);
        return TrustAnchors$.MODULE$.load((Seq<File>)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tals).asScala()).toSeq());
    }

    public void net$ripe$rpki$validator$config$Main$$refreshRisDumps() {
        Future$.MODULE$.traverse((TraversableOnce)this.bgpAnnouncementSets().single().get(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Future<BgpAnnouncementSet> apply(BgpAnnouncementSet dump) {
                return this.$outer.bgpRisDumpDownloader().download(dump, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.actorSystem().dispatcher()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply(Seq<BgpAnnouncementSet> dumps) {
                package$.MODULE$.atomic().apply((Function1)new Serializable(this, dumps){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$refreshRisDumps$2 $outer;
                    private final Seq dumps$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementSets().update((Object)this.dumps$1, (Object)transaction);
                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementValidator().startUpdate((Seq<BgpAnnouncement>)((Seq)((TraversableLike)this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().bgpAnnouncementSets().apply((Object)transaction)).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<BgpAnnouncement> apply(BgpAnnouncementSet x$5) {
                                return x$5.entries();
                            }
                        }, Seq$.MODULE$.canBuildFrom())), ((MemoryImage)this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage().apply((Object)transaction)).getDistinctRtrPrefixes());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dumps$1 = dumps$1;
                    }
                }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator(boolean forceNewFetch) {
        DateTime now = new DateTime();
        List needUpdating = (List)((TraversableLike)((MemoryImage)this.memoryImage().single().get()).trustAnchors().all().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TrustAnchor ta) {
                return ta.status().isIdle();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TrustAnchor, Idle> apply(TrustAnchor ta) {
                ProcessingStatus processingStatus = ta.status();
                if (processingStatus instanceof Idle) {
                    Tuple2 tuple2;
                    Idle idle = (Idle)processingStatus;
                    DateTime nextUpdate = idle.nextUpdate();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)idle, (Object)nextUpdate);
                    Idle x$6 = (Idle)tuple22._1();
                    DateTime nextUpdate2 = (DateTime)tuple22._2();
                    return new Tuple2((Object)ta, (Object)x$6);
                }
                throw new MatchError((Object)processingStatus);
            }
        }, List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final DateTime now$1;

            public final boolean apply(Tuple2<TrustAnchor, Idle> x$8) {
                Idle idle;
                Tuple2<TrustAnchor, Idle> tuple2 = x$8;
                if (tuple2 != null && (idle = (Idle)tuple2._2()) != null) {
                    DateTime nextUpdate = idle.nextUpdate();
                    boolean bl = Ordering.Implicits$.MODULE$.infixOrderingOps((Object)nextUpdate, (Ordering)DateAndTime$DateTimeOrdering$.MODULE$).$less$eq((Object)this.now$1);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.now$1 = now$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TrustAnchor, Idle> x$9) {
                Tuple2<TrustAnchor, Idle> tuple2 = x$9;
                if (tuple2 != null) {
                    TrustAnchor ta = (TrustAnchor)tuple2._1();
                    Idle idle = (Idle)tuple2._2();
                    if (idle != null) {
                        String string = ta.name();
                        return string;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom());
        this.net$ripe$rpki$validator$config$Main$$runValidator((Seq<String>)needUpdating, forceNewFetch);
    }

    public void net$ripe$rpki$validator$config$Main$$runValidator(Seq<String> trustAnchorNames, boolean forceNewFetch) {
        int maxStaleDays = ((UserPreferences)this.userPreferences().single().get()).maxStaleDays();
        List<TrustAnchor> trustAnchors = ((MemoryImage)this.memoryImage().single().get()).trustAnchors().all();
        Seq taLocators = (Seq)trustAnchorNames.flatMap((Function1)new Serializable(this, trustAnchors){
            public static final long serialVersionUID = 0L;
            private final List trustAnchors$1;

            public final Iterable<TrustAnchor> apply(String name) {
                return Option$.MODULE$.option2Iterable(this.trustAnchors$1.find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(TrustAnchor x$10) {
                        String string = x$10.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }));
            }
            {
                this.trustAnchors$1 = trustAnchors$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.store_$eq(DurableCaches$.MODULE$.apply(ApplicationOptions$.MODULE$.workDirLocation()));
        taLocators.foreach((Function1)new Serializable(this, forceNewFetch, maxStaleDays){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            public final boolean forceNewFetch$1;
            public final int maxStaleDays$1;

            public final Future<BoxedUnit> apply(TrustAnchor trustAnchorLocator) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, trustAnchorLocator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 $outer;
                    public final TrustAnchor trustAnchorLocator$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        RepoService repoService = new RepoService(RepoFetcher$.MODULE$.apply(ApplicationOptions$.MODULE$.workDirLocation(), new FetcherConfig(ApplicationOptions$.MODULE$.rsyncDirLocation(), FetcherConfig$.MODULE$.apply$default$2())));
                        TrackValidationProcess process = new TrackValidationProcess(this, repoService){
                            private final Ref<MemoryImage> memoryImage;
                            private volatile ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            private ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() {
                                $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1$$anon$4 var1_1 = this;
                                synchronized (var1_1) {
                                    if (this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module != null) return this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                    this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module = new ValidationProcessLogger$ObjectFetcherLogger$(this);
                                    return this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module;
                                }
                            }

                            public final ValidationProcessLogger$ObjectFetcherLogger$ net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger() {
                                return this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module == null ? this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$lzycompute() : this.net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$ObjectFetcherLogger$module;
                            }

                            public Seq net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$super$objectFetcherListeners() {
                                return ValidationProcess$class.objectFetcherListeners(this);
                            }

                            public Seq net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant validationStart) {
                                return TrackValidationProcess$class.validateObjects(this, certificate, forceNewFetch, validationStart);
                            }

                            public PartialFunction net$ripe$rpki$validator$models$validation$ValidationProcessLogger$$super$exceptionHandler() {
                                return ValidationProcess$class.exceptionHandler(this);
                            }

                            public Seq<NotifyingCertificateRepositoryObjectFetcher.Listener> objectFetcherListeners() {
                                return ValidationProcessLogger$class.objectFetcherListeners(this);
                            }

                            public Seq<ValidatedObject> validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant validationStart) {
                                return ValidationProcessLogger$class.validateObjects(this, certificate, forceNewFetch, validationStart);
                            }

                            public PartialFunction<Throwable, Validation<String, Nothing$>> exceptionHandler() {
                                return ValidationProcessLogger$class.exceptionHandler(this);
                            }

                            public Validation net$ripe$rpki$validator$models$validation$TrackValidationProcess$$super$runProcess(boolean forceNewFetch) {
                                return ValidationProcess$class.runProcess(this, forceNewFetch);
                            }

                            public Seq net$ripe$rpki$validator$models$validation$TrackValidationProcess$$super$validateObjects(CertificateRepositoryObjectValidationContext certificate, boolean forceNewFetch, Instant validationStart) {
                                return super.validateObjects(certificate, forceNewFetch, validationStart);
                            }

                            public Validation<String, Seq<ValidatedObject>> runProcess(boolean forceNewFetch) {
                                return TrackValidationProcess$class.runProcess(this, forceNewFetch);
                            }

                            public Ref<MemoryImage> memoryImage() {
                                return this.memoryImage;
                            }
                            {
                                super($outer.trustAnchorLocator$1.locator(), $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().net$ripe$rpki$validator$config$Main$$anonfun$$$outer().store(), repoService$1, $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().maxStaleDays$1, $outer.trustAnchorLocator$1.name(), ApplicationOptions$.MODULE$.enableLooseValidation());
                                TrackValidationProcess$class.$init$(this);
                                ValidationProcessLogger$class.$init$(this);
                                this.memoryImage = $outer.net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer().net$ripe$rpki$validator$config$Main$$anonfun$$$outer().memoryImage();
                            }
                        };
                        try {
                            Validation<String, Seq<ValidatedObject>> validation;
                            block8: {
                                block7: {
                                    block6: {
                                        validation = ((TrackValidationProcess)process).runProcess(this.$outer.forceNewFetch$1);
                                        if (!(validation instanceof Success)) break block6;
                                        Success success = (Success)validation;
                                        Seq validatedObjects = (Seq)success.a();
                                        this.$outer.net$ripe$rpki$validator$config$Main$$anonfun$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this, validatedObjects){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1$$anonfun$apply$1 $outer;
                                            private final Seq validatedObjects$1;

                                            public final MemoryImage apply(MemoryImage x$11) {
                                                return x$11.updateValidatedObjects(this.$outer.trustAnchorLocator$1.locator(), (Seq<ValidatedObject>)this.validatedObjects$1);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.validatedObjects$1 = validatedObjects$1;
                                            }
                                        }, (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block7;
                                    }
                                    if (!(validation instanceof Failure)) break block8;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new MatchError(validation);
                        }
                        finally {
                            ((TrustAnchorValidationProcess)((Object)process)).shutdown();
                        }
                    }

                    public /* synthetic */ $anonfun$net$ripe$rpki$validator$config$Main$$runValidator$1 net$ripe$rpki$validator$config$Main$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.trustAnchorLocator$1 = trustAnchorLocator$1;
                    }
                }, (ExecutionContext)this.$outer.actorSystem().dispatcher());
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.forceNewFetch$1 = forceNewFetch$1;
                this.maxStaleDays$1 = maxStaleDays$1;
            }
        });
    }

    private void runWebServer() {
        Server server = this.setup(new Server(ApplicationOptions$.MODULE$.httpPort()));
        scala.sys.package$.MODULE$.addShutdownHook((Function0)new Serializable(this, server){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;
            private final Server server$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.server$1.stop();
                this.$outer.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Terminating...";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.server$1 = server$1;
            }
        });
        server.start();
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Welcome to the RIPE NCC RPKI Validator, now available on port ").append((Object)BoxesRunTime.boxToInteger((int)ApplicationOptions$.MODULE$.httpPort())).append((Object)". Hit CTRL+C to terminate.").toString();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private RTRServer runRtrServer() {
        void var1_1;
        RTRServer rtrServer = new RTRServer(ApplicationOptions$.MODULE$.rtrPort(), ApplicationOptions$.MODULE$.rtrCloseOnError(), ApplicationOptions$.MODULE$.rtrSendNotify(), (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).version();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Seq<RtrPrefix>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final Seq<RtrPrefix> apply() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply() {
                return this.apply$mcS$sp();
            }

            public short apply$mcS$sp() {
                return Main$.MODULE$.net$ripe$rpki$validator$config$Main$$sessionId();
            }
        }, (Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors().hasEnabledAnchors();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        rtrServer.startServer();
        return var1_1;
    }

    private Server setup(Server server) {
        WebFilter webFilter = new WebFilter(this){
            private final Object dataFileLock;
            private final /* synthetic */ Main $outer;

            private Object dataFileLock() {
                return this.dataFileLock;
            }

            private void updateAndPersist(Function1<InTxn, BoxedUnit> f) {
                Object object = this.dataFileLock();
                synchronized (object) {
                    Tuple2 tuple2 = (Tuple2)package$.MODULE$.atomic().apply((Function1)new $anon$1$$anonfun$18(this, f), (MaybeTxn)MaybeTxn$.MODULE$.unknown());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        MemoryImage image = (MemoryImage)tuple2._1();
                        UserPreferences userPreferences = (UserPreferences)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)image, (Object)userPreferences);
                        MemoryImage image2 = (MemoryImage)tuple23._1();
                        UserPreferences userPreferences2 = (UserPreferences)tuple23._2();
                        Filters x$25 = image2.filters();
                        Whitelist x$26 = image2.whitelist();
                        UserPreferences x$27 = userPreferences2;
                        Map x$28 = (Map)image2.trustAnchors().all().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<String, TrustAnchorData> apply(TrustAnchor ta) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ta.name()), (Object)new TrustAnchorData(ta.enabled()));
                            }
                        }, scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
                        int x$29 = PersistentData$.MODULE$.apply$default$1();
                        PersistentDataSerialiser$.MODULE$.write(new PersistentData(x$29, x$25, x$26, x$27, (Map<String, TrustAnchorData>)x$28), this.$outer.dataFile());
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                }
            }

            public void startTrustAnchorValidation(Seq<String> trustAnchors) {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator(trustAnchors, true);
            }

            public TrustAnchors trustAnchors() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors();
            }

            public ValidatedObjects validatedObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).validatedObjects();
            }

            public Filters filters() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).filters();
            }

            public void addFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$13) {
                                return x$13.addFilter(this.$outer.filter$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$1 = filter$1;
                    }
                });
            }

            public void removeFilter(IgnoreFilter filter2) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final IgnoreFilter filter$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeFilter$1 $outer;

                            public final MemoryImage apply(MemoryImage x$14) {
                                return x$14.removeFilter(this.$outer.filter$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.filter$2 = filter$2;
                    }
                });
            }

            public Whitelist whitelist() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).whitelist();
            }

            public void addWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$addWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$15) {
                                return x$15.addWhitelistEntry(this.$outer.entry$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                });
            }

            public void removeWhitelistEntry(RtrPrefix entry) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final RtrPrefix entry$2;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().updateMemoryImage((Function1<MemoryImage, MemoryImage>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$removeWhitelistEntry$1 $outer;

                            public final MemoryImage apply(MemoryImage x$16) {
                                return x$16.removeWhitelistEntry(this.$outer.entry$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (MaybeTxn)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.entry$2 = entry$2;
                    }
                });
            }

            public Seq<BgpAnnouncementSet> bgpAnnouncementSet() {
                return (Seq)this.$outer.bgpAnnouncementSets().single().get();
            }

            public IndexedSeq<BgpValidatedAnnouncement> validatedAnnouncements() {
                return this.$outer.bgpAnnouncementValidator().validatedAnnouncements();
            }

            public Seq<RtrPrefix> getRtrPrefixes() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }

            public Iterable<RtrSessionData> sessionData() {
                return this.$outer.rtrServer().rtrSessions().allClientData();
            }

            public OnlineNewVersionDetailFetcher newVersionDetailFetcher() {
                return new OnlineNewVersionDetailFetcher(ReleaseInfo$.MODULE$.version(), (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final String apply() {
                        CloseableHttpResponse response = this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().httpGet("https://lirportal.ripe.net/certification/content/static/validator/latest-version.properties");
                        return Source$.MODULE$.fromInputStream(response.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public UserPreferences userPreferences() {
                return (UserPreferences)this.$outer.userPreferences().single().get();
            }

            public void updateUserPreferences(UserPreferences userPreferences) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, userPreferences){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    private final UserPreferences userPreferences$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().userPreferences().set((Object)this.userPreferences$1, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.userPreferences$1 = userPreferences$1;
                    }
                });
            }

            public void updateTrustAnchorState(TrustAnchorLocator locator, boolean enabled) {
                this.updateAndPersist((Function1<InTxn, BoxedUnit>)new Serializable(this, locator, enabled){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;
                    public final TrustAnchorLocator locator$1;
                    public final boolean enabled$1;

                    public final void apply(InTxn transaction) {
                        this.$outer.net$ripe$rpki$validator$config$Main$$anon$$$outer().memoryImage().transform((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1$$anonfun$updateTrustAnchorState$1 $outer;

                            public final MemoryImage apply(MemoryImage x$17) {
                                return x$17.updateTrustAnchorState(this.$outer.locator$1, this.$outer.enabled$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, (Object)transaction);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                        this.enabled$1 = enabled$1;
                    }
                });
            }

            public /* synthetic */ Main net$ripe$rpki$validator$config$Main$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataFileLock = new Object();
            }
        };
        RestApi restApiServlet = new RestApi(this){
            private final /* synthetic */ Main $outer;

            public Seq<RtrPrefix> getVrpObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).getDistinctRtrPrefixes();
            }

            public Seq<RepositoryObject<? extends CertificateRepositoryObject>> getCachedObjects() {
                return this.$outer.store().getAllObjects();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        HealthServlet healthServlet = new HealthServlet(this){
            private final /* synthetic */ Main $outer;

            public ValidatedObjects getValidatedObjects() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).validatedObjects();
            }

            public TrustAnchors getTrustAnchors() {
                return ((MemoryImage)this.$outer.memoryImage().single().get()).trustAnchors();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/", 1);
        root.setResourceBase(this.getClass().getResource("/public").toString());
        ServletHolder defaultServletHolder = new ServletHolder((Servlet)new DefaultServlet());
        defaultServletHolder.setName("default");
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        root.addServlet(defaultServletHolder, "/*");
        root.addServlet(new ServletHolder((Servlet)restApiServlet), "/api/*");
        root.addServlet(new ServletHolder((Servlet)healthServlet), "/health");
        root.addFilter(new FilterHolder((Filter)webFilter), "/*", EnumSet.allOf(DispatcherType.class));
        RequestLogHandler handler = new RequestLogHandler();
        NCSARequestLog requestLog = new NCSARequestLog(ApplicationOptions$.MODULE$.accessLogFileName());
        requestLog.setAppend(true);
        requestLog.setExtended(true);
        requestLog.setLogLatency(true);
        requestLog.setPreferProxiedForAddress(true);
        requestLog.setRetainDays(90);
        handler.setRequestLog((RequestLog)requestLog);
        RequestLogHandler requestLogHandler = handler;
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)root);
        handlers.addHandler((Handler)requestLogHandler);
        server.setHandler((Handler)handlers);
        return server;
    }

    private void wipeRsyncDiskCache() {
        File diskCache = new File(ApplicationOptions$.MODULE$.rsyncDirLocation());
        if (diskCache.isDirectory()) {
            FileUtils.cleanDirectory((File)diskCache);
        }
    }

    public Main() {
        Http$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.actorSystem = ActorSystem$.MODULE$.apply();
        this.startedAt = System.currentTimeMillis();
        this.logger().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Prefer RRDP=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)ApplicationOptions$.MODULE$.preferRrdp())}));
            }
        });
        this.bgpAnnouncementSets = Ref$.MODULE$.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BgpAnnouncementSet[]{new BgpAnnouncementSet("http://www.ris.ripe.net/dumps/riswhoisdump.IPv4.gz", BgpAnnouncementSet$.MODULE$.apply$default$2(), BgpAnnouncementSet$.MODULE$.apply$default$3()), new BgpAnnouncementSet("http://www.ris.ripe.net/dumps/riswhoisdump.IPv6.gz", BgpAnnouncementSet$.MODULE$.apply$default$2(), BgpAnnouncementSet$.MODULE$.apply$default$3())})), (OptManifest)ClassManifestFactory$.MODULE$.classType(Seq.class, (OptManifest)ClassManifestFactory$.MODULE$.classType(BgpAnnouncementSet.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])));
        this.bgpAnnouncementValidator = new BgpAnnouncementValidator(this.actorSystem());
        this.dataFile = ApplicationOptions$.MODULE$.dataFileLocation();
        this.data = (PersistentData)PersistentDataSerialiser$.MODULE$.read(this.dataFile()).getOrElse((Function0)new $anonfun$7(this));
        this.trustAnchors = (List)this.loadTrustAnchors().all().map((Function1)new $anonfun$8(this), List$.MODULE$.canBuildFrom());
        this.roas = ValidatedObjects$.MODULE$.apply(new TrustAnchors((Seq<TrustAnchor>)((Seq)this.trustAnchors().filter((Function1)new $anonfun$10(this)))));
        this.userPreferences = Ref$.MODULE$.apply((Object)this.data().userPreferences(), (OptManifest)ClassManifestFactory$.MODULE$.classType(UserPreferences.class));
        this.bgpRisDumpDownloader = new BgpRisDumpDownloader((HttpClient)this.http());
        this.memoryImage = Ref$.MODULE$.apply((Object)new MemoryImage(this.data().filters(), this.data().whitelist(), new TrustAnchors((Seq<TrustAnchor>)this.trustAnchors()), this.roas(), MemoryImage$.MODULE$.apply$default$5()), (OptManifest)ClassManifestFactory$.MODULE$.classType(MemoryImage.class));
        this.wipeRsyncDiskCache();
        this.rtrServer = this.runRtrServer();
        this.runWebServer();
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$runValidator(false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
        this.actorSystem().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).hours(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Main $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$config$Main$$refreshRisDumps();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.actorSystem().dispatcher());
    }
}

