/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.store;

import java.math.BigInteger;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsTest;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsTest;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.crl.X509CrlTest;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.CertificateObject$;
import net.ripe.rpki.validator.models.validation.CrlObject;
import net.ripe.rpki.validator.models.validation.CrlObject$;
import net.ripe.rpki.validator.models.validation.Hashing;
import net.ripe.rpki.validator.models.validation.ManifestObject;
import net.ripe.rpki.validator.models.validation.ManifestObject$;
import net.ripe.rpki.validator.models.validation.RepositoryObject;
import net.ripe.rpki.validator.models.validation.RoaObject;
import net.ripe.rpki.validator.models.validation.RoaObject$;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.store.CacheStoreTest$;
import net.ripe.rpki.validator.store.CacheStoreTest$$anonfun$6$;
import net.ripe.rpki.validator.store.DataSources$;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import org.joda.time.Instant;
import org.junit.runner.RunWith;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.enablers.Length$;
import org.scalatest.enablers.Size$;
import org.scalatest.junit.JUnitRunner;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.parallel.immutable.ParSeq;
import scala.collection.parallel.immutable.ParSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011abQ1dQ\u0016\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\nm\u0006d\u0017\u000eZ1u_JT!a\u0002\u0005\u0002\tI\u00048.\u001b\u0006\u0003\u0013)\tAA]5qK*\t1\"A\u0002oKR\u001c\u0001a\u0005\u0003\u0001\u001dQa\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u001d\u0019X\u000f\u001d9peRL!a\u0005\t\u0003#Y\u000bG.\u001b3bi>\u0014H+Z:u\u0007\u0006\u001cX\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005I1oY1mCR,7\u000f\u001e\u0006\u00023\u0005\u0019qN]4\n\u0005m1\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n!B^1mS\u0012\fG/[8o\u0015\t\tC!\u0001\u0004n_\u0012,Gn]\u0005\u0003Gy\u0011q\u0001S1tQ&tw\rC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0005!9!\u0006\u0001b\u0001\n\u0013Y\u0013\u0001E7f[>\u0014\u0018\u0010R1uCN{WO]2f+\u0005a\u0003CA\u00175\u001b\u0005q#BA\u00181\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003cI\nAA\u001b3cG*\u00111\u0007G\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011QG\f\u0002\u0018\tJLg/\u001a:NC:\fw-\u001a:ECR\f7k\\;sG\u0016Daa\u000e\u0001!\u0002\u0013a\u0013!E7f[>\u0014\u0018\u0010R1uCN{WO]2fA!91\u0001\u0001b\u0001\n\u0013IT#\u0001\u001e\u0011\u0005!Z\u0014B\u0001\u001f\u0003\u0005)\u0019\u0015m\u00195f'R|'/\u001a\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001e\u0002\rM$xN]3!\u0011\u001d\u0001\u0005A1A\u0005\u0002\u0005\u000bq\u0001^3ti\u000e\u0013H.F\u0001C!\t\u0019%*D\u0001E\u0015\t)e)A\u0002de2T!a\u0012%\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\tIe!A\u0004d_6lwN\\:\n\u0005-#%a\u0002-6ae\u001a%\u000f\u001c\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\"\u0002\u0011Q,7\u000f^\"sY\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+\u0001\u0007uKN$X*\u00198jM\u0016\u001cH/F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0005nC:Lg-Z:u\u0015\t1f)A\u0002d[NL!\u0001W*\u0003\u00175\u000bg.\u001b4fgR\u001cUn\u001d\u0005\u00075\u0002\u0001\u000b\u0011B)\u0002\u001bQ,7\u000f^'b]&4Wm\u001d;!\u0011\u001da\u0006A1A\u0005\u0002A\u000bQ\u0002^3ti6\u000bg.\u001b4fgR\f\u0004B\u00020\u0001A\u0003%\u0011+\u0001\buKN$X*\u00198jM\u0016\u001cH/\r\u0011\t\u000f\u0001\u0004!\u0019!C\u0001C\u00069A/Z:u%>\fW#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015,\u0016a\u0001:pC&\u0011q\r\u001a\u0002\u0007%>\f7)\\:\t\r%\u0004\u0001\u0015!\u0003c\u0003!!Xm\u001d;S_\u0006\u0004\u0003bB6\u0001\u0005\u0004%\t\u0001\\\u0001\u0010i\u0016\u001cHoQ3si&4\u0017nY1uKV\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002q\r\u0006A\u00010\u000e\u0019:G\u0016\u0014H/\u0003\u0002s_\n9\u0002,\u000e\u0019:%\u0016\u001cx.\u001e:dK\u000e+'\u000f^5gS\u000e\fG/\u001a\u0005\u0007i\u0002\u0001\u000b\u0011B7\u0002!Q,7\u000f^\"feRLg-[2bi\u0016\u0004\u0003\u0006\u0002\u0001w}~\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\rI,hN\\3s\u0015\tY\b$A\u0003kk:LG/\u0003\u0002~q\n9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u0001!\u0011\t\u0019!a\u0002\u000e\u0005\u0005\u0015!BA>\u0017\u0013\u0011\tI!!\u0002\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class CacheStoreTest
extends ValidatorTestCase
implements BeforeAndAfter,
Hashing {
    private final DriverManagerDataSource memoryDataSource;
    private final CacheStore net$ripe$rpki$validator$store$CacheStoreTest$$store;
    private final X509Crl testCrl;
    private final ManifestCms testManifest;
    private final ManifestCms testManifest1;
    private final RoaCms testRoa;
    private final X509ResourceCertificate testCertificate;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public byte[] getHash(byte[] bytes) {
        return Hashing.class.getHash((Hashing)this, (byte[])bytes);
    }

    public String stringify(byte[] bytes) {
        return Hashing.class.stringify((Hashing)this, (byte[])bytes);
    }

    public Option<byte[]> parseBytes(String hex) {
        return Hashing.class.parseBytes((Hashing)this, (String)hex);
    }

    public boolean equals(byte[] hashA, byte[] hashB) {
        return Hashing.class.equals((Hashing)this, (byte[])hashA, (byte[])hashB);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    private DriverManagerDataSource memoryDataSource() {
        return this.memoryDataSource;
    }

    public CacheStore net$ripe$rpki$validator$store$CacheStoreTest$$store() {
        return this.net$ripe$rpki$validator$store$CacheStoreTest$$store;
    }

    public X509Crl testCrl() {
        return this.testCrl;
    }

    public ManifestCms testManifest() {
        return this.testManifest;
    }

    public ManifestCms testManifest1() {
        return this.testManifest1;
    }

    public RoaCms testRoa() {
        return this.testRoa;
    }

    public X509ResourceCertificate testCertificate() {
        return this.testCertificate;
    }

    public CacheStoreTest() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        Hashing.class.$init$((Hashing)this);
        this.memoryDataSource = DataSources$.MODULE$.InMemoryDataSource();
        this.net$ripe$rpki$validator$store$CacheStoreTest$$store = new CacheStore((DataSource)this.memoryDataSource());
        this.testCrl = X509CrlTest.createCrl();
        this.testManifest = ManifestCmsTest.getRootManifestCms();
        this.testManifest1 = ManifestCmsTest.getRootManifestBuilder().withManifestNumber(new BigInteger("222")).build(ManifestCmsTest.MANIFEST_KEY_PAIR.getPrivate());
        this.testRoa = RoaCmsTest.getRoaCms();
        this.testCertificate = X509ResourceCertificateTest.createSelfSignedCaResourceCertificate();
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clear();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a certificate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject certificate = new CertificateObject("rsync://bla", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Seq obj = (Seq)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(certificate.hash())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CertificateObject apply(RepositoryObject<? extends CertificateRepositoryObject> x$1) {
                        return (CertificateObject)x$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.convertToStringShouldWrapper(((CertificateObject)obj.head()).url()).should(this.$outer.be().apply((Object)certificate.url()));
                this.$outer.convertToAnyShouldWrapper(((CertificateObject)obj.head()).aki()).should(this.$outer.be().apply((Object)certificate.aki()));
                this.$outer.convertToAnyShouldWrapper(((CertificateObject)obj.head()).ski()).should(this.$outer.be().apply((Object)certificate.ski()));
                this.$outer.convertToAnyShouldWrapper(((CertificateObject)obj.head()).encoded()).should(this.$outer.be().apply((Object)certificate.encoded()));
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)obj.head()).hash()).should(this.$outer.be().apply((Object)certificate.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a certificate and get it by URL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject certificate = new CertificateObject("rsync://bla", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Seq seq = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getCertificates("rsync://bla");
                this.$outer.convertToAnyShouldWrapper(seq).should(this.$outer.not()).be(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                CertificateObject obj = (CertificateObject)seq.head();
                this.$outer.convertToStringShouldWrapper(obj.url()).should(this.$outer.be().apply((Object)certificate.url()));
                this.$outer.convertToAnyShouldWrapper(obj.aki()).should(this.$outer.be().apply((Object)certificate.aki()));
                this.$outer.convertToAnyShouldWrapper(obj.ski()).should(this.$outer.be().apply((Object)certificate.ski()));
                this.$outer.convertToAnyShouldWrapper(obj.encoded()).should(this.$outer.be().apply((Object)certificate.encoded()));
                this.$outer.convertToAnyShouldWrapper(obj.hash()).should(this.$outer.be().apply((Object)certificate.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a crl", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CrlObject crl = new CrlObject("rsync://bla", this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(crl);
                Seq obj = (Seq)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(crl.hash())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CrlObject apply(RepositoryObject<? extends CertificateRepositoryObject> x$2) {
                        return (CrlObject)x$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.convertToStringShouldWrapper(((CrlObject)obj.head()).url()).should(this.$outer.be().apply((Object)crl.url()));
                this.$outer.convertToAnyShouldWrapper(((CrlObject)obj.head()).aki()).should(this.$outer.be().apply((Object)crl.aki()));
                this.$outer.convertToAnyShouldWrapper(((CrlObject)obj.head()).encoded()).should(this.$outer.be().apply((Object)crl.encoded()));
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)obj.head()).hash()).should(this.$outer.be().apply((Object)crl.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a manifest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ManifestObject manifest = new ManifestObject("rsync://bla", this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(manifest);
                Seq manifests = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getManifests(manifest.aki());
                this.$outer.convertToAnyShouldWrapper(manifests).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
                ManifestObject head = (ManifestObject)manifests.head();
                this.$outer.convertToStringShouldWrapper(head.url()).should(this.$outer.be().apply((Object)manifest.url()));
                this.$outer.convertToAnyShouldWrapper(head.aki()).should(this.$outer.be().apply((Object)manifest.aki()));
                this.$outer.convertToAnyShouldWrapper(head.encoded()).should(this.$outer.be().apply((Object)manifest.encoded()));
                this.$outer.convertToAnyShouldWrapper(head.hash()).should(this.$outer.be().apply((Object)manifest.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("DB concurrency", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ManifestObject manifest = new ManifestObject("rsync://bla", this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                long timeToGo = System.currentTimeMillis() + 100L;
                ParSeq results = (ParSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2 * Runtime.getRuntime().availableProcessors()).par().map((Function1)new Serializable(this, manifest, timeToGo){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final ManifestObject manifest$1;
                    private final long timeToGo$1;

                    public final Try<BoxedUnit> apply(int t) {
                        long sleepTime = this.timeToGo$1 - System.currentTimeMillis();
                        if (sleepTime > 1L) {
                            Thread.sleep(sleepTime);
                        }
                        return Try$.MODULE$.apply((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$18 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$anonfun$$$outer().net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(this.$outer.manifest$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$6 net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.manifest$1 = manifest$1;
                        this.timeToGo$1 = timeToGo$1;
                    }
                }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
                this.$outer.convertToAnyShouldWrapper(results.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Try<BoxedUnit> x$3) {
                        return x$3.isFailure();
                    }
                })).should(this.$outer.have()).length(0L, Length$.MODULE$.lengthOfGenSeq());
                Seq manifests = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getManifests(manifest.aki());
                this.$outer.convertToAnyShouldWrapper(manifests).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
                ManifestObject head = (ManifestObject)manifests.head();
                this.$outer.convertToStringShouldWrapper(head.url()).should(this.$outer.be().apply((Object)manifest.url()));
                this.$outer.convertToAnyShouldWrapper(head.aki()).should(this.$outer.be().apply((Object)manifest.aki()));
                this.$outer.convertToAnyShouldWrapper(head.encoded()).should(this.$outer.be().apply((Object)manifest.encoded()));
                this.$outer.convertToAnyShouldWrapper(head.hash()).should(this.$outer.be().apply((Object)manifest.hash()));
            }

            public /* synthetic */ CacheStoreTest net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Store a roa", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                Seq obj = (Seq)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(roa.hash())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RoaObject apply(RepositoryObject<? extends CertificateRepositoryObject> x$4) {
                        return (RoaObject)x$4;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.convertToStringShouldWrapper(((RoaObject)obj.head()).url()).should(this.$outer.be().apply((Object)roa.url()));
                this.$outer.convertToAnyShouldWrapper(((RoaObject)obj.head()).aki()).should(this.$outer.be().apply((Object)roa.aki()));
                this.$outer.convertToAnyShouldWrapper(((RoaObject)obj.head()).encoded()).should(this.$outer.be().apply((Object)roa.encoded()));
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)obj.head()).hash()).should(this.$outer.be().apply((Object)roa.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Do not store the same object twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(roa.hash())).size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Do not store the same certificate twice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject certificate = new CertificateObject("rsync://bla", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(certificate.hash())).size())).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Update validation timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant newTime = Instant.now();
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().updateValidationTimestamp((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{roa.hash(), certificate.hash()})), newTime);
                Seq roaObject = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(roa.hash()));
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)roaObject.head()).validationTime()).should(this.$outer.be().apply((Object)new Some((Object)newTime)));
                Seq certificateObject = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(certificate.hash()));
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)certificateObject.head()).validationTime()).should(this.$outer.be().apply((Object)new Some((Object)newTime)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Delete old objects", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant timeInThePast = Instant.now().minus((long)(3600000 * (this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().deletionDelay() + 1)));
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().updateValidationTimestamp((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{roa.hash(), certificate.hash()})), timeInThePast);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clearObjects(Instant.now());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(roa.hash())).isEmpty())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(certificate.hash())).isEmpty())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Delete objects never validated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RoaObject roa = new RoaObject("rsync://bla.roa", this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                CertificateObject certificate = new CertificateObject("rsync://bla.cer", this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                Instant timeInTheFuture = Instant.now().plus((long)(3600000 * (this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().deletionDelay() + 1)));
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().clearObjects(timeInTheFuture);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(roa.hash())).isEmpty())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(this.$outer.stringify(certificate.hash())).isEmpty())).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return both objects and certificates matching the url", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String myUrl = "rsync://bla";
                CertificateObject certificate = new CertificateObject(myUrl, this.$outer.testCertificate(), CertificateObject$.MODULE$.apply$default$3());
                RoaObject roa = new RoaObject(myUrl, this.$outer.testRoa(), RoaObject$.MODULE$.apply$default$3());
                ManifestObject manifest = new ManifestObject(myUrl, this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                CrlObject crl = new CrlObject(myUrl, this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                CrlObject someOtherCrl = new CrlObject("rsync://bla.bla", this.$outer.testCrl(), CrlObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(crl);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(manifest);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCertificate(certificate);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeRoa(roa);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeCrl(someOtherCrl);
                Seq objects = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects(myUrl);
                objects.foreach((Function1)new Serializable(this, certificate, roa, manifest, crl){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;
                    private final CertificateObject certificate$1;
                    private final RoaObject roa$1;
                    private final ManifestObject manifest$2;
                    private final CrlObject crl$1;

                    public final void apply(RepositoryObject<? extends CertificateRepositoryObject> x0$1) {
                        RepositoryObject<? extends CertificateRepositoryObject> repositoryObject;
                        block6: {
                            block3: {
                                block5: {
                                    block4: {
                                        block2: {
                                            repositoryObject = x0$1;
                                            if (!(repositoryObject instanceof CertificateObject)) break block2;
                                            CertificateObject certificateObject = (CertificateObject)repositoryObject;
                                            this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(certificateObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.certificate$1.decoded()));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!(repositoryObject instanceof RoaObject)) break block4;
                                        RoaObject roaObject = (RoaObject)repositoryObject;
                                        this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(roaObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.roa$1.decoded()));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(repositoryObject instanceof ManifestObject)) break block5;
                                    ManifestObject manifestObject = (ManifestObject)repositoryObject;
                                    this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(manifestObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.manifest$2.decoded()));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(repositoryObject instanceof CrlObject)) break block6;
                                CrlObject crlObject = (CrlObject)repositoryObject;
                                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().convertToAnyShouldWrapper(crlObject.decoded()).should(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer().be().apply((Object)this.crl$1.decoded()));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(repositoryObject);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.certificate$1 = certificate$1;
                        this.roa$1 = roa$1;
                        this.manifest$2 = manifest$2;
                        this.crl$1 = crl$1;
                    }
                });
            }

            public /* synthetic */ CacheStoreTest net$ripe$rpki$validator$store$CacheStoreTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return an empty Seq when nothing matches the url", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq objects = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getObjects("rsync:bla");
                this.$outer.convertToAnyShouldWrapper(objects).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should delete older object with the same URI", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheStoreTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ManifestObject mft1 = new ManifestObject("rsync://bla.mft", this.$outer.testManifest(), ManifestObject$.MODULE$.apply$default$3());
                ManifestObject mft2 = new ManifestObject("rsync://bla.mft", this.$outer.testManifest1(), ManifestObject$.MODULE$.apply$default$3());
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(mft1);
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().storeManifest(mft2);
                this.$outer.convertToAnyShouldWrapper(this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getManifests(mft1.aki())).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfGenTraversable());
                URI uri = new URI("rsync://bla.mft");
                this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().cleanOutdated((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)uri, (Object)mft1.hash())})));
                Seq manifests = this.$outer.net$ripe$rpki$validator$store$CacheStoreTest$$store().getManifests(mft1.aki());
                this.$outer.convertToAnyShouldWrapper(manifests).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(((RepositoryObject)manifests.head()).hash()).should(this.$outer.be().apply((Object)mft1.hash()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

