/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator.models.validation;

import java.net.URI;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateTest;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator.fetchers.Fetcher;
import net.ripe.rpki.validator.models.InvalidObject;
import net.ripe.rpki.validator.models.RepoService;
import net.ripe.rpki.validator.models.ValidObject;
import net.ripe.rpki.validator.models.ValidatedObject;
import net.ripe.rpki.validator.models.validation.CertificateObject;
import net.ripe.rpki.validator.models.validation.TrustAnchorValidationProcess;
import net.ripe.rpki.validator.models.validation.TrustAnchorValidationProcessTest$;
import net.ripe.rpki.validator.store.CacheStore;
import net.ripe.rpki.validator.support.ValidatorTestCase;
import net.ripe.rpki.validator.util.TrustAnchorLocator;
import org.joda.time.Instant;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.mock.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalaz.Validation;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u0001\u0003\u0001=\u0011\u0001\u0005\u0016:vgR\fen\u00195peZ\u000bG.\u001b3bi&|g\u000e\u0015:pG\u0016\u001c8\u000fV3ti*\u00111\u0001B\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0003\u0007\u0003\u0019iw\u000eZ3mg*\u0011q\u0001C\u0001\nm\u0006d\u0017\u000eZ1u_JT!!\u0003\u0006\u0002\tI\u00048.\u001b\u0006\u0003\u00171\tAA]5qK*\tQ\"A\u0002oKR\u001c\u0001a\u0005\u0003\u0001!Y\u0001\u0003CA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u001d\u0019X\u000f\u001d9peRL!!\u0006\n\u0003#Y\u000bG.\u001b3bi>\u0014H+Z:u\u0007\u0006\u001cX\r\u0005\u0002\u0018=5\t\u0001D\u0003\u0002\u001a5\u0005!Qn\\2l\u0015\tYB$A\u0005tG\u0006d\u0017\r^3ti*\tQ$A\u0002pe\u001eL!a\b\r\u0003\u00195{7m[5u_N+x-\u0019:\u0011\u0005\u0005\u0012S\"\u0001\u000e\n\u0005\rR\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM\u001d\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAqA\u000b\u0001C\u0002\u0013\u00051&A\u0005n_\u000e\\7\u000b^8sKV\tA\u0006\u0005\u0002.a5\taF\u0003\u00020\r\u0005)1\u000f^8sK&\u0011\u0011G\f\u0002\u000b\u0007\u0006\u001c\u0007.Z*u_J,\u0007BB\u001a\u0001A\u0003%A&\u0001\u0006n_\u000e\\7\u000b^8sK\u0002Bq!\u000e\u0001C\u0002\u0013\u0005a'A\bn_\u000e\\'+\u001a9p'\u0016\u0014h/[2f+\u00059\u0004C\u0001\u001d:\u001b\u0005!\u0011B\u0001\u001e\u0005\u0005-\u0011V\r]8TKJ4\u0018nY3\t\rq\u0002\u0001\u0015!\u00038\u0003AiwnY6SKB|7+\u001a:wS\u000e,\u0007\u0005C\u0004?\u0001\t\u0007I\u0011A \u0002-5|7m\u001b+skN$\u0018I\\2i_JdunY1u_J,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u001a\tA!\u001e;jY&\u0011QI\u0011\u0002\u0013)J,8\u000f^!oG\"|'\u000fT8dCR|'\u000f\u0003\u0004H\u0001\u0001\u0006I\u0001Q\u0001\u0018[>\u001c7\u000e\u0016:vgR\fen\u00195pe2{7-\u0019;pe\u0002Bq!\u0013\u0001C\u0002\u0013\u0005!*\u0001\u0007nCb\u001cF/\u00197f\t\u0006L8/F\u0001L!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\rIe\u000e\u001e\u0005\u0007%\u0002\u0001\u000b\u0011B&\u0002\u001b5\f\u0007p\u0015;bY\u0016$\u0015-_:!\u0011\u001d!\u0006A1A\u0005\u0002U\u000ba\u0001^1OC6,W#\u0001,\u0011\u0005]SfB\u0001'Y\u0013\tIV*\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-N\u0011\u0019q\u0006\u0001)A\u0005-\u00069A/\u0019(b[\u0016\u0004\u0003b\u00021\u0001\u0005\u0004%\t!Y\u0001\u0016K:\f'\r\\3M_>\u001cXMV1mS\u0012\fG/[8o+\u0005\u0011\u0007C\u0001'd\u0013\t!WJA\u0004C_>dW-\u00198\t\r\u0019\u0004\u0001\u0015!\u0003c\u0003Y)g.\u00192mK2{wn]3WC2LG-\u0019;j_:\u0004\u0003b\u00025\u0001\u0005\u0004%\t![\u0001\ni\u0006\u001cUM\u001d;Ve&,\u0012A\u001b\t\u0003W>l\u0011\u0001\u001c\u0006\u0003\u001b5T\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qY\n\u0019QKU%\t\rI\u0004\u0001\u0015!\u0003k\u0003)!\u0018mQ3siV\u0013\u0018\u000e\t\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u00031i\u0017\r^2iS:<7)\u001a:u+\u00051\bC\u0001\u0015x\u0013\tA(AA\tDKJ$\u0018NZ5dCR,wJ\u00196fGRDaA\u001f\u0001!\u0002\u00131\u0018!D7bi\u000eD\u0017N\\4DKJ$\b\u0005C\u0004}\u0001\t\u0007I\u0011A?\u0002%Q\fg+\u00197jI\u0006$xN\u001d)s_\u000e,7o]\u000b\u0002}B\u0011\u0001f`\u0005\u0004\u0003\u0003\u0011!\u0001\b+skN$\u0018I\\2i_J4\u0016\r\\5eCRLwN\u001c)s_\u000e,7o\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u007f\u0003M!\u0018MV1mS\u0012\fGo\u001c:Qe>\u001cWm]:!\u0001")
public class TrustAnchorValidationProcessTest
extends ValidatorTestCase
implements MockitoSugar,
BeforeAndAfter {
    private final CacheStore mockStore;
    private final RepoService mockRepoService;
    private final TrustAnchorLocator mockTrustAnchorLocator;
    private final int maxStaleDays;
    private final String taName;
    private final boolean enableLooseValidation;
    private final URI taCertUri;
    private final CertificateObject matchingCert;
    private final TrustAnchorValidationProcess taValidatorProcess;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public <T> T mock(Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, manifest);
    }

    public <T> T mock(Answer<?> defaultAnswer, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, defaultAnswer, manifest);
    }

    public <T> T mock(MockSettings mockSettings, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (MockSettings)mockSettings, manifest);
    }

    public <T> T mock(String name, Manifest<T> manifest) {
        return (T)MockitoSugar.class.mock((MockitoSugar)this, (String)name, manifest);
    }

    public CacheStore mockStore() {
        return this.mockStore;
    }

    public RepoService mockRepoService() {
        return this.mockRepoService;
    }

    public TrustAnchorLocator mockTrustAnchorLocator() {
        return this.mockTrustAnchorLocator;
    }

    public int maxStaleDays() {
        return this.maxStaleDays;
    }

    public String taName() {
        return this.taName;
    }

    public boolean enableLooseValidation() {
        return this.enableLooseValidation;
    }

    public URI taCertUri() {
        return this.taCertUri;
    }

    public CertificateObject matchingCert() {
        return this.matchingCert;
    }

    public TrustAnchorValidationProcess taValidatorProcess() {
        return this.taValidatorProcess;
    }

    public TrustAnchorValidationProcessTest() {
        MockitoSugar.class.$init$((MockitoSugar)this);
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.mockStore = (CacheStore)this.mock(ManifestFactory$.MODULE$.classType(CacheStore.class));
        this.mockRepoService = (RepoService)this.mock(ManifestFactory$.MODULE$.classType(RepoService.class));
        this.mockTrustAnchorLocator = (TrustAnchorLocator)this.mock(ManifestFactory$.MODULE$.classType(TrustAnchorLocator.class));
        this.maxStaleDays = 1;
        this.taName = "ripe";
        this.enableLooseValidation = true;
        this.taCertUri = new URI("rsync://taCert.cert");
        this.matchingCert = new CertificateObject("rsync://taCert.cert", X509ResourceCertificateTest.createSelfSignedCaResourceCertificate(), (Option)None$.MODULE$);
        this.taValidatorProcess = new $anon$1(this);
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcessTest $outer;

            public final OngoingStubbing<Seq<Fetcher.Error>> apply() {
                Mockito.reset((Object[])new Object[]{this.$outer.mockStore(), this.$outer.mockRepoService(), this.$outer.mockTrustAnchorLocator()});
                Mockito.when((Object)this.$outer.mockTrustAnchorLocator().getCertificateLocations()).thenReturn(Collections.singletonList(this.$outer.taCertUri()));
                Mockito.when((Object)this.$outer.mockRepoService().visitTrustAnchorCertificate((URI)Matchers.eq((Object)this.$outer.taCertUri()), Matchers.eq((boolean)true), (Instant)Matchers.any(Instant.class))).thenReturn((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                return Mockito.when((Object)this.$outer.mockRepoService().visitRepo(Matchers.eq((boolean)false), (Instant)Matchers.any(Instant.class), (URI)Matchers.eq((Object)this.$outer.matchingCert().decoded().getRepositoryUri()))).thenReturn((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return validObject for trust anchor certificate without errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.mockStore().getCertificates(this.$outer.taCertUri().toString())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CertificateObject[]{this.$outer.matchingCert()})));
                Mockito.when((Object)this.$outer.mockStore().getManifests(this.$outer.matchingCert().aki())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Validation validation = this.$outer.taValidatorProcess().runProcess(false);
                Option validatedObject = ((IterableLike)validation.toOption().get()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final boolean apply(ValidatedObject vo) {
                        URI uRI = vo.uri();
                        URI uRI2 = this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer().taCertUri();
                        return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null) && vo instanceof ValidObject;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)validatedObject.isDefined())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(((ValidatedObject)validatedObject.get()).validationStatus()).should(this.$outer.equal(ValidationStatus.PASSED), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ TrustAnchorValidationProcessTest net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return inValidObject when no valid ta certificate found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.mockStore().getCertificates(this.$outer.taCertUri().toString())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Validation validation = this.$outer.taValidatorProcess().runProcess(false);
                ValidatedObject validatedObject = (ValidatedObject)((IterableLike)validation.toOption().get()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final boolean apply(ValidatedObject vo) {
                        URI uRI = vo.uri();
                        URI uRI2 = this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer().taCertUri();
                        return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).get();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)(validatedObject instanceof InvalidObject))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(validatedObject.validationStatus()).should(this.$outer.equal(ValidationStatus.ERROR), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ TrustAnchorValidationProcessTest net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should return inValidObject when more than one matching ta certificate found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.mockStore().getCertificates(this.$outer.taCertUri().toString())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CertificateObject[]{this.$outer.matchingCert(), this.$outer.matchingCert()})));
                Validation validation = this.$outer.taValidatorProcess().runProcess(false);
                ValidatedObject validatedObject = (ValidatedObject)((IterableLike)validation.toOption().get()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final boolean apply(ValidatedObject vo) {
                        URI uRI = vo.uri();
                        URI uRI2 = this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer().taCertUri();
                        return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).get();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)(validatedObject instanceof InvalidObject))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(validatedObject.validationStatus()).should(this.$outer.equal(ValidationStatus.ERROR), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ TrustAnchorValidationProcessTest net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Should just warn when more than one object is found with the uri of the ta certificate but only one matches the ta certificate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrustAnchorValidationProcessTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CertificateObject cert2 = (CertificateObject)this.$outer.mock(ManifestFactory$.MODULE$.classType(CertificateObject.class));
                Mockito.when((Object)this.$outer.mockStore().getCertificates(this.$outer.taCertUri().toString())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CertificateObject[]{this.$outer.matchingCert(), cert2})));
                Mockito.when((Object)this.$outer.mockStore().getManifests(this.$outer.matchingCert().aki())).thenReturn((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Validation validation = this.$outer.taValidatorProcess().runProcess(false);
                Option validatedObject = ((IterableLike)validation.toOption().get()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final boolean apply(ValidatedObject vo) {
                        URI uRI = vo.uri();
                        URI uRI2 = this.$outer.net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer().taCertUri();
                        return !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null) && vo instanceof ValidObject;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)validatedObject.isDefined())).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(((ValidatedObject)validatedObject.get()).validationStatus()).should(this.$outer.equal(ValidationStatus.WARNING), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ TrustAnchorValidationProcessTest net$ripe$rpki$validator$models$validation$TrustAnchorValidationProcessTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

